<?php
/**
 * +============================================+
 * |                                            |
 * |   Xagio V3 – Alternative API   |
 * |                                            |
 * |   used instead of normal admin-post.php    |
 * |   API to provide compatibility with any    |
 * |   security plugins                         |
 * |                                            |
 * +============================================+
 */

/**
 *  Send the formatted JSON
 *   object back to browser
 *
 * @param string $status .... success | error | info
 * @param string $message .... message response
 * @param bool $data .... any relevant data object
 */
function xagio_send_json($status = 'info', $message = '', $data = false) {
	header('Content-Type: application/json');
	echo json_encode(array(
		'status'  => $status,
		'message' => $message,
		'data'    => $data
	));
}

/**
 *  Determine the necessary requires for API
 *  functionality from WordPress core
 */
function xagio_determine_requirements() {
	if ( ! function_exists( 'get_plugins' ) ) {
		require_once ABSPATH . 'wp-admin/includes/plugin.php';
	}
	if ( ! function_exists( 'get_core_updates' ) ) {
		require_once ABSPATH . 'wp-admin/includes/update.php';
	}
	if ( ! function_exists( 'request_filesystem_credentials' ) ) {
		require_once ABSPATH . 'wp-admin/includes/file.php';
	}
	if ( ! function_exists( 'show_message' ) ) {
		require_once ABSPATH . 'wp-admin/includes/misc.php';
	}
}

// Determine if WordPress core file is present
// in current directory
if (file_exists('wp-load.php')) {
	// Load the WordPress core file
	require_once ("wp-load.php");

	// Detect the requirements
	xagio_determine_requirements();

	// Check if PSv3 is activated
	if (class_exists('MXAG_Api')) {

		// Check if the $_POST['action'] is set
		if (isset($_REQUEST['action'])) {

			// Check if this request is towards the API or Remote Login
			switch ($_REQUEST['action']) {
				// API
				case 'prs_api':
					MXAG_Api::handleRequest();
					break;
				// Remote Login
				case 'prs_remote_login':
					MXAG_Api::remoteLogin();
					break;
				// Unrecognized
				default:
					xagio_send_json('error', 'Invalid action specified.');
					break;
			}

		} else {
			// Action is not being sent
			xagio_send_json('error', 'Action field is missing.');
		}

	} else {
		// Xagio is not activated / installed
		xagio_send_json('error', 'Xagio is not activated / installed on this website.');
	}

} else {
	// Obviously a non WordPress root directory
	xagio_send_json('error', 'Alternative API file is not in the WordPress root directory.');
}


