<?php
// Function that makes our zip utility skip zip files (aka our backups)
function xag_preZipAdd( $p_event, &$p_header ) {
	$info = pathinfo( $p_header['stored_filename'] );
	// ----- zip files are skipped
	if ( isset( $info['extension'] ) ) {
		if ( $info['extension'] == 'zip' ) {
			return 0;
		} else {
			return 1;
		}
	} else {
		return 1;
	}
}

if(! function_exists('xag_removeSlashes')) {
	function xag_removeSlashes($string)
	{
		$string = implode("", explode("\\", $string));
		return stripslashes(trim($string));
	}
}

if(! function_exists('xag_stripAllSlashes')) {
	function xag_stripAllSlashes($value)
	{
		$value = is_array($value) ?
			array_map('xag_stripAllSlashes', $value) :
			xag_removeSlashes($value);

		return $value;
	}
}

if(! function_exists('xag_stripUnwantedCharTag')) {
	function xag_stripUnwantedCharTag($string=null)
	{
		$string = str_replace('"', '', trim($string));
		return wp_strip_all_tags( $string );
	}
}

if(! function_exists('string_contains')) {
    function string_contains ($what, $where)
    {
        if (strpos($where, $what) !== FALSE) {
            return TRUE;
        } else {
            return FALSE;
        }
    }
}
