<?php

if (!class_exists('XAG_Init')) {

    class XAG_Init
    {
        // When plugin is activated
        public static function activate ()
        {
            XAG_Init::createTables();
            $result = MXAG_Api::apiRequest(
                $endpoint = 'plugin_status',
                $method = 'POST',
                [
                    'domain' => preg_replace('/^www\./', '', $_SERVER['SERVER_NAME']),
                    'event'  => 'activate'
                ]
            );

            update_option('ps_user_membership', $result['membership']);
            update_option('ps_seo_always_on', TRUE);
            update_option('prs_ts_memory_limit', TRUE);

            // Enable the V3 API
            if (MXAG_Troubleshooting::deployApiFile()) {
                update_option('prs_ts_alternative_api', TRUE);
            }
        }

        // When plugin is de-activated
        public static function deactivate ()
        {
            MXAG_Api::apiRequest(
                $endpoint = 'plugin_status',
                $method = 'POST',
                [
                    'domain' => preg_replace('/^www\./', '', $_SERVER['SERVER_NAME']),
                    'event'  => 'deactivate'
                ]
            );
        }

        // When plugin is uninstalled
        public static function uninstall ()
        {
            // Remove website from Panel
            MXAG_Api::apiRequest(
                $endpoint = 'plugin_status',
                $method = 'POST',
                [
                    'domain' => preg_replace('/^www\./', '', $_SERVER['SERVER_NAME']),
                    'event'  => 'uninstall'
                ]
            );

            // Remove Licence Key
            $salt_local = $_SERVER['SERVER_NAME'];
            delete_option(XAG_Licencator::encrypt('license_email', $salt_local));
            delete_option(XAG_Licencator::encrypt('license_key', $salt_local));
        }

        // Create/Modify Tables on new Update
        public static function checkVersion ()
        {
            if (get_option('XAG_CURRENT_VERSION') != XAG_CURRENT_VERSION) {

                // Update tables
                XAG_Init::createTables();

                // Update the new version
                update_option('XAG_CURRENT_VERSION', XAG_CURRENT_VERSION);

                // Reinstall the API
                if ( get_option('prs_ts_alternative_api') == TRUE ) {
                    MXAG_Troubleshooting::deployApiFile();
                }
            }
        }

        /**
         *  Install FailSafe File
         */
        public static function installFailSafe ()
        {
            /********************************************************
             * /********************************************************/

            // Check if the old file is present
            // TODO -- remove in future version 3.4.65
            $failsafe_file_name = substr(md5(MXAG_Api::getAPIKey()), 0, 10);

            // Have a easier to remember name
            $old_failsafe_file = ABSPATH . $failsafe_file_name . '.php';

            // Remove the old recovery file
            if (file_exists($old_failsafe_file)) {
                unlink($old_failsafe_file);
            }

            /********************************************************
             * /********************************************************/

            // Check if FailSafe should be disabled
            if (XAG_DISABLE_FAILSAFE != TRUE) {

                // Get the file location
                $failsafe_file = XAG_PATH . '/ext/xagio-failsafe.php';

                // Generate a unique name for this file
                //$failsafe_file_name = substr(md5(MXAG_Api::getAPIKey()), 0, 10);

                // Have a easier to remember name
                $root_failsafe_file = ABSPATH . 'xagio-recovery.php';

                if (!file_exists($root_failsafe_file)) {

                    // Copy the main file
                    file_put_contents($root_failsafe_file, str_replace('%%XAG_PATH%%', XAG_PATH, file_get_contents($failsafe_file)));

                }

            } else {

                // Remove the file if failsafe is disabled
                $root_failsafe_file = ABSPATH . 'v3-recovery.php';
                if (file_exists($root_failsafe_file)) {
                    unlink($root_failsafe_file);
                }

            }
        }

        /**
         *  Uninstall FailSafe File
         */
        public static function uninstallFailSafe ()
        {
            // Generate a unique name for this file
            $failsafe_file_name = substr(md5(MXAG_Api::getAPIKey()), 0, 10);
            $root_failsafe_file = ABSPATH . $failsafe_file_name . '.php';

            if (file_exists($root_failsafe_file)) {
                @unlink($root_failsafe_file);
            }
        }

        public static function jsonc ($array = [])
        {
            wp_send_json($array);
            wp_die();
        }

        // Print JSON
        public static function json ($type, $message, $data = NULL)
        {
            wp_send_json([
                'status'  => $type,
                'message' => $message,
                'data'    => $data
            ]);
            wp_die();
        }

        // Init hooks
        public static function hooks ()
        {
            add_action('admin_menu', ['XAG_Init', 'createPages']);
            add_action('admin_init', ['XAG_Init', 'loadAssets']);
            add_action('admin_init', ['XAG_Init', 'removeInstaller']);
            add_action('admin_init', ['XAG_Init', 'checkLicenseFile']);
            add_action('admin_enqueue_scripts', ['XAG_Init', 'loadAdminAssets'], 10, 1);
            add_action('wp_enqueue_scripts', ['XAG_Init', 'loadUserAssets'], 10, 1);
            add_filter('auto_update_plugin', ['XAG_Init', 'autoUpdatePS'], 10, 2);
            add_action('admin_print_scripts', ['XAG_Init', 'debugAssets'], 10);
            add_filter('widget_text', 'do_shortcode');

            // XAG_Post
            add_action('admin_post_xag_save_options', ['XAG_Post', 'saveOptions']);
        }

        public static function autoUpdatePS ($update, $item)
        {
            if ($item->slug == 'xagio') {
                return TRUE;
            } else {
                return $update;
            }
        }

        public static function removeInstaller ()
        {
            $slug      = 'project-supremacy-installer/project-supremacy-installer.php';
            $installer = ABSPATH . 'wp-content/plugins/' . $slug;
            if (file_exists($installer) && XAG_Licencator::isLicenseSet()) {
                require_once(ABSPATH . 'wp-admin/includes/plugin.php');
                require_once(ABSPATH . 'wp-admin/includes/file.php');

                deactivate_plugins([$slug]);
                delete_plugins([$slug]);
            }
        }

        private static function registerGoogleMaps ()
        {
            $apis = get_option('ps_api_settings');
            if (!isset($apis['googlemaps_api'])) {
                return;
            }
            if (empty($apis['googlemaps_api'])) {
                return;
            }
            wp_enqueue_script(
                'xag_google_maps',
                '//maps.googleapis.com/maps/api/js?key=' . $apis['googlemaps_api']
            );
        }

        // Enqueue scripts admin scripts
        public static function loadAdminAssets ($hook)
        {

            // Deregister jQuery UI Widget
            if ($hook === 'supremacy-v3_page_xag-projects') {
                wp_deregister_script('jquery-ui-widget');
            }

            global $post_type;
            // This section is for loading tiny MCE custom buttons on plugins
            // and themes that are using tiny MCE on their pages
            //
            // Just add hook for particular page and tiny MCE will work with Xagio Plugin
            wp_enqueue_script('xag_notification');
            wp_localize_script('xag_notification', 'xag_data', [
                    'wp_get'      => admin_url('admin-ajax.php'),
                    'wp_post'     => admin_url('admin-post.php'),
                    'plugins_url' => plugins_url('/', dirname(__FILE__)),
                    'sitename'    => get_bloginfo('name'),
                    'api_keys'    => get_option('ps_api_settings'),
                    'uploads_dir' => wp_upload_dir()
                ]
            );
            if (
                $hook == 'serp-tech_page_serp-tech-builder' ||
                $hook == 'widgets.php'
            ) {
                wp_enqueue_script('xag_troubleshooter');
                wp_localize_script('xag_troubleshooter', 'xag_tinymce_data',
                    [
                        'shortcodes' => MXAG_Shortcodes::getAllData('xag_shortcodes'),
                        'keywords'   => MXAG_Tinymce_buttons::getKeywords()
                    ]
                );

                wp_localize_script('xag_troubleshooter', 'xag_data', [
                        'wp_get'      => admin_url('admin-ajax.php'),
                        'wp_post'     => admin_url('admin-post.php'),
                        'plugins_url' => plugins_url('/', dirname(__FILE__)),
                        'sitename'    => get_bloginfo('name'),
                        'api_keys'    => get_option('ps_api_settings'),
                        'uploads_dir' => wp_upload_dir()
                    ]
                );

                wp_enqueue_script('xag_admin');
                wp_enqueue_style('xag_admin');
                wp_enqueue_style('xag_admin_bootstrap_grid');
                wp_enqueue_style('xag_uikit_datatables');
                wp_enqueue_style('xag_font-awesome');


                wp_enqueue_script('xag_uikit');
                wp_enqueue_script('xag_uikit_pagination');
                wp_enqueue_script('xag_uikit_accordion');
                wp_enqueue_script('xag_uikit_notify');
                wp_enqueue_style('xag_uikit_notify');

                // File upload scripts
                wp_enqueue_script('media-upload');
                wp_enqueue_script('thickbox');
                wp_enqueue_style('thickbox');

                // Chosen
                wp_enqueue_script('xag_chosen');
                wp_enqueue_style('xag_chosen');
            }
            // End section Tiny MCE fix //

            if ($hook == 'post-new.php' || $hook == 'post.php' || $hook == 'term.php') {


                if (in_array($post_type, MXAG_Seo::getAllPostTypes())) {
                    wp_enqueue_script('xag_admin');
                    wp_enqueue_style('xag_admin');
                }

                wp_enqueue_style('xag_admin_bootstrap_grid');
                wp_enqueue_style('xag_uikit_datatables');
                wp_enqueue_style('xag_font-awesome');

                wp_enqueue_script('xag_uikit_datatables_core');
                wp_enqueue_script('xag_uikit_datatables');
                wp_enqueue_script('xag_uikit');
                wp_enqueue_script('xag_uikit_pagination');
                wp_enqueue_script('xag_uikit_accordion');
                wp_enqueue_script('xag_uikit_notify');
                wp_enqueue_script('xag_uikit_tooltip');
                wp_enqueue_style('xag_uikit_tooltip');
                wp_enqueue_style('xag_uikit_notify');

                // File upload scripts
                wp_enqueue_script('media-upload');
                wp_enqueue_script('thickbox');

                // Chosen
                wp_enqueue_script('xag_chosen');
                wp_enqueue_style('xag_chosen');

                wp_enqueue_style('thickbox');

                wp_localize_script('xag_admin', 'xag_data',
                    [
                        'wp_get'      => admin_url('admin-ajax.php'),
                        'wp_post'     => admin_url('admin-post.php'),
                        'plugins_url' => plugins_url('/', dirname(__FILE__)),
                        'sitename'    => get_bloginfo('name'),
                        'api_keys'    => get_option('ps_api_settings'),
                        'uploads_dir' => wp_upload_dir()
                    ]
                );

                self::registerGoogleMaps();
            }

            if ($hook == 'upload.php') {
                wp_enqueue_script('xag_exif');
                wp_enqueue_style('xag_exif');

                wp_localize_script('xag_exif', 'xag_data',
                    [
                        'wp_get'      => admin_url('admin-ajax.php'),
                        'wp_post'     => admin_url('admin-post.php'),
                        'plugins_url' => plugins_url('/', dirname(__FILE__)),
                        'sitename'    => get_bloginfo('name'),
                        'api_keys'    => get_option('ps_api_settings'),
                        'uploads_dir' => wp_upload_dir()
                    ]
                );

                self::registerGoogleMaps();
            }

            if ($hook == 'media-upload-popup') {
                wp_enqueue_script('xag_exif_popup');
                wp_enqueue_style('xag_exif_popup');

                wp_localize_script('xag_exif', 'xag_data',
                    [
                        'wp_get'      => admin_url('admin-ajax.php'),
                        'wp_post'     => admin_url('admin-post.php'),
                        'plugins_url' => plugins_url('/', dirname(__FILE__)),
                        'sitename'    => get_bloginfo('name'),
                        'api_keys'    => get_option('ps_api_settings'),
                        'uploads_dir' => wp_upload_dir(),
                        'drakula'     => $hook
                    ]
                );

                self::registerGoogleMaps();
            }
        }

        // Register all Scripts and Styles that are being used in User Area
        public static function loadUserAssets ()
        {
            // Register Scripts
            /** Load Global JS **/
            wp_register_script('xag_user', XAG_URL . 'assets/js/xag_user.js', ['jquery'], TRUE);
            wp_register_script('xag_captcha_api', '//www.google.com/recaptcha/api.js', ['jquery'], TRUE);
            if (XAG_ENABLED_DISABLE_REVIEW_WIDGET_STATUS == FALSE || XAG_ENABLED_DISABLE_REVIEW_WIDGET_STATUS == 0) {
                wp_register_script('xag_review_widget', XAG_URL . 'assets/js/review-widget.js', ['jquery'], TRUE);
            }
            wp_register_script('xag_footer_links', XAG_URL . 'assets/js/footer_links.js', ['jquery'], TRUE);

            /** Load global CSS */
            wp_register_style('xag_font_awesome', XAG_URL . 'assets/css/vendor/font-awesome.min.css');
            wp_register_style('xag_font_awesome_new', XAG_URL . 'assets/css/vendor/fontawesome.min.css');
            if (XAG_ENABLED_DISABLE_REVIEW_WIDGET_STATUS == FALSE || XAG_ENABLED_DISABLE_REVIEW_WIDGET_STATUS == 0) {
                wp_register_style('xag_review_widget', XAG_URL . 'assets/css/review-widget.css');
                wp_register_style('xag_review_display', XAG_URL . 'assets/css/review-display.css');
            }

            /**
             *  Add a global JS object to main script
             */
            wp_localize_script('xag_user', 'xag_data',
                [
                    'wp_get'             => admin_url('admin-ajax.php'),
                    'wp_post'            => admin_url('admin-post.php'),
                    'plugins_url'        => plugins_url(),
                    'sitename'           => get_bloginfo('name'),
                    'ps_user_membership' => get_option('ps_user_membership')
                ]
            );

            // Register Styles

            // Enqueue Scripts
            wp_enqueue_script('xag_user');
            wp_enqueue_script('xag_captcha_api');
            wp_enqueue_script('xag_review_widget');


            if (is_front_page()) {
                wp_enqueue_script('xag_footer_links');
            }

            wp_enqueue_style('xag_font_awesome');
            wp_enqueue_style('xag_review_widget');
            wp_enqueue_style('xag_review_display');
        }

        // Debug all the loaded assets
        public static function debugAssets ()
        {
            if (XAG_DEBUG == TRUE) {
                global $wp_scripts;
                echo "\n<!-- Xagio - Assets Debug \n";
                foreach ($wp_scripts->queue as $handle) {
                    echo "[$handle]\n";
                }
                echo "     Xagio - Assets Debug -->\n";
            }

            /**
             *  Fix shitty enqueues that break our beautiful plugin
             */
            if (isset($_GET['page']) && $_GET['page'] == 'xagio-projects') {
                wp_deregister_script('jquery-ui-dialog');
                wp_dequeue_script('jquery-ui-dialog');

                wp_deregister_script('default');
                wp_dequeue_script('default');
            }
            if (isset($_GET['page']) && $_GET['page'] == 'xagio-log') {
                wp_deregister_script('vsp_uikit');
                wp_dequeue_script('vsp_uikit');
            }
            if (isset($_GET['page']) && $_GET['page'] == 'xagio-reviews') {
                wp_deregister_script('yg_front_js');
                wp_dequeue_script('yg_front_js');
                wp_deregister_script('yg_color_js');
                wp_dequeue_script('yg_color_js');
            }
        }

        // Register all Scripts and Styles that are being used in Admin Area
        public static function loadAssets ()
        {
            // Scripts
            wp_register_script('xag_uikit', XAG_URL . 'assets/js/uikit/uikit.min.js', ['jquery'], TRUE);
            wp_register_script('xag_uikit_notify', XAG_URL . 'assets/js/uikit/components/notify.min.js', ['jquery'], TRUE);
            wp_register_script('xag_uikit_accordion', XAG_URL . 'assets/js/uikit/components/accordion.min.js', ['jquery'], TRUE);
            wp_register_script('xag_uikit_datepicker', XAG_URL . 'assets/js/uikit/components/datepicker.min.js', ['jquery'], TRUE);
            wp_register_script('xag_uikit_lightbox', XAG_URL . 'assets/js/uikit/components/lightbox.min.js', ['jquery'], TRUE);
            wp_register_script('xag_uikit_grid', XAG_URL . 'assets/js/uikit/components/grid.min.js', ['jquery'], TRUE);
            wp_register_script('xag_uikit_tooltip', XAG_URL . 'assets/js/uikit/components/tooltip.min.js', ['jquery'], TRUE);
            wp_register_script('xag_uikit_search', XAG_URL . 'assets/js/uikit/components/search.min.js', ['jquery'], TRUE);
            wp_register_script('xag_uikit_sortable', XAG_URL . 'assets/js/uikit/components/sortable.min.js', ['jquery'], TRUE);
            wp_register_script('xag_uikit_upload', XAG_URL . 'assets/js/uikit/components/upload.min.js', ['jquery'], TRUE);
            wp_register_script('xag_jquery_sortable', XAG_URL . 'assets/js/uikit/components/jquery-ui.min.js', ['jquery'], TRUE);
            wp_register_script('xag_jquery_multisortable', XAG_URL . 'assets/js/vendor/jquery.multisortable.js', ['jquery'], TRUE);
            wp_register_script('xag_uikit_datatables_core', XAG_URL . 'assets/js/vendor/jquery.dataTables.min.js', ['jquery'], TRUE);
            wp_register_script('xag_uikit_datatables', XAG_URL . 'assets/js/vendor/dataTables.uikit.min.js', ['jquery'], TRUE);
            wp_register_script('xag_uikit_slideset', XAG_URL . 'assets/js/uikit/components/slideset.min.js', ['jquery'], TRUE);
            wp_register_script('xag_uikit_pagination', XAG_URL . 'assets/js/uikit/components/pagination.min.js', ['jquery'], TRUE);
            wp_register_script('xag_uikit_accordion', XAG_URL . 'assets/js/uikit/components/accordion.min.js', ['jquery'], TRUE);
            wp_register_script('xag_ajaxq', XAG_URL . 'assets/js/ajaxq.js', ['jquery'], TRUE);
            wp_register_script('xag_jstree', XAG_URL . 'assets/js/vendor/jstree.min.js', ['jquery'], TRUE);
            wp_register_script('xag_tagsinput', XAG_URL . 'assets/js/vendor/jquery.tagsinput.js', ['jquery'], TRUE);
            wp_register_script('xag_chosen', XAG_URL . 'assets/js/vendor/chosen.jquery.min.js', ['jquery'], TRUE);
            wp_register_script('xag_select2', XAG_URL . 'assets/js/vendor/select2.min.js', ['jquery'], TRUE);
            wp_register_script('xag_migration', XAG_URL . 'assets/js/xag_migration.js', ['jquery'], TRUE);
            wp_register_script('xag_google_charts', '//www.gstatic.com/charts/loader.js');
            wp_register_script('xag_notification', XAG_URL . 'assets/js/xag_notification.js', ['jquery'], TRUE);
            wp_register_script('xag_flowchart', XAG_URL . 'assets/js/vendor/jquery.flowchart.js', ['jquery'], TRUE);
            wp_register_script('xag_panzoom', XAG_URL . 'assets/js/vendor/jquery.panzoom.min.js', ['jquery'], TRUE);
            wp_register_script('xag_mousewheel', XAG_URL . 'assets/js/vendor/jquery.mousewheel.min.js', ['jquery'], TRUE);
            wp_register_script('xag_jquery_ui', XAG_URL . 'assets/js/vendor/jquery-ui.js', ['jquery'], TRUE);
            wp_register_script('xag_selectables', XAG_URL . 'assets/js/vendor/selectables.js', ['jquery'], TRUE);
            wp_register_script('xag_mdrag', XAG_URL . 'assets/js/vendor/jquery.multi-draggable.js', ['jquery', 'xag_jquery_sortable'], TRUE);


            // Datatables
            wp_register_script('xag_datatables', XAG_URL . 'assets/js/vendor/jquery.dataTables.min.js', ['jquery', 'xag_uikit'], TRUE);
            wp_register_script('xag_datatables_uikit', XAG_URL . 'assets/js/vendor/dataTables.uikit.min.js', ['jquery', 'xag_uikit', 'xag_datatables'], TRUE);

            // Table Sorter
            wp_register_script('xag_tablesorter', XAG_URL . 'assets/js/vendor/jquery.tablesorter.min.js', ['jquery'], TRUE);

            // Page Specific Scripts
            wp_register_script('xag_page_settings', XAG_URL . 'assets/js/page_settings.js', ['jquery'], TRUE);
            wp_register_script('xag_page_schema', XAG_URL . 'assets/js/page_schema.js', ['jquery'], TRUE);
            wp_register_script('xag_page_projects', XAG_URL . 'assets/js/page_projects.js', ['jquery'], TRUE);
            wp_register_script('xag_page_silo', XAG_URL . 'assets/js/page_silo.js', ['jquery'], TRUE);
            wp_register_script('xag_text_cloud', XAG_URL . 'assets/js/vendor/jqcloud-1.0.4.js', ['jquery'], TRUE);
            wp_register_script('xag_page_seo', XAG_URL . 'assets/js/page_seo.js', ['jquery'], TRUE);
            wp_register_script('xag_page_log', XAG_URL . 'assets/js/page_log.js', ['jquery'], TRUE);
            wp_register_script('xag_page_reviews_datepicker', XAG_URL . 'assets/js/uikit/components/datepicker.min.js', ['jquery'], TRUE);
            wp_register_script('xag_page_reviews', XAG_URL . 'assets/js/page_reviews.js', ['jquery'], TRUE);
            wp_register_script('xag_page_affiliate', XAG_URL . 'assets/js/page_affiliate.js', ['jquery'], TRUE);
            wp_register_script('xag_page_rescue', XAG_URL . 'assets/js/page_rescue.js', ['jquery'], TRUE);

            wp_register_script('xag_admin', XAG_URL . 'assets/js/xag_admin.js', ['jquery'], TRUE, TRUE);
            wp_register_script('xag_exif', XAG_URL . 'assets/js/xag_exif.js', ['jquery'], TRUE, TRUE);
            wp_register_script('xag_exif_popup', XAG_URL . 'assets/js/xag_exif_popup.js', ['jquery'], TRUE, TRUE);

            // Troubleshooter
            wp_register_script('xag_troubleshooter', XAG_URL . 'assets/js/troubleshooter.js', ['jquery'], TRUE);

            /** Load Global JS **/
            wp_register_script('xag_main', XAG_URL . 'assets/js/main.js', ['jquery'], TRUE);

            /**
             *  Add a global JS object to main script
             */

            wp_localize_script('xag_main', 'xag_data',
                [
                    'wp_get'      => admin_url('admin-ajax.php'),
                    'wp_post'     => admin_url('admin-post.php'),
                    'wp_admin'    => admin_url(),
                    'plugins_url' => plugins_url('/', dirname(__FILE__)),
                    'sitename'    => get_bloginfo('name'),
                    'panel_url'   => XAG_PANEL_URL,
                    'api_key'     => base64_encode(MXAG_Api::getAPIKey())
                ]
            );

            // Styles
            wp_register_style('xag_uikit', XAG_URL . 'assets/css/uikit/uikit.min.css');
            wp_register_style('xag_uikit_notify', XAG_URL . 'assets/css/uikit/components/notify.min.css');
            wp_register_style('xag_uikit_datepicker', XAG_URL . 'assets/css/uikit/components/datepicker.min.css');
            wp_register_style('xag_uikit_tooltip', XAG_URL . 'assets/css/uikit/components/tooltip.min.css');
            wp_register_style('xag_uikit_search', XAG_URL . 'assets/css/uikit/components/search.min.css');
            wp_register_style('xag_font-awesome', XAG_URL . 'assets/css/vendor/font-awesome.min.css');
            wp_register_style('xag_font-awesome_new', XAG_URL . 'assets/css/vendor/fontawesome.min.css');
            wp_register_style('xag_chosen', XAG_URL . 'assets/css/vendor/chosen.min.css');
            wp_register_style('xag_animate', XAG_URL . 'assets/css/vendor/animate.css');
            wp_register_style('xag_main', XAG_URL . 'assets/css/main.css');
            wp_register_style('xag_admin', XAG_URL . 'assets/css/xag_admin.css');
            wp_register_style('xag_exif', XAG_URL . 'assets/css/xag_exif.css');
            wp_register_style('xag_exif_popup', XAG_URL . 'assets/css/xag_exif_popup.css');
            wp_register_style('xag_admin_bootstrap_grid', XAG_URL . 'assets/css/vendor/uikit-grid.css');
            wp_register_style('xag_datatables', XAG_URL . 'assets/css/vendor/dataTables.uikit.min.css');
            wp_register_style('xag_tagsinput', XAG_URL . 'assets/css/vendor/jquery.tagsinput.css');
            wp_register_style('xag_jstree', XAG_URL . 'assets/css/vendor/jstree/themes/default/style.min.css');
            wp_register_style('xag_uikit_datatables', XAG_URL . 'assets/css/vendor/dataTables.uikit.min.css');
            wp_register_style('xag_review_widget', XAG_URL . 'assets/css/review-widget.css');
            wp_register_style('xag_review_display', XAG_URL . 'assets/css/review-display.css');
            wp_register_style('xag_select2', XAG_URL . 'assets/css/vendor/select2.min.css');
            wp_register_style('xag_flowchart', XAG_URL . 'assets/css/vendor/jquery.flowchart.css');
            wp_register_style('xag_selectables', XAG_URL . 'assets/css/vendor/selectables.css');
            wp_register_style('xag_mdrag', XAG_URL . 'assets/css/vendor/jquery.multi-draggable.css');


            /**
             *  Page Specific CSS
             */
            wp_register_style('xag_page_silo', XAG_URL . 'assets/css/xag_page_silo.css');
            wp_register_style('xag_page_reviews', XAG_URL . 'assets/css/xag_page_reviews.css');
            wp_register_style('xag_page_affiliate', XAG_URL . 'assets/css/xag_page_affiliate.css');
            wp_register_style('xag_page_rescue', XAG_URL . 'assets/css/xag_page_rescue.css');
            wp_register_style('xag_page_projects', XAG_URL . 'assets/css/xag_page_projects.css');
            wp_register_style('xag_text_cloud', XAG_URL . 'assets/css/vendor/jqcloud.css');
            wp_register_style('xag_page_ranktracker', XAG_URL . 'assets/css/xag_page_ranktracker.css');
        }


        // Create Admin Menu Pages
        public static function createPages ()
        {
            global $xag_pages, $xag_global_js, $xag_global_css;
            foreach ($xag_pages as $p) {
                if (get_option('ps_hidden')) {
                    continue;
                }

                $page_hook_suffix = NULL;
                if ($p['Type'] == 'MENU') {
                    $page_hook_suffix = add_menu_page($p['Page_Title'], $p['Menu_Title'], $p['Capability'], $p['Slug'], ['XAG_Init', 'loadPage'], XAG_URL . $p['Icon'], 2);
                } else {
                    if (XAG_Licencator::isLicenseSet()) {

                        $ps_features = get_option('ps_features');

                        if ($ps_features != FALSE && is_array($ps_features) && isset($p['Feature'])) {

                            if (!in_array($p['Feature'], $ps_features)) {

                                // Display upgrade page
                                $page_hook_suffix = add_submenu_page($p['Parent_Slug'], 'Access Denied', $p['Menu_Title'], $p['Capability'], 'xagio-upgrade-' . strtolower($p['Feature']), ['XAG_Init', 'loadPage']);

                            } else {

                                // Feature is allowed to be used
                                $page_hook_suffix = add_submenu_page($p['Parent_Slug'], $p['Page_Title'], $p['Menu_Title'], $p['Capability'], $p['Slug'], ['XAG_Init', 'loadPage']);

                            }

                        } else {

                            if (isset($p['Feature']) && ($ps_features == 'none' || empty($ps_features))) {

                                // Display upgrade page
                                $page_hook_suffix = add_submenu_page($p['Parent_Slug'], 'Access Denied', $p['Menu_Title'], $p['Capability'], 'xagio-upgrade-' . strtolower($p['Feature']), ['XAG_Init', 'loadPage']);

                            } else {

                                // Features are not defined
                                $page_hook_suffix = add_submenu_page($p['Parent_Slug'], $p['Page_Title'], $p['Menu_Title'], $p['Capability'], $p['Slug'], ['XAG_Init', 'loadPage']);

                            }

                        }
                    }
                }
                add_action('admin_print_scripts-' . $page_hook_suffix, function () use ($p, $xag_global_js) {
                    foreach ($xag_global_js as $enqueueName) {
                        wp_enqueue_script($enqueueName);
                    }
                    foreach ($p['JavaScript'] as $enqueueName) {
                        wp_enqueue_script($enqueueName);
                    }
                });
                add_action('admin_print_styles-' . $page_hook_suffix, function () use ($p, $xag_global_css) {
                    foreach ($xag_global_css as $enqueueName) {
                        wp_enqueue_style($enqueueName);
                    }
                    foreach ($p['Css'] as $enqueueName) {
                        wp_enqueue_style($enqueueName);
                    }
                });
            }
        }

        // Load a Page
        public static function loadPage ()
        {
            $page = $_GET['page'];
            $page = str_replace('xagio-', '', $page);
            $page = str_replace('-', '_', $page);
            $page = 'page_' . $page . '.php';
            $page = XAG_PATH . '/pages/' . $page;
            if (file_exists($page)) {
                require_once($page);
            } else {
                echo "<h1>404 - Page not Found!</h1>";
            }
        }

        // Load all Models and init them
        public static function loadModels ()
        {
            $models = glob(XAG_PATH . '/models/wp_*');
            sort($models);
            foreach ($models as $m) {
                require_once($m);

                // Init the model
                $x     = explode('wp_', $m);
                $class = 'MXAG_' . ucfirst(str_replace('.php', '', $x[1]));
                if (method_exists($class, 'initialize')) {
                    call_user_func([$class, 'initialize']);
                }
            }
        }

        // Register activation/deactivation/uninstall hooks
        public static function registerPluginHooks ()
        {
            register_activation_hook(XAG_SLUG, ['XAG_Init', 'activate']);
            register_deactivation_hook(XAG_SLUG, ['XAG_Init', 'deactivate']);
            register_uninstall_hook(XAG_SLUG, ['XAG_Init', 'uninstall']);
        }

        // Create/Modify Tables
        public static function createTables ()
        {
            $models = glob(XAG_PATH . '/models/wp_*');
            sort($models);
            foreach ($models as $m) {
                $x     = explode('wp_', $m);
                $class = 'MXAG_' . ucfirst(str_replace('.php', '', $x[1]));
                if (method_exists($class, 'createTable')) {
                    call_user_func([$class, 'createTable']);
                }
            }
        }

        // Remove Tables
        public static function removeTables ()
        {
            $models = glob(XAG_PATH . '/models/wp_*');
            sort($models);
            foreach ($models as $m) {
                require_once($m);
                $x     = explode('wp_', $m);
                $class = 'MXAG_' . ucfirst(str_replace('.php', '', $x[1]));
                if (method_exists($class, 'removeTable')) {
                    call_user_func([$class, 'removeTable']);
                }
            }
        }

        public static function removeOptions ()
        {

            $options   = [
                'ps_disable_redirects', 'ps_seo_always_on', 'ps_schema_always_on', 'ps_pretty_schemas', 'ps_remove_footprint', 'ps_recaptcha_enabled', 'xag_ts_alternative_api', 'ps_disable_failsafe', 'xag_review_widget_status', 'xag_disable_canonicals', 'xag_default_og_status', 'xag_disable_log404s', 'xag_enable_spider404s', 'xag_enable_404s_with_referr_url', 'xag_global_404_redirections_url', 'xag_max_log_limit', 'xag_ignore_404_urls', 'xag_ts_memory_limit', 'XAG_CURRENT_VERSION', 'prs', 'ps_api_settings', 'ps_hidden', 'ps_features', 'ps_review', 'ps_seo_title_separator', 'ps_seo_target_keyword', 'ps_seo_force_noodp', 'ps_seo_index_subpages', 'ps_seo_title', 'ps_seo_description', 'ps_seo_post_types', 'ps_seo_default_post_og', 'ps_seo_custom_post_types', 'ps_seo_taxonomies', 'ps_seo_miscellaneous', 'ps_seo_title_fb', 'ps_seo_description_fb', 'ps_seo_image_fb', 'ps_seo_title_tw', 'ps_seo_description_tw', 'ps_seo_image_tw', 'ps_seo_verify_bing', 'ps_seo_verify_google', 'ps_seo_verify_google_analytics', 'ps_seo_verify_pinterest', 'ps_seo_verify_yandex', 'ps_seo_global_scripts', 'ps_seo_global_footer_scripts', 'XAG_MIGRATION', 'xag_redirect_mask', 'ps_backup_settings', 'ps_backup_limit', 'ps_backup_location', 'ps_shared_scripts'
            ];
            $post_meta = ['ps_seo_enabled', 'ps_seo_title', 'ps_seo_description', 'ps_seo_url', 'ps_seo_keyword', 'ps_seo_notes', 'ps_seo_scripts', 'ps_meta_robots_enabled', 'ps_seo_metarobots_index', 'ps_seo_metarobots_follow', 'ps_seo_metarobots_advanced', 'ps_seo_canonical', 'ps_seo_tw_title', 'ps_seo_tw_desc', 'ps_seo_tw_img', 'ps_seo_fb_title', 'ps_seo_fb_desc', 'ps_seo_fb_img', 'ps_seo_disable_global_scripts', 'ps_seo_disable_page_scripts', 'ps_schema_data', 'ps_schema_meta', 'xag_exif_desc', 'xag_exif_latitude', 'xag_exif_longitude'];

            foreach ($options as $option) {
                delete_option($option);
            }

            foreach ($post_meta as $meta) {
                delete_post_meta_by_key($meta);
            }

        }

        public static function checkLicenseFile ()
        {
            if (file_exists(XAG_PATH . '/data.lic')) {
                XAG_Licencator::activateLicense();
            }
        }

        public static function sendLog ($action, $data)
        {

            $license_email = '';
            $license_key   = '';
            if (!$license_set = XAG_Licencator::isLicenseSet($license_email, $license_key)) {
                return FALSE;
            }

            // Set the HTTP Query
            $http_query = [
                'license_email' => $license_email,
                'license_key'   => $license_key,
            ];

            $http_query = array_merge($http_query, [
                'action' => $action,
                'data'   => $data
            ]);

            // Set the domain name
            $domain = parse_url(admin_url());
            $domain = $domain['host'];
            $domain = str_replace('www.', '', $domain);

            wp_remote_post(XAG_PANEL_URL . "/api/log", [
                    'user-agent'  => "Xagio - " . XAG_CURRENT_VERSION . " ($domain)",
                    'timeout'     => 30,
                    'redirection' => 5,
                    'httpversion' => '1.0',
                    'blocking'    => FALSE,
                    'method'      => 'POST',
                    'body'        => $http_query,
                ]
            );

            return TRUE;
        }

        // Init the plugin
        public static function init ()
        {
            // Init the models
            self::loadModels();

            // Register hooks
            self::registerPluginHooks();

            // Init the hooks
            self::hooks();

            // Perform a version check
            self::checkVersion();

            // Install Recovery
            self::installFailSafe();
        }
    }

}
