<?php

if ( ! class_exists( 'XAG_Licencator' ) ) {

	class XAG_Licencator {

		public static function initialize() {
			add_action('xag_LicenseCheck', array('XAG_Licencator', 'checkLicenseRemote'));
			if ( ! wp_next_scheduled( 'xag_LicenseCheck' ) ) {
				wp_schedule_event( time(), 'daily', 'xag_LicenseCheck' );
			}
		}

		// Secure Encryption
		public static function decrypt($string, $salt, $softDecrypt = true)
		{
		    // Decrypt $string
            $key = hash("SHA256", $salt, true);
            $iv = '741952hheeyy66#cs!9hjv887mxx7@8y';

            if (version_compare(PHP_VERSION, '7.0', '<')) {
                $decrypted = base64_decode($string);
                $decrypted = @mcrypt_decrypt(MCRYPT_RIJNDAEL_256, $key, $decrypted, MCRYPT_MODE_CBC, $iv);
                $decrypted = str_replace("\0", "", $decrypted);
            } else {
                $string = base64_decode($string);
                $ivSize = openssl_cipher_iv_length($cipher="AES-256-CBC");
                $iv = substr($iv, 16);
                $decrypted = openssl_decrypt(substr($string, $ivSize), $cipher, $key, OPENSSL_RAW_DATA, $iv);
            }

            return $decrypted;
		}

		// Secure Encryption
		public static function encrypt($string, $salt)
		{
		    // Prevent license from being deactivated
		    if ($string == 'license_email' || $string == 'license_key') {
                $salt .= '_Xagio';
            }

            $key = hash("SHA256", $salt, true); // 32 * 8 = 256 bit key
            $iv = '741952hheeyy66#cs!9hjv887mxx7@8y'; // 32 * 8 = 256 bit iv

            if (version_compare(PHP_VERSION, '7.0', '<')) {
                $encrypted = @mcrypt_encrypt(MCRYPT_RIJNDAEL_256, $key, $string, MCRYPT_MODE_CBC, $iv);
                $encrypted = base64_encode($encrypted);
            } else {
                $iv = substr($iv, 16);
                $encrypted = openssl_encrypt($string, "AES-256-CBC", $key, OPENSSL_RAW_DATA, $iv);
                $encrypted = base64_encode($iv . $encrypted);
            }

            return $encrypted;
		}


		public static function isLicenseSet(&$license_email = false, &$license_key = false) {
			$salt_local = $_SERVER['SERVER_NAME'];
			$license_email = get_option(XAG_Licencator::encrypt('license_email', $salt_local));
			$license_key   = get_option(XAG_Licencator::encrypt('license_key', $salt_local));
			if ($license_email == false || $license_key == false) {
				return false;
			} else {
				$license_email = XAG_Licencator::decrypt($license_email, $salt_local, false);
				$license_key   = XAG_Licencator::decrypt($license_key, $salt_local, false);
				return true;
			}
		}

		public static function deactivateLicense() {
			// Set the local salt variable
			$salt_local = $_SERVER['SERVER_NAME'];

			// Perform remote license deactivation
			$license_email = get_option(XAG_Licencator::encrypt('license_email', $salt_local));
			$license_key   = get_option(XAG_Licencator::encrypt('license_key', $salt_local));

			// Decrypt Licenses
			$license_email = XAG_Licencator::decrypt($license_email, $salt_local);
			$license_key   = XAG_Licencator::decrypt($license_key, $salt_local);

			// Verify if everything is normal
			if (empty($license_email) || empty($license_key)) {
				XAG_Init::json('error', 'Invalid request.');
			}

			// Set the remote salt variable
			$salt = $license_key;

			// Set the domain name
			$domain = parse_url(admin_url());
			$domain = $domain['host'];
			$domain = str_replace('www.', '', $domain);

			// Set the HTTP Query
			$http_query = array(
				'license_email' => $license_email,
				'license_key'   => $license_key,
				'domain'        => $domain
			);

			// Build HTTP Query
			$http_query = self::buildQuery($http_query);

			// Remove license key and license email
			self::removeLicense($salt_local);

			$response = wp_remote_request( XAG_PANEL_URL . "/api/license?$http_query", array(
				'user-agent'  => "Xagio - " . XAG_CURRENT_VERSION . " ($domain)",
				'method'      => 'DELETE',
				'timeout'     => 30
			) );

			// Verify the response
			if ( is_wp_error( $response ) ) {
				XAG_Init::json('error', 'There was a problem while communicating with our server. Make sure your server meets all the requirements.');
			} else {
				if (!isset($response['body'])) {
					XAG_Init::json('error', 'The license information that you submitted is not valid. Please try again.');
				} else {
					$code     = $response['response']['code'];
					$response = $response['body'];

					if (empty($response)) {
						XAG_Init::json('error', 'The license information that you submitted is not valid. Please try again.');
					} else {
						$response = json_decode($response, true);
						$message  = $response['message'];

						if ($code <= 201) {
							XAG_Init::json('success', 'Your license has been successfully deactivated.');
						} else {
							XAG_Init::json('error', $message);
						}
					}
				}
			}
		}

		public static function activateLicense() {

			// Check if fields are being sent properly
			$showOutput = true;
			if (file_exists(XAG_PATH . '/data.lic')) {
				$license = explode("\n", file_get_contents(XAG_PATH . '/data.lic'));
				$license_email = trim($license[0]);
				$license_key   = trim($license[1]);
				$showOutput    = false;
			} else if (isset($_POST['license_email']) && isset($_POST['license_key'])) {
				$license_email = trim($_POST['license_email']);
				$license_key   = trim($_POST['license_key']);
			} else if (!isset($_POST['license_email'], $_POST['license_key'])) {
				XAG_Init::json('error', 'Invalid request.');
			}

			// Verify if everything is normal
			if (empty($license_email) || empty($license_key)) {
			    XAG_Init::json('error', 'Invalid request.');
			}

			// Set the local salt variable
			$salt_local = $_SERVER['SERVER_NAME'];

			// Set the domain name
			$domain = parse_url(admin_url());
			$domain = $domain['host'];
			$domain = str_replace('www.', '', $domain);

			// Get the API
			$ps_api = get_option(XAG_Licencator::encrypt('ps_api', $salt_local));

			// Set the HTTP Query
			$http_query = array(
				'license_email' => $license_email,
				'license_key'   => $license_key,
				'domain'        => $domain,
				'admin_post'    => (get_option('prs_ts_alternative_api') == TRUE) ? get_site_url() . '/xagio-api.php' : admin_url() . 'admin-post.php',
				'api_key'       => $ps_api,
                'blog_name'     => get_bloginfo('name'),
                'blog_desc'     => get_bloginfo('description'),
			);

			// Build HTTP Query
			$http_query = self::buildQuery($http_query);

			$response = wp_remote_get( XAG_PANEL_URL . "/api/license?$http_query", array(
					'user-agent'  => "Xagio - " . XAG_CURRENT_VERSION . " ($domain)",
					'timeout'     => 30,
					'redirection' => 5,
					'httpversion' => '1.0',
					'blocking'    => true
				)
			);

			if (XAG_DEBUG === TRUE) {
				var_dump($response);
			}

			// Verify the response
			if ( is_wp_error( $response ) ) {
				if ($showOutput) XAG_Init::json('error', 'There was a problem while communicating with our server. Make sure your server meets all the requirements.');
			} else {
				if (!isset($response['body'])) {
					if ($showOutput) XAG_Init::json('error', 'The license information that you submitted is not valid. Please try again.');
				} else {
					$code     = $response['response']['code'];
					$response = $response['body'];

					if (empty($response)) {
						if ($showOutput) XAG_Init::json('error', 'The license information that you submitted is not valid. Please try again.');
					} else {
						$response = json_decode($response, true);
						$message  = $response['message'];

						if ($code <= 201) {
							// All went ok, insert the license info into the DB
							$license_email = XAG_Licencator::encrypt($license_email, $salt_local);
							$license_key   = XAG_Licencator::encrypt($license_key, $salt_local);

							update_option(XAG_Licencator::encrypt('license_email', $salt_local), $license_email);
							update_option(XAG_Licencator::encrypt('license_key', $salt_local), $license_key);

							@unlink(XAG_PATH . '/data.lic');

                            if ($showOutput) XAG_Init::json('success', $message);
						} else {
							if ($showOutput) XAG_Init::json('error', $message);
						}
					}
				}
			}

		}

		public static function checkLicenseRemote() {
			// Set the local salt variable
			$salt_local = $_SERVER['SERVER_NAME'];

			// Perform remote license deactivation
			$license_email = get_option(XAG_Licencator::encrypt('license_email', $salt_local));
			$license_key   = get_option(XAG_Licencator::encrypt('license_key', $salt_local));

			// Decrypt Licenses
			$license_email = XAG_Licencator::decrypt($license_email, $salt_local);
			$license_key   = XAG_Licencator::decrypt($license_key, $salt_local);

			// Verify if everything is normal
			if (empty($license_email) || empty($license_key)) {
				XAG_Init::json('error', 'Invalid request.');
			}

			// Set the domain name
			$domain = parse_url(admin_url());
			$domain = $domain['host'];
			$domain = str_replace('www.', '', $domain);

			// Get the API
			$ps_api = get_option(XAG_Licencator::encrypt('ps_api', $salt_local));

			// Set the HTTP Query
			$http_query = array(
				'license_email' => $license_email,
				'license_key'   => $license_key,
				'domain'        => $domain,
				'admin_post'    => (get_option('prs_ts_alternative_api') == TRUE) ? get_site_url() . '/xagio-api.php' : admin_url() . 'admin-post.php',
				'api_key'       => $ps_api,
				'blog_name'     => get_bloginfo('name'),
				'blog_desc'     => get_bloginfo('description'),
			);

			// Build HTTP Query
			$http_query = self::buildQuery($http_query);

			$response = wp_remote_get( XAG_PANEL_URL . "/api/license?$http_query", array(
					'user-agent'  => "Xagio - " . XAG_CURRENT_VERSION . " ($domain)",
					'timeout'     => 30,
					'redirection' => 5,
					'httpversion' => '1.0',
					'blocking'    => true
				)
			);

			if (XAG_DEBUG === TRUE) {
				var_dump($response);
			}

			// Verify the response
			if ( is_wp_error( $response ) ) {
				XAG_Init::json('error', 'There was a problem while communicating with our server. Make sure your server meets all the requirements.');
			} else {
				if (!isset($response['body'])) {
					XAG_Init::json('error', 'The license information that you submitted is not valid. Please try again.');
				} else {

					$code     = $response['response']['code'];
					$response = $response['body'];

					if (empty($response)) {
						XAG_Init::json('error', 'The license information that you submitted is not valid. Please try again.');
					} else {

						// Send the log to Panel so we can analyze it
						$log = base64_encode(serialize($response));
						XAG_Init::sendLog('XAG_Licencator::checkLicenseRemote:' . $code, $log);

						$response = json_decode($response, true);
						if ($response != false) {

							$message  = $response['message'];
							if ($code <= 201) {
								XAG_Init::json('success', $message);
							} else {
								self::removeLicense($salt_local);
								XAG_Init::json('error', $message);
							}

						}

					}
				}
			}

		}

		private static function removeLicense($salt_local) {
			// Remove license key and license email
			delete_option(XAG_Licencator::encrypt('license_email', $salt_local));
			delete_option(XAG_Licencator::encrypt('license_key', $salt_local));
		}

		public static function buildQuery($params) {
			return http_build_query($params, '', '&');
		}

	}

}
