<?php

/** Global Variables */
define('XAG_REQUIRED_PHP_VERSION', '5.4');
define('XAG_REQUIRED_WP_VERSION', '4.4');
define('XAG_REQUIRED_WP_NETWORK', FALSE);
define('XAG_PATH', dirname(__FILE__));
define('XAG_SLUG', 'xagio/xagio.php');
define('XAG_SLUG_NAME', 'xagio');
define('XAG_URL', plugin_dir_url(__FILE__));
define('XAG_DISABLE_REDIRECTS', filter_var(get_option('ps_disable_redirects'), FILTER_VALIDATE_BOOLEAN));
define('XAG_FORCE_SEO', filter_var(get_option('ps_seo_always_on'), FILTER_VALIDATE_BOOLEAN));
define('XAG_FORCE_SCHEMA', filter_var(get_option('ps_schema_always_on'), FILTER_VALIDATE_BOOLEAN));
define('XAG_PRETTY_SCHEMA', filter_var(get_option('ps_pretty_schemas'), FILTER_VALIDATE_BOOLEAN));
define('XAG_REMOVE_FOOTPRINT', filter_var(get_option('ps_remove_footprint'), FILTER_VALIDATE_BOOLEAN));
define('XAG_RECAPTCHA', filter_var(get_option('ps_recaptcha_enabled'), FILTER_VALIDATE_BOOLEAN));
define('XAG_ALT_API', filter_var(get_option('prs_ts_alternative_api'), FILTER_VALIDATE_BOOLEAN));
define('XAG_DISABLE_FAILSAFE', filter_var(get_option('ps_disable_failsafe'), FILTER_VALIDATE_BOOLEAN));
define('XAG_ENABLED_DISABLE_REVIEW_WIDGET_STATUS', filter_var(get_option('prs_review_widget_status'), FILTER_VALIDATE_BOOLEAN));
define('XAG_DISABLE_CANONICALS', filter_var(get_option('prs_disable_canonicals'), FILTER_VALIDATE_BOOLEAN));
define('XAG_DEFAULT_OG_STATUS', filter_var(get_option('prs_default_og_status'), FILTER_VALIDATE_BOOLEAN));
define('XAG_DISABLE_Log404s', filter_var(get_option('prs_disable_log404s'), FILTER_VALIDATE_BOOLEAN));
define('XAG_ENABLE_SPIDER404s', filter_var(get_option('prs_enable_spider404s'), FILTER_VALIDATE_BOOLEAN));
define('XAG_ENABLE_404s_with_REFERR', filter_var(get_option('prs_enable_404s_with_referr_url'), FILTER_VALIDATE_BOOLEAN));
define('XAG_DEV_MODE', filter_var(get_option('prs_dev_mode'), FILTER_VALIDATE_BOOLEAN));

/** Global Variables */
/** Verify the Panel communication */
if (XAG_DEV_MODE == TRUE) {
    define('XAG_PANEL_URL', 'https://dev.xagio.net');
} else {
    define('XAG_PANEL_URL', 'https://app.xagio.net');
}
/** Verify the Panel communication */

/** Define Global JS/CSS */
$xag_global_js  = [
    'xag_uikit',
    'xag_uikit_notify',
    'xag_uikit_accordion',
    'xag_uikit_lightbox',
    'xag_uikit_grid',
    'xag_uikit_tooltip',
    'xag_main',
    'xag_ajaxq'
];
$xag_global_css = [
    'xag_main',
    'xag_uikit',
    'xag_font-awesome'
];

/** Define Pages */
$xag_pages = [
    // Main Tab
    [
        "Type"        => "MENU",
        "Page_Title"  => "Xagio",
        "Menu_Title"  => "Xagio",
        "Capability"  => "manage_options",
        "Slug"        => "xagio-settings",
        "Parent_Slug" => "",
        "Icon"        => "/assets/img/logo-menu-xagio.png",
        "JavaScript"  => [
            'xag_page_settings',
            'xag_tagsinput',
            'xag_uikit_search'
        ],
        "Css"         => [
            'xag_animate',
            'xag_tagsinput'
        ]
    ],
    // Settings
    [
        "Type"        => "SUBMENU",
        "Page_Title"  => "Dashboard",
        "Menu_Title"  => "Dashboard",
        "Capability"  => "manage_options",
        "Slug"        => "xagio-settings",
        "Parent_Slug" => "xagio-settings",
        "Icon"        => "/assets/img/logo-menu-xagio.png",
        "JavaScript"  => [
            'xag_page_settings',
            'xag_tagsinput',
            'xag_uikit_search'
        ],
        "Css"         => [
            'xag_animate',
            'xag_tagsinput'
        ]
    ],
    // SEO Settings
    [
        "Type"        => "SUBMENU",
        "Page_Title"  => "SEO Settings",
        "Menu_Title"  => "SEO Settings",
        "Capability"  => "manage_options",
        "Slug"        => "xagio-seo",
        "Parent_Slug" => "xagio-settings",
        "Icon"        => "/assets/img/logo-menu-xagio.png",
        "JavaScript"  => [
            'xag_page_seo',
            'media-upload',
            'thickbox'
        ],
        "Css"         => [
            'thickbox'
        ],
        'Feature'     => 'seo'
    ],
    // 301 & 404 Management
    [
        "Type"        => "SUBMENU",
        "Page_Title"  => "301 & 404 Management",
        "Menu_Title"  => "301 & 404 Management",
        "Capability"  => "manage_options",
        "Slug"        => "xagio-log",
        "Parent_Slug" => "xagio-settings",
        "Icon"        => "/assets/img/logo-menu-xagio.png",
        "JavaScript"  => [
            'xag_page_log',
            'media-upload',
            'thickbox',
            'xag_uikit_sortable',
            'xag_datatables',
            'xag_datatables_uikit'
        ],
        "Css"         => [
            'thickbox'
        ],
        'Feature'     => 'log'
    ],
    // Reviews
    [
        "Type"        => "SUBMENU",
        "Page_Title"  => "Reviews",
        "Menu_Title"  => "Reviews",
        "Capability"  => "manage_options",
        "Slug"        => "xagio-reviews",
        "Parent_Slug" => "xagio-settings",
        "Icon"        => "/assets/img/logo-menu-xagio.png",
        "JavaScript"  => [
            'xag_page_reviews_datepicker',
            'xag_page_reviews',
            'xag_uikit_slideset',
            'xag_uikit_sortable',
            'xag_datatables',
            'xag_datatables_uikit'
        ],
        "Css"         => [
            'xag_review_widget',
            'xag_review_display',
            'xag_page_reviews'
        ],
        'Feature'     => 'reviews'
    ],
    // Project Management
    [
        "Type"        => "SUBMENU",
        "Page_Title"  => "Project Planner",
        "Menu_Title"  => "Project Planner",
        "Capability"  => "manage_options",
        "Slug"        => "xagio-projects",
        "Parent_Slug" => "xagio-settings",
        "Icon"        => "/assets/img/logo-menu-xagio.png",
        "JavaScript"  => [
            'xag_datatables',
            'xag_datatables_uikit',
            'xag_tablesorter',
            'xag_jstree',
            'xag_uikit_upload',
            'xag_select2',
            'xag_tagsinput',
            'xag_jquery_sortable',
            'xag_jquery_multisortable',
            'xag_text_cloud',
            'xag_panzoom',
            'xag_mousewheel',
            'xag_flowchart',
            'xag_jquery_ui',
            'xag_page_projects'
        ],
        "Css"         => [
            'xag_datatables',
            'xag_page_projects',
            'xag_jstree',
            'xag_select2',
            'xag_tagsinput',
            'xag_text_cloud',
            'xag_flowchart',
        ],
        'Feature'     => 'projectplanner'
    ],
    // Silo Builder
    [
        "Type"        => "SUBMENU",
        "Page_Title"  => "SILO Builder",
        "Menu_Title"  => "SILO Builder",
        "Capability"  => "manage_options",
        "Slug"        => "xagio-silo",
        "Parent_Slug" => "xagio-settings",
        "Icon"        => "/assets/img/logo-menu-xagio.png",
        "JavaScript"  => [
            'xag_mdrag',
            'xag_datatables',
            'xag_datatables_uikit',
            'xag_tablesorter',
            'xag_jstree',
            'xag_uikit_upload',
            'xag_select2',
            'xag_tagsinput',
            'xag_jquery_sortable',
            'xag_jquery_multisortable',
            'xag_text_cloud',
            'xag_panzoom',
            'xag_mousewheel',
            'xag_flowchart',
            'xag_jquery_ui',
            'xag_page_silo',
            'xag_selectables'
        ],
        "Css"         => [
            'xag_mdrag',
            'xag_datatables',
            'xag_page_projects',
            'xag_page_silo',
            'xag_jstree',
            'xag_select2',
            'xag_tagsinput',
            'xag_text_cloud',
            'xag_flowchart',
            'xag_selectables'
        ],
        'Feature'     => 'silo'
    ],
    // Link Management
    [
        "Type"        => "SUBMENU",
        "Page_Title"  => "Link Management",
        "Menu_Title"  => "Link Management",
        "Capability"  => "manage_options",
        "Slug"        => "xagio-link-management",
        "Parent_Slug" => "xagio-settings",
        "Icon"        => "/assets/img/logo-menu-xagio.png",
        "JavaScript"  => [
            'xag_page_affiliate',
            'xag_uikit_pagination',
            'xag_datatables',
            'xag_datatables_uikit',
            'media-upload',
            'thickbox',
            'xag_google_charts'
        ],
        "Css"         => [
            'xag_page_affiliate',
            'xag_datatables',
            'thickbox'
        ],
        'Feature'     => 'linkmanagement'
    ],
    // Rescue Center
    [
        "Type"        => "SUBMENU",
        "Page_Title"  => "Rescue Center",
        "Menu_Title"  => "Rescue Center",
        "Capability"  => "manage_options",
        "Slug"        => "xagio-rescue",
        "Parent_Slug" => "xagio-settings",
        "Icon"        => "/assets/img/logo-menu-xagio.png",
        "JavaScript"  => [
            'xag_page_rescue',
            'xag_jstree'
        ],
        "Css"         => [
            'xag_page_rescue',
            'xag_jstree'
        ],
        'Feature'     => 'rescue'
    ],
    //Security Center
    //    [
    //        "Type"        => "SUBMENU",
    //        "Page_Title"  => "Security Center",
    //        "Menu_Title"  => "Security Center",
    //        "Capability"  => "manage_options",
    //        "Slug"        => "xagio-security",
    //        "Parent_Slug" => "xagio-settings",
    //        "Icon"        => "/assets/img/logo-menu-xagio.png",
    //        "JavaScript"  => [
    //            'xag_page_security'
    //        ],
    //        "Css"         => [
    //            'xag_page_security',
    //            'xag_font-awesome_new',
    //        ],
    //        'Feature'     => 'security'
    //    ]
];
/** Define Pages */

/** Try to use unlimited POWAAAAH */
if (get_option('prs_ts_memory_limit') == TRUE) {
    @ini_set('memory_limit', '-1');
}
/** Try to use unlimited POWAAAAH */

/** Turn on error reporting if debug is on */
if (XAG_DEBUG) {
    @ini_set('display_errors', 1);
    @error_reporting(E_ALL);
} else {
    // Turn off PHP errors / warnings
    @ini_set('display_errors', 0);
    @error_reporting(0);
}

/** Set the Version in Options */
if (!get_option('XAG_CURRENT_VERSION')) {
    update_option('XAG_CURRENT_VERSION', XAG_CURRENT_VERSION);
}
/** Set the Version in Options */

/** Include all dependencies */
$files = glob(XAG_PATH . '/inc/wp_*');
foreach ($files as $f) {
    require_once($f);
}
/** Include all dependencies */

/** Initialize Licencator */
XAG_Licencator::initialize();
/** Initialize Licencator */

/** Start the plugin */
XAG_Init::init();
