<?php

if ( ! class_exists( 'MXAG_Affiliate' ) ) {

	class MXAG_Affiliate extends MXAG_Model {

		public static function initialize() {
			add_action('admin_post_xag_searchClickbank', array('MXAG_Affiliate', 'searchClickbank'));
			add_action('admin_post_xag_searchAmazon', array('MXAG_Affiliate', 'searchAmazon'));
			add_action('admin_post_xag_getMarketHealth', array('MXAG_Affiliate', 'getMarketHealth'));

			add_filter('cron_schedules', array('MXAG_Affiliate', 'customSchedules'));
			add_action('xag_downloadClickbankData', array('MXAG_Affiliate', 'downloadClickbankData'));
			if (! wp_next_scheduled ( 'xag_downloadClickbankData' )) {
				wp_schedule_event(time(), 'weekly', 'xag_downloadClickbankData');
			}
		}

		public static function customSchedules($schedules) {
			if(!isset($schedules["weekly"])){
				$schedules["weekly"] = array(
					'interval' => 604800,
					'display' => __('Once every week'));
			}
			return $schedules;
		}

		/**
		 *  MarketHealth
		 */
		public static function getMarketHealth() {
			$apis = get_option('ps_api_settings');

			if (
				!isset($apis['markethealth_api'])
			) {
				XAG_Init::json('error', 'Please set up your MarketHealth API key on Panel first.');
				return;
			}

			if (
				empty($apis['markethealth_api'])
			) {
				XAG_Init::json('error', 'Please set up your MarketHealth API key on Panel first.');
				return;
			}

			$MarketHealthAPI = $apis['markethealth_api'];

			$response = wp_remote_get( "http://stats.markethealth.com/offers/offers.json", array(
					'user-agent'  => "Xagio - " . XAG_CURRENT_VERSION,
					'timeout'     => 30,
					'redirection' => 5,
					'httpversion' => '1.0',
					'blocking'    => true,
					'body'        => array(
						'api_key' => $MarketHealthAPI
					)
				)
			);

			if ( is_wp_error( $response ) ) {
				XAG_Init::json('error', 'There was a problem retrieving MarketHealth data.');
			} else {
				if ( !isset( $response['body'] ) ) {
					XAG_Init::json('error', 'There was a problem retrieving MarketHealth data.');
				} else {
					$data = json_decode($response['body'], true);
					if (!$data) {
						XAG_Init::json('error', 'There was a problem retrieving MarketHealth data.');
					} else {;
						XAG_Init::json('success', 'Successfully retrieved MarketHealth data.', $data);
					}
				}
			}

		}

		/**
		 *  Amazon
		 */
		public static function searchAmazon() {

			// Load the Amazon Class
			$aClass = XAG_PATH.'/ext/ApaiIO/autoload.php';
			if (file_exists($aClass)) {
				require_once( $aClass );
			} else {
				XAG_Init::json('error', 'Amazon Library not found. Please contact support.');
				return;
			}

			// Load the keys
			$apis = get_option('ps_api_settings');
			if (
				!isset($apis['amazon_AssociateTag']) ||
				!isset($apis['amazon_AWSAccessKeyId']) ||
				!isset($apis['amazon_AWSSecretKey'])
			) {
				XAG_Init::json('error', 'Please set up your Amazon Associates API keys on Panel before trying to search for products.');
				return;
			}

			if (
				empty($apis['amazon_AssociateTag']) ||
				empty($apis['amazon_AWSAccessKeyId']) ||
				empty($apis['amazon_AWSSecretKey'])
			) {
				XAG_Init::json('error', 'Please set up your Amazon Associates API keys on Panel before trying to search for products.');
				return;
			}

			$keyword        = trim($_POST['keyword']);
			$page           = (isset($_POST['page'])) ? $_POST['page'] : 1;

			if (empty($keyword)) {
				XAG_Init::json('error', 'You must provide a keyword before searching.');
				return;
			}

			$AssociateTag   = $apis['amazon_AssociateTag'];
			$AWSAccessKeyId = $apis['amazon_AWSAccessKeyId'];
			$AWSSecretKey   = $apis['amazon_AWSSecretKey'];

			$conf = new \ApaiIO\Configuration\GenericConfiguration();
			try {
				$conf
					->setCountry('com')
					->setAccessKey($AWSAccessKeyId)
					->setSecretKey($AWSSecretKey)
					->setAssociateTag($AssociateTag);
			} catch (\Exception $e) {
				XAG_Init::json('error', $e->getMessage());
				return;
			}
			$apaiIO = new \ApaiIO\ApaiIO($conf);
			$search = new \ApaiIO\Operations\Search();

			$search->setCategory('Blended');
			$search->setKeywords($keyword);
			$search->setPage($page);
			$search->setResponseGroup(array('Medium'));
			$formattedResponse = $apaiIO->runOperation($search);

			$xmlNode = new SimpleXMLElement($formattedResponse);;
			$arrayData = self::xmlToArray($xmlNode);

			XAG_Init::json('success', 'Successfully retrieved search results from Amazon', $arrayData);
		}

		/**
		 *  ClickBank
		 */
		public static function searchClickbank() {
			global $wpdb;

			$aColumns = array(
				'id',
				'Category',
				'Tag',
				'PopularityRank',
				'Title',
				'Description',
				'HasRecurringProducts',
				'Gravity',
				'PercentPerSale',
				'PercentPerRebill',
				'AverageEarningsPerSale',
				'InitialEarningsPerSale',
				'TotalRebillAmt',
				'Referred',
				'Commission',
				'ActivateDate',
				'ActivateDate'
			);

			/* Indexed column (used for fast and accurate table cardinality) */
			$sIndexColumn = "id";

			/* DB table to use */
			$sTable = 'prs_clickbank_data';

			/*
			 * Paging
			 */
			$sLimit = '';
			if ( isset( $_POST['iDisplayStart'] ) && $_POST['iDisplayLength'] != '-1' ) {
				$sLimit = "LIMIT " . ( $_POST['iDisplayStart'] ) . ", " .
				          ( $_POST['iDisplayLength'] );
			} else {
				$sLimit = "LIMIT 0,50";
			}


			/*
			 * Ordering
			 */
			$sOrder = '';
			if ( isset( $_POST['iSortCol_0'] ) ) {
				$sOrder = "ORDER BY  ";
				for ( $i = 0; $i < intval( $_POST['iSortingCols'] ); $i ++ ) {
					if ( $_POST[ 'bSortable_' . intval( $_POST[ 'iSortCol_' . $i ] ) ] == "true" ) {
						$sOrder .= $_POST[ 'mDataProp_' . intval( $_POST[ 'iSortCol_' . $i ] ) ]  . "
				 	" . ( $_POST[ 'sSortDir_' . $i ] ) . ", ";
					}
				}

				$sOrder = substr_replace( $sOrder, "", - 2 );
				if ( $sOrder == "ORDER BY" ) {
					$sOrder = "";
				}
			}

			$customFilters = array(
				'Title' => $_POST['Title'],
				'Description' => $_POST['Description'],
				'Commission' => $_POST['Commission'],
				'Gravity' => $_POST['Gravity'],
				'PercentPerSale' => $_POST['PercentPerSale'],
				'PercentPerRebill' => $_POST['PercentPerRebill'],
				'AverageEarningsPerSale' => $_POST['AverageEarningsPerSale'],
				'InitialEarningsPerSale' => $_POST['InitialEarningsPerSale'],
				'TotalRebillAmt' => $_POST['TotalRebillAmt'],
				'Referred' => $_POST['Referred']
			);

			$customWhere = "";

			foreach($customFilters as $key=>$column){

				if($column != ''){
					if($customWhere == ""){
						$customWhere = "WHERE ";
					}else{
						$customWhere .= " AND ";
					}

					if($key == 'Title'){
						$customWhere .= $key . " LIKE '%" . ($column) . "%' ";
					}elseif($key == 'Description'){
						$customWhere .= $key . " LIKE '%" . ($column) . "%' ";
					}else{
						$customWhere .= $key . " >= " . ($column) . " ";
					}
				}
			}

			/*
			 * SQL queries
			 * Get data to display
			 */
			$sQuery  = "
				SELECT SQL_CALC_FOUND_ROWS " . str_replace( " , ", " ", implode( ", ", $aColumns ) ) . "
				FROM   $sTable
				$customWhere
				$sOrder
				$sLimit";

			$rResult = $wpdb->get_results( $sQuery, ARRAY_A );

			$sQuery             = "SELECT FOUND_ROWS()";
			$aResultFilterTotal = $wpdb->get_results( $sQuery, ARRAY_A );
			$iFilteredTotal     = $aResultFilterTotal[0]['FOUND_ROWS()'];

			/* Total data set length */
			$sQuery       = "
				SELECT COUNT(" . $sIndexColumn . ")
				FROM   $sTable";

			$aResultTotal = $wpdb->get_results( $sQuery, ARRAY_A );
			$iTotal       = $aResultTotal[0]['COUNT(id)'];

			/*
			 * Output
			 */
			$output = array(
				"sEcho"                => intval( $_POST['sEcho'] ),
				"iTotalRecords"        => $iTotal,
				"iTotalDisplayRecords" => $iFilteredTotal,
				"aaData"               => $rResult
			);

			echo json_encode( $output );
		}

		/**
		 *  ClickBank Download
		 */
		public static function downloadClickbankData() {
			$ups = wp_upload_dir();

			$db = $ups['basedir'] . "/db.zip";
			$fb = $ups['basedir'] . "/";

			$fn = 'marketplace_feed_v2.xml';
			$fd = 'marketplace_feed_v2.dtd';
			@unlink( $db );
			@unlink( $fb . $fn );
			@unlink( $fb . $fd );

			@set_time_limit(0);

			$url = "http://accounts.clickbank.com/feeds/marketplace_feed_v2.xml.zip";

			if (file_exists($db)) {
				@unlink($db);
			}

			$fp = fopen ($db, 'w+');
			$ch = curl_init($url);

			curl_setopt($ch, CURLOPT_TIMEOUT, 60);
			curl_setopt($ch, CURLOPT_FILE, $fp);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

			curl_exec($ch);
			curl_close($ch);
			fclose($fp);

			if ( class_exists( 'ZipArchive' ) ) {
				$zip = new ZipArchive;
				$res = $zip->open( $db );
				if ( $res === true ) {
					$zip->extractTo( $fb );
					$zip->close();
				} else {
					# 'ZipArchive failed to open Clickbank ZIP.';
					return;
				}
			} else {
				if (!class_exists('PclZip')) {
					require_once ( XAG_PATH . '/ext/pclzip.lib.php' );
				}
				$archive = new PclZip( $db );
				$list = $archive->extract(PCLZIP_OPT_PATH, $fb);
				if ($list == 0) {
					# 'PclZip failed to extract Clickbank zip.';
					return;
				}
			}

			// check if unzipped
			if (!file_exists($fb . $fn )) {
				# 'Clickbank ZIP does not exist.';
				return;
			}

			// Unzipped, now push to DB
			$xml = file_get_contents( $fb . $fn );
			$xml = simplexml_load_string( $xml );
			if ( $xml === false ) {
				# 'Cannot parse Clickbank data.';
				return;
			} else {

				// Remove old data
				self::truncate('prs_clickbank_data');

				foreach ( $xml->Category as $c ) {
					$cat = $c->Name;
					foreach ( $c->Site as $s ) {
						self::insertData( array(
							'Category'               => $cat,
							'Tag'                    => $s->Id,
							'PopularityRank'         => $s->PopularityRank,
							'Title'                  => $s->Title,
							'Description'            => $s->Description,
							'HasRecurringProducts'   => $s->HasRecurringProducts,
							'Gravity'                => $s->Gravity,
							'PercentPerSale'         => $s->PercentPerSale,
							'PercentPerRebill'       => $s->PercentPerRebill,
							'AverageEarningsPerSale' => $s->AverageEarningsPerSale,
							'InitialEarningsPerSale' => $s->InitialEarningsPerSale,
							'TotalRebillAmt'         => $s->TotalRebillAmt,
							'Referred'               => $s->Referred,
							'Commission'             => $s->Commission,
							'ActivateDate'           => $s->ActivateDate
						), 'prs_clickbank_data' );
					}
				}
			}

		}

		public static function xmlToArray($xml, $options = array()) {
			$defaults = array(
				'namespaceSeparator' => ':',//you may want this to be something other than a colon
				'attributePrefix' => '@',   //to distinguish between attributes and nodes with the same name
				'alwaysArray' => array(),   //array of xml tag names which should always become arrays
				'autoArray' => true,        //only create arrays for tags which appear more than once
				'textContent' => '$',       //key used for the text content of elements
				'autoText' => true,         //skip textContent key if node has no attributes or child nodes
				'keySearch' => false,       //optional search and replace on tag and attribute names
				'keyReplace' => false       //replace values for above search values (as passed to str_replace())
			);
			$options = array_merge($defaults, $options);
			$namespaces = $xml->getDocNamespaces();
			$namespaces[''] = null; //add base (empty) namespace

			//get attributes from all namespaces
			$attributesArray = array();
			foreach ($namespaces as $prefix => $namespace) {
				foreach ($xml->attributes($namespace) as $attributeName => $attribute) {
					//replace characters in attribute name
					if ($options['keySearch']) $attributeName =
						str_replace($options['keySearch'], $options['keyReplace'], $attributeName);
					$attributeKey = $options['attributePrefix']
					                . ($prefix ? $prefix . $options['namespaceSeparator'] : '')
					                . $attributeName;
					$attributesArray[$attributeKey] = (string)$attribute;
				}
			}

			//get child nodes from all namespaces
			$tagsArray = array();
			foreach ($namespaces as $prefix => $namespace) {
				foreach ($xml->children($namespace) as $childXml) {
					//recurse into child nodes
					$childArray = self::xmlToArray($childXml, $options);
					list($childTagName, $childProperties) = each($childArray);

					//replace characters in tag name
					if ($options['keySearch']) $childTagName =
						str_replace($options['keySearch'], $options['keyReplace'], $childTagName);
					//add namespace prefix, if any
					if ($prefix) $childTagName = $prefix . $options['namespaceSeparator'] . $childTagName;

					if (!isset($tagsArray[$childTagName])) {
						//only entry with this key
						//test if tags of this type should always be arrays, no matter the element count
						$tagsArray[$childTagName] =
							in_array($childTagName, $options['alwaysArray']) || !$options['autoArray']
								? array($childProperties) : $childProperties;
					} elseif (
						is_array($tagsArray[$childTagName]) && array_keys($tagsArray[$childTagName])
						                                       === range(0, count($tagsArray[$childTagName]) - 1)
					) {
						//key already exists and is integer indexed array
						$tagsArray[$childTagName][] = $childProperties;
					} else {
						//key exists so convert to integer indexed array with previous value in position 0
						$tagsArray[$childTagName] = array($tagsArray[$childTagName], $childProperties);
					}
				}
			}

			//get text content of node
			$textContentArray = array();
			$plainText = trim((string)$xml);
			if ($plainText !== '') $textContentArray[$options['textContent']] = $plainText;

			//stick it all together
			$propertiesArray = !$options['autoText'] || $attributesArray || $tagsArray || ($plainText === '')
				? array_merge($attributesArray, $tagsArray, $textContentArray) : $plainText;

			//return node as array
			return array(
				$xml->getName() => $propertiesArray
			);
		}

		// MySQL
		public static function createTable() {
			global $wpdb;
			require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

			$charset_collate = $wpdb->get_charset_collate();
			$creation_query =
				'CREATE TABLE prs_clickbank_data (
					`id` int(20) NOT NULL AUTO_INCREMENT,
					`Category` varchar(255),
					`Tag` varchar(255),
					`PopularityRank` int(5),
					`Title` longtext,
					`Description` longtext,
					`HasRecurringProducts` varchar(255),
					`Gravity` float(11,5),
					`PercentPerSale` float(11,5),
					`PercentPerRebill` float(11,5),
					`AverageEarningsPerSale` float(11,5),
					`InitialEarningsPerSale` float(11,5),
					`TotalRebillAmt` float(11,5),
					`Referred` float(11,5),
					`Commission` int(5),
					`ActivateDate` date,
				PRIMARY KEY  (`id`)
			) ' .$charset_collate . ';';
			@dbDelta( $creation_query );
		}

		public static function removeTable() {
			global $wpdb;
			$query = 'DROP TABLE IF EXISTS prs_clickbank_data;';
			$wpdb->query( $query );
		}

	}

}