<?php

if (!class_exists('MXAG_Batches')) {

    class MXAG_Batches extends MXAG_Model
    {

        public static function initialize ()
        {
            add_filter('cron_schedules', ['MXAG_Batches', 'customSchedules']);
			add_action('xag_checkKeywordBatches', array('MXAG_Batches', 'checkKeywordBatches'));
			if (! wp_next_scheduled ( 'xag_checkKeywordBatches' )) {
				wp_schedule_event(time(), 'minute', 'xag_checkKeywordBatches');
			}
            add_action('admin_post_xag_checkBatchCron', ['MXAG_Batches', 'checkKeywordBatches']);
        }

        public static function customSchedules ($schedules)
        {
            if (!isset($schedules["minute"])) {
                $schedules["minute"] = [
                    'interval' => 60,
                    'display'  => __('Once every minute')
                ];
            }
            return $schedules;
        }

        public static function checkKeywordBatches ()
        {
            $batches = self::getAllData();

            if (sizeof($batches) == 0) {
                XAG_Init::json('done', 'No more batches.');
            }

            $change = FALSE;

            foreach ($batches as $batch) {

                $http_code = 0;
                $result    = MXAG_Api::apiRequest(
                    $endpoint = 'keywords',
                    $method = 'GET',
                    [
                        'batch_id' => $batch['batch_id'],
                    ],
                    $http_code
                );

                // Check the status
                if ($http_code == 200) {

                    $change = TRUE;

                    // They're all completed
                    foreach ($result as $keyword) {
                        MXAG_Keywords::updateData([
                            'broad'   => $keyword['broad'],
                            'phrase'  => $keyword['phrase'],
                            'intitle' => $keyword['title'],
                            'inurl'   => $keyword['url'],
                            'queued'  => 0,
                        ], [
                            'id' => $keyword['real_id']
                        ]);
                    }

                    // Remove the batch
                    self::removeData([
                        'id' => $batch['id'],
                    ]);

                } else if ($http_code == 500) {
                    self::removeData([
                        'id' => $batch['id']
                    ]);
                }

            }

            if ($change == TRUE) {
                XAG_Init::json('change', 'Batch finished.');
            } else {
                XAG_Init::json('pending', 'Batch still running.');
            }
        }

        protected static $TABLE_NAME;

        public function __construct ()
        {
            static::$TABLE_NAME = self::TABLE_NAME;
        }

        // MySQL
        const TABLE_NAME = 'prs_batches';

        public static function createTable ()
        {
            global $wpdb;
            require_once(ABSPATH . 'wp-admin/includes/upgrade.php');

            $charset_collate = $wpdb->get_charset_collate();
            $creation_query  =
                'CREATE TABLE ' . self::TABLE_NAME . ' (
			        `id` int(11) NOT NULL AUTO_INCREMENT,
			        `batch_id` int(11),
			        `status` varchar(255) default "pending",		  
			        `date_created` datetime,			        
			        PRIMARY KEY  (`id`)
			    ) ' . $charset_collate . ';';
            @dbDelta($creation_query);
        }

        public static function removeTable ()
        {
            global $wpdb;
            $query = 'DROP TABLE IF EXISTS ' . self::TABLE_NAME . ';';
            $wpdb->query($query);
        }

    }

}