<?php

if ( ! class_exists( 'MXAG_Captcha' ) ) {

	class MXAG_Captcha {

		/** @var string captcha site key */
		static protected $site_key;

		/** @var string captcha secrete key */
		static protected $secret_key;

		static protected $recaptcha_enabled;

		static protected $error_message;

		static protected $api_settings;

		static protected $textdomain;

		public static function initialize() {

			self::$api_settings = get_option( 'ps_api_settings' );

			self::$site_key = isset( self::$api_settings['recaptcha_site_key'] ) ? self::$api_settings['recaptcha_site_key'] : '';

			self::$secret_key = isset( self::$api_settings['recaptcha_secret_key'] ) ? self::$api_settings['recaptcha_secret_key'] : '';

			self::$error_message = wp_kses( __( '<strong>ERROR</strong>: Invalid reCAPTCHA entered.', 'prs-captcha' ), array( 'strong' => array() ) );

			add_action( 'login_enqueue_scripts', array( __CLASS__, 'expandLoginWidth' ) );

		}


		/** Increase the width of login/registration form */
		public static function expandLoginWidth() {
			echo '<style type="text/css"> #login { width: 350px !important; } </style>';
		}


		/** Output the reCAPTCHA form field. */
		public static function display_captcha() {

			if ( isset( $_GET['captcha'] ) && $_GET['captcha'] == 'failed' ) {
				echo self::$error_message;
			}
			?>
			<script src="https://www.google.com/recaptcha/api.js" async defer></script>
			<div style="margin-bottom: 15px; margin-top:5px" id="recaptcha" class="g-recaptcha" data-sitekey="<?php echo self::$site_key ?>" data-theme="light"></div>
			<?php
		}

		/**
		 * Send a GET request to verify captcha challenge
		 *
		 * @return bool
		 */
		public static function captcha_verification() {

			$token = $_POST['g-recaptcha-response'];

			$response = wp_remote_post( 'https://www.google.com/recaptcha/api/siteverify', array(
					'method' => 'POST',
					'timeout' => 45,
					'redirection' => 5,
					'httpversion' => '1.0',
					'blocking' => true,
					'headers' => array(),
					'body' => array( 'secret' => self::$secret_key, 'response' => $token, 'remoteip' => $_SERVER['REMOTE_ADDR'] ),
					'cookies' => array()
				)
			);


			if ( is_wp_error( $response ) ) {
				return false;
			} else {
				$body = json_decode($response['body'], TRUE);
				if ($body['success'] == false) {
					return false;
				} else {
					return true;
				}
			}
		}

	}

}