<?php

if ( ! class_exists( 'MXAG_Captcha_login' ) ) {

	class MXAG_Captcha_login extends MXAG_Captcha {

		public static function initialize() {
			if (XAG_RECAPTCHA == TRUE && (!empty(self::$site_key) && !empty(self::$secret_key))) {
				// adds the captcha to the login form
				add_action( 'login_form', array( __CLASS__, 'display_captcha' ) );

				// authenticate the captcha answer
				add_action( 'wp_authenticate_user', array( __CLASS__, 'validate_captcha' ), 10, 2 );
			}
		}

		/**
		 * Verify the captcha answer
		 *
		 * @param $user string login username
		 * @param $password string login password
		 *
		 * @return WP_Error|WP_user
		 */
		public static function validate_captcha( $user, $password ) {
			if ( ! isset( $_POST['g-recaptcha-response'] ) || ! self::captcha_verification() ) {
				/** Check whether failed captchas count as failed login attempts */
				return new WP_Error( 'empty_captcha', self::$error_message );
			}
			return $user;
		}
	}

}