<?php

if ( ! class_exists( 'MXAG_Captcha_register' ) ) {

	class MXAG_Captcha_register extends MXAG_Captcha {

		public static function initialize() {
			if (XAG_RECAPTCHA == TRUE && (!empty(self::$site_key) && !empty(self::$secret_key))) {
				// adds the captcha to the registration form
				add_action( 'register_form', array( __CLASS__, 'display_captcha' ) );

				// authenticate the captcha answer
				add_action( 'registration_errors', array( __CLASS__, 'validate_captcha_registration_field' ), 10, 3 );
			}
		}

		public static function validate_captcha_registration_field( $errors, $sanitized_user_login, $user_email ) {
			if ( ! isset( $_POST['g-recaptcha-response'] ) || ! self::captcha_verification() ) {
				$errors->add( 'failed_verification', self::$error_message );
			}

			return $errors;
		}
	}

}