<?php

if ( ! class_exists( 'MXAG_Clone' ) ) {

	class MXAG_Clone extends MXAG_Model {

		public static function initialize() {
			add_action('admin_post_xag_verify_connection', array('MXAG_Clone', 'verifyConnection'));
			add_action('admin_post_xag_obtain_api_key', array('MXAG_Clone', 'obtainApiKey'));
			add_action('admin_post_xag_create_clone_backup', array('MXAG_Clone', 'createCloneBackup'));
			add_action('admin_post_xag_download_clone_backup', array('MXAG_Clone', 'downloadCloneBackup'));
			add_action('admin_post_xag_remove_clone_backup', array('MXAG_Clone', 'removeCloneBackup'));
			add_action('admin_post_xag_extract_merge_clone', array('MXAG_Clone', 'extractAndMerge'));
		}

		public static function extractAndMerge() {

			$PREFIX = $_POST['prefix'];

			$BACKUP_PATH   = $_POST['backup_path'];
			if (!file_exists($BACKUP_PATH)) {
				XAG_Init::json('error', 'Backup either did not download properly, or there is a problem with downloaded cloned version of files.');
				return;
			}

			$URL = $_POST['url'];
			if (!filter_var($URL, FILTER_VALIDATE_URL)) {
				XAG_Init::json('error', 'Provided "url" argument is not an actual URL.');
				return;
			}
			$OLD_URL = parse_url($URL);
			$NEW_URL = parse_url(site_url());

			$OLD_DOMAIN = $OLD_URL['host'];
			$NEW_DOMAIN = $NEW_URL['host'];

			// Get the salt
			$salt_local    = $_SERVER['SERVER_NAME'];

			// Get the License
			$license_email = '';
			$license_key   = '';
			XAG_Licencator::isLicenseSet($license_email, $license_key);

			// Get the API key
			$api_key = MXAG_Api::getAPIKey();

			// Move the files from temporary directory to root
			self::recurseCopy(rtrim($BACKUP_PATH, DIRECTORY_SEPARATOR), rtrim(ABSPATH, DIRECTORY_SEPARATOR));

			$new_mysql_file = array();

			// Replace the stuff in MySQL
			$file_handle = fopen(ABSPATH . 'mysql-backup.sql', "r");
			while (!feof($file_handle)) {
				$line = fgets($file_handle);
				if (
					strpos($line, '_options') !== false ||
					strpos($line, '_postmeta') !== false ||
					strpos($line, '_termmeta') !== false ||
					strpos($line, '_usermeta') !== false
				) {
					// This will be done later on
				} else {
					$line = str_replace($OLD_DOMAIN, $NEW_DOMAIN, $line);
				}
				$new_mysql_file[] = $line;
			}
			fclose($file_handle);

			// Put the new MySQL file
			file_put_contents(ABSPATH . 'mysql-backup-fixed.sql', join("\n", $new_mysql_file));

			// Push the MySQL changes

			$result = MXAG_Backups::restoreMySQL(ABSPATH . 'mysql-backup-fixed.sql', true);

			@unlink(ABSPATH . 'mysql-backup.sql' );
			@unlink(ABSPATH . 'mysql-backup-fixed.sql' );

			MXAG_Rescue::deleteFolder(rtrim($BACKUP_PATH, DIRECTORY_SEPARATOR));

			/**
			 *  Time to do magic fixes :)
			 */

			// Get license and api key back
			$con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);

			$errors = array();

			$con->query("INSERT INTO {$PREFIX}options (option_name, option_value) VALUES ('" . XAG_Licencator::encrypt('license_email', $salt_local) . "', '" . XAG_Licencator::encrypt($license_email, $salt_local) . "') ON DUPLICATE KEY UPDATE option_value = '" . XAG_Licencator::encrypt($license_email, $salt_local) . "';");
			if (!empty($con->error)) $errors[] = $con->error;

			$con->query("INSERT INTO {$PREFIX}options (option_name, option_value) VALUES ('" . XAG_Licencator::encrypt('license_key',   $salt_local) . "', '" . XAG_Licencator::encrypt($license_key,   $salt_local) . "') ON DUPLICATE KEY UPDATE option_value = '" . XAG_Licencator::encrypt($license_key,   $salt_local) . "';");
			if (!empty($con->error)) $errors[] = $con->error;

			$con->query("INSERT INTO {$PREFIX}options (option_name, option_value) VALUES ('" . XAG_Licencator::encrypt('ps_api', $salt_local) ."', '$api_key') ON DUPLICATE KEY UPDATE option_value = '$api_key';");
			if (!empty($con->error)) $errors[] = $con->error;

			// Update wp_options
			$wp_options = $con->query("SELECT * FROM {$PREFIX}options WHERE option_value LIKE '%$OLD_DOMAIN%';");
			if ($wp_options) {
				$wp_options_data = $wp_options->fetch_all( MYSQLI_ASSOC );
				foreach( $wp_options_data as $option ) {
					$con->query("UPDATE {$PREFIX}options SET option_value = '" . self::recurseSearchAndReplace($OLD_DOMAIN, $NEW_DOMAIN, $option['option_value']) . "' WHERE option_id = '{$option['option_id']}';");
					if (!empty($con->error)) $errors[] = $con->error;
				}
				$wp_options->free();
			}

			// Update wp_postmeta
			$wp_postmeta = $con->query("SELECT * FROM {$PREFIX}postmeta WHERE meta_value LIKE '%$OLD_DOMAIN%';");
			if ($wp_postmeta) {
				$wp_postmeta_data = $wp_postmeta->fetch_all( MYSQLI_ASSOC );
				foreach($wp_postmeta_data as $meta) {
					$con->query("UPDATE {$PREFIX}postmeta SET meta_value = '" . self::recurseSearchAndReplace($OLD_DOMAIN, $NEW_DOMAIN, $meta['meta_value']) . "' WHERE meta_id = '{$meta['meta_id']}';");
					if (!empty($con->error)) $errors[] = $con->error;
				}
				$wp_postmeta->free();
			}

			// Update wp_termmeta
			$wp_termmeta = $con->query("SELECT * FROM {$PREFIX}termmeta WHERE meta_value LIKE '%$OLD_DOMAIN%';");
			if ($wp_termmeta) {
				$wp_termmeta_data = $wp_termmeta->fetch_all( MYSQLI_ASSOC );
				foreach($wp_termmeta_data as $meta) {
					$con->query("UPDATE {$PREFIX}termmeta SET meta_value = '" . self::recurseSearchAndReplace($OLD_DOMAIN, $NEW_DOMAIN, $meta['meta_value']) . "' WHERE meta_id = '{$meta['meta_id']}';");
					if (!empty($con->error)) $errors[] = $con->error;
				}
				$wp_termmeta->free();
			}

			// Update wp_usermeta
			$wp_usermeta = $con->query("SELECT * FROM {$PREFIX}usermeta WHERE meta_value LIKE '%$OLD_DOMAIN%';");
			if ($wp_usermeta) {
				$wp_usermeta_data = $wp_usermeta->fetch_all( MYSQLI_ASSOC );
				foreach($wp_usermeta_data as $meta) {
					$con->query("UPDATE {$PREFIX}usermeta SET meta_value = '" . self::recurseSearchAndReplace($OLD_DOMAIN, $NEW_DOMAIN, $meta['meta_value']) . "' WHERE umeta_id = '{$meta['umeta_id']}';");
					if (!empty($con->error)) $errors[] = $con->error;
				}
				$wp_usermeta->free();
			}

			$con->close();

			if ($result == true && sizeof($errors) == 0) {

				XAG_Init::json('success', 'Successfully performed cloning!');

			} else {

				XAG_Init::json('error', 'Failed to merge databases!', $errors);

			}

		}

		private static function recurseSearchAndReplace($old_domain, $new_domain, $data) {
			$data = maybe_unserialize($data);
			if (is_array($data)) {
				return serialize(json_decode(str_replace($old_domain, $new_domain, json_encode($data))));
			} else {
				return str_replace($old_domain, $new_domain, $data);
			}
		}

		public static function obtainApiKey() {

			$URL = $_POST['url'];
			if (!filter_var($URL, FILTER_VALIDATE_URL)) {
				XAG_Init::json('error', 'Provided "url" argument is not an actual URL.');
				return;
			}
			$URL = parse_url($URL);

			$http_code = 0;
			$output    = MXAG_Api::apiRequest('key', 'GET', array( 'domain' =>  $URL['host'] ), $http_code);

			if ($http_code == 200) {

				XAG_Init::json('success', 'Successfully obtained API key!', $output['message']);

			} else {

				XAG_Init::json('error', $output['message']);

			}

		}

		private static function recurseCopy($src, $dst) {
			$dir = opendir($src);
			@mkdir($dst);
			while(false !== ( $file = readdir($dir)) ) {
				if (( $file != '.' ) && ( $file != '..' )) {
					if ( is_dir($src . '/' . $file) ) {
						self::recurseCopy($src . '/' . $file,$dst . '/' . $file);
					}
					else {
						copy($src . '/' . $file,$dst . '/' . $file);
					}
				}
			}
			closedir($dir);
		}

		private static function getBetween($string, $start, $end){
			$string = ' ' . $string;
			$ini = strpos($string, $start);
			if ($ini == 0) return '';
			$ini += strlen($start);
			$len = strpos($string, $end, $ini) - $ini;
			return substr($string, $ini, $len);
		}

		public static function downloadCloneBackup() {

			$BACKUP   = $_POST['backup'];
			$tempDir  = XAG_PATH . '/tmp/';
			$tempFile = $tempDir . md5($BACKUP) . '.zip';
			$extDir   = $tempDir . md5(AUTH_KEY . AUTH_SALT . $tempFile);

			$isSuccessful = false;

			// Check if temp dir exists
			if (!file_exists($tempDir))
				mkdir($tempDir);

			// Check if ext dir exists
			if (!file_exists($extDir))
				mkdir($extDir);

			// Check if file already exists
			if (file_exists($tempFile))
				unlink($tempFile);

			// Download the zip file
			$fp = fopen ($tempFile, 'w+');

			$ch = curl_init();

			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

			curl_setopt($ch, CURLOPT_TIMEOUT, 60);
			curl_setopt($ch, CURLOPT_URL, $BACKUP);
			curl_setopt($ch, CURLOPT_FILE, $fp);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
			curl_setopt($ch, CURLOPT_HEADER, false);

			$result = curl_exec($ch);
			curl_close($ch);
			fclose($fp);

			// Unzip it
			if ( class_exists( 'ZipArchive' ) ) {
				$zip = new ZipArchive;
				$res = $zip->open( $tempFile );
				if ( $res === true ) {
					$out = $zip->extractTo( $extDir );
					if ($out == false) {
						XAG_Init::json('error', 'Failed to unzip cloned backup using ZipArchive.');
						return;
					}
					$zip->close();
				}
			} else {
				if (!class_exists('PclZip')) {
					require_once ( XAG_PATH . '/ext/pclzip.lib.php' );
				}
				$archive = new PclZip( $tempFile );
				$out = $archive->extract(PCLZIP_OPT_PATH, $extDir);
				if ($out == false) {
					XAG_Init::json('error', 'Failed to unzip cloned backup using ZipArchive.');
					return;
				}
			}

			// check if unzipped
			if (file_exists( $extDir . DIRECTORY_SEPARATOR . 'index.php' )) {
				$isSuccessful = true;
			}

			@unlink($tempFile);

			if (!$isSuccessful) {

				XAG_Init::json('error', 'There was a problem while downloading a copy of the Remote Website.');

			} else {

				// Regenerate wp-config with prefix
				$prefix    = 'wp_';
				$wp_config = $extDir . DIRECTORY_SEPARATOR . 'wp-config.php';
				if (file_exists( $wp_config )) {

					$file   = fopen($wp_config, "r");

					while(($line = fgets($file)) !== false)
					{
						if (strpos($line, 'table_prefix') !== false) {

							$prefix = self::getBetween($line, "= '", "';");

						}
					}
					fclose($file);

					MXAG_Rescue::regenerateWpConfig($prefix, $extDir . DIRECTORY_SEPARATOR);
				}

				XAG_Init::json('success', 'Successfully downloaded and unzipped cloned backup.', array(
					'prefix' => $prefix,
					'extDir' => $extDir
				));

			}

		}

		public static function removeCloneBackup() {

			$URL = $_POST['url'];
			if (!filter_var($URL, FILTER_VALIDATE_URL)) {
				XAG_Init::json('error', 'Provided "url" argument is not an actual URL.');
				return;
			}
			$KEY    = $_POST['key'];
			$BACKUP = $_POST['backup'];

			$RESULT   = self::createRequest($URL, array( 'key' => $KEY, 'function' => 'removeCloneBackup', 'backup_name' => basename($BACKUP), 'action' => 'prs_api' ));

			XAG_Init::jsonc($RESULT);
		}

		public static function createCloneBackup() {

			$URL = $_POST['url'];
			if (!filter_var($URL, FILTER_VALIDATE_URL)) {
				XAG_Init::json('error', 'Provided "url" argument is not an actual URL.');
				return;
			}
			$KEY = $_POST['key'];

			$RESULT   = self::createRequest($URL, array( 'key' => $KEY, 'function' => 'createCloneBackup', 'action' => 'prs_api' ));

			XAG_Init::jsonc($RESULT);

		}

		public static function verifyConnection() {

			$URL = $_POST['url'];
			if (!filter_var($URL, FILTER_VALIDATE_URL)) {
				XAG_Init::json('error', 'Provided "url" argument is not an actual URL.');
				return;
			}
			$URL = parse_url($URL);
			$URL = $URL['scheme'] . '://' . $URL['host'];

			$SUCCESS  = FALSE;
			$ENDPOINT = '/wp-admin/admin-post.php';

			$RESULT   = self::createRequest($URL . $ENDPOINT, array( 'key' => false, 'function' => 'PING', 'action' => 'prs_api' ));
			if ($RESULT == FALSE) {
				$ENDPOINT = '/xagio-api.php';
				$RESULT   = self::createRequest($URL . $ENDPOINT, array( 'key' => false, 'function' => 'PING', 'action' => 'prs_api' ));
				if ($RESULT == FALSE) {
					XAG_Init::json('error', 'There was a problem communicating with ' . $URL . '. Make sure Xagio V3 is installed on it and activated.');
				}
			}

			if ($RESULT['status'] == 'success' && $RESULT['message'] == 'PONG') {

				XAG_Init::json('success', 'Communication with ' . $URL . ' is successful. You can proceed with cloning.', $URL . $ENDPOINT);

			} else {

				XAG_Init::json('error', 'There was a problem communicating with ' . $URL . '. Make sure that Xagio V3 is updated to the latest version.');

			}

		}

		private static function createRequest($url = '', $data = array(), $method = 'POST') {

			$response = wp_remote_post( $url, array(
					'user-agent'  => "PSv3 - " . XAG_CURRENT_VERSION . " (".site_url().")",
					'timeout'     => 30,
					'redirection' => 5,
					'httpversion' => '1.0',
					'blocking'    => true,
					'method'      => $method,
					'body'        => $data,
					'sslverify'   => false
				)
			);

			if ( is_wp_error( $response ) ) {
				return false;
			} else {
				if ( !isset( $response['body'] ) ) {
					return false;
				} else {
					$data = json_decode($response['body'], true);
					if (!$data) {
						var_dump($response);
						return false;
					} else {;
						return $data;
					}
				}
			}

		}

	}

}