<?php

if (!class_exists('MXAG_Groups')) {

	class MXAG_Groups extends MXAG_Model
	{

		public static function initialize()
		{
			add_action('admin_post_xag_import_keyword_planner', ['MXAG_Groups', 'importKeywordPlanner']);
			add_action('admin_post_xag_getGroups', ['MXAG_Groups', 'getGroups']);
			add_action('admin_post_xag_getGroup', ['MXAG_Groups', 'getGroup']);
			add_action('admin_post_xag_newGroup', ['MXAG_Groups', 'newGroup']);
			add_action('admin_post_xag_deleteGroup', ['MXAG_Groups', 'deleteGroup']);
			add_action('admin_post_xag_deleteGroups', ['MXAG_Groups', 'deleteGroups']);
			add_action('admin_post_xag_deleteKeywords', ['MXAG_Groups', 'deleteKeywords']);
			add_action('admin_post_xag_updateGroup', ['MXAG_Groups', 'updateGroup']);
			add_action('admin_post_xag_moveToProject', ['MXAG_Groups', 'moveToProject']);
			add_action('admin_post_xag_getCfTemplates', ['MXAG_Groups', 'getCfTemplates']); // Get all Templates
			add_action('admin_post_xag_saveCfTemplate', ['MXAG_Groups', 'saveCfTemplate']); // Save Template
			add_action('admin_post_xag_applyCfTemplate', ['MXAG_Groups', 'applyCfTemplate']); // Set Default Template
			add_action('admin_post_xag_createCfTemplate', ['MXAG_Groups', 'createCfTemplate']); // Create new Template
			add_action('admin_post_xag_deleteCfTemplate', ['MXAG_Groups', 'deleteCfTemplate']); // Delete Template
		}

		public static function moveToProject()
		{
			$project_id = $_POST['project_id'];
			$group_id   = $_POST['group_id'];

			self::updateData([
				'project_id' => $project_id
			], [
				'id' => $group_id
			]);

			XAG_Init::json('success', 'Group has been moved to a different project.');
		}

		public static function prsCsvUploadMimes($existing_mimes = [])
		{
			$existing_mimes['json'] = 'application/csv';
			return $existing_mimes;
		}

		public static function importKeywordPlanner()
		{

			$projectID = $_GET['project'];
			if (isset($_FILES['file-import'])) {

				$root_directory = get_home_path();
				$csv_path       = $root_directory . md5(microtime()) . '.csv';

				@move_uploaded_file($_FILES['file-import']['tmp_name'], $csv_path);

				$file_contents = @file_get_contents($csv_path);

				@unlink($csv_path);

				$kw_data = [];
				$rows    = explode("\n", $file_contents);

				$group_name = $_FILES['file-import']['name'];
				$group_name = str_replace('.csv', '', $group_name);

				// Check if CSV is from SurferSEO
				$isSurfer = false;
				if(strpos($rows[0], "Cluster Name") !== FALSE) $isSurfer = true;

				if ($rows[0] == '"Keyword","Words","Volume","Cost Per Click","Competition","Date Added"') {
					unset($rows[0]);
					$data = [
						'project_id' => $projectID,
						'group_name' => $group_name,
						'title'      => $group_name,
						'url'        => strtolower(sanitize_title($group_name)),
						'h1'         => $group_name
					];

					$group_id = self::insertData($data);

					$used_keywords = [];

					foreach ($rows as $row) {
						$row = explode(',', $row);
						for ($i = 0; $i < sizeof($row); $i++) {
							$row[$i] = ltrim($row[$i], '"');
							$row[$i] = rtrim($row[$i], '"');
						}
						if (empty($row[0])) {
							continue;
						}
						if (strlen($row[0]) < 3) {
							continue;
						}
						if (in_array($row[0], $used_keywords)) {
							continue;
						}

						$keyword_data = [
							'group_id' => $group_id,
							'keyword'  => $row[0],
							'volume'   => $row[2],
							'cpc'      => $row[3]
						];

						$keywords[] = MXAG_Keywords::insertData($keyword_data);
						$used_keywords[] = $row[0];
					}
					return;
				}

				unset($rows[0]);
				foreach ($rows as $row) {
					$r = explode("\t", $row);
					if (sizeof($r) < 2) {
						$r = explode(',', $row);
					}
					for ($i = 0; $i < sizeof($r); $i++) {
						$r[$i] = preg_replace('/\s+/', ' ', trim($r[$i]));
						$r[$i] = preg_replace('/[^A-Za-z0-9\. -]/', '', $r[$i]);
						$r[$i] = str_replace('Keywords like ', '', $r[$i]);
					}
					$kw_column = 1;
                    $vo_column = 3;
					if($isSurfer) $vo_column = 2;
					$cp_column = 5;

					// Custom
					if (sizeof($r) == 3) {
                        $kw_column = 0;
                        $vo_column = 1;
                        $cp_column = 2;
                    }

					if (isset($r[0])) {
						if ($r[0] == '') {
							continue;
						}
					}
					// Check if bad csv
					if (ctype_alpha($r[3])) {
						$vo_column++;
						$cp_column++;
					}
					$volume = explode('  ', $r[$vo_column]);

					if (isset($volume[1])) {
						$volume = trim(@$volume[1]);
					} else {
						$volume = trim(@$volume[0]);
					}

					$volume = str_replace('K', '000', $volume);
					$volume = str_replace('M', '000000', $volume);

					$cpc = $r[$cp_column];
					if (empty($cpc)) {
						$cpc = '0.00';
					}

                    // Custom
                    if (sizeof($r) == 3) {

                        if (!isset($kw_data['Custom Import'])) {
                            $kw_data['Custom Import'] = [];
                        }
                        $kw_data['Custom Import'][] = [
                            'keyword' => $r[$kw_column],
                            'volumn'  => $volume,
                            'cpc'     => $cpc
                        ];

                    } else {

                        if (!isset($kw_data[$r[0]])) {
                            $kw_data[$r[0]]   = [];
                            $kw_data[$r[0]][] = [
                                'keyword' => $r[$kw_column],
                                'volumn'  => $volume,
                                'cpc'     => $cpc
                            ];
                        } else {
                            $kw_data[$r[0]][] = [
                                'keyword' => $r[$kw_column],
                                'volumn'  => $volume,
                                'cpc'     => $cpc
                            ];
                        }

                    }


				}

				$keywords = [];
				foreach ($kw_data as $groupName => $groupData) {
					if (sizeof($groupData) < 1) {
						continue;
					}
					$data = [
						'project_id' => $projectID,
						'group_name' => $groupName,
						'title'      => $groupName,
						'url'        => strtolower(sanitize_title($groupName)),
						'h1'         => $groupName
					];

					$group_id = self::insertData($data);

					foreach ($groupData as $keyword) {
						$keyword_data = [
							'group_id' => $group_id,
							'keyword'  => $keyword['keyword'],
							'volume'   => $keyword['volumn'],
							'cpc'      => $keyword['cpc']
						];

						$keywords[] = MXAG_Keywords::insertData($keyword_data);
					}
				}

			}
		}

		public static function newGroup()
		{
			$project_id = $_POST['project_id'];
			$group_name = $_POST['group_name'];

			self::insertData([
				'project_id'   => $project_id,
				'group_name'   => $group_name,
				'date_created' => date('Y-m-d H:i:s')
			]);
		}

		public static function newGroupFromExistingPost($project_id, $group_name, $post_id = '', $title = '', $url = '', $description = '', $h1 = '', $notes = '')
		{
			self::insertData([
				'project_id'   => $project_id,
				'group_name'   => $group_name,
				'id_page_post' => $post_id,
				'title'        => $title,
				'url'          => $url,
				'description'  => $description,
				'h1'           => $h1,
				'notes'        => $notes,
				'date_created' => date('Y-m-d H:i:s')
			]);
		}

		public static function deleteGroups()
		{
			$group_id = $_POST['group_ids'];

			unset($_POST['group_ids']);
			unset($_POST['action']);

			self::query("DELETE g, k FROM prs_groups g LEFT JOIN prs_keywords k ON g.id = k.group_id WHERE g.id IN ($group_id)");
			wp_send_json(['status' => 'success', 'message' => 'Groups successfully deleted!']);
		}

		public static function deleteGroup()
		{
			$group_id = $_POST['group_id'];

			unset($_POST['group_id']);
			unset($_POST['action']);

			self::query("DELETE g, k FROM prs_groups g LEFT JOIN prs_keywords k ON g.id = k.group_id WHERE g.id = $group_id");
			wp_send_json(['status' => 'success', 'message' => 'Group successfully deleted!']);
		}

		public static function deleteKeywords()
		{
			$keywords = $_POST['keywords'];
			unset($_POST['keywords']);
			unset($_POST['action']);

			$query = 'DELETE FROM prs_keywords WHERE id IN (';
			foreach ($keywords as $id) {
				$query .= $id . ",";
			}
			$query = rtrim($query, ',');
			$query .= ')';

			self::query("{$query}");
			wp_send_json(['status' => 'success', 'message' => 'Group successfully deleted!']);
		}

		public static function updateGroup()
		{
			$project_id  = $_POST['project_id'];
			$group_id    = $_POST['group_id'];
			$originalUrl = $_POST['oriUrl'];

			$group = self::getData('*', [
				'id' => $group_id
			]);

			$post_id = $group['id_page_post'];

			unset($_POST['project_id']);
			unset($_POST['group_id']);
			unset($_POST['action']);
			unset($_POST['request_type']);
			unset($_POST['oriUrl']);

			self::updateData($_POST, [
				'id'         => $group_id,
				'project_id' => $project_id
			]);

			// Update the Post/Page Data
			$post_data = [];

			// Set the new URL
			if (isset($_POST['url'])) {

				// Create redirection if needed
				$newUrl = $_POST['url'];

				if ($newUrl != $originalUrl) {
					MXAG_Redirects::add($originalUrl, $newUrl);
				}

				$post_data['post_name'] = MXAG_Seo::extract_url_name($_POST['url']);

				update_post_meta($post_id, 'ps_seo_url', $newUrl);
			}

			// Set the new H1
			if (isset($_POST['h1']) && !empty($_POST['h1'])) {

				$post_data['post_title'] = $_POST['h1'];

				$post_type = get_post_type($post_id);

				$operators = NULL;

				$operators = get_option(($post_type == 'page') ? 'prs_silo_pages' : 'prs_silo_posts');
				$operators = urldecode($operators);
				$operators = stripslashes($operators);
				$operators = json_decode($operators, TRUE);

				// Find the operator
				$operator_id = MXAG_Silo::_findOperator($operators, $post_type, $post_id);

				// Modify the operator
				if ($operator_id !== NULL) {
					$operators['operators'][$operator_id]['properties']['title'] = $_POST['h1'];
					update_option(($post_type == 'page') ? 'prs_silo_pages' : 'prs_silo_posts', urlencode(json_encode($operators)));
				}

			}

			if (sizeof($post_data) > 0) {
				if ($group !== FALSE) {
					$post_data['ID'] = $post_id;
					wp_update_post($post_data);
				}
			}

			// Update SEO Title / Meta
			update_post_meta($post_id, 'ps_seo_title', $_POST['title']);
			update_post_meta($post_id, 'ps_seo_description', $_POST['description']);
			update_post_meta($post_id, 'ps_seo_notes', $_POST['notes']);
		}

		public static function getGroups()
		{

			$project_id = $_POST['project_id'];
			$post_type  = isset($_POST['post_type']) ? $_POST['post_type'] : FALSE;

			$results     = self::query("SELECT * FROM " . self::TABLE_NAME . " WHERE project_id = '$project_id'");
			$outputArray = [];
			if ($results !== FALSE) {

				for ($i = 0; $i < sizeof($results); $i++) {

					$group_post_type = FALSE;
					if (!empty($results[$i]['id_page_post'])) {
						$group_post_type = get_post_type($results[$i]['id_page_post']);
					}

					if ($post_type !== FALSE && !empty($post_type)) {
						if ($group_post_type !== FALSE) {
							if ($post_type !== $group_post_type) {
								continue;
							}
						} else {
							continue;
						}
					}

					$keywords = MXAG_Keywords::getKeywords(TRUE, $results[$i]['id']);
					if (!$keywords) {
						$keywords = [];
					}
					$results[$i]['keywords']  = $keywords;
					$results[$i]['post_type'] = $group_post_type;

					$outputArray[] = $results[$i];
				}

			}
			wp_send_json($outputArray);
		}

		public static function getGroup()
		{
			$project_id = $_POST['project_id'];
			$group_id   = $_POST['group_id'];
			$results    = self::querySingle("SELECT * FROM " . self::TABLE_NAME . " WHERE project_id = '$project_id' AND id = '$group_id'");
			if (!$results) {
				$results = [];
			} else {
				$keywords = MXAG_Keywords::getKeywords(TRUE, $results['id']);
				if (!$keywords) {
					$keywords = [];
				}
				$results['keywords'] = $keywords;
			}
			wp_send_json($results);
		}

		public static function getCfTemplates()
		{
			if (!get_option('prs_cf_templates')) {
				wp_send_json(['status' => 'error', 'default' => 'Default']);
			}

			if (!get_option('prs_cf_default_template')) {
				$CfTemplates = get_option('prs_cf_templates');
				wp_send_json(['status' => 'success', 'data' => $CfTemplates, 'default' => 'Default']);
			} else {
				$CfTemplates = get_option('prs_cf_templates');
				wp_send_json(['status' => 'success', 'data' => $CfTemplates, 'default' => get_option('prs_cf_default_template')]);
			}

		}

		public static function saveCfTemplate()
		{
			$data = $_POST;
			$name = $data['name'];

			// Unset data
			unset($data['action']);
			unset($data['name']);

			foreach ($data as $key => $val) {
				if ($val < 0 || $val == '') {
					wp_send_json(['status' => 'error', 'message' => "<i class='uk-icon-exclamation'></i> All fields must be at last 0 and cannot be empty, field $key"]);
				}
			}

			$option[$name] = [
				'name' => $name,
				'data' => $data
			];

			if (!get_option('prs_cf_templates')) {
				update_option('prs_cf_templates', $option);

				wp_send_json(['status' => 'success', 'message' => "<i class='uk-icon-check'></i> Successfully saved template", 'data' => get_option('prs_cf_templates')]);
			} else {
				$prs_cf_templates        = get_option('prs_cf_templates');
				$prs_cf_templates[$name] = $option[$name];
				update_option('prs_cf_templates', $prs_cf_templates);

				wp_send_json(['status' => 'success', 'message' => "<i class='uk-icon-check'></i> Successfully saved template", 'data' => get_option('prs_cf_templates')]);
			}
		}

		public function applyCfTemplate()
		{
			$templateName = $_POST['templateName'];

			if (empty($templateName) || $templateName == "") {
				wp_send_json(['status' => 'error', 'message' => "<i class='uk-icon-exclamation'></i> Template name not defined"]);
			}

			update_option('prs_cf_default_template', $templateName);
			wp_send_json(['status' => 'success', 'message' => "<i class='uk-icon-check'></i> Template successfully applied"]);

		}

		public function createCfTemplate()
		{
			$data = $_POST;
			$name = $data['name'];

			// Unset data
			unset($data['action']);
			unset($data['name']);

			if (empty($name) || $name == "") {
				wp_send_json(['status' => 'error', 'message' => "<i class='uk-icon-exclamation'></i> Template name not defined"]);
			}

			foreach ($data as $key => $val) {
				if ($val < 0 || $val == '') {
					wp_send_json(['status' => 'error', 'message' => "<i class='uk-icon-exclamation'></i> All fields must be at last 0 and cannot be empty"]);
				}
			}

			$option[$name] = [
				'name' => $name,
				'data' => $data
			];

			if (!get_option('prs_cf_templates')) {
				update_option('prs_cf_templates', $option);
				if (!get_option('prs_cf_default_template')) {
					update_option('prs_cf_default_template', $name);
				}
				wp_send_json(['status' => 'success', 'message' => "<i class='uk-icon-check'></i> Successfully saved template", 'data' => get_option('prs_cf_templates')]);
			} else {
				$prs_cf_templates = get_option('prs_cf_templates');

				if ($prs_cf_templates[$name]) {
					wp_send_json(['status' => 'error', 'message' => "<i class='uk-icon-exclamation'></i> Template with this name already exist, please chose a different name"]);
				} else {
					$prs_cf_templates[$name] = $option[$name];

					if (!get_option('prs_cf_default_template')) {
						update_option('prs_cf_default_template', $name);
					}

					update_option('prs_cf_templates', $prs_cf_templates);
					wp_send_json(['status' => 'success', 'message' => "<i class='uk-icon-check'></i> Successfully saved template", 'data' => get_option('prs_cf_templates')]);
				}
			}

		}

		public function deleteCfTemplate()
		{
			$name = $_POST['templateName'];

			if (empty($name) || $name == "") {
				wp_send_json(['status' => 'error', 'message' => "<i class='uk-icon-exclamation'></i> Template name not defined"]);
			}

			if (!get_option('prs_cf_default_template')) {
				if (!get_option('prs_cf_templates')) {
					wp_send_json(['status' => 'error', 'message' => "<i class='uk-icon-exclamation'></i> You cannot delete Default Template"]);
				}
			} else {
				if (get_option('prs_cf_default_template') == $name) {
					wp_send_json(['status' => 'error', 'message' => "<i class='uk-icon-exclamation'></i> You cannot delete Default Template"]);
				}
			}

			$prs_cf_templates = get_option('prs_cf_templates');
			unset($prs_cf_templates[$name]);
			update_option('prs_cf_templates', $prs_cf_templates);
			wp_send_json(['status' => 'success', 'message' => "<i class='uk-icon-check'></i> Successfully deleted", 'data' => get_option('prs_cf_templates')]);
		}

		protected static $TABLE_NAME;

		public function __construct()
		{
			static::$TABLE_NAME = self::TABLE_NAME;
		}

		// MySQL
		const TABLE_NAME = 'prs_groups';

		public static function createTable()
		{
			global $wpdb;
			require_once(ABSPATH . 'wp-admin/includes/upgrade.php');

			$charset_collate = $wpdb->get_charset_collate();
			$creation_query  =
				'CREATE TABLE ' . self::TABLE_NAME . ' (
			        `id` int(11) NOT NULL AUTO_INCREMENT,
			        `project_id` int(11),
			        `id_page_post` int(11),
			        `group_name` varchar(255),
			        `title` varchar(255),
			        `url` varchar(255),
			        `description` text,
			        `h1` varchar(255),
			        `date_created` datetime,
			        `position` int(11) default 999,
			        `notes` longtext,
			        PRIMARY KEY  (`id`)
			    ) ' . $charset_collate . ';';
			@dbDelta($creation_query);
		}

		public static function removeTable()
		{
			global $wpdb;
			$query = 'DROP TABLE IF EXISTS ' . self::TABLE_NAME . ';';
			$wpdb->query($query);
		}

	}

}