<?php

if (!class_exists('MXAG_Keywords')) {

    class MXAG_Keywords extends MXAG_Model
    {

        public static function initialize ()
        {
            add_action('admin_post_xag_getKeywordAllowance', ['MXAG_Keywords', 'getKeywordAllowance']);
            add_action('admin_post_xag_getVolumeAndCPC', ['MXAG_Keywords', 'getVolumeAndCPC']);
            add_action('admin_post_xag_getKeywordData', ['MXAG_Keywords', 'getKeywordData']);
            add_action('admin_post_xag_getKeywordDataCaptcha', ['MXAG_Keywords', 'getKeywordDataCaptcha']);
            add_action('admin_post_xag_getKeyword', ['MXAG_Keywords', 'getKeyword']);
            add_action('admin_post_xag_getKeyword', ['MXAG_Keywords', 'getKeywords']);
            add_action('admin_post_xag_addKeyword', ['MXAG_Keywords', 'addKeyword']);
            add_action('admin_post_xag_updateKeywords', ['MXAG_Keywords', 'updateKeywords']);
            add_action('admin_post_xag_keywordChangeGroup', ['MXAG_Keywords', 'keywordChangeGroup']);
            add_action('admin_post_xag_autoGenerateGroups', ['MXAG_Keywords', 'autoGenerateGroups']);
            add_action('admin_post_xag_phraseMatch', ['MXAG_Keywords', 'phraseMatch']);
            add_action('admin_post_xag_resetKeywordNotification', ['MXAG_Keywords', 'resetKeywordNotification']);
            add_action('admin_notices', ['MXAG_Keywords', 'KeywordNotification']);

            // Pro Rank Tracker
            add_action('admin_post_xag_track_keywords_add', ['MXAG_Keywords', 'trackKeywordsAdd']);
            add_action('admin_post_xag_track_keywords_get', ['MXAG_Keywords', 'trackKeywordsget']);
            add_action('admin_post_xag_track_keywords_delete', ['MXAG_Keywords', 'trackKeywordsdelete']);
            // Pro Rank Tracker

            add_action('wp_ajax_nopriv_xag_queued_keywords_completed', ['MXAG_Keywords', 'queuedKeywordsCompleted']);
            add_action('wp_ajax_nopriv_xag_queued_groups_completed', ['MXAG_Keywords', 'queuedGroupsCompleted']);

            // This is causing all forms on WordPress to have this From Name set

            //add_filter( 'wp_mail_from_name', array('MXAG_Keywords', 'customFromName')  );

        }

        public static function customFromName ($name)
        {
            return "Xagio V3";
        }

        //--------------------------------------------
        //
        //             MySQL Operations
        //
        //--------------------------------------------

        protected static $TABLE_NAME;

        public function __construct ()
        {
            static::$TABLE_NAME = self::TABLE_NAME;
        }

        // MySQL
        const TABLE_NAME = 'prs_keywords';

        public static function createTable ()
        {
            global $wpdb;
            require_once(ABSPATH . 'wp-admin/includes/upgrade.php');

            $charset_collate = $wpdb->get_charset_collate();
            $creation_query  =
                'CREATE TABLE ' . self::TABLE_NAME . ' (
			        `id` int(11) NOT NULL AUTO_INCREMENT,
			        `group_id` int(11),
			        `keyword` varchar(255),
			        `volume` varchar(255),
			        `cpc` varchar(255),
			        `inurl` varchar(255),
			        `intitle` varchar(255),
			        `phrase` varchar(255),
			        `broad` varchar(255),
			        `date_created` datetime,
			        `position` int(11) default 999,
			        `queued` int(1) default 0,
			        `rank` longtext,
			        PRIMARY KEY  (`id`)
			    ) ' . $charset_collate . ';';
            return @dbDelta($creation_query);
        }

        public static function removeTable ()
        {
            global $wpdb;
            $query = 'DROP TABLE IF EXISTS ' . self::TABLE_NAME . ';';
            $wpdb->query($query);
        }



        //--------------------------------------------
        //
        //               Functions
        //
        //--------------------------------------------

        public static function resetKeywordNotification ()
        {
            update_option('ps_ag_error', '');
        }

        public static function KeywordNotification ()
        {
            $ps_ag_error = get_option('ps_ag_error');
            if ($ps_ag_error) {
                $class   = 'notice notice-error is-dismissible keyword_notification';
                $message = __($ps_ag_error, 'sample-text-domain');

                printf('<div class="%1$s"><p>%2$s</p></div>', esc_attr($class), esc_html($message));
            }
        }

        public static function getKeywordAllowance ()
        {
            $http_code = 0;
            $result    = MXAG_Api::apiRequest(
                $endpoint = 'info',
                $method = 'GET',
                [
                    'type' => 'keyword_scraping_allowance'
                ],
                $http_code
            );

            if ($http_code == 200) {

                $result = [
                    'keyword_scraping_allowance'        => $result['keyword_scraping_allowance'],
                    'keyword_volume_scraping_allowance' => $result['keyword_volume_scraping_allowance']
                ];

                XAG_Init::json('success', 'Successfully retrieved keyword allowance.', $result);
            } else {
                XAG_Init::json('error', $result);
            }
        }

        public static function getKeywordDataCaptcha ($KEYWORD = NULL, $TYPE = NULL, $ID = NULL, $RETURN = FALSE)
        {

            $aClass = XAG_PATH . '/ext/simple_html_dom.php';
            if (!function_exists('str_get_html')) {
                require_once($aClass);
            }

            $KEYWORD = ($KEYWORD == NULL) ? $_POST['keyword'] : $KEYWORD;
            $TYPE    = ($TYPE == NULL) ? $_POST['type'] : $TYPE;
            $ID      = ($ID == NULL) ? $_POST['id'] : $ID;

            // Sanitize keyword
            $KEYWORD = self::sanitazeKeyword($KEYWORD, $TYPE);

            // URL
            $GOOGLE_URL = 'https://www.google.com/search?hl=en&source=hp&biw=&bih=&q=' . $KEYWORD . '&btnG=Google+Search&gbv=1';

            $curl = curl_init();
            curl_setopt($curl, CURLOPT_URL, $GOOGLE_URL);
            curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 120);
            curl_setopt($curl, CURLOPT_TIMEOUT, 120);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($curl, CURLOPT_HEADER, FALSE);
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, TRUE);
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
            curl_setopt($curl, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.99 Safari/537.36');
            curl_setopt($curl, CURLOPT_COOKIEFILE, dirname(__FILE__) . '/cookies.txt');
            curl_setopt($curl, CURLOPT_COOKIEJAR, dirname(__FILE__) . '/cookies.txt');
            curl_setopt($curl, CURLOPT_ENCODING, "gzip, deflate");
            curl_setopt($curl, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
            curl_setopt($curl, CURLOPT_REFERER, 'https://www.google.com/');
            curl_setopt($curl, CURLOPT_FOLLOWLOCATION, TRUE);
            curl_setopt($curl, CURLOPT_HTTPHEADER, ["Accept: text/plain"]);

            // Fetch the response
            $RESPONSE = curl_exec($curl);
            $ERROR    = curl_error($curl);
            $INFO     = curl_getinfo($curl);

            curl_close($curl);

            // Check if captcha has been changed
            if (strpos($RESPONSE, 'Your client does not have permission') !== FALSE) {
                // Captcha solving method has been changed
                $REPORT   = $RESPONSE;
                $ERROR    = "Captcha solving algorithm has been changed by Google. Xagio developers are notified by this. Please refrain from using this feature until a new update is released.";
                $RESPONSE = "";

                $to      = 'team@n-finity.org';
                $subject = 'V3 - Captcha algorithm changed';
                $body    = '<h1>Report:</h1>' . $REPORT;
                $headers = ['Content-Type: text/html; charset=UTF-8'];

                wp_mail($to, $subject, $body, $headers);
            }

            $CAPTCHA_MSG = '';
            $CAPTCHA_DET = FALSE;

            // Check if captchas are presented (i hate you Google)
            if (strpos($RESPONSE, 'captcha') !== FALSE) {
                $CAPTCHA_DET = TRUE;

                // See if any of captcha solvers are in place
                $api = get_option('ps_api_settings');
                if (
                    isset($api['anticaptcha_api']) &&
                    !empty($api['anticaptcha_api'])
                ) {
                    /**
                     *  Anti Captcha
                     */

                    $RESPONSE = self::captchaSolver_AntiCaptcha($RESPONSE, $GOOGLE_URL, $api['anticaptcha_api'], $CAPTCHA_MSG);
                    $ERROR    = $CAPTCHA_MSG;
                    if (!empty($ERROR)) {
                        $INFO     = $RESPONSE;
                        $RESPONSE = '';
                    }

                } else if (
                    isset($api['2captcha_api']) &&
                    !empty($api['2captcha_api'])
                ) {
                    /**
                     *  2Captcha
                     */

                    $RESPONSE = self::captchaSolver_2Captcha($RESPONSE, $GOOGLE_URL, $api['2captcha_api'], $CAPTCHA_MSG);
                    $ERROR    = $CAPTCHA_MSG;
                    if (!empty($ERROR)) {
                        $INFO     = $RESPONSE;
                        $RESPONSE = '';
                    }

                } else if (
                    isset($api['dbc_username'], $api['dbc_password']) &&
                    !empty($api['dbc_username']) && !empty($api['dbc_password'])
                ) {
                    /**
                     *  DeathByCaptcha
                     */

                    // DEPRECATED

                } else {
                    $ERROR    = "Captcha has been detected but you don't have any Captcha Solving API keys present in your account.";
                    $RESPONSE = "";
                }
            }

            // Parse Data
            if (!$RETURN) {
                if (empty($RESPONSE)) {
                    XAG_Init::json('error', $ERROR, $INFO);
                } else {
                    $HTML     = str_get_html($RESPONSE);
                    $RESPONSE = self::parseResults($HTML->find('div#resultStats', 0)->innertext);

                    // All good, write it to DB
                    self::updateData([$TYPE => $RESPONSE], ['id' => $ID]);

                    XAG_Init::json('success', 'Captcha Detected: ' . (($CAPTCHA_DET) ? 'Yes' : 'No'), $RESPONSE);
                }
            } else {
                return $RESPONSE;
            }
        }

        public static function captchaSolver_AntiCaptcha (
            $content, $requestUrl, $api_key, &$message = NULL
        )
        {
            // Prepare to solve the captcha
            $html        = str_get_html($content);
            $website_key = trim(@$html->find('#recaptcha', 0)->attr['data-sitekey']);
            $q           = trim(@$html->find('input[name="q"]', 0)->value);

            $website_key = htmlspecialchars_decode($website_key);

            // Send the captcha
            $task = self::jsonPostRequest('https://api.anti-captcha.com/createTask', [
                'clientKey'    => $api_key,
                'task'         => [
                    'type'       => 'NoCaptchaTaskProxyless',
                    'websiteURL' => $requestUrl,
                    'websiteKey' => $website_key
                ],
                'softId'       => 0,
                'languagePool' => 'en'
            ]);

            if ($task['errorId'] !== 0) {
                return FALSE;
            }

            $taskId = $task['taskId'];

            sleep(5);
            $solved  = FALSE;
            $key     = '';
            $timeout = 0;
            while ($solved == FALSE) {

                $check = self::jsonPostRequest('https://api.anti-captcha.com/getTaskResult ', [
                    'clientKey' => $api_key,
                    'taskId'    => $taskId
                ]);

                if ($check['errorId'] !== 0) {
                    $message = 'There was a problem while resolving captcha.';
                    return FALSE;
                } else {
                    if ($check['status'] == 'ready') {
                        $key    = $check['solution']['gRecaptchaResponse'];
                        $solved = TRUE;
                        break;
                    }
                }

                if ($timeout === 6) {
                    $message = 'Timeout of 30 secs. reached while waiting for a captcha solution from AntiCaptcha.';
                    return FALSE;
                }
                sleep(5);
                $timeout++;
            }

            // Solve the captcha

            $solve_url = 'https://ipv4.google.com/sorry/index';
            $solve     = self::captchaRequest($solve_url, [
                'g-recaptcha-response' => $key,
                'q'                    => $q,
                'continue'             => urlencode($requestUrl),
                'submit'               => 'Submit'
            ]);

            // Check if badly solved, return nothing
            if (strpos($solve, 'captcha') !== FALSE) {
                $message = 'Captcha solved incorrectly at AntiCaptcha or there are some problems with your server.';
                return FALSE;
            }

            return $solve;
        }

        public static function captchaSolver_2Captcha (
            $content, $requestUrl, $api_key, &$message = NULL
        )
        {
            // Prepare to solve the captcha
            $html        = str_get_html($content);
            $website_key = trim(@$html->find('#recaptcha', 0)->attr['data-sitekey']);
            $q           = trim(@$html->find('input[name="q"]', 0)->value);

            $website_key = htmlspecialchars_decode($website_key);

            // Send the captcha
            $id = self::captchaRequest('http://2captcha.com/in.php', [
                'key'       => $api_key,
                'method'    => 'userrecaptcha',
                'googlekey' => $website_key,
                'pageurl'   => $requestUrl
            ]);

            $id = explode('|', $id);
            if ($id[0] == 'OK') {
                $id = $id[1];
            } else {
                $message = 'Failed to send captcha to 2Captcha.';
                return $content;
            }

            sleep(5);
            $solved  = FALSE;
            $key     = '';
            $timeout = 0;
            while ($solved == FALSE) {

                $check = self::captchaRequest('http://2captcha.com/res.php?key=' . $api_key . '&action=get&id=' . $id);
                if (is_array($check) && $check[0] == 'ERROR_WRONG_CAPTCHA_ID') {
                    $message = 'Captcha submitted successfully to 2Captcha but its ID is nowhere to be found.';
                    return FALSE;
                } else if (is_array($check) && $check[0] == 'ERROR_WRONG_USER_KEY') {
                    $message = 'API key problems with 2Captcha. Wrong API key used.';
                    return FALSE;
                } else {
                    $check = explode('|', $check);
                    if ($check[0] == 'OK') {
                        $key    = $check[1];
                        $solved = TRUE;
                        break;
                    }
                }
                if ($timeout === 6) {
                    $message = 'Timeout of 30 secs. reached while waiting for a captcha solution from 2Captcha.';
                    return FALSE;
                }
                sleep(5);
                $timeout++;
            }

            // Solve the captcha

            $solve_url = 'https://ipv4.google.com/sorry/index';
            $solve     = self::captchaRequest($solve_url, [
                'g-recaptcha-response' => $key,
                'q'                    => $q,
                'continue'             => urlencode($requestUrl),
                'submit'               => 'Submit'
            ]);

            // Check if badly solved, return nothing
            if (strpos($solve, 'captcha') !== FALSE) {
                $message = 'Captcha solved incorrectly at 2Captcha or there are some problems with your server.';
                return FALSE;
            }

            return $solve;
        }

        public static function jsonPostRequest ($url, $postData)
        {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_ENCODING, "gzip,deflate");
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
            $postDataEncoded = json_encode($postData);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $postDataEncoded);
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/json; charset=utf-8',
                'Accept: application/json',
                'Content-Length: ' . strlen($postDataEncoded)
            ]);
            curl_setopt($ch, CURLOPT_TIMEOUT, 30);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
            $result    = curl_exec($ch);
            $curlError = curl_error($ch);

            if ($curlError != "") {
                return FALSE;
            }
            curl_close($ch);
            return json_decode($result, TRUE);
        }

        public static function captchaRequest ($URL, $POST = NULL, $ENCODED = FALSE)
        {
            $curl = curl_init();
            curl_setopt($curl, CURLOPT_URL, $URL);
            curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 120);
            curl_setopt($curl, CURLOPT_TIMEOUT, 120);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($curl, CURLOPT_HEADER, FALSE);
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, TRUE);
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
            curl_setopt($curl, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.99 Safari/537.36');
            curl_setopt($curl, CURLOPT_COOKIEFILE, dirname(__FILE__) . '/cookies.txt');
            curl_setopt($curl, CURLOPT_COOKIEJAR, dirname(__FILE__) . '/cookies.txt');
            curl_setopt($curl, CURLOPT_ENCODING, "gzip, deflate");
            curl_setopt($curl, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
            curl_setopt($curl, CURLOPT_REFERER, 'https://www.google.com/');
            curl_setopt($curl, CURLOPT_FOLLOWLOCATION, TRUE);
            curl_setopt($curl, CURLOPT_HTTPHEADER, ["Accept: text/plain"]);

            if ($POST !== NULL) {
                if ($ENCODED == TRUE) {
                    curl_setopt($curl, CURLOPT_HTTPHEADER, ['Content-Type: application/x-www-form-urlencoded']);
                }
                curl_setopt($curl, CURLOPT_POST, count($POST));
                curl_setopt($curl, CURLOPT_POSTFIELDS, $POST);
            }

            $result = curl_exec($curl);

            curl_close($curl);

            return $result;
        }

        public static function sanitazeKeyword ($string, $type)
        {
            $string = str_replace(["\r", "\n", "\t", "\v"], ' ', $string);
            $string = trim($string);
            switch ($type) {
                case 'phrase':
                    $string = '"' . $string . '"';
                    break;
                case 'intitle':
                    $string = 'intitle:"' . $string . '"';
                    break;
                case 'inurl':
                    $string = 'inurl:"' . $string . '"';
                    break;
            }
            return urlencode(str_replace(' ', '+', $string));
        }

        public static function parseResults ($string)
        {
            $result_string = trim($string);
            $result_string = preg_replace('~<nobr(.*?)</nobr>~', "", $result_string);
            $result_string = preg_replace("/[^0-9]/", "", $result_string);
            $value         = doubleval($result_string);
            return $value;
        }

        public static function getVolumeAndCPC ()
        {
            if (isset($_POST['keywords'], $_POST['ids'], $_POST['language'])) {

                $keywords = $_POST['keywords'];
                $ids      = $_POST['ids'];
                $language = $_POST['language'];
                $cache    = $_POST['disable_cache'];

                if ($language == '0000') {
                    $language = '1000';
                }

                $keywords = explode(',', $keywords);
                $ids      = explode(',', $ids);

                if (sizeof($keywords) < 1 || sizeof($ids) < 1) {
                    XAG_Init::json('error', 'You must send at least one keyword to analysis.');
                    return;
                }

                $output_array = [];

                for ($i = 0; $i < sizeof($keywords); $i++) {
                    $output_array[] = [
                        'id'             => $ids[$i],
                        'keyword'        => strtolower($keywords[$i]),
                        'search_volume'  => 0,
                        'cost_per_click' => 0.0
                    ];
                }

                $http_code = 0;
                $result    = MXAG_Api::apiRequest(
                    $endpoint = 'keywords_volume',
                    $method = 'POST',
                    [
                        'keywords' => join(',', $keywords),
                        'language' => $language,
                        'cache'    => $cache,
                        'callback' => admin_url('admin-ajax.php') . '?action=xag_queued_keywords_completed'
                    ],
                    $http_code
                );

                if ($result['status'] == 'queued') {
                    // Update the keywords to queued
                    foreach ($output_array as $o) {
                        self::updateData([
                            'queued' => 2
                        ], [
                            'id' => $o['id']
                        ]);
                    }
                    XAG_Init::json('queued', 'Volume and CPC successfully queued!', $output_array);

                } else if ($result['status'] == 'results') {

                    $keywordData = $result['data'];
                    for ($i = 0; $i < sizeof($output_array); $i++) {
                        for ($x = 0; $x < sizeof($keywordData); $x++) {
                            if ($output_array[$i]['keyword'] == $keywordData[$x]['keyword']) {
                                $output_array[$i]['search_volume']  = $keywordData[$x]['search_volume'];
                                $output_array[$i]['cost_per_click'] = number_format($keywordData[$x]['competition'], 2);
                            }
                        }
                    }

                    // Update the keywords
                    foreach ($output_array as $o) {
                        self::updateData([
                            'volume' => $o['search_volume'],
                            'cpc'    => $o['cost_per_click'],
                            'queued' => 0,
                        ], [
                            'id' => $o['id']
                        ]);
                    }

                    XAG_Init::json('results', 'Volume and CPC successfully retrieved!', $output_array);
                } else {
                    XAG_Init::json('error', $result['message']);
                }

            }
        }

        public static function queuedKeywordsCompleted ()
        {

            $data = FALSE;

            if (isset($_POST['data'])) {
                if (!empty($_POST['data'])) {
                    $data = $_POST['data'];
                }
            }

            if (!$data) {
                XAG_Init::json('error', 'Nothing to see here!');
            }

            foreach ($data as $keyword) {
                $cpc = number_format($keyword['cost_per_click'], 2);

                self::updateData([
                    'volume' => $keyword['search_volume'],
                    'cpc'    => $cpc,
                    'queued' => 0
                ], [
                    'keyword' => $keyword['keyword'],
                    'queued'  => 2
                ]);

            }

            // Send the email
            $to = NULL;
            XAG_Licencator::isLicenseSet($to);

            $subject = '[PSv3] Keyword Volume and CPC Analysis is completed!';
            $body    = file_get_contents(XAG_PATH . '/pages/emails/keywords.php');
            $body    = str_replace("{site_url}", get_site_url(), $body);
            $headers = [
                'Content-Type: text/html; charset=UTF-8',
                'From: Xagio V3 <support@projectsupremacy.com>'
            ];
            wp_mail($to, $subject, $body, $headers);

            XAG_Init::json('success', 'Volume and CPC successfully inserted!');
        }

        public static function getKeywordData ()
        {
            if (isset($_POST['keywords'], $_POST['ids'])) {

                $keywords = $_POST['keywords'];
                $ids      = $_POST['ids'];

                $keywords = explode(',', $keywords);
                $ids      = explode(',', $ids);

                if (sizeof($keywords) < 1 || sizeof($ids) < 1) {
                    XAG_Init::json('error', 'You must send at least one keyword to analysis.');
                    return;
                }

                $http_code = 0;
                $result    = MXAG_Api::apiRequest(
                    $endpoint = 'keywords',
                    $method = 'POST',
                    [
                        'keywords' => $keywords,
                        'ids'      => $ids
                    ],
                    $http_code
                );

                if ($http_code == 200) {
                    // Mark them as scraped
                    for ($i = 0; $i < sizeof($ids); $i++) {
                        self::updateData([
                            'queued'  => 1,
                            'inurl'   => -1,
                            'intitle' => -1,
                            'phrase'  => -1,
                            'broad'   => -1
                        ], [
                            'id' => $ids[$i]
                        ]);
                    }
                    // Store batch ID
                    $BATCH_ID = $result['message'];
                    MXAG_Batches::insertData([
                        'batch_id'     => $BATCH_ID,
                        'date_created' => date('Y-m-d H:i:s')
                    ]);

                    XAG_Init::json('success', 'Successfully pushed keywords into analysis queue.');
                } else {
                    XAG_Init::json('error', $result);
                }
            } else {
                XAG_Init::json('error', 'Invalid request type.');
            }
        }

        public static function updateKeywords ()
        {
            $group_id = $_POST['group_id'];
            $keywords = json_decode(urldecode($_POST['keywords']), TRUE);

            foreach ($keywords as $keyword) {
                $id = $keyword['id'];
                unset($keyword['id']);

                $fields = ['volume', 'inurl', 'intitle', 'phrase', 'broad'];

                foreach ($fields as $f) {
                    if (isset($keyword[$f])) {
                        $keyword[$f] = str_replace(',', '', $keyword[$f]);
                    }
                }

                self::updateData(
                    $keyword,
                    [
                        'group_id' => $group_id,
                        'id'       => $id
                    ]
                );
            }
        }

        public static function keywordChangeGroup ()
        {
            $original_group_id = $_POST['original_group_id'];
            $target_group_id   = $_POST['target_group_id'];
            $keyword_ids       = $_POST['keyword_ids'];

            $keyword_ids = explode(',', $keyword_ids);
            foreach ($keyword_ids as $keyword_id) {
                self::updateData(
                    [
                        'group_id' => $target_group_id
                    ],
                    [
                        'group_id' => $original_group_id,
                        'id'       => $keyword_id
                    ]
                );
            }
        }

        public static function phraseMatch ()
        {
            $project_name = $_POST['project_name'];
            $keywords     = $_POST['keywords'];

            $minMatchingWords    = isset($_POST['min_match']) ? $_POST['min_match'] : 2;
            $minKeywordsInGroup  = isset($_POST['min_kws']) ? $_POST['min_kws'] : 3;
            $includePrepositions = isset($_POST['include_prepositions']) ? filter_var($_POST['include_prepositions'], FILTER_VALIDATE_BOOLEAN) : FALSE;
            $excludedWords       = $_POST['excluded_words'];

            if (!empty($excludedWords)) {
                $excludedWords = explode(',', $excludedWords);
            }

            $groups = [];
            $words  = [];
            $used   = [];

            // Separate the words first
            foreach ($keywords as $k) {
                $w = explode(' ', $k);
                foreach ($w as $wi) {
                    if (!isset($words[$wi])) {
                        $words[$wi] = 1;
                    } else {
                        $words[$wi]++;
                    }
                }
            }

            // Trim out the prepositions
            if ($includePrepositions == FALSE) {
                $prepositions = ['for', 'or', 'in', 'the', 'a', 'and', 'at', 'on', 'to', 'by', 'of'];
                foreach ($prepositions as $preposition) {
                    unset($words[$preposition]);
                }
            }

            // Exclude words
            if (is_array($excludedWords)) {
                foreach ($excludedWords as $word) {
                    $w = trim($word);
                    if (!empty($w)) {
                        unset($words[$w]);
                    }
                }
            }

            $new_words = [];
            foreach ($words as $word => $count) {
                if ($count > 1 && !is_int($word)) {
                    $new_words[] = $word;
                }
            }

            $words = $new_words;

            // Create groups
            foreach ($keywords as $k) {

                $group_name = [];
                // Check if keyword contains high volume groups
                $w = explode(' ', $k);

                foreach ($w as $word) {
                    if (in_array($word, $words)) {
                        $group_name[] = $word;
                    }
                }

                if (sizeof($group_name) < $minMatchingWords) {
                    continue;
                }

                $group_name = join(' ', $group_name);
                if (!in_array($group_name, $groups)) $groups[] = $group_name;
            }

            // Trim out lonely groups
            $new_groups = [];
            foreach ($groups as $group_name) {

                $group_split = explode(' ', $group_name);
                $kws         = [];

                foreach ($keywords as $k) {

                    $keyword_split     = explode(' ', $k);
                    $containsAllValues = !array_diff($group_split, $keyword_split);
                    if ($containsAllValues && !in_array($k, $used)) {
                        $kws[]  = $k;
                        $used[] = $k;
                    }

                }

                $new_group_name = [];
                foreach ($group_split as $gs) {
                    $new_group_name[] = ucfirst($gs);
                }
                $group_name = join(' ', $new_group_name);

                if (sizeof($kws) >= $minKeywordsInGroup) {
                    $new_groups[$group_name] = $kws;
                }
            }

            // Put the unsorted keywords into Miscellaneous group
            if (sizeof($keywords) != sizeof($used)) {
                $new_groups['Miscellaneous'] = [];
                foreach ($keywords as $keyword) {
                    if (!in_array($keyword, $used)) {
                        $new_groups['Miscellaneous'][] = $keyword;
                    }
                }
            }

            $groups = $new_groups;

            // Create a new Project
            $dateCreated = date('Y-m-d H:i:s');
            $project_id  = MXAG_Projects::insertData([
                'project_name' => $project_name,
                'date_created' => $dateCreated
            ]);

            foreach ($groups as $group => $keywords) {

                $data     = [
                    'project_id' => $project_id,
                    'group_name' => $group,
                    'title'      => '',
                    'url'        => self::stripSymbols($group),
                    'h1'         => '',
                ];
                $group_id = MXAG_Groups::insertData($data, 'prs_groups');

                foreach ($keywords as $keyword) {

                    $kw_data = self::querySingle("SELECT * FROM " . self::TABLE_NAME . " WHERE keyword = '$keyword'");

                    $keyword_data = [
                        'group_id' => $group_id,
                        'keyword'  => $keyword,
                        'volume'   => $kw_data['volume'],
                        'cpc'      => $kw_data['cpc'],
                        'inurl'    => $kw_data['inurl'],
                        'intitle'  => $kw_data['intitle'],
                        'phrase'   => $kw_data['phrase'],
                        'broad'    => $kw_data['broad'],
                        'rank'     => $kw_data['rank']
                    ];

                    MXAG_Groups::insertData($keyword_data, 'prs_keywords');
                }

            }

            XAG_Init::json('success', 'Your new project with phrase matched keywords has been successfully created! To view it, save changes on your current Project and head back to Project screen to view your new project.');

        }

        public static function autoGenerateGroups ()
        {

            $seed_keyword      = $_POST['seed_keyword'];
            $projectID         = $_POST['project_id'];
            $min_search_volume = $_POST['min_search_volume'];
            $min_cpc           = $_POST['min_cpc'];
            $language          = $_POST['language'];
            $max_keywords      = $_POST['max_keywords'];
            $cache             = $_POST['disable_cache'];

            if (empty($cache)) {
                $cache = 'off';
            }

            $http_code = 0;
            $result    = MXAG_Api::apiRequest(
                $endpoint = 'keywords_generate_groups',
                $method = 'POST', [
                'seed_keyword' => $seed_keyword,
                'max_keywords' => $max_keywords,
                'language'     => $language,
                'callback'     => admin_url('admin-ajax.php') . "?action=xag_queued_groups_completed&min_search_volume=$min_search_volume&min_cpc=$min_cpc&project_id=$projectID&max_keywords=$max_keywords",
                'cache'        => $cache
            ],
                $http_code
            );

            if ($http_code == 200) {

                if ($result['status'] == 'queued') {

                    XAG_Init::json('success', 'Auto-Generate Groups successfully queued! Please check back later for results.', $output_array);

                } else if ($result['status'] == 'results') {

                    self::processQueuedGroups($result['data'], $min_search_volume, $min_cpc, $projectID, $max_keywords);

                } else {
                    XAG_Init::json('error', $result['message']);
                }

            } else {
                XAG_Init::json('error', $result);
            }

        }

        public static function processQueuedGroups ($results, $min_search_volume, $min_cpc, $project_id, $max_keywords)
        {

            if (empty($project_id) || empty($max_keywords)) {
                XAG_Init::json('error', 'Something went wrong, please contact support!');
            }

            $formattedGroupData = [];

            foreach ($results as $d) {
                if (!isset($formattedGroupData[$d['category']])) {
                    $formattedGroupData[$d['category']] = [];
                }

                $volume_value = $d['search_volume'];
                $cpc_value    = $d['cost_per_click'];

                if ($volume_value < $min_search_volume) {
                    continue;
                }
                if ($cpc_value < $min_cpc) {
                    continue;
                }

                $formattedGroupData[$d['category']][] = [
                    'keyword' => str_replace("'", '', $d['keyword']),
                    'volume'  => $volume_value,
                    'cpc'     => $cpc_value
                ];

                if (sizeof($formattedGroupData) >= $max_keywords) {
                    break;
                }
            }

            // Remove all keywords from the project
            $groups = MXAG_Groups::query("SELECT * FROM {table} WHERE project_id='" . $project_id . "' and group_name = '' and title IS NULL;", 'prs_groups');
            if (is_array($groups)) {
                foreach ($groups as $group) {
                    MXAG_Groups::query("DELETE FROM {table} WHERE group_id = " . $group['id'], 'prs_keywords');
                }
            }

            // Remove all groups from the project
            MXAG_Groups::query("DELETE FROM {table} WHERE project_id='" . $project_id . "';", 'prs_groups');

            $keywords = [];
            foreach ($formattedGroupData as $groupName => $groupData) {
                if (sizeof($groupData) < 1) {
                    continue;
                }

                $data     = [
                    'project_id' => $project_id,
                    'group_name' => $groupName,
                    'title'      => '',
                    'url'        => self::stripSymbols($groupName),
                    'h1'         => '',
                ];
                $group_id = MXAG_Groups::insertData($data, 'prs_groups');

                foreach ($groupData as $keyword) {
                    $keyword_data = [
                        'group_id' => $group_id,
                        'keyword'  => $keyword['keyword'],
                        'volume'   => $keyword['volume'],
                        'cpc'      => number_format($keyword['cpc'], 2)
                    ];
                    $keywords[]   = MXAG_Groups::insertData($keyword_data, 'prs_keywords');
                }
            }

            // Number of credits to deduct
            $keyword_credits = sizeof($formattedGroupData);

            // Send the email
            $to = NULL;
            XAG_Licencator::isLicenseSet($to);

            $subject = '[PSv3] Auto-Generate Groups process is completed!';
            $body    = file_get_contents(XAG_PATH . '/pages/emails/groups.php');
            $body    = str_replace("{site_url}", get_site_url(), $body);
            $headers = [
                'Content-Type: text/html; charset=UTF-8',
                'From: Xagio V3 <support@projectsupremacy.com>'
            ];
            wp_mail($to, $subject, $body, $headers);

            XAG_Init::json('success', 'Successfully generated groups from seed keyword.');
        }

        public static function queuedGroupsCompleted ()
        {

            $min_search_volume = $_GET['min_search_volume'];
            $min_cpc           = $_GET['min_cpc'];
            $project_id        = $_GET['project_id'];
            $max_keywords      = $_GET['max_keywords'];
            $data              = FALSE;

            if (isset($_POST['data'])) {
                if (!empty($_POST['data'])) {
                    $data = $_POST['data'];
                }
            }

            if (isset($_POST['message'])) {
                update_option('ps_ag_error', 'PSv3 - Auto Generate Groups for the keyword " ' . $_POST['data'][0]['keyword'] . ' " failed.  Sorry, but Adwords will not report data to us for this keyword.  Please try with another seed keyword.');
            }

            if (!$data) {
                XAG_Init::json('error', 'Nothing to see here!');
            }

            self::processQueuedGroups($data, $min_search_volume, $min_cpc, $project_id, $max_keywords);
        }


        public static function addKeyword ()
        {
            $group_id = $_POST['group_id'];
            $keywords = $_POST['keywords'];

            $keywords = explode("\n", $keywords);

            foreach ($keywords as $keyword) {

                self::insertData([
                    'keyword'      => $keyword,
                    'group_id'     => $group_id,
                    'rank'         => '0',
                    'date_created' => date('Y-m-d H:i:s')
                ]);

            }
        }

        public static function getKeyword ($return = FALSE, $gid = 0, $kid = 0)
        {
            $keyword_id = ($kid == 0) ? $_POST['keyword_id'] : $kid;
            $group_id   = ($gid == 0) ? $_POST['group_id'] : $gid;
            $results    = self::querySingle("SELECT * FROM " . self::TABLE_NAME . " WHERE group_id = '$group_id' AND id = '$keyword_id'");
            if (!$results) {
                $results = [];
            }
            if ($return) {
                return $results;
            } else {
                wp_send_json($results);
            }
        }

        public static function getKeywords ($return = FALSE, $gid = 0)
        {
            $group_id = ($gid == 0) ? $_POST['group_id'] : $gid;
            $results  = self::query("SELECT * FROM " . self::TABLE_NAME . " WHERE group_id = '$group_id' ORDER BY position ASC");
            if (!$results) {
                $results = [];
            }
            if ($return) {
                return $results;
            } else {
                wp_send_json($results);
            }
        }

        // Pro Rank Tracker Add
        public static function trackKeywordsAdd ()
        {
            $data = $_POST;

            // Unset data
            unset($data['action']);

            // Verify data before sending to panel
            if (!isset($data['keywords']) || $data['keywords'] == '') {
                wp_send_json(['status' => 'error', 'message' => "<i class='uk-icon-exclamation'></i> Please select some keywords!"]);
            }

            // Check if Search engine is set
            if (!isset($data['search_engine'])) {
                wp_send_json(['status' => 'error', 'message' => "<i class='uk-icon-exclamation'></i> Please enter search engine!"]);
            }

            // Check if Search engine is set
            if (!isset($data['search_location'])) {
                wp_send_json(['status' => 'error', 'message' => "<i class='uk-icon-exclamation'></i> Please enter search location!"]);
            }


            // Store keywords
            $keywords = explode(',', $data['keywords']);

            $result = MXAG_Api::apiRequest(
                $endpoint = 'rank_tracker',
                $method = 'POST',
                [
                    'url'             => site_url(),
                    'keywords'        => $keywords,
                    'search_engines'  => $data['search_engine'],
                    'search_location' => $data['search_location']
                ],
                $http_code
            );

            if ($http_code == 200) {
                XAG_Init::json('success', 'Keywords are added successfully!');
            } else {
                XAG_Init::json('error', $result);
            }

            /////////////////////////////////////////////// NEW CALL


        }

        //PRO Rank Tracker Get
        public static function trackKeywordsget ()
        {
            $data = $_POST;

            // Unset data
            unset($data['action']);

            // Verify data before sending to panel
            if (!isset($data['keywords']) || $data['keywords'] == '') {
                wp_send_json(['status' => 'error', 'message' => "<i class='uk-icon-exclamation'></i> Please select some keywords!"]);
            }

            // Store keywords
            $keywords = explode(',', $data['keywords']);

            $result = MXAG_Api::apiRequest(
                $endpoint = 'check_rank_tracker',
                $method = 'POST',
                [
                    'url'      => site_url(),
                    'keywords' => $keywords
                ],
                $http_code
            );

            if ($http_code == 200) {
                XAG_Init::json('success', 'Keywords found.');
            } else {
                XAG_Init::json('error', $result);
            }
        }

        //PRO Rank Tracker Delete
        public static function trackKeywordsdelete ()
        {
            $data = $_POST;

            // Unset data
            unset($data['action']);

            // Verify data before sending to panel
            if (!isset($data['keywords']) || $data['keywords'] == '') {
                wp_send_json(['status' => 'error', 'message' => "<i class='uk-icon-exclamation'></i> Please select some keywords!"]);
            }

            // Store keywords
            $keywords = explode(',', $data['keywords']);

            $result = MXAG_Api::apiRequest(
                $endpoint = 'delete_rank_tracker',
                $method = 'POST',
                [
                    'url'      => site_url(),
                    'keywords' => $keywords
                ],
                $http_code
            );

            if ($http_code == 200) {
                XAG_Init::json('success', 'Keywords are deleted successfully!');
            } else {
                XAG_Init::json('error', $result);
            }

        }

        static function stripSymbols ($string)
        {
            return strtolower(preg_replace('/[^\p{L}\p{N}\s]/u', '-', str_replace(' ', '', $string)));
        }

    }

}