<?php

if ( ! class_exists( 'MXAG_Log404' ) ) {

	class MXAG_Log404 extends MXAG_Model {

        public static function initialize() {
			// Disable Model if not license is present
			if (!XAG_Licencator::isLicenseSet()) return;

			// Check if feature is enabled
			$ps_features = get_option('ps_features');
			if ($ps_features != false && is_array($ps_features)) {
			    if (!in_array('log', $ps_features)) {
			        return;
               }
			}
			if ($ps_features == 'none') return;

			$listIgnoredUrls = get_option('prs_ignore_404_urls');
			$getLogLmt = get_option('prs_max_log_limit');

            if (!is_admin()) {
                $htAccFile = self::chkHtAccExists();
                if ($htAccFile === false) { self::createHtAccFile(); }

				$defaultIgnoredStr = array('*/pingserver.php', '*/xmlrpc.php');
				if($listIgnoredUrls === false) { update_option( 'prs_ignore_404_urls', $defaultIgnoredStr ); }
				if($getLogLmt === false) { update_option( 'prs_max_log_limit', 500 ); }

				add_action('template_redirect', array('MXAG_Log404', 'doStuffOn404'));
            }

			add_action('admin_post_xag_get_log404s', array('MXAG_Log404', 'getLog404_Datatables'));
			add_action('admin_post_xag_add_log404_redirect', array('MXAG_Log404', 'addLog404Redirect'));
			add_action('admin_post_xag_delete_log404', array('MXAG_Log404', 'deleteLog404'));
			add_action('admin_post_xag_clear_log404', array('MXAG_Log404', 'clearLog404'));
			add_action('admin_post_xag_export_404s_log', array('MXAG_Log404', 'exportLogs'));
			add_action('admin_post_xag_log_404s_settings', array('MXAG_Log404', 'Log404Settings'));
		}

        //--------------------------------------------
        //
        //             MySQL Operations
        //
        //--------------------------------------------
        protected static $TABLE_NAME;
		public function __construct() {
			static::$TABLE_NAME = self::TABLE_NAME;
		}

		// MySQL
		const TABLE_NAME = 'prs_log_404s';
		public static function createTable() {
			global $wpdb;
			require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

			$charset_collate = $wpdb->get_charset_collate();
			$creation_query =
				'CREATE TABLE ' . self::TABLE_NAME . ' (
			        `id` int(11) NOT NULL AUTO_INCREMENT,
			        `url` varchar(255) NOT NULL,
			        `slug` varchar(255) NOT NULL,
			        `agent` text,
			        `ip` text,
			        `reference` text,
			        `last_hit_counts` int(10) UNSIGNED,
			        `date_created` datetime,
			        `date_updated` datetime NOT NULL DEFAULT NOW(),
			        PRIMARY KEY  (`id`)
			    ) ' .$charset_collate. ';';
			@dbDelta( $creation_query );
		}

		public static function removeTable() {
			global $wpdb;
			$query = 'DROP TABLE IF EXISTS ' . self::TABLE_NAME . ';';
			$wpdb->query( $query );
		}

        public static function chkHtAccExists() {
            $htAccPath = ABSPATH.'.htaccess';
            if ( !file_exists($htAccPath) ) {
                return false;
            } else {
				if ( 0 == filesize( $htAccPath ) ) {
					return false;
				}
				return true;
			}
        }

        public static function createHtAccFile() {
            $htAccPath = ABSPATH.'.htaccess';
			$homeRoot = parse_url( home_url() );

			if ( isset( $homeRoot['path'] ) ) {
				$homeRoot = trailingslashit( $homeRoot['path'] );
			} else {
				$homeRoot = '/';
			}

			$file = fopen("$htAccPath", "w");

			$rules  = "# BEGIN WordPress\n";
			$rules .= "<IfModule mod_rewrite.c>\n";
			$rules .= "RewriteEngine On\n";
			$rules .= "RewriteBase $homeRoot\n";

			/* Prevent -f checks on index.php. */
			$rules .= "RewriteRule ^index\.php$ - [L]\n";

			$rules .= "RewriteCond %{REQUEST_FILENAME} !-f\n";
			$rules .= "RewriteCond %{REQUEST_FILENAME} !-d\n";
			$rules .= "RewriteRule . $homeRoot"."index.php [L,QSA]\n";
			$rules .= "</IfModule>\n";
			$rules .= "# END WordPress\n";

			fwrite($file, $rules);
			fclose($file);
        }

		public static function getIp() {
		    if (!empty( $_SERVER['HTTP_CLIENT_IP'])) {
		        /* check ip from share internet */
		        $ip = $_SERVER['HTTP_CLIENT_IP'];
		    } else if (!empty( $_SERVER['HTTP_X_FORWARDED_FOR'])) {
		        /* to check ip is pass from proxy */
		        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
		    } else {
		        $ip = $_SERVER['REMOTE_ADDR'];
		    }
		    return $ip;
		}

		public static function getServerName() {
			$host = '';
			if ( isset( $_SERVER['HTTP_HOST'] ) ) {
				$host = $_SERVER['HTTP_HOST'];
			}

			if ( isset( $_SERVER['SERVER_NAME'] ) ) {
				$host = $_SERVER['SERVER_NAME'];
			}
			return $host;
		}

		public static function getCurrentUrl() {
			$url = '';
			$urlProtocol = isset($_SERVER['HTTPS']) ? "https" : "http";
			$serverName = self::getServerName();

			$slug = '';
			if ( isset( $_SERVER['REQUEST_URI'] ) ) {
				$slug = $_SERVER['REQUEST_URI'];
			}

			$url = $urlProtocol . '://' . $serverName . $slug;
			return $url;
		}

		public static function getCurrentSlug() {
			$slug = '';
			if ( isset( $_SERVER['REQUEST_URI'] ) ) {
				$slug = $_SERVER['REQUEST_URI'];
			}
			return $slug;
		}

        public static function doStuffOn404() {
			$chk404sStatus = get_option('prs_disable_log404s');

			if($chk404sStatus != 1) {
				if (is_404()) {
					$ip = self::getIp();
					$url = self::getCurrentUrl();
					$slug = self::getCurrentSlug();
					$chk404sSpiderLog = get_option('prs_enable_spider404s');
					$ext = pathinfo($url, PATHINFO_EXTENSION);

					if ( isset($ext) && !empty($ext) ) {
						$chkBlockedExt = self::chkBlockedExtensions($ext);

						if ( $chkBlockedExt === true) {
							return false;
						}
					}

					$chkSlug = self::chkSlugStrExists($slug);
					if ($chkSlug === true) {
						return false;
					}

					$agent = '';
					if ( isset( $_SERVER['HTTP_USER_AGENT'] ) ) {
						$agent = $_SERVER['HTTP_USER_AGENT'];

						if ( $chk404sSpiderLog != 1 ) {
							$checkBot = self::smartIpDetectCrawler($agent);

							if ($checkBot === true) {
								return false;
							}
						}

					} else {
						return false;
					}

					$reference = '';
					if ( isset( $_SERVER['HTTP_REFERER'] ) ) {

						$reference = $_SERVER['HTTP_REFERER'];
						$mainUrl = parse_url($url);
						$RefUrl = parse_url($reference);

						if ( strtolower( $mainUrl['host'] ) == strtolower( $RefUrl['host'] ) ) {
							return false;
						}

						$chkEscRefStr = self::checkEscapeRefStr($reference);

						if ($chkEscRefStr === true) {
							return false;
						}

					}

					if ( empty($reference) ) {
						$chk404sWithReferenceStatus = get_option('prs_enable_404s_with_referr_url');
						if($chk404sWithReferenceStatus == 1) {
							return false;
						}
					}

					$getHits = self::getData('id, ip, agent, reference, last_hit_counts', array(
						'url' => $url
					));

					if (isset($getHits) && !empty($getHits)) {

						$ipAr = json_decode($getHits['ip']);
						$agentAr = json_decode($getHits['agent']);
						$referenceAr = json_decode($getHits['reference']);

						$ipArRes = self::insertUpdateJsonVal($ipAr, $ip);
						$agentArRes = self::insertUpdateJsonVal($agentAr, $agent);
						$referenceArRes = self::insertUpdateJsonVal($referenceAr, $reference);

						if ($ipArRes['method'] === 'update' && $agentArRes['method'] === 'update' && $referenceArRes['method'] === 'update') {
							$curntHits = $getHits['last_hit_counts'] + 1;
							self::updateData(
								array(
									'ip' => wp_json_encode($ipArRes['value']),
									'agent' => wp_json_encode($agentArRes['value']),
									'reference' => wp_json_encode($referenceArRes['value']),
									'last_hit_counts' => $curntHits
								),
								array(
									'id' => $getHits['id']
								)
							);
						}

					} else {
						$ipAddr = self::insertUpdateJsonVal(null, $ip);
						$userAgent = self::insertUpdateJsonVal(null, $agent);
						$referrer = self::insertUpdateJsonVal(null, $reference);

						if ($ipAddr['method'] === 'insert' && $userAgent['method'] === 'insert' && $referrer['method'] === 'insert') {
							self::insertData(array(
								'url' => $url,
								'slug' => $slug,
								'agent' => wp_json_encode($userAgent['value']),
								'reference' => wp_json_encode($referrer['value']),
								'ip' => wp_json_encode($ipAddr['value']),
								'last_hit_counts' => 1,
								'date_created' => date('Y-m-d H:i:s')
							));
						}
					}

					$get404sLogLmt = get_option('prs_max_log_limit');
					$logLmt = intval($get404sLogLmt);

					if ( isset( $logLmt ) && !empty($logLmt) ) {
						self::query('DELETE tb FROM `prs_log_404s` AS tb
										JOIN
											( SELECT id AS tmp_tb
											  FROM `prs_log_404s`
											  ORDER BY tmp_tb DESC
											  LIMIT 18446744073709551615 OFFSET '.$logLmt.'
											) tmp_limit
										ON tb.id <= tmp_limit.tmp_tb'
										);
					}

					$getGlobal301RdirectUrl = get_option('prs_global_404_redirections_url');

					if ( isset($getGlobal301RdirectUrl) && !empty($getGlobal301RdirectUrl) ) {
						wp_redirect("$getGlobal301RdirectUrl");
					}

	            }
			} else {
				return false;
			}
        }

		public static function insertUpdateJsonVal($ArVal, $currVal) {
			if (is_array($ArVal)) {

				if (!empty($currVal)) {
					if (!in_array($currVal, $ArVal)) {
						$ArVal[] = $currVal;
						return array('value' => $ArVal, 'method' => 'update');
					}
				}
				return array('value' => $ArVal, 'method' => 'update');

			} else {

				$defaultAr = array();
				if (!empty($currVal)) {
					$defaultAr[] = $currVal;
					return array('value' => $defaultAr, 'method' => 'insert');
				}
				return array('value' => $defaultAr, 'method' => 'insert');

			}
		}

		public static function getLog404_Datatables() {
			global $wpdb;

			$aColumns = array(
				'id',
				'last_hit_counts',
				'url',
				'date_updated',
				'ip',
				'reference',
				'agent',
				'slug'
			);

			/* Indexed column (used for fast and accurate table cardinality) */
			$sIndexColumn = "id";

			/* DB table to use */
			$sTable = self::TABLE_NAME;

			/*
			 * Paging
			 */
			$sLimit = '';
			if ( isset( $_POST['iDisplayStart'] ) && $_POST['iDisplayLength'] != '-1' ) {
				$sLimit = "LIMIT " . ( $_POST['iDisplayStart'] ) . ", " .
				          ( $_POST['iDisplayLength'] );
			} else {
				$sLimit = "LIMIT 0,3000";
			}

			/*
			 * Ordering
			 */
			$sOrder = '';
			if ( isset( $_POST['iSortCol_0'] ) ) {
				$sOrder = "ORDER BY  ";
				for ( $i = 0; $i < intval( $_POST['iSortingCols'] ); $i ++ ) {
					if ( $_POST[ 'bSortable_' . intval( $_POST[ 'iSortCol_' . $i ] ) ] == "true" ) {
						$sOrder .= $_POST[ 'mDataProp_' . intval( $_POST[ 'iSortCol_' . $i ] ) ]  . "
				 	" . ( $_POST[ 'sSortDir_' . $i ] ) . ", ";
					}
				}

				$sOrder = substr_replace( $sOrder, "", - 2 );
				if ( $sOrder == "ORDER BY" ) {
					$sOrder = "";
				}
			}

			$customFilters = array(
				'search'   => $_POST['sSearch']
			);

			$customWhere = "";

			foreach($customFilters as $key=>$column) {

				if ($column != '') {
					if ($customWhere == "") {
						$customWhere = "WHERE ";
					} else {
						$customWhere .= " AND ";
					}

					if ($key == 'search') {
						$customWhere .= " (`url` LIKE '%" . ($column) . "%') ";
					} else {
						$customWhere .= $key . " = " . ($column) . " ";
					}
				}
			}

			/*
			 * SQL queries
			 * Get data to display
			 */
			$sQuery  = "
				SELECT SQL_CALC_FOUND_ROWS " . str_replace( " , ", " ", implode( ", ", $aColumns ) ) . "
				FROM   $sTable
				$customWhere
				$sOrder
				$sLimit";

			$rResult = $wpdb->get_results( $sQuery, ARRAY_A );

			$sQuery             = "SELECT FOUND_ROWS()";
			$aResultFilterTotal = $wpdb->get_results( $sQuery, ARRAY_A );
			$iFilteredTotal     = $aResultFilterTotal[0]['FOUND_ROWS()'];

			/* Total data set length */
			$sQuery       = "
				SELECT COUNT(" . $sIndexColumn . ")
				FROM   $sTable";

			$aResultTotal = $wpdb->get_results( $sQuery, ARRAY_A );
			$iTotal       = $aResultTotal[0]['COUNT(id)'];

			$datt = array();
			foreach($rResult as $d) {
				$d['date_updated'] = date("M dS, Y", strtotime($d['date_updated']));
				$datt[] = $d;
			}

			/*
			 * Output
			 */
			$output = array(
				"sEcho"                => intval( $_POST['sEcho'] ),
				"iTotalRecords"        => $iTotal,
				"iTotalDisplayRecords" => $iFilteredTotal,
				"aaData"               => $datt
			);

			echo json_encode( $output );
		}

		public static function addLog404Redirect() {
			if (isset($_POST['old404URL']) && isset($_POST['newURL'])) {
				self::add404Redirect($_POST['old404URL'], $_POST['newURL']);
			}
			XAG_Init::json('error', '404 URL not fetched! Please add this URL from 301 redirects.');
		}

		public static function add404Redirect($old, $new) {
			/* Check if empty */
			if (empty($old) || empty($new)) {
				return;
			}

			/* Remove old data */
			MXAG_Redirects::removeData(array( 'new' => $old ));

			$old = ltrim($old, '/');
			$old = rtrim($old, '/');

			$new = ltrim($new, '/');
			$new = rtrim($new, '/');

			$chkExistsUrl = MXAG_Redirects::checkExistsUrl($old);

			if (isset($chkExistsUrl['id']) && $chkExistsUrl['status'] === true) {

				MXAG_Redirects::updateData(
					array(
						'old' => $old,
						'new' => $new
					),
					array(
						'id' => $chkExistsUrl['id']
					)
				);

			} else {

				MXAG_Redirects::insertData(array(
					'old' => $old,
					'new' => $new,
					'date_created' => date('Y-m-d H:i:s')
				));

			}

			XAG_Init::json('success', 'Redirect successfully added in 301 redirects list.');
		}

		public static function smartIpDetectCrawler($userAgent) {
			/* User lowercase string for comparison. */
			if (isset($userAgent)) {
				$userAgent = strtolower($userAgent);
			} else {
				$userAgent = strtolower($_SERVER['HTTP_USER_AGENT']);
			}
			/* A list of some common words used only for bots and crawlers. */
			$botIdentifiers = array(
				'bot',
				'slurp',
				'crawler',
				'crawl',
				'spider',
				'curl',
				'facebook',
				'search',
				'fetch'
			);
			/* See if one of the identifiers is in the UA string. */
			foreach ($botIdentifiers as $identifier) {
				if (strpos($userAgent, $identifier) !== false) {
					return true;
				}
			}
			return false;
		}

		public static function checkEscapeRefStr($referer) {
			if (isset($referer)) {
				$referer = strtolower($referer);
			} else {
				$referer = strtolower($_SERVER['HTTP_REFERER']);
			}

			$symbolIdentifiers = array( '{', '}', '<', '>' );

			foreach ($symbolIdentifiers as $identifier) {
				if (strpos($referer, $identifier) !== false) {
					return true;
				}
			}
			return false;
		}

		public static function chkBlockedExtensions($ext) {
			$ext = strtolower($ext);

			$extAr = array('jpg', 'jpeg', 'gif', 'png', 'tiff', 'psd', 'pdf', 'doc', 'docx', 'ppt', 'xls', 'eps', 'ai', 'indd', 'raw', 'mp4', 'm4a', 'm4v', 'f4v', 'f4a', 'm4b', 'm4r', 'f4b', 'mov', '3gp', '3gp2', '3g2', '3gpp', '3gpp2', 'ogg', 'oga', 'ogv', 'ogx', 'wmv', 'wma', 'asf*', 'webm', 'flv', 'avi', 'hdv', 'OP1a', 'OP-Atom', 'ts', 'wav', 'lxf', 'gxf*', 'vob', 'mp3', 'aac', 'ac3', 'eac3', 'vorbis', 'pcm', 'ico', 'xml', 'zip', 'conf', 'ini', 'xsd', 'env', 'txt', 'cfg', 'bsh', 'json', 'log', 'bshservlet', 'action');

			if ( in_array($ext, $extAr) ) {
				return true;
			}
			return false;
		}

		public static function chkSlugStrExists($slugStr) {
			if ( isset($slugStr) && !empty($slugStr) ) {
				/* lowercase string for comparison. */
				$slugStr = strtolower($slugStr);

				$defaultStrAr = array(
					'/wp-content/',
					'/uploads/',
					'/vendor/',
					'/phpmyadmin/',
					'/mysqladmin/',
					'/temp/',
					'/tmp/'
				);

				foreach ($defaultStrAr as $defaultStr) {
					if (strpos($slugStr, $defaultStr) !== false) {
						return true;
					}
				}

				$listIgnoredUrls = get_option('prs_ignore_404_urls');
				$listIgnoredUrls = implode('',$listIgnoredUrls);

				if ( isset($listIgnoredUrls) && !empty($listIgnoredUrls) ) {
					$ignoredUrlAr = explode('*', $listIgnoredUrls);

					foreach ($ignoredUrlAr as $ignoredUrl) {
						$ignoredUrl = strtolower($ignoredUrl);
						if( !empty($ignoredUrl) ) {
							if (strpos($slugStr, $ignoredUrl) !== false) {
								return true;
							}
						}
					}

				}
				return false;
			}
			return false;
		}

		public static function deleteLog404() {
			$ID = $_POST['id'];

			$RemoveIDs = explode(',' , $ID);

			foreach ($RemoveIDs as $i_d) {
				self::removeData(array('id'=>$i_d));
			}
		}

		public static function clearLog404() {
			self::truncate('prs_log_404s');
		}

        public static function exportLogs() {
            if (is_admin()) {
				self::exportLogsToCsv($project_id);
            } else {
                exit('You are not auththorized user.');
            }
        }

		public static function exportLogsToCsv($project_id) {
            $getLogs = self::query("SELECT * FROM prs_log_404s WHERE slug != ''");

            $output .= '"Total Entries","' . count($getLogs) . '",';
            $output .= "\n";
			$output .= 'Hits,404 URL,IP Addresses,Referers,User Agents,Last Hit';
			$output .= "\n";

            foreach ($getLogs as $log) {

				$ips = '';
				$references = '';
				$agents = '';

				$log['ip'] = json_decode($log['ip']);
				$log['reference'] = json_decode($log['reference']);
				$log['agent'] = json_decode($log['agent']);

				$ips = implode(" , ", $log['ip']);
				$references = implode(" , ", $log['reference']);
				$agents = implode(" , ", $log['agent']);

				$output .= '"' . $log['last_hit_counts'] . '","' . $log['url'] . '","' . $ips . '","' . $references . '","' . $agents . '","' . $log['date_updated'] . '",';
                $output .= "\n";

            }

            $filename = "log404s.csv";
            header('Content-type: application/csv');
            header('Content-Disposition: attachment; filename=' . $filename);

            echo $output;
            exit;
        }

		public static function Log404Settings() {
			if (! isset( $_POST['_wpnonce'] ) || ! wp_verify_nonce( $_POST['_wpnonce'], 'xag_log_404s_settings' ) ) {
				XAG_Init::json( 'error', 'Sorry, you are not auththorized user.' );
			} else {
				if ( isset( $_POST['xag_disable_log404s'] ) ) {
					if ( $_POST['xag_disable_log404s'] == 1 ) {
						update_option( 'prs_disable_log404s', true );
						$statusMessages[] = '404s Log disabled.';
					} else {
						update_option( 'prs_disable_log404s', false );
						$statusMessages[] = '404s Log enabled.';
					}
				}

				if ( isset( $_POST['xag_enable_spider404s'] ) ) {
					if ( $_POST['xag_enable_spider404s'] == 1 ) {
						update_option( 'xag_enable_spider404s', true );
						$statusMessages[] = '404s Spider Log enabled.';
					} else {
						update_option( 'xag_enable_spider404s', false );
						$statusMessages[] = '404s Spider Log disabled.';
					}
				}

				$maxLogLimit = trim(sanitize_text_field($_POST['xag_max_log_limit']));

				if(isset($maxLogLimit) && ctype_digit($maxLogLimit)) {
					update_option( 'xag_max_log_limit', $maxLogLimit );
					$statusMessages[] = 'Updated 404s max log limit.';
				}

				if ( isset( $_POST['ignored-urls-list'] ) ) {
					$ignoredUrlsList = explode("\n", $_POST['ignored-urls-list']);
					update_option( 'xag_ignore_404_urls', $ignoredUrlsList );
					$statusMessages[] = 'Updated 404s ignored URLs.';
				}

				$global301Redirect = trim(esc_url_raw($_POST['xag_global_404_redirections_url']));

				if ( isset($global301Redirect) ) {
					update_option( 'xag_global_404_redirections_url', $global301Redirect );
					$statusMessages[] = 'Updated global 301 redirect URL.';
				}

				if ( isset( $_POST['xag_enable_404s_with_referr_url'] ) ) {
					if ( $_POST['xag_enable_404s_with_referr_url'] == 1 ) {
						update_option( 'xag_enable_404s_with_referr_url', true );
						$statusMessages[] = '404s Log with referers disabled.';
					} else {
						update_option( 'xag_enable_404s_with_referr_url', false );
						$statusMessages[] = '404s Log with referers enabled.';
					}
				}

				XAG_Init::json( 'success', "Operation completed! \n" . join( "\n", $statusMessages ) );
			}
		}

    }
}
