<?php

if ( ! class_exists( 'MXAG_Migration' ) ) {

	class MXAG_Migration extends MXAG_Model {

		public static function initialize() {
			add_action('admin_post_xag_migrate', array('MXAG_Migration', 'doMigration'));

			add_action('admin_post_xag_migrate_yoast', array('MXAG_Migration', 'migration_YOAST'));
			add_action('admin_post_xag_migrate_aio', array('MXAG_Migration', 'migration_AIO'));
		}

		public static function migration_YOAST()
		{
			global $wpdb;
			$query = "SELECT * FROM {$wpdb->prefix}postmeta WHERE meta_key LIKE '%_yoast_wpseo_%'";
			$results = $wpdb->get_results($query, ARRAY_A);

			foreach ($results as $r) {
				if ($r['meta_key'] == '_yoast_wpseo_title') {
					$id = $r['post_id'];
					update_post_meta($id, 'ps_seo_title', $r['meta_value']);
					// Enable Meta Robots
					update_post_meta($id, 'ps_meta_robots_enabled', 1);
				}
				if ($r['meta_key'] == '_yoast_wpseo_metadesc') {
					$id = $r['post_id'];
					update_post_meta($id, 'ps_seo_description', $r['meta_value']);
				}
				if ($r['meta_key'] == '_yoast_wpseo_focuskw') {
					$id = $r['post_id'];
					update_post_meta($id, 'ps_seo_keyword', $r['meta_value']);
				}
				if ($r['meta_key'] == '_yoast_wpseo_canonical') {
					$id = $r['post_id'];
					update_post_meta($id, 'ps_seo_canonical', $r['meta_value']);
				}
				if ($r['meta_key'] == '_yoast_wpseo_opengraph-title') {
					$id = $r['post_id'];
					update_post_meta($id, 'ps_seo_fb_title', $r['meta_value']);
				}
				if ($r['meta_key'] == '_yoast_wpseo_opengraph-description') {
					$id = $r['post_id'];
					update_post_meta($id, 'ps_seo_fb_desc', $r['meta_value']);
				}
				if ($r['meta_key'] == '_yoast_wpseo_opengraph-image') {
					$id = $r['post_id'];
					update_post_meta($id, 'ps_seo_fb_img', $r['meta_value']);
				}
				if ($r['meta_key'] == '_yoast_wpseo_twitter-title') {
					$id = $r['post_id'];
					update_post_meta($id, 'ps_seo_tw_title', $r['meta_value']);
				}
				if ($r['meta_key'] == '_yoast_wpseo_twitter-description') {
					$id = $r['post_id'];
					update_post_meta($id, 'ps_seo_tw_desc', $r['meta_value']);
				}
				if ($r['meta_key'] == '_yoast_wpseo_twitter-image') {
					$id = $r['post_id'];
					update_post_meta($id, 'ps_seo_tw_img', $r['meta_value']);
				}
			}

			// Do the settings migration
			$yoast_settings = get_option('wpseo_titles');

			// Homepage vars
			update_option('ps_seo_title', $yoast_settings['title-home-wpseo']);
			update_option('ps_seo_description', $yoast_settings['metadesc-home-wpseo']);

			// Container Arrays
			$ps_seo_post_types = get_option('ps_seo_post_types');
			$ps_seo_taxonomies = get_option('ps_seo_taxonomies');

			$ps_seo_post_types['post'] = array(
				'title'       => str_replace('%page%', '', $yoast_settings['title-post']),
				'description' => $yoast_settings['metadesc-post'],
				'nofollow'    => $yoast_settings['noindex-post']
			);

			$ps_seo_post_types['page'] = array(
				'title'       => str_replace('%page%', '', $yoast_settings['title-page']),
				'description' => $yoast_settings['metadesc-page'],
				'nofollow'    => $yoast_settings['noindex-page']
			);

			$ps_seo_taxonomies['category'] = array(
				'title'       => str_replace('%page%', '', $yoast_settings['title-tax-category']),
				'description' => $yoast_settings['metadesc-tax-category'],
				'nofollow'    => $yoast_settings['noindex-tax-category']
			);

			$ps_seo_taxonomies['post_tag'] = array(
				'title'       => str_replace('%page%', '', $yoast_settings['title-tax-post_tag']),
				'description' => $yoast_settings['metadesc-tax-post_tag'],
				'nofollow'    => $yoast_settings['noindex-tax-post_tag']
			);

			$ps_seo_taxonomies['post_format'] = array(
				'title'       => str_replace('%page%', '', $yoast_settings['title-tax-post_format']),
				'description' => $yoast_settings['metadesc-tax-post_format'],
				'nofollow'    => $yoast_settings['noindex-tax-post_format']
			);

			update_option('ps_seo_post_types', $ps_seo_post_types);
			update_option('ps_seo_taxonomies', $ps_seo_taxonomies);

		}

		public static function migration_AIO()
		{
			global $wpdb;
			$query = "SELECT * FROM {$wpdb->prefix}postmeta WHERE meta_key LIKE '%_aioseop%'";
			$results = $wpdb->get_results($query, ARRAY_A);
			foreach ($results as $r) {
				if ($r['meta_key'] == '_aioseop_title') {
					$id = $r['post_id'];
					update_post_meta($id, 'ps_seo_title', $r['meta_value']);
				}
				if ($r['meta_key'] == '_aioseop_description') {
					$id = $r['post_id'];
					update_post_meta($id, 'ps_seo_description', $r['meta_value']);
				}
				if ($r['meta_key'] == '_aioseop_custom_link') {
					$id = $r['post_id'];
					update_post_meta($id, 'ps_seo_canonical', $r['meta_value']);
				}
			}
		}

		public static function doMigration() {
			$status_messages = array();

			$XAG_MIGRATION  = get_option('XAG_MIGRATION');
			$migrationArray = array();
			if (is_array($XAG_MIGRATION)) {
				$migrationArray = $XAG_MIGRATION;
			}

			/**
			 *   Migrate Reviews
			 */
			if (isset($_POST['ts_migrate_reviews'])) {
				if ($_POST['ts_migrate_reviews'] == 1) {

					$migrationArray['ts_migrate_reviews'] = 1;

					// Get all reviews
					$homepage_reviews  = get_option('ps_default_reviews');
					$post_page_reviews = get_option('ps_per_page_reviews');

					// Insert homepage reviews
					foreach($homepage_reviews as $review) {
						$data = array(
							'name'      => sanitize_text_field($review['author']['name']),
							'review'    => sanitize_text_field($review['reviewBody']),
							'rating'    => intval($review['reviewRating']['ratingValue']),
							'email'     => '',
							'website'   => '',
							'telephone' => '',
							'location'  => '',
							'age'       => '',
							'approved'  => 1,
							'date'      => date('Y-m-d H:i:s', strtotime($review['datePublished']))
						);
						MXAG_Reviews::insertData($data);
					}

					// Insert post/page reviews
					foreach($post_page_reviews as $id=>$reviews) {
						foreach($reviews as $review) {
							$data = array(
								'name'      => sanitize_text_field($review['author']['name']),
								'review'    => sanitize_text_field($review['reviewBody']),
								'rating'    => intval($review['reviewRating']['ratingValue']),
								'email'     => '',
								'website'   => '',
								'telephone' => '',
								'location'  => '',
								'age'       => '',
								'approved'  => 1,
								'date'      => date('Y-m-d H:i:s', strtotime($review['datePublished'])),
								'page_id'   => $id
							);
							MXAG_Reviews::insertData($data);
						}
					}

				}
			}

			/**
			 *   Migrate Projects
			 */
			if (isset($_POST['ts_migrate_projects'])) {
				if ($_POST['ts_migrate_projects'] == 1) {

					$migrationArray['ts_migrate_projects'] = 1;

					// Migrate Projects
					$projects = self::getAllData('gkty_project');
					self::truncate('prs_projects');
					foreach($projects as $project) {
						self::insertData(array(
							'id'           => $project['id'],
							'project_name' => $project['name'],
							'date_created' => date('Y-m-d H:i:s', strtotime($project['created_date']))
						), 'prs_projects');
					}

					// Migrate Groups
					$groups = self::getAllData('gkty_group');
					self::truncate('prs_groups');
					foreach($groups as $group) {
						self::insertData(array(
							'id'           => $group['id'],
							'project_id'   => $group['project_id'],
							'id_page_post' => $group['id_post_page'],
							'group_name'   => $group['name'],
							'title'        => $group['title'],
							'url'          => $group['url'],
							'description'  => $group['description'],
							'h1'           => $group['h1'],
							'date_created' => date('Y-m-d H:i:s'),
							'position'     => 999
						), 'prs_groups');
					}

					// Migrate Keywords
					$keywords = self::getAllData('gkty_keyword');
					self::truncate('prs_keywords');
					foreach($keywords as $keyword) {
						self::insertData(array(
							'id'           => $keyword['id'],
							'group_id'     => $keyword['group_id'],
							'keyword'      => $keyword['name'],
							'volume'       => $keyword['volumn'],
							'cpc'          => $keyword['cpc'],
							'inurl'        => $keyword['inurl'],
							'intitle'      => $keyword['intitle'],
							'phrase'       => $keyword['inparse'],
							'broad'        => $keyword['inbroad'],
							'date_created' => date('Y-m-d H:i:s')
						), 'prs_keywords');
					}

				}
			}

			/**
			 *   Migrate Affiliate Shortcodes
			 */
			if (isset($_POST['ts_migrate_affiliate_shortcodes'])) {
				if ($_POST['ts_migrate_affiliate_shortcodes'] == 1) {

					$migrationArray['ts_migrate_affiliate_shortcodes'] = 1;

					$shortcodes = self::getAllData('gkty_affiliate_shortcodes');
					foreach($shortcodes as $shortcode) {
						self::insertData(array(
							'shortcode'    => str_replace(' ', '_', $shortcode['Shortcode']),
							'url'          => $shortcode['URL'],
							'title'        => $shortcode['Title'],
							'group'        => $shortcode['Group'],
							'target_blank' => $shortcode['Follow'],
							'nofollow'     => $shortcode['Nofollow'],
							'mask'         => $shortcode['Mask'],
							'image'        => $shortcode['ImageLink']
						), 'prs_shortcodes');
					}

				}
			}

			/**
			 *   Migrate Schemas
			 */
			if (isset($_POST['ts_migrate_schemas'])) {
				if ( $_POST['ts_migrate_schemas'] == 1 ) {

					$migrationArray['ts_migrate_schemas'] = 1;

					// Get the V2 schemas
					$schemas_default  = get_option('ps_default_schemas');
					$schemas_per_page = get_option('ps_per_page_schemas');

					// Send them schemas
					$output = MXAG_Api::apiRequest(
						'migrate_schema',
						'POST',
						array(
							'domain'           => preg_replace('/^www\./','',$_SERVER['SERVER_NAME']),
							'schemas_default'  => serialize($schemas_default),
							'schemas_per_page' => serialize($schemas_per_page)
						)
					);


				}
			}

			/**
			 *   Migrate Settings
			 */
			if (isset($_POST['ts_migrate_settings'])) {
				if ( $_POST['ts_migrate_settings'] == 1 ) {

					$migrationArray['ts_migrate_settings'] = 1;

					// Google website verification
					update_option('ps_seo_verify_google', get_option('GoogleVerification'));

					// Homepage Title
					update_option('ps_seo_title', get_option('ps_default_title'));

					// Homepage Description
					update_option('ps_seo_description', get_option('ps_default_desc'));

					// Target keyword => Meta keywords tag
					update_option('ps_seo_target_keyword', get_option('ps_meta_keywords'));

					/**
					 *  Set Force Enable & Enable SEO for all current Posts/Pages
					 */
					$always_seo = get_option('ps_always_seo');
					update_option('ps_seo_always_on', $always_seo);

					if ($always_seo != false) {
						$post_ids = MXAG_Seo::getAllPosts(TRUE);
						foreach($post_ids as $id) {
							update_post_meta($id, 'ps_seo_enabled', true);
						}
					}

					/**
					 *  Review settings
					 */
					$ps_review = get_option('ps_review');
					$ps_review['settings']['per_page_reviews'] = get_option('ps_per_page_review');
					$ps_review['settings']['natural_reviews']  = get_option('ps_review_natural');

					$ps_review['details']['title']        = get_option('ps_review_widget_title');
					$ps_review['details']['text']         = get_option('ps_review_widget_description');
					$ps_review['details']['button_title'] = get_option('ps_review_widget_label_button');

					/**
					 *  Post Pages / Taxonomies
					 */
					$ps_seo_default_values = get_option('ps_default_seo_values');

					// Post Types
					$post_types = MXAG_Seo::getAllPostTypes();

					// Taxonomies
					$taxonomies = MXAG_Seo::getAllTaxonomies();

					// Container Arrays
					$ps_seo_post_types = array();
					$ps_seo_taxonomies = array();

					foreach($ps_seo_default_values as $type => $data) {
						if (in_array($type, $post_types)) {
							$ps_seo_post_types[$type] = array(
								'title'       => $data['title'],
								'description' => $data['desc'],
								'nofollow'    => $data['noindex_follow']
							);
						} else if (in_array($type, $taxonomies)) {
							$ps_seo_taxonomies[$type] = array(
								'title'       => $data['title'],
								'description' => $data['desc'],
								'nofollow'    => $data['noindex_follow']
							);
						}
					}

					update_option('ps_seo_post_types', $ps_seo_post_types);
					update_option('ps_seo_taxonomies', $ps_seo_taxonomies);

				}
			}

			/**
			 *   Migrate On Page SEO Settings
			 */
			if (isset($_POST['ts_migrate_on_page_seo'])) {
				if ( $_POST['ts_migrate_on_page_seo'] == 1 ) {

					$migrationArray['ts_migrate_on_page_seo'] = 1;

					// Get the V2 On Page SEO Settings for all page/post
					$ps_seo_options  = get_option('ps_seo');

					if ( $ps_seo_options ) {
						foreach ( $ps_seo_options as $post_id => $val ) {
							// $val = array
							$meta_robots_enabled = get_post_meta($post_id, 'ps_meta_robots_enabled', true);
							update_post_meta($post_id, 'ps_seo_enabled', (isset($val['enabled'])) ? $val['enabled'] : 0);
							update_post_meta($post_id, 'ps_seo_title',   (isset($val['title'])) ? $val['title'] : '');
							update_post_meta($post_id, 'ps_seo_description', (isset($val['description'])) ? $val['description'] : '');
							update_post_meta($post_id, 'ps_seo_url', MXAG_Seo::extract_url($post_id));
							update_post_meta($post_id, 'ps_seo_keyword', (isset($val['keyword'])) ? $val['keyword'] : '');
							update_post_meta($post_id, 'ps_seo_metarobots_enabled', ($meta_robots_enabled) ? $meta_robots_enabled : 0);
							update_post_meta($post_id, 'ps_seo_metarobots', (isset($val['metarobots'])) ? $val['metarobots'] : '');
							update_post_meta($post_id, 'ps_seo_metarobots_follow', (isset($val['metarobots_follow'])) ? $val['metarobots_follow'] : '');
							update_post_meta($post_id, 'ps_seo_metarobots_advanced', (isset($val['metarobots_advanced'])) ? $val['metarobots_advanced'] : '');
							update_post_meta($post_id, 'ps_seo_canonical', (isset($val['canonical'])) ? $val['canonical'] : '');
							update_post_meta($post_id, 'ps_seo_tw_title', (isset($val['tw_title'])) ? $val['tw_title'] : '');
							update_post_meta($post_id, 'ps_seo_tw_desc', (isset($val['tw_desc'])) ? $val['tw_desc'] : '');
							update_post_meta($post_id, 'ps_seo_tw_img', (isset($val['tw_img'])) ? $val['tw_img'] : '');
							update_post_meta($post_id, 'ps_seo_fb_title', (isset($val['fb_title'])) ? $val['fb_title'] : '');
							update_post_meta($post_id, 'ps_seo_fb_desc', (isset($val['fb_desc'])) ? $val['fb_desc'] : '');
							update_post_meta($post_id, 'ps_seo_fb_img', (isset($val['fb_img'])) ? $val['fb_img'] : '');

						}
					}
				}
			}

			if (!empty($migrationArray)) {
				update_option('PRS_MIGRATION', $migrationArray);
			}

			XAG_Init::json('success', 'Operation completed!', $status_messages);
		}
	}

}