<?php

if (!class_exists('MXAG_Projects')) {

    class MXAG_Projects extends MXAG_Model
    {

        public static function initialize ()
        {
            // Disable Model if not license is present
            if (!XAG_Licencator::isLicenseSet()) {
                return;
            }

            add_action('admin_post_xag_get_projects', ['MXAG_Projects', 'getProjects']);

            add_action('admin_post_xag_new_project', ['MXAG_Projects', 'newProject']);
            add_action('admin_post_xag_rename_project', ['MXAG_Projects', 'renameProject']);
            add_action('admin_post_xag_remove_project', ['MXAG_Projects', 'removeProject']);
            add_action('admin_post_xag_export_project', ['MXAG_Projects', 'exportProject']);
            add_action('admin_post_xag_import_project', ['MXAG_Projects', 'importProject']);
            add_action('admin_post_xag_import_kws', ['MXAG_Projects', 'importKWS']);

            add_action('admin_post_xag_create_page_post', ['MXAG_Projects', 'createPagePost']);

            add_action('admin_post_xag_get_page_post_parent', ['MXAG_Projects', 'getPagePostParent']);
            add_action('admin_post_xag_get_page_post_status', ['MXAG_Projects', 'getPagePostStatus']);

            add_action('admin_post_xag_update_page_parent', ['MXAG_Projects', 'updatePageParent']);
            add_action('admin_post_xag_update_page_post_status', ['MXAG_Projects', 'updatePagePostStatus']);

            add_action('admin_post_xag_make_groups', ['MXAG_Projects', 'makeGroups']);

            add_action('admin_post_xag_get_posts', ['MXAG_Projects', 'getPosts']);
            add_action('admin_post_xag_get_post_types', ['MXAG_Projects', 'getPostTypes']);
            add_action('admin_post_xag_get_tags_categories', ['MXAG_Projects', 'getTagsCategories']);

            add_action('admin_post_xag_attach_to_page_post', ['MXAG_Projects', 'attachToPagePost']);
            add_action('admin_post_xag_set_default_search_engine', ['MXAG_Projects', 'setDefaultSearchEngine']);
            add_action('admin_post_xag_get_default_search_engine', ['MXAG_Projects', 'getDefaultSearchEngine']);
        }

        protected static $TABLE_NAME;

        public function __construct ()
        {
            static::$TABLE_NAME = self::TABLE_NAME;
        }

        //--------------------------------------------
        //
        //             MySQL Operations
        //
        //--------------------------------------------

        // MySQL
        const TABLE_NAME = 'prs_projects';

        public static function createTable ()
        {
            global $wpdb;
            require_once(ABSPATH . 'wp-admin/includes/upgrade.php');

            $charset_collate = $wpdb->get_charset_collate();
            $creation_query  =
                'CREATE TABLE ' . self::TABLE_NAME . ' (
			        `id` int(11) NOT NULL AUTO_INCREMENT,
			        `project_name` varchar(255),
			        `date_created` datetime,
			        PRIMARY KEY  (`id`)
			    ) ' . $charset_collate . ';';
            @dbDelta($creation_query);
        }

        public static function removeTable ()
        {
            global $wpdb;
            $query = 'DROP TABLE IF EXISTS ' . self::TABLE_NAME . ';';
            $wpdb->query($query);
        }

        // Attach to Page/Post
        public static function attachToPagePost ()
        {

            $post_id     = $_POST['post_id'];
            $group_id    = $_POST['group_id'];
            $attach_type = $_POST['attach_type'];

            $post  = get_post($post_id);
            $group = MXAG_Groups::getData("*", [
                'id' => $group_id
            ]);

            $h1    = NULL;
            $title = NULL;
            $desc  = NULL;
            $notes = NULL;

            if ($attach_type == 'page') {

                $h1    = $post->post_title;
                $title = get_post_meta($post_id, 'ps_seo_title', TRUE);
                $desc  = get_post_meta($post_id, 'ps_seo_description', TRUE);
                $notes = get_post_meta($post_id, 'ps_seo_notes', TRUE);

            } else if ($attach_type == 'group') {

                $h1    = $group['h1'];
                $title = $group['title'];
                $desc  = $group['description'];
                $notes = $group['notes'];

            }

            if (empty($title)) {
                XAG_Init::json('error', "SEO Title from your $attach_type is empty! Please set it up, or choose a different import data source!");
                return;
            }

            if (empty($desc)) {
                XAG_Init::json('error', "SEO Description from your $attach_type is empty! Please set it up, or choose a different import data source!");
                return;
            }

            if (empty($h1)) {
                XAG_Init::json('error', "H1 from your $attach_type is empty! Please set it up, or choose a different import data source!");
                return;
            }

            MXAG_Groups::updateData([
                'id_page_post' => $post_id,
                'h1'           => $h1,
                'url'          => MXAG_Seo::extract_url($post_id),
                'title'        => $title,
                'description'  => $desc,
                'notes'        => $notes
            ], [
                'id' => $group_id
            ]);

            $title = update_post_meta($post_id, 'ps_seo_title', $title);
            $desc  = update_post_meta($post_id, 'ps_seo_description', $desc);
            $notes = update_post_meta($post_id, 'ps_seo_notes', $notes);

            $post_data = [
                'ID'         => $post_id,
                'post_title' => $h1
            ];

            // Update the post into the database
            wp_update_post($post_data);

            XAG_Init::json('success', 'Successfully attached page/post.');
        }

        /*Set Default Search Engine*/
        public function setDefaultSearchEngine ()
        {
            if ($_POST['action'] == 'xag_set_default_search_engine' && !empty($_POST['data'])) {
                $seachEnignes = json_decode(stripslashes($_POST['data']), TRUE);
                update_user_meta(get_current_user_id(), 'prs_keyword_ranking_default_search_engine', $seachEnignes);
                XAG_Init::json('success', 'Added Default search engine Successfully.', $seachEnignes);
            }
        }

        /*Get Default Search Engine*/
        public function getDefaultSearchEngine ()
        {
            if ($_POST['action'] == 'xag_get_default_search_engine') {
                $data = get_user_meta(get_current_user_id(), 'prs_keyword_ranking_default_search_engine');
                if (!empty($data)) {
                    XAG_Init::json('success', 'Get Default search engine Successfully.', $data['0']);
                }
            }
        }

        public static function isAttachedToGroup ($post_id)
        {
            $groups = MXAG_Groups::getData('*', [
                'id_page_post' => $post_id
            ]);
            if ($groups == FALSE) return FALSE;
            return (int)$groups['id'];
        }

        // Get Posts
        public static function getPosts ()
        {
            MXAG_Api::searchPosts();
        }

        // Get Posts
        public static function getPostTypes ()
        {
            MXAG_Api::getPostTypes();
        }

        public static function getTagsCategories ()
        {
            $categories = get_categories([
                    "hide_empty" => 0,
                    "type"       => "post",
                    "orderby"    => "name",
                    "order"      => "ASC"
                ]
            );
            $tags       = get_tags([
                "hide_empty" => 0,
                "type"       => "post",
                "orderby"    => "name",
                "order"      => "ASC"
            ]);

            XAG_Init::json('success', 'Successfully got tags and categories!', [
                'categories' => $categories,
                'tags'       => $tags
            ]);
        }

        // Make Groups
        public static function makeGroups ()
        {
            $posts      = explode(',', $_POST['ids']);
            $project_id = $_POST['project_id'];

            if (!isset($project_id) || empty($project_id)) {
                XAG_Init::json('error', 'Project ID is missing, please enter some project!');
            }

            if (!is_array($posts)) {
                XAG_Init::json('error', 'Please select some posts!');
            }

            foreach ($posts as $post_id) {
                $post = get_post($post_id);

                $ps_seo_enabled = get_post_meta($post_id, 'ps_seo_enabled', TRUE);
                $wp_post_title  = $post->post_title;
                $wp_post_url    = MXAG_Seo::extract_url($post_id);
                $wp_description = '';

                $ps_seo_title       = get_post_meta($post_id, 'ps_seo_title', TRUE);
                $ps_seo_description = get_post_meta($post_id, 'ps_seo_description', TRUE);
                $ps_seo_notes       = get_post_meta($page_id, 'ps_seo_notes', TRUE);

                MXAG_Groups::newGroupFromExistingPost(
                    $project_id,
                    $wp_post_title,
                    $post_id,
                    $ps_seo_title,
                    $wp_post_url,
                    $ps_seo_description,
                    $wp_post_title,
                    $ps_seo_notes
                );

            }

            XAG_Init::json('success', 'Successfully Created Groups!');
        }

        // Get all projects
        public static function getProjects ()
        {
            wp_send_json(["aaData" => MXAG_Projects::getAllData()]);
        }

        // Rename Project
        public static function renameProject ()
        {
            $project_name = $_POST['project_name'];
            $project_id   = $_POST['project_id'];

            MXAG_Projects::updateData([
                'project_name' => $project_name
            ], [
                'id' => $project_id
            ]);
        }

        // Create new Project
        public static function newProject ()
        {
            $projectName = $_POST['project_name'];
            $dateCreated = date('Y-m-d H:i:s');
            MXAG_Projects::insertData([
                'project_name' => $projectName,
                'date_created' => $dateCreated
            ]);
        }

        // Remove Project
        public static function removeProject ()
        {
            $projectID = $_POST['project_id'];
            self::query("DELETE p, g, k FROM prs_projects p LEFT JOIN prs_groups g ON p.id = g.project_id LEFT JOIN prs_keywords k ON g.id = k.group_id WHERE p.id = '$projectID'");

        }


        //--------------------------------------------
        //
        //               Functions
        //
        //--------------------------------------------

        public static function getPagePostParent ()
        {
            $pages = get_pages();
            for ($i = 0; $i < count($pages); $i++) {
                $page       = (array)$pages[$i];
                $id         = $page['ID'];
                $title      = $page['post_title'];
                $pageList[] = [
                    'id'    => $id,
                    'title' => $title,
                ];
            }

            XAG_Init::jsonc($pageList);
        }

        public static function updatePagePostStatus ()
        {
            if (isset($_POST['page_id']) && isset($_POST['value'])) {
                $res = wp_update_post([
                    'ID'          => $_POST['page_id'],
                    'post_status' => $_POST['value']
                ]);
            }
            XAG_Init::json('success', 'Status updated!', $res);
        }

        public static function updatePageParent ()
        {
            if (isset($_POST['page_id']) && isset($_POST['value'])) {
                $res = wp_update_post([
                    'ID'          => $_POST['page_id'],
                    'post_parent' => $_POST['value']
                ]);
            }
            XAG_Init::json('success', 'Parent updated!', $res);
        }

        public static function getPagePostStatus ()
        {
            $statusTypes  = array_keys(get_post_statuses());
            $statusValues = get_post_statuses();
            for ($i = 0; $i < count($statusTypes); $i++) {
                $status[] = ['value' => $statusTypes[$i], 'title' => $statusValues[$statusTypes[$i]]];
            }
            XAG_Init::jsonc($status);
        }


        public static function createPagePost ()
        {

            if ($_POST['request_type'] == 'single') {
                $group_id          = intval($_POST['group_id']);
                $group_name        = esc_html($_POST['group_name']);
                $group_title       = trim(esc_html($_POST['title']));
                $group_url         = trim(esc_html($_POST['url']));
                $group_description = trim(esc_html($_POST['description']));
                $group_h1          = trim(esc_html($_POST['h1']));
                $post_type         = $_POST['type'];
                $post_note         = trim(esc_html($_POST['notes']));
            } else {
                $group_id          = $_POST['group_id'];
                $post_type         = $_POST['type'];
                $group             = self::querySingle("SELECT * FROM prs_groups WHERE id = '$group_id'");
                $group_name        = esc_html($group['group_name']);
                $group_title       = trim(esc_html($group['title']));
                $group_url         = trim(esc_html($group['url']));
                $group_description = trim(esc_html($group['description']));
                $group_h1          = trim(esc_html($group['h1']));
                $post_note         = trim(esc_html($_POST['notes']));
            }


            if ($post_type != 'page' && $post_type != 'post') {
                $post_type = 'page';
            }
            if ($group_title == '') {
                XAG_Init::json('error', 'Your SEO title is missing!');
            }

            if ($group_url == '') {
                XAG_Init::json('error', 'Your group URL is missing!');
            }

            if ($group_h1 == '') {
                XAG_Init::json('error', 'Your group header is missing!');
            }

            // Check if the Group is already associated with a Page/Post
            $group = MXAG_Groups::getData('*', [
                'id' => $group_id
            ]);

            if ($group === FALSE) {
                XAG_Init::json('error', 'Specified group does not exist.');
            }

            if (!empty($group['id_page_post'])) {
                XAG_Init::json('warning', 'Already exists!', ['url' => admin_url() . "post.php?post={$group['id_page_post']}&action=edit", 'page_id' => $group['id_page_post']]);
            }

            // Create Page/Post.
            global $user_ID;

            $page['post_type']    = $post_type;
            $page['post_content'] = '';
            $page['post_parent']  = 0;
            $page['post_author']  = $user_ID;
            $page['post_status']  = 'draft';
            $page['post_title']   = $group_h1;
            $page_id              = wp_insert_post($page);

            $data  = [
                'group_name'   => $group_name,
                'title'        => $group_title,
                'url'          => $group_url,
                'description'  => $group_description,
                'h1'           => $group_h1,
                'notes'        => $post_note,
                'id_page_post' => $page_id,
            ];
            $where = [
                'id' => $group_id
            ];
            self::updateData($data, $where, 'prs_groups');

            if ($page_id == 0) {
                XAG_Init::json('error', 'Could not create page at the moment!');
            }
            wp_update_post([
                'ID'        => $page_id,
                'post_name' => $group_url,
            ]);
            update_post_meta($page_id, '_yoast_wpseo_title', $group_title);
            update_post_meta($page_id, '_yoast_wpseo_metadesc', $group_description);
            update_post_meta($page_id, 'ps_seo_title', $group_title);
            update_post_meta($page_id, 'ps_seo_description', $group_description);
            update_post_meta($page_id, 'ps_seo_notes', $post_note);

            XAG_Init::json('success', 'Created!', ['url' => admin_url() . "post.php?post={$page_id}&action=edit", 'page_id' => $page_id, 'post_type' => $post_type]);
        }

        // Download to CSV
        public static function exportProject ()
        {
            // Export to csv.
            if (!isset($_GET['project_id'])) {
                die('Project ID is missing!');
            }

            $project_id = $_GET['project_id'];
            $project_id = intval($project_id);
            if ($project_id > 0) {
                self::exportToCsv($project_id);
            } else {
                die('Project ID is missing!');
            }
        }

        public static function exportToCsv ($project_id)
        {

            $projectData = self::querySingle("SELECT project_name FROM " . self::TABLE_NAME . " WHERE id = '$project_id'");
            if (isset($projectData['project_name'])) {
                $projectName = $projectData['project_name'];
            } else {
                $projectName = '';
            }
            unset($projectData);

            $projectGroups = self::query("SELECT * FROM prs_groups WHERE project_id = '$project_id'");

            $output = '"Project Name","' . $projectName . '",';
            $output .= "\n";
            $output .= '"Total Groups","' . count($projectGroups) . '",';
            $output .= "\n";
            foreach ($projectGroups as $group) {
                $group_id = $group['id'];
                $keywords = self::query("SELECT * FROM prs_keywords WHERE group_id = '$group_id'");
                $output   .= "\n";
                $output   .= 'Group,Title,URL,DESC,H1,';
                $output   .= "\n";
                $output   .= '"' . $group['group_name'] . '","' . $group['title'] . '","' . $group['url'] . '","' . $group['description'] . '","' . $group['h1'] . '",';
                $output   .= "\n";
                $output   .= 'Keyword,Volume,CPC,Broad,Phrase,inTITLE,inURL,"' . count($keywords) . '",';
                $output   .= "\n";
                foreach ($keywords as $keyword) {
                    $output .= '"' . $keyword['keyword'] . '",="' . $keyword['volume'] . '",="' . $keyword['cpc'] . '",="' . $keyword['broad'] . '",="' . $keyword['phrase'] . '",="' . $keyword['intitle'] . '",="' . $keyword['inurl'] . '",';
                    $output .= "\n";
                }
            }
            $filename = $projectName . ".csv";
            header('Content-type: application/csv');
            header('Content-Disposition: attachment; filename=' . $filename);

            echo $output;
            exit;


        }


        public static function importKWS ()
        {
            $project_id = $_POST['project_id'];
            $data       = json_decode(base64_decode($_POST['data']), TRUE);

            $group_name = $data['name'];
            $data       = $data['data'];

            $group_data       = [
                'project_id'   => $project_id,
                'group_name'   => $group_name,
                'title'        => $group_name,
                'url'          => '',
                'description'  => '',
                'h1'           => $group_name,
                'date_created' => date('Y-m-d H:i:s')

            ];
            $current_group_id = self::insertData($group_data, 'prs_groups');

            $processed_keywords = [];

            foreach ($data as $d) {
                if (in_array($d['Keyword'], $processed_keywords)) continue;
                if (strlen($d['Keyword']) < 3) continue;
                $data = [
                    'group_id' => $current_group_id,
                    'keyword'  => $d['Keyword'],
                    'volume'   => $d['Volume'],
                    'cpc'      => $d['Cost Per Click'],
                    'broad'    => 0,
                    'phrase'   => 0,
                    'intitle'  => 0,
                    'inurl'    => 0
                ];
                self::insertData($data, 'prs_keywords');
                $processed_keywords[] = $d['Keyword'];
            }

            XAG_Init::json('success', 'KWS data successfully imported!');
        }

        // Import Project from CSV
        public static function importProject ()
        {

            // check user role
            if (!current_user_can('manage_options')) {
                wp_die('Not allowed');
            }

            if (isset($_FILES['file-import'])) {
                // Handle the uploaded file
                $root_directory = get_home_path();
                $csv_path       = $root_directory . md5(microtime()) . '.csv';

                @move_uploaded_file($_FILES['file-import']['tmp_name'], $csv_path);

                $file_contents = @file_get_contents($csv_path);

                @unlink($csv_path);

                $file_contents = str_replace('=', '', $file_contents);
                $file_contents = str_replace('"', '', $file_contents);
                $file_contents = explode("\n", $file_contents);

                $project_name = explode(",", $file_contents[0]);
                $project_name = $project_name[1];

                // Create project
                $data = [
                    'project_name' => trim($project_name),
                    'date_created' => date("Y-m-d H:i:s")
                ];

                $project_id = self::insertData($data);

                $expectGroup      = FALSE;
                $current_group_id = 0;
                for ($i = 2; $i < sizeof($file_contents); $i++) {
                    $current = $file_contents[$i];
                    if ($current == '') {
                        $i           += 1;
                        $expectGroup = TRUE;
                        continue;
                    }
                    if ($expectGroup == TRUE) {
                        $expectGroup      = FALSE;
                        $data             = [
                            'project_id' => $project_id
                        ];
                        $current_group_id = self::insertData($data, 'prs_groups');
                        $x                = explode(",", $current);
                        $data             = [
                            'group_name'   => $x[0],
                            'title'        => $x[1],
                            'url'          => $x[2],
                            'description'  => $x[3],
                            'h1'           => $x[4],
                            'date_created' => date('Y-m-d H:i:s')
                        ];
                        self::updateData($data, ['id' => $current_group_id], 'prs_groups');
                        $i += 1;
                        continue;
                    }
                    $x               = explode(",", $current);
                    $keyword_name    = trim($x[0]);
                    $keyword_volume  = $x[1];
                    $keyword_cpc     = $x[2];
                    $keyword_broad   = $x[3];
                    $keyword_phrase  = $x[4];
                    $keyword_intitle = $x[5];
                    $keyword_inurl   = $x[6];

                    $data       = [
                        'group_id' => $current_group_id,
                    ];
                    $keyword_id = self::insertData($data, 'prs_keywords');

                    $data = [];

                    if (!empty($keyword_name)) {
                        $data['keyword'] = $keyword_name;
                    } else {
                        $data['keyword'] = '';
                    }
                    if (!empty($keyword_volume) && $keyword_volume != 0) {
                        $data['volume'] = $keyword_volume;
                    } else {
                        $data['volume'] = 0;
                    }
                    if (!empty($keyword_cpc) && $keyword_cpc != 0) {
                        $data['cpc'] = $keyword_cpc;
                    } else {
                        $data['cpc'] = 0;
                    }
                    if (!empty($keyword_broad) && $keyword_broad != 0) {
                        $data['broad'] = $keyword_broad;
                    } else {
                        $data['broad'] = 0;
                    }
                    if (!empty($keyword_phrase) && $keyword_phrase != 0) {
                        $data['phrase'] = $keyword_phrase;
                    } else {
                        $data['phrase'] = 0;
                    }
                    if (!empty($keyword_intitle) && $keyword_intitle != 0) {
                        $data['intitle'] = $keyword_intitle;
                    } else {
                        $data['intitle'] = 0;
                    }
                    if (!empty($keyword_inurl) && $keyword_inurl != 0) {
                        $data['inurl'] = $keyword_inurl;
                    } else {
                        $data['inurl'] = 0;
                    }

                    self::updateData($data, ['id' => $keyword_id], 'prs_keywords');
                }
            }

            //wp_redirect(add_query_arg('page', 'xagio-projects', admin_url('admin.php')));
            die();

        }

        public static function prsCsvUploadMimes ($existing_mimes = [])
        {
            $existing_mimes['json'] = 'application/csv';
            return $existing_mimes;
        }

        // Retrieve keyword data
        public static function getKeywordData ($keyword = "")
        {
            // Trim out bad characters from keyword
            $keyword = str_replace(["\r", "\n", "\t", "\v"], ' ', trim($keyword));

            // Prepare a temporary cookie path
            $cookiePath = sys_get_temp_dir() . DIRECTORY_SEPARATOR . self::generateRandomString();


        }

        public static function createRequests ($requestURLs = [], $options = [])
        {
            // Trim out the bad characters from request
            array_walk($requestURLs, function (&$requestURL, $key) {
                $requestURL = str_replace(["\r", "\n", "\t", "\v"], ' ', trim($requestURL));
                $requestURL = str_replace("++", '+', $requestURL);
            });

            // If no URL passed, return false
            if (empty($requestURLs)) {
                return FALSE;
            }

            // Multi cURL handle
            $mch = curl_multi_init();

            // Array containing single cURL instances
            $sch = [];

            // Store results here
            $outputData = [];

            // Add requests to Multi cURL handle
            foreach ($requestURLs as $id => $url) {

                $sch[$id] = curl_init();

                curl_setopt($sch[$id], CURLOPT_URL, $url);
                curl_setopt($sch[$id], CURLOPT_HEADER, 0);
                curl_setopt($sch[$id], CURLOPT_RETURNTRANSFER, 1);

                // extra options?
                if (!empty($options)) {
                    curl_setopt_array($sch[$id], $options);
                }

                curl_multi_add_handle($mch, $sch[$id]);
            }

            // Run all cURLs
            $running = NULL;
            do {
                curl_multi_exec($mch, $running);
            } while ($running > 0);

            // Retrieve result
            foreach ($sch as $id => $c) {
                $outputData[$id] = curl_multi_getcontent($c);
                curl_multi_remove_handle($mch, $c);
            }

            // All results captured
            curl_multi_close($mch);

            return $outputData;

        }

        // Replacing spaces with + since Google likes that
        private static function sanitize ($text)
        {
            return urlencode(str_replace(' ', '+', $text));
        }

        // Extract Metrics from Google
        private static function extractMetrics ($html = '')
        {
            if (empty($html)) {
                return $html;
            }
            $html          = str_get_html($html);
            $result_string = trim($html->find('div#resultStats', 0)->innertext);
            $result_string = preg_replace("/[^0-9]/", "", $result_string);
            return doubleval($result_string);
        }

        // Generate Random String
        private static function generateRandomString ($length = 10)
        {
            $characters       = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
            $charactersLength = strlen($characters);
            $randomString     = '';
            for ($i = 0; $i < $length; $i++) {
                $randomString .= $characters[rand(0, $charactersLength - 1)];
            }
            return $randomString;
        }


    }

}
