<?php

if ( ! class_exists( 'MXAG_Redirects' ) ) {

	class MXAG_Redirects extends MXAG_Model {

		public static function initialize() {
			add_action('admin_post_xag_get_redirects', array('MXAG_Redirects', 'getRedirects'));
			add_action('admin_post_xag_add_redirect', array('MXAG_Redirects', 'addRedirect'));
			add_action('admin_post_xag_edit_redirect', array('MXAG_Redirects', 'editRedirect'));
			add_action('admin_post_xag_delete_redirect', array('MXAG_Redirects', 'deleteRedirect'));
			add_action('admin_post_xag_delete_all_redirects', array('MXAG_Redirects', 'deleteAllRedirects'));
			add_action('admin_post_xag_query_string_redirect', array('MXAG_Redirects', 'queryStringRedirect'));
			add_action( 'template_redirect', array('MXAG_Redirects', 'doRedirect') );
		}


		public static function add($old, $new) {
			// Check if empty
			if (empty($old) || empty($new)) {
				return;
			}

			// Remove old data
			//self::removeData(array( 'new' => $new ));
			self::removeData(array( 'new' => $old ));

			$old = ltrim($old, '/');
			$old = rtrim($old, '/');

			$new = ltrim($new, '/');
			$new = rtrim($new, '/');

			$chkExistsUrl = self::checkExistsUrl($old);

			if (isset($chkExistsUrl['id']) && $chkExistsUrl['status'] === true) {

				self::updateData(
					array(
						'old' => $old,
						'new' => $new
					),
					array(
						'id' => $chkExistsUrl['id']
					)
				);

			} else {

				self::insertData(array(
					'old' => $old,
					'new' => $new,
					'date_created' => date('Y-m-d H:i:s')
				));

			}

		}

		public static function addRedirect() {
			$oldURL = $_POST['oldURL'];
			$newURL = $_POST['newURL'];

			self::add($oldURL, $newURL);
		}

		public static function editRedirect() {
			$id = $_POST['id'];
			$oldURL = $_POST['oldURL'];
			$newURL = $_POST['newURL'];

			self::updateData(
				array(
					'old' => $oldURL,
					'new' => $newURL
				),
				array(
					'id' => $id
				)
			);
		}

		public static function doRedirect() {

		    // This logic is in wp_seo.php so it will work only on auto generating redirects when post URL is changed
			// if (XAG_DISABLE_REDIRECTS === true) return;

			$redirects   = self::getAllData();
			$current_url = $_SERVER['REQUEST_URI'];

			foreach($redirects as $r) {
			    if (isset($r['qry_str_url'])) {
                    if($r['qry_str_url'] == 1) {
                        $request_uri = rtrim(strtok($current_url, '?'), '/');
                        $request_uri_ltrim = ltrim($request_uri, '/');
                        $r['old'] = strtok($r['old'], '?');

                    } else {
                        $request_uri = rtrim($current_url, '/');
                        $request_uri_ltrim = ltrim($request_uri, '/');
                    }
                }
				
				if ($request_uri === $r['old'] || $request_uri_ltrim === $r['old']) {

					// Check if external
					if (strpos($r['new'], 'http') !== false) {
						wp_redirect($r['new'], 301);
					} else {
						wp_redirect(site_url('/' . $r['new'] . '/'), 301);
					}
					die();
				}
			}
		}

		public static function deleteRedirect() {
			$ID = $_POST['id'];

			$RemoveIDs = explode(',' , $ID);

			foreach ($RemoveIDs as $i_d) {
				self::removeData(array('id'=>$i_d));
			}

		}

		public static function deleteAllRedirects() {
			self::truncate('prs_redirects');
		}



		public static function getRedirects() {
			
			global $wpdb;
			$result = $wpdb->get_row(sprintf("SELECT * FROM %s LIMIT 1",self::TABLE_NAME));

			//Add column if not present.
			if(!isset($result->qry_str_url)){
			    $wpdb->query(sprintf("ALTER TABLE %s ADD `qry_str_url` TINYINT NOT NULL DEFAULT '1' AFTER `new`",self::TABLE_NAME));
			}

			XAG_Init::json('success', 'Retrieved all redirects.', self::query("SELECT id, old, new, qry_str_url, DATE_FORMAT(date_created, '%b %D, %Y') as date_created FROM prs_redirects"));
		}
		
		public static function queryStringRedirect() {

			if(isset($_POST['id']) && isset($_POST['qsetting'])) {
				
				self::updateData(
					array(
						'qry_str_url' => $_POST['qsetting']
					),
					array(
						'id' => $_POST['id']
					),
					self::TABLE_NAME
				);	
			}
		}

		public static function checkExistsUrl($oldUrl) {
			if (isset($oldUrl)) {
				$redirects = self::getAllData();

				foreach($redirects as $r) {

					$id = $r['id'];
					$slug = $r['old'];
					$slug = ltrim($slug, '/');
					$slug = rtrim($slug, '/');

					if ($slug === $oldUrl) {
						return array('id' => $id, 'status' => true);
					}

				}
			}
			return array('id' => '', 'status' => false);
		}

		protected static $TABLE_NAME;
		public function __construct(){
			static::$TABLE_NAME = self::TABLE_NAME;
		}

		// MySQL
		const TABLE_NAME = 'prs_redirects';
		public static function createTable() {
			global $wpdb;
			require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

			$charset_collate = $wpdb->get_charset_collate();
			$creation_query =
				'CREATE TABLE ' . self::TABLE_NAME . ' (
			        `id` int(11) NOT NULL AUTO_INCREMENT,
			        `old` varchar(255),
			        `new` varchar(255),
			        `date_created` datetime,
			        PRIMARY KEY  (`id`)
			    ) ' .$charset_collate. ';';
			@dbDelta( $creation_query );
		}
		public static function removeTable() {
			global $wpdb;
			$query = 'DROP TABLE IF EXISTS ' . self::TABLE_NAME . ';';
			$wpdb->query( $query );
		}

	}

}
