<?php

if ( ! class_exists( 'MXAG_Rescue' ) ) {

	class MXAG_Rescue extends MXAG_Model {

		public static function initialize() {
			add_action('admin_post_xag_download_core', array('MXAG_Rescue', 'downloadCore'));
			add_action('admin_post_xag_files_core', array('MXAG_Rescue', 'previewCoreFiles'));
			add_action('admin_post_xag_start_core_rescue', array('MXAG_Rescue', 'startCoreRescue'));
			add_action('admin_post_xag_remove_old_core', array('MXAG_Rescue', 'removeOldCoreFiles'));

			add_action('admin_post_xag_scan_plugins_themes', array('MXAG_Rescue', 'scanPluginsThemes'));
			add_action('admin_post_xag_uninstall_plugin_theme', array('MXAG_Rescue', 'uninstallPluginTheme'));
			add_action('admin_post_xag_normal_rescue_plugin_theme', array('MXAG_Rescue', 'normalRescuePluginTheme'));
			add_action('admin_post_xag_upload_rescue_plugin_theme', array('MXAG_Rescue', 'uploadRescuePluginTheme'));

			add_action('admin_post_xag_scan_uploads', array('MXAG_Rescue', 'scanUploads'));
			add_action('admin_post_xag_remove_uploads', array('MXAG_Rescue', 'removeUploads'));
		}

		public static function removeUploads() {
			$uploads = WP_CONTENT_DIR . DIRECTORY_SEPARATOR . 'uploads' . DIRECTORY_SEPARATOR;
			$files   = $_POST['files'];
			foreach($files as $file) {
				if( strpos( $file, $uploads ) !== false ) {
					@unlink($file);
				}
			}
			XAG_Init::json('success', 'Successfully removed files.', $files);
		}

		public static function scanUploads() {

			// Give user some experience
			sleep(3);

			$allowed_extensions = array('xml', 'dtd', 'zip', 'rar', 'tar.gz', 'tar', '7z', 'jpg', 'jpeg', 'gif', 'png', 'avi', 'mp4', 'mpeg', 'mp3', 'wav', 'ogg');

			$uploads = WP_CONTENT_DIR . DIRECTORY_SEPARATOR . 'uploads' . DIRECTORY_SEPARATOR;
			$files   = MXAG_Rescue::getFiles($uploads);

			$suspicious_files = array();

			foreach($files as $file => $data) {
				$ext = pathinfo($file, PATHINFO_EXTENSION);

				if (!in_array($ext, $allowed_extensions)) {
					$suspicious_files[$file] = $data;
				}
			}

			XAG_Init::json('success', 'Successfully retrieved suspicious files.', $suspicious_files);
		}

		public static function uploadRescuePluginTheme() {

			$type     = $_POST['type'];
			$slug     = $_POST['slug'];

			$theme_plugin_dir = dirname($slug);
			if (empty($theme_plugin_dir) || $theme_plugin_dir === '.') {
				$theme_plugin_dir = $slug;
			}

			$unzip_directory = WP_CONTENT_DIR . DIRECTORY_SEPARATOR . $type . 's' . DIRECTORY_SEPARATOR;

			// Remove the old plugin
			MXAG_Rescue::deleteFolder($unzip_directory . $theme_plugin_dir);

			// Move and Unzip
			MXAG_Rescue::moveUploadUnzip($_FILES['file'], $unzip_directory);

			$result = file_exists($unzip_directory . $theme_plugin_dir);

			if ($result !== false) {
				XAG_Init::json('success', 'Rescue operation completed successfully.', $result);
			} else {
				XAG_Init::json('error', 'Failed to perform rescue operation. Please reinstall ' . $type . ' manually.');
			}

		}

		public static function normalRescuePluginTheme() {

			$type     = $_POST['type'];
			$slug     = $_POST['slug'];
			$download = $_POST['download'];

			$theme_plugin_dir = dirname($slug);
			if (empty($theme_plugin_dir) || $theme_plugin_dir === '.') {
				$theme_plugin_dir = $slug;
			}

			$unzip_directory = WP_CONTENT_DIR . DIRECTORY_SEPARATOR . $type . 's' . DIRECTORY_SEPARATOR;

			$result = MXAG_Rescue::downloadUnzip($download, $theme_plugin_dir, $unzip_directory);

			if ($result !== false) {
				XAG_Init::json('success', 'Rescue operation completed successfully.', $result);
			} else {
				XAG_Init::json('error', 'Failed to perform rescue operation. Please reinstall ' . $type . ' manually.');
			}

		}

		public static function uninstallPluginTheme() {

			$type = $_POST['type'];
			$slug = $_POST['slug'];

			if ($type === 'theme') {
				require_once( ABSPATH . 'wp-admin/includes/theme.php');
				require_once( ABSPATH . 'wp-admin/includes/file.php');
				delete_theme($slug);
			} else if ($type === 'plugin') {
				require_once( ABSPATH . 'wp-admin/includes/plugin.php');
				require_once( ABSPATH . 'wp-admin/includes/file.php');
				delete_plugins(array($slug));
			}

			XAG_Init::json('success', 'Operation completed.');
		}

		public static function scanPluginsThemes() {
			XAG_Init::json('success', 'Retrieved data.', MXAG_Rescue::getPluginsThemes());
		}

		public static function removeOldCoreFiles() {
			// Remove the WordPress core files
			MXAG_Rescue::deleteFolder(XAG_PATH . '/tmp/wordpress');
		}

		public static function regenerateWpConfig( $prefix = false, $location = false ) {
			global $table_prefix;

			if ($prefix != false) {
				$table_prefix = $prefix;
			}

			$t = "<?php\n";
			$t .= "\n";
			$t .= "/* Generated by Xagio V3 */\n";
			$t .= "\n";
			$t .= "/* MySQL settings */\n";
			$t .= "define( 'DB_NAME',     '".DB_NAME."' );\n";
			$t .= "define( 'DB_USER',     '".DB_USER."' );\n";
			$t .= "define( 'DB_PASSWORD', '".DB_PASSWORD."' );\n";
			$t .= "define( 'DB_HOST',     '".DB_HOST."' );\n";
			$t .= "define( 'DB_CHARSET',  '".DB_CHARSET."' );\n";
			$t .= "\n";
			$t .= "/* MySQL database table prefix. */\n";
			$t .= "\$table_prefix = '".$table_prefix."';\n";
			$t .= "\n";
			$t .= "/* Authentication Unique Keys and Salts. */\n";
			$t .= "/* https://api.wordpress.org/secret-key/1.1/salt/ */\n";
			$t .= "define( 'AUTH_KEY',         '".AUTH_KEY."' );\n";
			$t .= "define( 'SECURE_AUTH_KEY',  '".SECURE_AUTH_KEY."' );\n";
			$t .= "define( 'LOGGED_IN_KEY',    '".LOGGED_IN_KEY."' );\n";
			$t .= "define( 'NONCE_KEY',        '".NONCE_KEY."' );\n";
			$t .= "define( 'AUTH_SALT',        '".AUTH_SALT."' );\n";
			$t .= "define( 'SECURE_AUTH_SALT', '".SECURE_AUTH_SALT."' );\n";
			$t .= "define( 'LOGGED_IN_SALT',   '".LOGGED_IN_SALT."' );\n";
			$t .= "define( 'NONCE_SALT',       '".NONCE_SALT."' );\n";
			$t .= "\n";
			$t .= "/* Absolute path to the WordPress directory. */\n";
			$t .= "if ( !defined('ABSPATH') )\n";
			$t .= "	define('ABSPATH', dirname(__FILE__) . '/');\n";
			$t .= "\n";
			$t .= "/* Sets up WordPress vars and included files. */\n";
			$t .= "require_once(ABSPATH . 'wp-settings.php');\n";
			$t .= "?>";

			if ( $location == false ) {
				file_put_contents(ABSPATH . 'wp-config.php', $t);
			} else {
				file_put_contents($location . 'wp-config.php', $t);
			}

		}

		public static function startCoreRescue() {

			// Capture the files
			$files = json_decode(urldecode(stripslashes($_POST['files'])), true);

			if (!$files) {
				XAG_Init::json('Invalid file data received.', 'Your list of files could not be properly parsed. Please contact support.', $files);
				return;
			}

			// Process the file changes
			$files = MXAG_Rescue::processFiles($files['filesToDelete'], $files['filesToOverwrite'], $files['filesToAdd']);

			// Remove the WordPress core files
			MXAG_Rescue::deleteFolder(XAG_PATH . '/tmp/wordpress');

			// Regenerate the WP-CONFIG
			MXAG_Rescue::regenerateWpConfig();

			// Ouput
			XAG_Init::json('Successfully finished WordPress core rescue.', 'Rescue has been successfully performed for your selected WordPress core files. You can leave this page now.', $files);

		}

		public static function downloadCore() {

			// Get the version for download
			$version = $_POST['version'];

			// Download the WP core
			$coreDownload = MXAG_Rescue::downloadUnzip( 'https://wordpress.org/wordpress-' . $version . '.zip', 'wordpress');

			if (!$coreDownload) {

				XAG_Init::json('error', 'There was a problem while downloading WordPress core files. Please try again later.');
				return;

			} else {

				XAG_Init::json('success', 'WordPress core files successfully downloaded. You may now proceed to view the detected changes between local and remote core files.');
				return;

			}

		}

		public static function getCoreExcludes() {
			$excludes = MXAG_Rescue::getPluginsThemes(true);
			return array_merge($excludes, array(
				'uploads',
				'wp-config.php',
				'xagio-api.php',
				'wp-config-sample.php',
				'.htaccess'
			));
		}

		public static function previewCoreFiles() {

			$current_wp_files = MXAG_Rescue::getFiles(ABSPATH, '', MXAG_Rescue::getCoreExcludes());
			$new_wp_files     = MXAG_Rescue::getFiles(XAG_PATH . '/tmp/wordpress/', '', MXAG_Rescue::getCoreExcludes());

			$advanced = true;
			if (isset($_POST['type'])) {
				if ($_POST['type'] === 'easy') {
					$advanced = false;
				}
			}

			$compiled_list = MXAG_Rescue::compareFiles($current_wp_files, $new_wp_files, $advanced, ABSPATH);

			ksort($compiled_list);

			XAG_Init::json('success', 'Ready for rescue.', $compiled_list);
		}

		public static function getPluginsThemes($only_slugs = false) {
			// URL templates
			$themeUrl  = 'https://downloads.wordpress.org/theme/%s.zip';
			$pluginUrl = 'https://downloads.wordpress.org/plugin/%s.zip';

			// Collect all plugins & themes
			$allPluginsThemes = MXAG_Api::getPluginsThemes(true);

			// Output array
			$results = array(
				'plugins' => array(
					'found'    => array(),
					'missing'  => array()
				),
				'themes'  => array(
					'found'    => array(),
					'missing'  => array()
				)
			);

			if ($only_slugs === true) {
				$results = array();
			}

			// Loop through plugins
			foreach($allPluginsThemes['plugins'] as $slug => $data) {

				if ($only_slugs === true) {
					$plugin_dir = dirname($slug);
					if (!empty($plugin_dir) && $plugin_dir !== '.') {
						$results[] = $plugin_dir;
					} else {
						$results[] = $slug;
					}
					continue;
				}

				$plugin_dir = dirname($slug);
				if (empty($plugin_dir) || $plugin_dir === '.') {
					$plugin_dir = str_replace('.php', '', $slug);
				}

				$downloadUrl = sprintf($pluginUrl, $plugin_dir . '.' . $data['Version']);

				if (MXAG_Rescue::verifyURL($downloadUrl)) {

					$data['DownloadUrl'] = $downloadUrl;
					$results['plugins']['found'][$slug] = $data;

				} else {

					$results['plugins']['missing'][$slug] = $data;

				}

			}

			// Loop through themes
			foreach($allPluginsThemes['themes'] as $slug => $data) {

				if ($only_slugs === true) {
					$results[] = $slug;
					continue;
				}

				$downloadUrl = sprintf($themeUrl, $slug . '.' . $data['Version']);

				if (MXAG_Rescue::verifyURL($downloadUrl)) {

					$data['DownloadUrl'] = $downloadUrl;
					$results['themes']['found'][$slug] = $data;

				} else {

					$results['themes']['missing'][$slug] = $data;

				}

			}

			return $results;
		}


		public static function verifyURL($url) {

			$curl = curl_init();
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($curl, CURLOPT_USERAGENT, 'WordPress/4.8; http://localhost/');
			curl_setopt($curl, CURLOPT_NOBODY, true);
			curl_exec($curl);
			$info = curl_getinfo($curl);
			curl_close($curl);

			if ($info['http_code'] != 200) {
				return false;
			} else {
				return true;
			}
		}

		public static function getAvailableCoreVersions() {
			$releases_url = 'https://wordpress.org/download/release-archive/';
			$versions     = array();

			$data = wp_remote_get($releases_url);

			preg_match_all('/wordpress\-(4\.[4-9].*?)?\.[a-z]{3}.*?/', $data['body'], $matches, PREG_SET_ORDER, 0);

			foreach($matches as $match) {
				if (strpos($match[1], '-') !== false) {
					continue;
				}
				$versions[] = $match[1];
			}

			$versions = array_unique($versions);

			return $versions;
		}

		public static function downloadUnzip($remote_path, $local_path, $alternative_temp = false) {
			$tempDir = '';
			if ($alternative_temp !== false) {
				$tempDir = $alternative_temp;
			} else {
				$tempDir  = XAG_PATH . '/tmp/';
			}
			$tempFile = $tempDir . md5($remote_path) . '.zip';

			$isSuccessful = false;

			// Check if temp dir exists
			if (!file_exists($tempDir))
				mkdir($tempDir);

			// Check if file already exists
			if (file_exists($tempFile))
				unlink($tempFile);

			// Check if the extraction path exists
			if (file_exists($tempDir . $local_path))
				MXAG_Rescue::deleteFolder($tempDir . $local_path);


			// Download the zip file
			$fp = fopen ($tempFile, 'w+');
			$ch = curl_init($remote_path);

			curl_setopt($ch, CURLOPT_TIMEOUT, 60);
			curl_setopt($ch, CURLOPT_FILE, $fp);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

			curl_exec($ch);
			curl_close($ch);
			fclose($fp);

			// Unzip it
			if ( class_exists( 'ZipArchive' ) ) {
				$zip = new ZipArchive;
				$res = $zip->open( $tempFile );
				if ( $res === true ) {
					$zip->extractTo( $tempDir );
					$zip->close();
				}
			} else {
				if (!class_exists('PclZip')) {
					require_once ( XAG_PATH . '/ext/pclzip.lib.php' );
				}
				$archive = new PclZip( $tempFile );
				$archive->extract(PCLZIP_OPT_PATH, $tempDir);
			}

			// check if unzipped
			if (file_exists($tempDir . $local_path )) {
				$isSuccessful = true;
			}

			@unlink($tempFile);

			if (!$isSuccessful) {
				return false;
			} else {
				return $tempDir . $local_path;
			}

		}

		public static function moveUploadUnzip($file, $local_path) {

			$tempFile = $local_path . md5($file['name']) . '.zip';

			// Check if temp dir exists
			if (!file_exists($local_path))
				mkdir($local_path);

			// Check if file already exists
			if (file_exists($tempFile))
				unlink($tempFile);

			move_uploaded_file($file['tmp_name'], $tempFile);

			// Unzip it
			if ( class_exists( 'ZipArchive' ) ) {
				$zip = new ZipArchive;
				$res = $zip->open( $tempFile );
				if ( $res === true ) {
					$zip->extractTo( $local_path );
					$zip->close();
				}
			} else {
				if (!class_exists('PclZip')) {
					require_once ( XAG_PATH . '/ext/pclzip.lib.php' );
				}
				$archive = new PclZip( $tempFile );
				$archive->extract(PCLZIP_OPT_PATH, $local_path);
			}

			@unlink($tempFile);
		}

		public static function processFiles($filesToDelete = array(), $filesToOverwrite = array(), $filesToAdd = array()) {

			$filesAdded       = array();
			$filesOverwritten = array();
			$filesDeleted     = array();

			foreach($filesToAdd as $aFiles) {
				$newFile = $aFiles[0];
				$oldFile = $aFiles[1];

				$oldDir = dirname($oldFile);
				@mkdir($oldDir, 0777, true);

				copy($newFile, $oldFile);

				$filesAdded[] = $oldFile;
			}

			foreach($filesToOverwrite as $oFiles) {
				$newFile = $oFiles[0];
				$oldFile = $oFiles[1];

				copy($newFile, $oldFile);

				$filesOverwritten[] = $oldFile;
			}

			foreach($filesToDelete as $dFile) {
				unlink($dFile);

				$filesDeleted[] = $dFile;
			}

			return array(
				'filesAdded'       => $filesAdded,
				'filesOverwritten' => $filesOverwritten,
				'filesDeleted'     => $filesDeleted,
			);

		}

		public static function deleteFolder($dir) {
			$files = array_diff(scandir($dir), array('.','..'));
			foreach ($files as $file) {
				if (is_dir($dir . DIRECTORY_SEPARATOR . $file)) {
					MXAG_Rescue::deleteFolder($dir . DIRECTORY_SEPARATOR . $file);
				} else {
					unlink($dir . DIRECTORY_SEPARATOR . $file);
				}
			}
			return rmdir($dir);
		}

		public static function getFiles($root_path = '', $path = '', $exclusions = array()){
			$files = array();

			if (empty($root_path))
				$root_path = ABSPATH;

			$handle = opendir( $root_path . $path );

			if( ! $handle )
				return $files;

			// loop through dirs/files
			while ( false !== ( $file = readdir( $handle ) ) )
			{

				// Ignore . and ..
				if( "." == $file || ".." == $file || in_array($file, $exclusions)){
					continue;
				}

				$full_file_name     = ltrim($path . DIRECTORY_SEPARATOR . $file, DIRECTORY_SEPARATOR);
				$full_dir_file_name = $root_path . $full_file_name;

				// Directory? else file
				if( 'dir' === filetype( $full_dir_file_name ) )
				{

					// We are on a directory lets go one deeper
					$new_files = MXAG_Rescue::getFiles( $root_path, $full_file_name, $exclusions );
					$files     = array_merge( $files, $new_files );

				} else {

					$files[$full_file_name] = array(
						'md5'  => md5_file($full_dir_file_name),
						'path' => $full_dir_file_name
					);

				}
			}

			// Close connection
			closedir( $handle );

			return $files;

		}

		public static function compareFiles($old_files, $new_files, $multiDimensional = true, $rootPath = '') {

			$compiled_list = array();

			foreach($new_files as $file=>$new_data) {

				if (isset($old_files[$file])) {

					if ($old_files[$file]['md5'] !== $new_data['md5']) {
						$old_files[$file]['action'] = 'force-overwrite';
					} else {
						$old_files[$file]['action'] = 'overwrite';
					}

					$old_files[$file]['new_path'] = $new_data['path'];

				} else {


					$old_files[$file] = array(
						'action'   => 'add',
						'path'     => $rootPath . $file,
						'new_path' => $new_data['path'],
						'md5'      => $new_data['md5']
					);

				}

			}

			foreach($old_files as $file=>$old_data) {

				if ($multiDimensional) {

					$parts = explode(DIRECTORY_SEPARATOR, $file);

					$last_array = &$compiled_list;

					for($i = 0; $i < sizeof($parts); $i++) {

						$last_array =& $last_array[$parts[$i]];

					}

					unset($old_data['md5']);
					if (!isset($old_data['action'])) {
						$old_data['action'] = 'delete';
					}
					$last_array = $old_data;

				} else {

					unset($old_data['md5']);
					if (!isset($old_data['action'])) {
						$old_data['action'] = 'delete';
					} else if ($old_data['action'] === 'overwrite') {
						continue;
					}

					$compiled_list[$file] = $old_data;

				}

			}


			return $compiled_list;
		}

	}

}