<?php

if ( ! class_exists( 'MXAG_Settings' ) ) {

	class MXAG_Settings {

		public static function initialize() {
			add_action( 'admin_post_xag_activate_license', array( 'XAG_Licencator', 'activateLicense' ) );
			add_action( 'admin_post_xag_deactivate_license', array( 'XAG_Licencator', 'deactivateLicense' ) );

			add_action( 'admin_post_xag_show_tutorial', array( 'MXAG_Settings', 'showTutorial' ) );

			add_action( 'admin_post_xag_settings', array( 'MXAG_Settings', 'saveSettings' ) );

			add_action( 'admin_post_xag_settings_update_shared_scripts', array( 'MXAG_Settings', 'updateSharedScripts' ) );
			add_action( 'admin_post_xag_settings_update_api_keys', array( 'MXAG_Settings', 'updateAPIKeys' ) );
			add_action( 'admin_post_xag_settings_update_backup_settings', array( 'MXAG_Settings', 'updateBackupSettings' ) );
			add_action( 'admin_post_xag_settings_download_clickbank_data', array( 'MXAG_Settings', 'downloadClickbankData' ) );
			add_action( 'admin_post_xag_settings_create_backup', array( 'MXAG_Settings', 'createBackup' ) );

			add_action( 'admin_post_xag_export_options', array( 'MXAG_Settings', 'exportOptions' ) );
			add_action( 'admin_post_xag_import_options', array( 'MXAG_Settings', 'importOptions' ) );

            add_action( 'admin_post_xag_settings_update_server_api', array( 'MXAG_Settings', 'updateServerAPI' ) );
            add_action( 'admin_post_xag_settings_update_max_upload_size', array( 'MXAG_Settings', 'maxUploadSize' ) );
            add_action( 'admin_post_xag_settings_update_post_max_size', array( 'MXAG_Settings', 'maxPostSize' ) );
            add_action( 'admin_post_xag_settings_update_max_execution_time', array( 'MXAG_Settings', 'maxExecutionTime' ) );
            add_action( 'admin_post_xag_settings_update_max_input_vars', array( 'MXAG_Settings', 'maxInputVars' ) );
            add_action( 'admin_post_xag_settings_update_max_memory_limit', array( 'MXAG_Settings', 'maxMemoryLimit' ) );

            if (!is_admin()) {
                $htAccFile = self::chkHtAccExists();
                if ($htAccFile === false) { self::createHtAccFile(); }
            }
		}

		public static function chkHtAccExists() {
            $htAccPath = ABSPATH.'.htaccess';
            if ( !file_exists($htAccPath) ) {
                return false;
            } else {
				if ( 0 == filesize( $htAccPath ) ) {
					return false;
				}
				return true;
			}
        }

        public static function createHtAccFile() {
            $htAccPath = ABSPATH.'.htaccess';
			$homeRoot = parse_url( home_url() );

			if ( isset( $homeRoot['path'] ) ) {
				$homeRoot = trailingslashit( $homeRoot['path'] );
			} else {
				$homeRoot = '/';
			}

			$file = fopen("$htAccPath", "w");

			$rules  = "# BEGIN WordPress\n";
			$rules .= "<IfModule mod_rewrite.c>\n";
			$rules .= "RewriteEngine On\n";
			$rules .= "RewriteBase $homeRoot\n";

			/* Prevent -f checks on index.php. */
			$rules .= "RewriteRule ^index\.php$ - [L]\n";

			$rules .= "RewriteCond %{REQUEST_FILENAME} !-f\n";
			$rules .= "RewriteCond %{REQUEST_FILENAME} !-d\n";
			$rules .= "RewriteRule . $homeRoot"."index.php [L,QSA]\n";
			$rules .= "</IfModule>\n";
			$rules .= "# END WordPress\n";

			fwrite($file, $rules);
			fclose($file);
        }

		public static function chkIniExists() {
		    $iniPath = ABSPATH.'php.ini';
		    if ( !file_exists($iniPath) ) {
		        return false;
		    } else {
				if ( 0 == filesize( $iniPath ) ) {
					return false;
				}
				return true;
			}
		}

		public static function createIniFile() {
		    $iniPath = ABSPATH.'php.ini';
			$homeRoot = parse_url( home_url() );

			if ( isset( $homeRoot['path'] ) ) {
				$homeRoot = trailingslashit( $homeRoot['path'] );
			} else {
				$homeRoot = '/';
			}

			$file = fopen("$iniPath", "w");
			$rules  = "\n";
			fwrite($file, $rules);
			fclose($file);
		}

		public function maxUploadSize() {

			$ht_access_file = get_home_path() . '.htaccess';
			@$php_ini_file   = get_home_path() . 'php.ini';
			$sapi_type = php_sapi_name();

			if (strpos($sapi_type,'cgi')!== false) {
			    if (!file_exists($php_ini_file)) {
					$php_ini_file = self::createIniFile();
					$php_ini_file   = get_home_path() . 'php.ini';
				}
			} else {
				if (!file_exists($ht_access_file)) {
					$htAccFile = self::createHtAccFile();
				}
			}

			if (strpos($sapi_type,'cgi')!== false) {
			    if (file_exists($php_ini_file)) {
					
					if ( ! is_writable( $php_ini_file ) ) {
						XAG_Init::json( 'ERROR', "If your php.ini were writable, you can use this." );
					}

					$old = ini_get( 'upload_max_filesize = ' );
		            $new = $_POST['uploadSize'];
		            $text  = "upload_max_filesize = ".$old;
		            $text2 = "upload_max_filesize = ".$new;
		            $file  = file($php_ini_file);

		            foreach($file as $line) {
		                if (strpos($line, $text) !== false) {
		                    $contents = file_get_contents($php_ini_file);
		                    $contents = str_replace($line,$text2."\r\n", $contents);
		                    $res = file_put_contents($php_ini_file, $contents);
		                    XAG_Init::json( 'success', "Successfully updated Max Upload Size." );
		                } 
		            }
		            if (empty($res)) {
		            	$fc = fopen($php_ini_file, "r");
						while (!feof($fc)) {
						    $buffer = fgets($fc, 4096);
						    $lines[] = $buffer;
						}
						fclose($fc);

		            	$f = fopen($php_ini_file, "w");
		            	$lineCount = count($lines);
						//loop through array writing the lines until the secondlast
						for ($i = 0; $i < $lineCount- 1; $i++) {
						    fwrite($f, $lines[$i]);
						}
		            	fwrite($f, $text2.PHP_EOL);
		            	fwrite($f, $lines[$lineCount-1]);
		            	fclose($f);
		            	XAG_Init::json( 'success', "Successfully updated Max Upload Size." );
		            }
				} else {
					XAG_Init::json( 'error', "You need to create php.ini file." );
				}
			} else {
				if (file_exists($ht_access_file)) {
					
					if ( ! is_writable( $ht_access_file ) ) {
						XAG_Init::json( 'ERROR', "If your .htaccess were writable, you can use this." );
					}

					$old = ini_get( 'upload_max_filesize' );
		            $new = $_POST['uploadSize'];
		            $text  = "php_value upload_max_filesize ".$old;
		            $text2 = "php_value upload_max_filesize ".$new;
		            $file  = file($ht_access_file);

		            foreach($file as $line) {
		                if (strpos($line, $text) !== false) {
		                    $contents = file_get_contents($ht_access_file);
		                    $contents = str_replace($line,$text2."\r\n", $contents);
		                    $res = file_put_contents($ht_access_file, $contents);
		                    XAG_Init::json( 'success', "Successfully updated Max Upload Size." );
		                } 
		            }
		            if (empty($res)) {
		            	$fc = fopen($ht_access_file, "r");
						while (!feof($fc)) {
						    $buffer = fgets($fc, 4096);
						    $lines[] = $buffer;
						}
						fclose($fc);

						$comment = "# Max Upload Size";
		            	$f = fopen($ht_access_file, "w");
		            	$lineCount = count($lines);
						//loop through array writing the lines until the secondlast
						for ($i = 0; $i < $lineCount- 1; $i++) {
						    fwrite($f, $lines[$i]);
						}
		            	fwrite($f, $comment.PHP_EOL);
		            	fwrite($f, $text2.PHP_EOL);
		            	fwrite($f, $lines[$lineCount-1]);
		            	fclose($f);
		            	XAG_Init::json( 'success', "Successfully updated Max Upload Size." );
		            }
				} else {
					XAG_Init::json( 'error', "You need to create .htaccess file." );
				}
			}			
		}

		public function maxPostSize(){

			$ht_access_file = get_home_path() . '.htaccess';
			@$php_ini_file   = get_home_path() . 'php.ini';
			$sapi_type = php_sapi_name();

			if (strpos($sapi_type,'cgi')!== false) {
			    if (!file_exists($php_ini_file)) {
					$php_ini_file = self::createIniFile();
					$php_ini_file   = get_home_path() . 'php.ini';
				}
			} else {
				if (!file_exists($ht_access_file)) {
					$htAccFile = self::createHtAccFile();
				}
			}

			if (strpos($sapi_type,'cgi')!== false) {
			    if (file_exists($php_ini_file)) {
					
					if ( ! is_writable( $php_ini_file ) ) {
						XAG_Init::json( 'ERROR', "If your php.ini were writable, you can use this." );
					}

					$old = ini_get( 'post_max_size = ' );
		            $new = $_POST['postSize'];
		            $text  = "post_max_size = ".$old;
		            $text2 = "post_max_size = ".$new;
		            $file  = file($php_ini_file);

		            foreach($file as $line) {
		                if (strpos($line, $text) !== false) {
		                    $contents = file_get_contents($php_ini_file);
		                    $contents = str_replace($line,$text2."\r\n", $contents);
		                    $res = file_put_contents($php_ini_file, $contents);
		                    XAG_Init::json( 'success', "Successfully updated Post Max Size." );
		                } 
		            }
		            if (empty($res)) {
		            	$fc = fopen($php_ini_file, "r");
						while (!feof($fc)) {
						    $buffer = fgets($fc, 4096);
						    $lines[] = $buffer;
						}
						fclose($fc);

		            	$f = fopen($php_ini_file, "w");
		            	$lineCount = count($lines);
						//loop through array writing the lines until the secondlast
						for ($i = 0; $i < $lineCount- 1; $i++) {
						    fwrite($f, $lines[$i]);
						}
		            	fwrite($f, $text2.PHP_EOL);
		            	fwrite($f, $lines[$lineCount-1]);
		            	fclose($f);
		            	XAG_Init::json( 'success', "Successfully updated Post Max Size." );
		            }
				} else {
					XAG_Init::json( 'error', "You need to create php.ini file." );
				}
			} else {
				if (file_exists($ht_access_file)) {
					
					if ( ! is_writable( $ht_access_file ) ) {
						XAG_Init::json( 'ERROR', "If your .htaccess were writable, you can use this." );
					}

					$old = ini_get( 'post_max_size' );
		            $new = $_POST['postSize'];
		            $text  = "php_value post_max_size ".$old;
		            $text2 = "php_value post_max_size ".$new;
		            $file  = file($ht_access_file);

		            foreach($file as $line) {
		                if (strpos($line, $text) !== false) {
		                    $contents = file_get_contents($ht_access_file);
		                    $contents = str_replace($line,$text2."\r\n", $contents);
		                    $res = file_put_contents($ht_access_file, $contents);
		                    XAG_Init::json( 'success', "Successfully updated Post Max Size." );
		                } 
		            }
		            if (empty($res)) {
		            	$fc = fopen($ht_access_file, "r");
						while (!feof($fc)) {
						    $buffer = fgets($fc, 4096);
						    $lines[] = $buffer;
						}
						fclose($fc);

						$comment = "# Max Post Size";
		            	$f = fopen($ht_access_file, "w");
		            	$lineCount = count($lines);
						//loop through array writing the lines until the secondlast
						for ($i = 0; $i < $lineCount- 1; $i++) {
						    fwrite($f, $lines[$i]);
						}
						fwrite($f, $comment.PHP_EOL);
		            	fwrite($f, $text2.PHP_EOL);
		            	fwrite($f, $lines[$lineCount-1]);
		            	fclose($f);
		            	XAG_Init::json( 'success', "Successfully updated Post Max Size." );
		            }
				} else {
					XAG_Init::json( 'error', "You need to create .htaccess file." );
				}
			}
		}

		public function maxExecutionTime(){
			$ht_access_file = get_home_path() . '.htaccess';
			@$php_ini_file   = get_home_path() . 'php.ini';
			$sapi_type = php_sapi_name();

			if (strpos($sapi_type,'cgi')!== false) {
			    if (!file_exists($php_ini_file)) {
					$php_ini_file = self::createIniFile();
					$php_ini_file   = get_home_path() . 'php.ini';
				}
			} else {
				if (!file_exists($ht_access_file)) {
					$htAccFile = self::createHtAccFile();
				}
			}

			if (strpos($sapi_type,'cgi')!== false) {
			    if (file_exists($php_ini_file)) {
					
					if ( ! is_writable( $php_ini_file ) ) {
						XAG_Init::json( 'ERROR', "If your php.ini were writable, you can use this." );
					}

					$old = ini_get( 'max_execution_time = ' );
		            $new = $_POST['executionTime'];
		            $text  = "max_execution_time = ".$old;
		            $text2 = "max_execution_time = ".$new;
		            $file  = file($php_ini_file);

		            foreach($file as $line) {
		                if (strpos($line, $text) !== false) {
		                    $contents = file_get_contents($php_ini_file);
		                    $contents = str_replace($line,$text2."\r\n", $contents);
		                    $res = file_put_contents($php_ini_file, $contents);
		                    XAG_Init::json( 'success', "Successfully updated Max Execution Time." );
		                } 
		            }
		            if (empty($res)) {
		            	$fc = fopen($php_ini_file, "r");
						while (!feof($fc)) {
						    $buffer = fgets($fc, 4096);
						    $lines[] = $buffer;
						}
						fclose($fc);

		            	$f = fopen($php_ini_file, "w");
		            	$lineCount = count($lines);
						//loop through array writing the lines until the secondlast
						for ($i = 0; $i < $lineCount- 1; $i++) {
						    fwrite($f, $lines[$i]);
						}
		            	fwrite($f, $text2.PHP_EOL);
		            	fwrite($f, $lines[$lineCount-1]);
		            	fclose($f);
		            	XAG_Init::json( 'success', "Successfully updated Max Execution Time." );
		            }
				} else {
					XAG_Init::json( 'error', "You need to create php.ini file." );
				}
			} else {
				if (file_exists($ht_access_file)) {

					if ( ! is_writable( $ht_access_file ) ) {
						XAG_Init::json( 'ERROR', "If your .htaccess were writable, you can use this." );
					}

					$old = ini_get( 'max_execution_time' );
		            $new = $_POST['executionTime'];
		            $text  = "php_value max_execution_time ".$old;
		            $text2 = "php_value max_execution_time ".$new;
		            $file  = file($ht_access_file);

		            foreach($file as $line) {
		                if (strpos($line, $text) !== false) {
		                    $contents = file_get_contents($ht_access_file);
		                    $contents = str_replace($line,$text2."\r\n", $contents);
		                    $res = file_put_contents($ht_access_file, $contents);
		                    XAG_Init::json( 'success', "Successfully updated Max Execution Time." );
		                } 
		            }
		            if (empty($res)) {
		            	$fc = fopen($ht_access_file, "r");
						while (!feof($fc)) {
						    $buffer = fgets($fc, 4096);
						    $lines[] = $buffer;
						}
						fclose($fc);

						$comment = "# Max Execution Time";
		            	$f = fopen($ht_access_file, "w");
		            	$lineCount = count($lines);
						//loop through array writing the lines until the secondlast
						for ($i = 0; $i < $lineCount- 1; $i++) {
						    fwrite($f, $lines[$i]);
						}
						fwrite($f, $comment.PHP_EOL);
		            	fwrite($f, $text2.PHP_EOL);
		            	fwrite($f, $lines[$lineCount-1]);
		            	fclose($f);
		            	XAG_Init::json( 'success', "Successfully updated Max Execution Time." );
		            }
				} else {
					XAG_Init::json( 'error', "You need to create .htaccess file." );
				}
			}			
		}

		public function maxInputVars(){
			$ht_access_file = get_home_path() . '.htaccess';
			@$php_ini_file   = get_home_path() . 'php.ini';
			$sapi_type = php_sapi_name();

			if (strpos($sapi_type,'cgi')!== false) {
			    if (!file_exists($php_ini_file)) {
					$php_ini_file = self::createIniFile();
					$php_ini_file   = get_home_path() . 'php.ini';
				}
			} else {
				if (!file_exists($ht_access_file)) {
					$htAccFile = self::createHtAccFile();
				}
			}

			if (strpos($sapi_type,'cgi')!== false) {
			    if (file_exists($php_ini_file)) {
					
					if ( ! is_writable( $php_ini_file ) ) {
						XAG_Init::json( 'ERROR', "If your php.ini were writable, you can use this." );
					}

					$old = ini_get( 'max_input_vars = ' );
		            $new = $_POST['inputVars'];
		            $text  = "max_input_vars = ".$old;
		            $text2 = "max_input_vars = ".$new;
		            $file  = file($php_ini_file);

		            foreach($file as $line) {
		                if (strpos($line, $text) !== false) {
		                    $contents = file_get_contents($php_ini_file);
		                    $contents = str_replace($line,$text2."\r\n", $contents);
		                    $res = file_put_contents($php_ini_file, $contents);
		                    XAG_Init::json( 'success', "Successfully updated Max Input Vars." );
		                } 
		            }
		            if (empty($res)) {
		            	$fc = fopen($php_ini_file, "r");
						while (!feof($fc)) {
						    $buffer = fgets($fc, 4096);
						    $lines[] = $buffer;
						}
						fclose($fc);

		            	$f = fopen($php_ini_file, "w");
		            	$lineCount = count($lines);
						//loop through array writing the lines until the secondlast
						for ($i = 0; $i < $lineCount- 1; $i++) {
						    fwrite($f, $lines[$i]);
						}
		            	fwrite($f, $text2.PHP_EOL);
		            	fwrite($f, $lines[$lineCount-1]);
		            	fclose($f);
		            	XAG_Init::json( 'success', "Successfully updated Max Input Vars." );
		            }
				} else {
					XAG_Init::json( 'error', "You need to create php.ini file." );
				}
			} else {
				if (file_exists($ht_access_file)) {

					if ( ! is_writeable( $ht_access_file ) ) {
						XAG_Init::json( 'ERROR', "If your .htaccess were writable, you can use this." );
					}

					$old = ini_get( 'max_input_vars' );
		            $new = $_POST['inputVars'];
		            $text  = "php_value max_input_vars ".$old;
		            $text2 = "php_value max_input_vars ".$new;
		            $file  = file($ht_access_file);

		            foreach($file as $line) {
		                if (strpos($line, $text) !== false) {
		                    $contents = file_get_contents($ht_access_file);
		                    $contents = str_replace($line,$text2."\r\n", $contents);
		                    $res = file_put_contents($ht_access_file, $contents);
		                    XAG_Init::json( 'success', "Successfully updated Max Input Vars." );
		                } 
		            }
		            if (empty($res)) {
		            	$fc = fopen($ht_access_file, "r");
						while (!feof($fc)) {
						    $buffer = fgets($fc, 4096);
						    $lines[] = $buffer;
						}
						fclose($fc);

						$comment = "# Max Input Vars";
		            	$f = fopen($ht_access_file, "w");
		            	$lineCount = count($lines);
						//loop through array writing the lines until the secondlast
						for ($i = 0; $i < $lineCount- 1; $i++) {
						    fwrite($f, $lines[$i]);
						}
						fwrite($f, $comment.PHP_EOL);
		            	fwrite($f, $text2.PHP_EOL);
		            	fwrite($f, $lines[$lineCount-1]);
		            	fclose($f);
		            	XAG_Init::json( 'success', "Successfully updated Max Input Vars." );
		            }
				} else {
					XAG_Init::json( 'error', "You need to create .htaccess file." );
				}
			}			
		}

		public function maxMemoryLimit(){

			$ht_access_file = get_home_path() . '.htaccess';
			@$php_ini_file   = get_home_path() . 'php.ini';
			$sapi_type = php_sapi_name();

			if (strpos($sapi_type,'cgi')!== false) {
			    if (!file_exists($php_ini_file)) {
					$php_ini_file = self::createIniFile();
					$php_ini_file   = get_home_path() . 'php.ini';
				}
			} else {
				if (!file_exists($ht_access_file)) {
					$htAccFile = self::createHtAccFile();
				}
			}

			if (strpos($sapi_type,'cgi')!== false) {
			    if (file_exists($php_ini_file)) {
					
					if ( ! is_writable( $php_ini_file ) ) {
						XAG_Init::json( 'ERROR', "If your php.ini were writable, you can use this." );
					}

					$old = ini_get( 'memory_limit = ' );
		            $new = $_POST['memoryLimit'];
		            $text  = "memory_limit = ".$old;
		            $text2 = "memory_limit = ".$new;
		            $file  = file($php_ini_file);

		            foreach($file as $line) {
		                if (strpos($line, $text) !== false) {
		                    $contents = file_get_contents($php_ini_file);
		                    $contents = str_replace($line,$text2."\r\n", $contents);
		                    $res = file_put_contents($php_ini_file, $contents);
		                    XAG_Init::json( 'success', "Successfully updated Max Memory Limit." );
		                } 
		            }
		            if (empty($res)) {
		            	$fc = fopen($php_ini_file, "r");
						while (!feof($fc)) {
						    $buffer = fgets($fc, 4096);
						    $lines[] = $buffer;
						}
						fclose($fc);

		            	$f = fopen($php_ini_file, "w");
		            	$lineCount = count($lines);
						//loop through array writing the lines until the secondlast
						for ($i = 0; $i < $lineCount- 1; $i++) {
						    fwrite($f, $lines[$i]);
						}
		            	fwrite($f, $text2.PHP_EOL);
		            	fwrite($f, $lines[$lineCount-1]);
		            	fclose($f);
		            	XAG_Init::json( 'success', "Successfully updated Max Memory Limit." );
		            }
				} else {
					XAG_Init::json( 'error', "You need to create php.ini file." );
				}
			} else {
				if (file_exists($ht_access_file)) {
				
					if ( ! is_writable( $ht_access_file ) ) {
						XAG_Init::json( 'ERROR', "If your .htaccess were writable, you can use this." );
					}

					$old = ini_get( 'memory_limit' );
		            $new = $_POST['memoryLimit'];
		            $text  = "php_value memory_limit ".$old;
		            $text2 = "php_value memory_limit ".$new;
		            $file  = file($ht_access_file);

		            foreach($file as $line) {
		                if (strpos($line, $text) !== false) {
		                    $contents = file_get_contents($ht_access_file);
		                    $contents = str_replace($line,$text2."\r\n", $contents);
		                    $res = file_put_contents($ht_access_file, $contents);
		                    XAG_Init::json( 'success', "Successfully updated Max Memory Limit." );
		                } 
		            }
		            if (empty($res)) {
		            	$fc = fopen($ht_access_file, "r");
						while (!feof($fc)) {
						    $buffer = fgets($fc, 4096);
						    $lines[] = $buffer;
						}
						fclose($fc);

						$comment = "# Max Memory Limit";
		            	$f = fopen($ht_access_file, "w");
		            	$lineCount = count($lines);
						//loop through array writing the lines until the secondlast
						for ($i = 0; $i < $lineCount- 1; $i++) {
						    fwrite($f, $lines[$i]);
						}
						fwrite($f, $comment.PHP_EOL);
		            	fwrite($f, $text2.PHP_EOL);
		            	fwrite($f, $lines[$lineCount-1]);
		            	fclose($f);
		            	XAG_Init::json( 'success', "Successfully updated Max Memory Limit." );
		            }
				} else {
					XAG_Init::json( 'error', "You need to create .htaccess file." );
				}
			}
		}

		public static function showTutorial() {

			if ( isset( $_POST['page'] ) && ! empty( $_POST['page'] ) ) {

				$page = $_POST['page'];

				$video_codes = MXAG_Api::apiRequest(
					'get_tutorial',
					'POST',
					array(
						'page' => $page
					)
				);
				XAG_Init::json( 'success', 'Success.', $video_codes );
			} else {
				XAG_Init::json( 'error', 'Not allowed.' );
			}

		}

		public static function saveSettings() {

			$status_messages = array();

            /**
             * Enabled/Disabled DEV mode
             */
            if ( isset( $_POST['xag_dev_mode'] ) ) {
                if ( $_POST['xag_dev_mode'] == 1 ) {
                    update_option( 'prs_dev_mode', true );
                    $status_messages[] = 'DEV Mode disabled.';
                } else {
                    update_option( 'prs_dev_mode', false );
                    $status_messages[] = 'DEV Mode enabled.';
                }
            }

			/**
			 * Enabled/Disabled default OG settings for all page/post
			 */
			if ( isset( $_POST['xag_default_og_status'] ) ) {
				if ( $_POST['xag_default_og_status'] == 1 ) {
					update_option( 'prs_default_og_status', true );
					$status_messages[] = 'Default OG settings disabled.';
				} else {
					update_option( 'prs_default_og_status', false );
					$status_messages[] = 'Default OG settings enabled.';
				}
			}

			/**
			 * Enabled/Disabled WordPress Canonical URLs
			 */
			if ( isset( $_POST['xag_disable_canonicals'] ) ) {
				if ( $_POST['xag_disable_canonicals'] == 1 ) {
					update_option( 'prs_disable_canonicals', true );
					$status_messages[] = 'WordPress Canonical URLs are now disabled.';
				} else {
					update_option( 'prs_disable_canonicals', false );
					$status_messages[] = 'WordPress Canonical URLs are now enabled.';
				}
			}

			/**
			 * Enabled/Disabled CSS,JS for review widget
			 */
			if ( isset( $_POST['xag_review_widget_status'] ) ) {
				if ( $_POST['xag_review_widget_status'] == 1 ) {
					update_option( 'prs_review_widget_status', true );
					$status_messages[] = 'Review Widget css,js disabled.';
				} else {
					update_option( 'prs_review_widget_status', false );
					$status_messages[] = 'Review Widget css,js enabled.';
				}
			}

			/**
			 *  Disable FailSafe Recovery
			 */
			if ( isset ( $_POST['xag_disable_failsafe'] ) ) {
				if ( $_POST['xag_disable_failsafe'] == 1 ) {
					XAG_Init::uninstallFailSafe();
					update_option( 'ps_disable_failsafe', true );
					$status_messages[] = 'FailSafe disabled.';
				} else {
					XAG_Init::installFailSafe();
					update_option( 'ps_disable_failsafe', false );
					$status_messages[] = 'FailSafe enabled.';
				}
			}

			/**
			 *  Disable 301 Redirects
			 */
			if ( isset( $_POST['xag_disable_redirects'] ) ) {
				if ( $_POST['xag_disable_redirects'] == 1 ) {
					update_option( 'ps_disable_redirects', true );
					$status_messages[] = 'Redirects disabled.';
				} else {
					update_option( 'ps_disable_redirects', false );
					$status_messages[] = 'Redirects enabled.';
				}
			}


			/**
			 *  Remove HTML comments footprint
			 */
			if ( isset( $_POST['xag_remove_footprint'] ) ) {
				if ( $_POST['xag_remove_footprint'] == 1 ) {
					update_option( 'ps_remove_footprint', true );
					$status_messages[] = 'Footprint disabled.';
				} else {
					update_option( 'ps_remove_footprint', false );
					$status_messages[] = 'Footprint enabled.';
				}
			}

			/**
			 *  Force Homepage schema globally
			 */
			if ( isset( $_POST['xag_force_schema'] ) ) {

				if ( $_POST['xag_force_schema'] == 1 ) {
					update_option( 'ps_schema_always_on', true );

					$r = MXAG_Api::apiRequest(
						$endpoint = 'toggleForceSchema',
						$method   = 'GET',
						array(
							'domain'    => preg_replace('/^www\./','',$_SERVER['SERVER_NAME']),
							'force_schema' => 1
						)
					);

					$status_messages[] = 'Set schemas to apply globally.';
				} else {
					update_option( 'ps_schema_always_on', false );

					$r = MXAG_Api::apiRequest(
						$endpoint = 'toggleForceSchema',
						$method   = 'GET',
						array(
							'domain'    => preg_replace('/^www\./','',$_SERVER['SERVER_NAME']),
							'force_schema' => 0
						)
					);
					$status_messages[] = 'Disabled schemas to apply globally.';
				}
			}

			/**
			 *  Force Homepage schema globally
			 */
			if ( isset( $_POST['xag_pretty_schema'] ) ) {
				if ( $_POST['xag_pretty_schema'] == 1 ) {
					update_option( 'ps_pretty_schemas', true );
					$status_messages[] = 'Schemas are now pretty.';
				} else {
					update_option( 'ps_pretty_schemas', false );
					$status_messages[] = 'Schemas are ugly again.';
				}
			}

			/**
			 *  Set usage of reCAPTCHA
			 */
			if ( isset( $_POST['xag_recaptcha_enabled'] ) ) {
				if ( $_POST['xag_recaptcha_enabled'] == 1 ) {
					update_option( 'ps_recaptcha_enabled', true );
					$status_messages[] = 'reCAPTCHA enabled.';
				} else {
					update_option( 'ps_recaptcha_enabled', false );
					$status_messages[] = 'reCAPTCHA disabled.';
				}
			}

			XAG_Init::json( 'success', "Operation completed! \n" . join( "\n", $status_messages ) );

		}

		public static function updateSharedScripts() {
			MXAG_Sync::getSharedScripts();
			XAG_Init::json( 'success', "Successfully updated Shared Scripts on this website!" );
		}

		public static function updateAPIKeys() {
			MXAG_Sync::getAPIKeys();
			XAG_Init::json( 'success', "Successfully updated API keys on this website!" );
		}

		public static function updateServerAPI() {
            do_action('xag_LicenseCheck');
        }

		public static function updateBackupSettings() {
			MXAG_Sync::getBackupSettings();
			XAG_Init::json( 'success', "Successfully updated Backup settings on this website!" );
		}

		public static function downloadClickbankData() {
			MXAG_Affiliate::downloadClickbankData();
			XAG_Init::json( 'success', "Successfully download the latest Clickbank data to this website!" );
		}

		public static function createBackup() {
			XAG_Init::jsonc(MXAG_Backups::doBackup());
		}

		public static function exportOptions() {

			header("Content-type: text/plain");
			header("Content-Disposition: attachment; filename=test.txt");
			global $wpdb;

			$all_wp_options = array(
				'ps_seo_title_separator',
				'ps_seo_target_keyword',
				'ps_seo_force_noodp',
				'ps_seo_index_subpages',
				'ps_seo_always_on',
				'ps_seo_title',
				'ps_seo_description',
				'ps_seo_post_types',
				'ps_seo_default_post_og',
				'ps_seo_custom_post_types',
				'ps_seo_taxonomies',
				'ps_seo_miscellaneous',
				'ps_seo_title_fb',
				'ps_seo_description_fb',
				'ps_seo_image_fb',
				'ps_seo_title_tw',
				'ps_seo_description_tw',
				'ps_seo_image_tw',
				'ps_seo_verify_bing',
				'ps_seo_verify_google',
				'ps_seo_verify_pinterest',
				'ps_seo_verify_yandex',
				'ps_schema_always_on',
				'ps_recaptcha_enabled',
				'ps_remove_footprint',
				'prs_ts_memory_limit',
				'prs_ts_alternative_api'
			);

			$return = array();
			foreach ( $all_wp_options as $wp_option ) {
				if (!get_option($wp_option))
					continue;
				$return['options'][$wp_option] = get_option($wp_option);
			}

			$all_post_meta = array(
				'ps_seo_enabled',
				'ps_seo_title',
				'ps_seo_url',
				'ps_seo_description',
				'ps_seo_keyword',
				'ps_seo_metarobots_enabled',
				'ps_seo_metarobots_index',
				'ps_seo_metarobots_follow',
				'ps_seo_metarobots_advanced',
				'ps_seo_canonical',
				'ps_seo_tw_title',
				'ps_seo_tw_desc',
				'ps_seo_tw_img',
				'ps_seo_fb_title',
				'ps_seo_fb_desc',
				'ps_seo_fb_img',
				'ps_seo_notes',
			);

			$temp = array();

			foreach ( $all_post_meta as $meta ) {
				$results = $wpdb->get_results("SELECT post_id, meta_key, meta_value FROM wp_postmeta WHERE meta_key = '{$meta}'", ARRAY_A);
				$temp[] = $results;
			}
			$by_id = array();
			foreach ( $temp as $t ) {
				if ( is_array($t) ) {
					foreach ( $t as $s ) {
						if ( isset($s['post_id']) ) {
							$post_id = $s['post_id'];
							unset($s['post_id']);
							$by_id[$post_id][] = $s;
						}
					}
				}
			}

			$return['postmeta'] = $by_id;

			header('Content-disposition: attachment; filename=PSv3_Export_Settings_' . date('Y-m-d_H:i:s') . '.psexp');
			header('Content-type: application/json');
			echo json_encode($return, TRUE);

		}

		public static function importOptions() {

			if ( !isset($_FILES['import_options_file']) ) {
				XAG_Init::json( 'error', 'File is not sent!' );
			}

			$file = $_FILES['import_options_file'];

			if ( $file['error'] == UPLOAD_ERR_OK && is_uploaded_file($file['tmp_name'])) {

				$info = pathinfo($file['name']);
				if ($info["extension"] != "psexp") {
					XAG_Init::json( 'error', 'File does not contain right extension!' );
				}

				$json = file_get_contents($file['tmp_name']);
				$json = @json_decode($json, TRUE);

				if ($json === NULL && json_last_error() !== JSON_ERROR_NONE) {
					XAG_Init::json( 'error', 'File that you uploaded is corrupted.' );
				}
				if ( !$json['options'] ) XAG_Init::json( 'error', 'File that you uploaded is corrupted.' );
				if ( !$json['postmeta'] ) XAG_Init::json( 'error', 'File that you uploaded is corrupted.' );

				$options = $json['options'];
				$postmeta = $json['postmeta'];

				foreach ( $options as $key => $option ) {
					update_option($key, $option);
				}

				foreach ( $postmeta as $key => $metas ) {
					$post_id = $key;
					if ( get_post_status( $post_id ) != FALSE ) {
						foreach ( $metas as $value) {
							update_post_meta( $post_id, $value['meta_key'] , $value['meta_value'] );
						}
					}
				}
				XAG_Init::json( 'success', 'Successfully imported settings.' );

			} else {
				XAG_Init::json( 'error', 'Error on upload, please contact support.' );
			}




		}


	}

}
