<?php

if ( ! class_exists( 'MXAG_Shortcodes' ) ) {

	class MXAG_Shortcodes extends MXAG_Model {

		public static function initialize() {
			add_action('admin_post_xag_saveShortcode', array('MXAG_Shortcodes', 'saveShortcode'));
			add_action('admin_post_xag_loadShortcodes', array('MXAG_Shortcodes', 'loadShortcodes'));
			add_action('admin_post_xag_getTrackingBoxes', array('MXAG_Shortcodes', 'getTrackingBoxes'));
			add_action('admin_post_xag_getTrackingCharts', array('MXAG_Shortcodes', 'getTrackingCharts'));
			add_action('admin_post_xag_getTrackingUrlCharts', array('MXAG_Shortcodes', 'getTrackingUrlCharts'));
			add_action('admin_post_xag_truncateTrackingData', array('MXAG_Shortcodes', 'truncateTrackingData'));
			add_action('admin_post_xag_urlTruncateTrackingData', array('MXAG_Shortcodes', 'urlTruncateTrackingData'));
			add_action('admin_post_xag_duplicateShortcode', array('MXAG_Shortcodes', 'duplicateShortcode'));
			add_action('admin_post_xag_getShortcode', array('MXAG_Shortcodes', 'getShortcode'));
			add_action('admin_post_xag_deleteShortcode', array('MXAG_Shortcodes', 'deleteShortcode'));

			add_action('admin_post_xag_save_shortcode_setup', array('MXAG_Shortcodes', 'saveShortcodeSetup'));

			add_action('admin_post_xag_trackShortcode',        array('MXAG_Shortcodes', 'trackShortcode'));
			add_action('admin_post_nopriv_xag_trackShortcode', array('MXAG_Shortcodes', 'trackShortcode'));

			add_action('parse_request', array('MXAG_Shortcodes', 'maskedShortcode'));

			self::initShortcodes();
		}

		public static function saveShortcodeSetup() {
			if (isset($_POST['redirect_mask'])) {
				if ( !empty($_POST['redirect_mask'])) {
					$redirect_mask = $_POST['redirect_mask'];
					update_option('prs_redirect_mask', $redirect_mask);

					XAG_Init::json('success', 'Successfully updated masked URL!');
				} else {
					XAG_Init::json('error', 'Redirect Mask cannot be empty!');
				}
			} else {
				XAG_Init::json('error', 'Redirect Mask must be sent!');
			}
		}

		public static function deleteShortcode() {
			if (isset($_POST['id'])) {
				$ID = $_POST['id'];
				$shortcode = self::getData('*', array('id'=>$ID), false, false, 'prs_shortcodes');
				if ($shortcode !== false) {

					self::removeData(array('id'=>$ID), 'prs_shortcodes');
					self::removeData(array('shortcode_id'=>$ID), 'prs_shortcodes_tracking');

					XAG_Init::json('success', 'Successfully deleted shortcode!');

				} else {
					XAG_Init::json('error', 'No such shortcode exists!');
				}
			} else {
				XAG_Init::json('error', 'ID must be sent!');
			}
		}

		public static function getShortcode() {
			if (isset($_POST['id'])) {
				$ID = $_POST['id'];
				$shortcode = self::getData('*', array('id'=>$ID), false, false, 'prs_shortcodes');
				if ($shortcode !== false) {

					XAG_Init::json('success', 'Shortcode successfully retrieved!', $shortcode);

				} else {
					XAG_Init::json('error', 'No such shortcode exists!');
				}
			} else {
				XAG_Init::json('error', 'ID must be sent!');
			}
		}

		public static function duplicateShortcode() {
			if (isset($_POST['id'])) {
				$ID = $_POST['id'];
				$shortcode = self::getData('*', array('id'=>$ID), false, false, 'prs_shortcodes');

				if ($shortcode !== false) {

					$newName = $shortcode['shortcode'];
					if (substr($newName, -1) != '_') {
						$newName .= '_';
					}

					$counter = 0;

					TRY_AGAIN:
					$counter++;

					$name   = $newName . $counter;
					$exists = self::getData('id', array('shortcode'=>$name), false, false, 'prs_shortcodes');

					if ($exists !== false) {
						goto TRY_AGAIN;
					} else {

						$shortcode['shortcode'] = $name;
						$shortcode['name'] = $shortcode['name'].'Copy';
						unset($shortcode['id']);

						self::insertData($shortcode, 'prs_shortcodes');
					}

					XAG_Init::json('success', 'Shortcode successfully duplicated!');

				} else {
					XAG_Init::json('error', 'No such shortcode exists!');
				}
			} else {
				XAG_Init::json('error', 'ID must be sent!');
			}
		}

		public static function truncateTrackingData() {
			if (isset($_POST['id'])) {
				$ID = $_POST['id'];
				self::removeData(array('shortcode_id' => $ID), 'prs_shortcodes_tracking');
				XAG_Init::json('success', 'Truncated tracking data successfully!');
			} else {
				XAG_Init::json('error', 'ID must be sent!');
			}
		}

		public static function urlTruncateTrackingData() {
			if (isset($_POST['id'])) {
				$ID = $_POST['id'];
				self::removeData(array('shortcode_id' => $ID), 'prs_shortcodes_url_tracking');
				XAG_Init::json('success', 'Truncated tracking data successfully!');
			} else {
				XAG_Init::json('error', 'ID must be sent!');
			}
		}

		public static function getTrackingCharts() {
			if (isset($_POST['id'])) {
				$ID = $_POST['id'];

				// Impressions
				$impressions = self::query("SELECT CAST(date AS DATE) AS DATE_TRACKED, COUNT(*) AS TOTAL FROM prs_shortcodes_tracking WHERE shortcode_id = $ID GROUP BY DATE_TRACKED", 'prs_shortcodes_tracking');

				// Unique Clicks
				$unique_clicks = self::query("SELECT CAST(date AS DATE) AS DATE_TRACKED, COUNT(DISTINCT ip_address) AS TOTAL FROM prs_shortcodes_tracking WHERE shortcode_id = $ID AND clicked = 1 GROUP BY DATE_TRACKED", 'prs_shortcodes_tracking');

				// Chart Data
				$chart_data = array();

				foreach($impressions as $d) {
					$chart_data[$d['DATE_TRACKED']]['IMPRESSIONS'] = (int)$d['TOTAL'];
					$chart_data[$d['DATE_TRACKED']]['UNIQUE_CLICKS'] = 0;
				}

				foreach($unique_clicks as $d) {
					$chart_data[$d['DATE_TRACKED']]['UNIQUE_CLICKS'] = (int)$d['TOTAL'];
				}

				$final_chart_data = array(array('Date', 'Impressions', 'Unique Clicks'));
				foreach($chart_data as $date=>$data) {
					$final_chart_data[] = array(
						$date,
						$data['IMPRESSIONS'],
						$data['UNIQUE_CLICKS']
					);
				}

				XAG_Init::json('success', 'Retrieved tracking charts data successfully!', $final_chart_data);

			} else {
				XAG_Init::json('error', 'ID must be sent!');
			}
		}

		public static function getTrackingUrlCharts() {
			if (isset($_POST['id'])) {
				$ID = $_POST['id'];

				// Impressions
				$impressions = self::query("SELECT CAST(date AS DATE) AS DATE_TRACKED, COUNT(*) AS TOTAL FROM prs_shortcodes_url_tracking WHERE shortcode_id = $ID GROUP BY DATE_TRACKED", 'prs_shortcodes_url_tracking');

				// Unique Clicks
				$unique_clicks = self::query("SELECT CAST(date AS DATE) AS DATE_TRACKED, COUNT(DISTINCT ip_address) AS TOTAL FROM prs_shortcodes_url_tracking WHERE shortcode_id = $ID AND clicked = 1 GROUP BY DATE_TRACKED", 'prs_shortcodes_url_tracking');

				// Chart Data
				$chart_data = array();

				foreach($impressions as $d) {
					$chart_data[$d['DATE_TRACKED']]['IMPRESSIONS'] = (int)$d['TOTAL'];
					$chart_data[$d['DATE_TRACKED']]['UNIQUE_CLICKS'] = 0;
				}

				foreach($unique_clicks as $d) {
					$chart_data[$d['DATE_TRACKED']]['UNIQUE_CLICKS'] = (int)$d['TOTAL'];
				}

				$final_chart_data = array(array('Date', 'Impressions', 'Unique Clicks'));
				foreach($chart_data as $date=>$data) {
					$final_chart_data[] = array(
						$date,
						$data['IMPRESSIONS'],
						$data['UNIQUE_CLICKS']
					);
				}

				XAG_Init::json('success', 'Retrieved tracking charts data successfully!', $final_chart_data);

			} else {
				XAG_Init::json('error', 'ID must be sent!');
			}
		}

		public static function maskedShortcode() {
			$q = $_GET;
			$u = get_site_url();
			$redirect_mask = get_option('prs_redirect_mask');
			if ( !$redirect_mask ) $redirect_mask = 'ps_redirect';

			if (isset($q[$redirect_mask])) {
				if (!empty($q[$redirect_mask])) {
					$ID = $q[$redirect_mask];
					$where = array();
					if (is_numeric($ID)) {
						$where['id'] = $ID;
					} else {
						$where['name'] = $ID;
					}
					$shortcode = self::getData('*', $where, false, false, 'prs_shortcodes');
					if ($shortcode !== false) {
						self::trackShortcode();
						self::trackShortcodeUrl();
						wp_redirect($shortcode['url']);
						exit();
					} else {
						wp_redirect($u);
                        exit();
					}
				} else {
					wp_redirect($u);
                    exit();
				}
			} elseif (isset($q['ps_redirect'])) {
				if (!empty($q['ps_redirect'])) {
					$ID = $q['ps_redirect'];
					$where = array();
					if (is_numeric($ID)) {
						$where['id'] = $ID;
					} else {
						$where['name'] = $ID;
					}
					$shortcode = self::getData('*', $where, false, false, 'prs_shortcodes');
					if ($shortcode !== false) {
						self::trackShortcode();
						self::trackShortcodeUrl();
						wp_redirect($shortcode['url']);
						exit();
					} else {
						wp_redirect($u);
                        exit();
					}
				} else {
					wp_redirect($u);
                    exit();
				}
			}
		}

		public static function trackShortcode() {
			$ID = 0;
			$redirect_mask = get_option('prs_redirect_mask');
			if ( !$redirect_mask ) $redirect_mask = 'ps_redirect';
			if (isset($_POST['id'])) {
				$ID = $_POST['id'];
			} else if (isset($_REQUEST[$redirect_mask])) {
				$ID = $_REQUEST[$redirect_mask];
			} else if (isset($_REQUEST['ps_redirect'])) {
				$ID = $_REQUEST['ps_redirect'];
			}

			if (!empty($ID)) {
				$shortcode_tracking = self::getData('*', array('id'=>$ID), false, false, 'prs_shortcodes_tracking');
				if ($shortcode_tracking !== false)  {
					self::updateData(array('clicked'=>1), array('id'=>$ID), 'prs_shortcodes_tracking');
				} else {
					if (!empty($ID) && is_numeric($ID)) {
							self::insertData(array(
							'ip_address'   => $_SERVER['REMOTE_ADDR'],
							'shortcode_id' => $ID,
							'date'         => date('Y-m-d'),
							'clicked'      => 1
						), 'prs_shortcodes_tracking');
					}
				}
			}

		}

		public static function trackShortcodeUrl() {
			$ID = 0;
			$redirect_mask = get_option('prs_redirect_mask');
			if ( !$redirect_mask ) $redirect_mask = 'ps_redirect';
			if (isset($_REQUEST[$redirect_mask])) {
				$ID = $_REQUEST[$redirect_mask];
			} else if (isset($_REQUEST['ps_redirect'])) {
				$ID = $_REQUEST['ps_redirect'];
			}

			if (!is_numeric($ID)) {
				$where['name'] = $ID;
				if (!empty($ID)) {
					$shortcode_url_tracking = self::getData('*', $where, false, false, 'prs_shortcodes');
					if ($shortcode_url_tracking !== false)  {
						self::insertData(array(
							'ip_address'   => $_SERVER['REMOTE_ADDR'],
							'shortcode_id' => $shortcode_url_tracking['id'],
							'date'         => date('Y-m-d'),
							'clicked'      => 1
						), 'xag_shortcodes_url_tracking');
					}
				}
			}


		}

		public static function initShortcodes() {
			$shortcodes = self::getAllData('prs_shortcodes');
			foreach($shortcodes as $s) {
				add_shortcode($s['shortcode'], array('MXAG_Shortcodes', 'renderShortcode'));
			}
			// V2 compatibility failback
			add_shortcode('aff', array('MXAG_Shortcodes', 'renderShortcode'));

			add_shortcode('xag_project_keyword', array('MXAG_Shortcodes', 'renderShortcode'));

		}

		public static function renderShortcode($atts, $content = "", $tag) {

			if ($tag === 'aff') {
				// V2 compatibility failback
				$shortcode = self::getData('*', array('shortcode'=>str_replace(' ', '_', $atts['name'])), false, false, 'prs_shortcodes');
			} elseif ($tag === 'xag_project_keyword') {
				// Render!
				$a = '<a class="prs-group-keyword" href="' . $atts['url'] . '"';

				if ( $atts['target'] === 'true') $a .= ' target="_blank"';

				$a .= '>';

				if ( $atts['capitalize'] === 'true' ) $atts['keyword'] = ucfirst(strtolower($atts['keyword']));

				$a .= $atts['keyword'];
				$a .= '</a>';
				return $a;
			} else {
				$shortcode = self::getData('*', array('shortcode'=>$tag), false, false, 'prs_shortcodes');
			}

			if ($shortcode !== false) {
				// if multiple shortcodes
				if (!isset($shortcode['shortcode'])) {
					$shortcode = $shortcode[0];
				}

				// Track!
				$ip_address   = $_SERVER['REMOTE_ADDR'];
				$shortcode_id = $shortcode['id'];
				$date         = date('Y-m-d');

				// Get tracking ID if visited today, if not, create
				$tracking_id = null;

				$tracking = self::getData('*', array('ip_address' => $ip_address, 'date' => $date, 'shortcode_id' => $shortcode_id), false, false, 'prs_shortcodes_tracking');
				if ($tracking !== false) {
					$tracking_id = $tracking['id'];
				} else {
					$tracking_id  = self::insertData(array(
						'ip_address'   => $ip_address,
						'shortcode_id' => $shortcode_id,
						'date'         => $date
					), 'prs_shortcodes_tracking');
				}

				$redirect_mask = get_option('prs_redirect_mask');
				if ( !$redirect_mask ) $redirect_mask = 'ps_redirect';

				// Check if URL needs to be masked
				if ($shortcode['mask'] == 1) {
					$shortcode['url'] = '/?'.$redirect_mask.'=' . $shortcode_id;
				}

				if (isset($atts['title'])) {
					$shortcode['title'] = $atts['title'];
				}

				// Render!
				$a = '<a class="ps-tracking" data-id="'.$tracking_id.'" href="' . $shortcode['url'] . '"';
				if ($shortcode['target_blank'] == 1) {
					$a .= ' target="_blank"';
				}
				if ($shortcode['nofollow'] == 1) {
					$a .= ' rel="nofollow"';
				}
				$a .= '>';

				if (empty($shortcode['image'])) {
					$a .= $shortcode['title'];
				} else {
					$a .= '<img src="' . $shortcode['image'] . '" title="'.$shortcode['title'].'"/>';
				}
				$a .= '</a>';
				return $a;
			}
			return '';
		}

		public static function loadShortcodes() {
			$data = $_POST;
			$page = $data['page'];

			unset($data['page']);
			unset($data['action']);

			$page    = $page * 10;
			$maximum = 10;

			if ($data['group'] == 'all') {
				$data['group'] = '';
			}

			$count   = 0;
			$results = self::getDataLike(
				$what     = '*',
				$where    = $data,
				$group_by = false,
				$limit    = $page . ', ' . $maximum,
				$table    = 'prs_shortcodes',
				$count
			);

			$pages = ceil($count / 10);

			if (isset($results['id'])) {
				$results = array($results);
			}

			for($i = 0; $i < sizeof($results); $i++) {
				if (!isset($results[$i]['id'])) {
					continue;
				}
				$ID = $results[$i]['id'];

				// Impressions
				$data = self::getData('id', array('shortcode_id'=>$ID), false, false, 'prs_shortcodes_tracking');
				$impressions = ($data == false) ? 0 : sizeof($data);

				// Unique Clicks
				$data = self::getData('id', array('shortcode_id'=>$ID, 'clicked'=>1), 'ip_address', false, 'prs_shortcodes_tracking');
				$unique_clicks = ($data == false) ? 0 : sizeof($data);

				// CTR
				if ($impressions === 0 || $unique_clicks === 0) {
					$ctr = 0;
				} else {
					$ctr = ((float)($unique_clicks / $impressions)) * 100;
				}

				// URL Impressions
				$url_data = self::getData('id', array('shortcode_id'=>$ID), false, false, 'prs_shortcodes_url_tracking');
				$url_impressions = ($url_data == false) ? 0 : sizeof($url_data);

				// URL Unique Clicks
				$url_data = self::getData('id', array('shortcode_id'=>$ID, 'clicked'=>1), 'ip_address', false, 'prs_shortcodes_url_tracking');
				$url_unique_clicks = ($url_data == false) ? 0 : sizeof($url_data);

				// URL CTR
				if ($url_impressions === 0 || $url_unique_clicks === 0) {
					$url_ctr = 0;
				} else {
					$url_ctr = ((float)($url_unique_clicks / $url_impressions)) * 100;
				}

				$results[$i]['impressions'] = $impressions;
				$results[$i]['unique_clicks'] = $unique_clicks;
				$results[$i]['ctr'] = $ctr;

				$results[$i]['url_impressions'] = $url_impressions;
				$results[$i]['url_unique_clicks'] = $url_unique_clicks;
				$results[$i]['url_ctr'] = $url_ctr;
			}


			XAG_Init::json('success', 'Shortcodes retrieved successfully', array(
				'rows'  => $results,
				'pages' => $pages
			));
		}

		public static function saveShortcode() {
			$data = $_POST;
			$id   = $data['id'];
			unset($data['id']);
			unset($data['action']);

			if ($id == 0) {
				$result = self::insertData($data, 'prs_shortcodes');
			} else {
				$result = self::updateData($data, array('id'=>$id), 'prs_shortcodes');
			}

			if (is_string($result)) {
				XAG_Init::json('error', $result);
				return;
			}

			XAG_Init::json('success', 'Shortcode successfully saved!', $result);
		}

		public static function createTable() {
			global $wpdb;
			require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

			$charset_collate = $wpdb->get_charset_collate();
			$creation_query =
				'CREATE TABLE prs_shortcodes (
					`id` int(11) NOT NULL AUTO_INCREMENT,
					`name` varchar(255),
					`shortcode` varchar(255),
					`url` text,
					`title` varchar(255),
					`group` varchar(255),				
					`target_blank` int(1) DEFAULT 0,
					`nofollow` int(1) DEFAULT 0,
					`mask` int(1) DEFAULT 0,
					`image` text,										
				PRIMARY KEY  (`id`)
			) ' .$charset_collate. ';';

			@dbDelta( $creation_query );

			$creation_query =
				'CREATE TABLE prs_shortcodes_tracking (
					`id` int(11) NOT NULL AUTO_INCREMENT,
					`shortcode_id` int(11),
					`clicked` int(1) DEFAULT 0,
					`ip_address` varchar(255),										
					`date` date,										
				PRIMARY KEY  (`id`)
			) ' .$charset_collate. ';';

			@dbDelta( $creation_query );

			$creation_query =
				'CREATE TABLE prs_shortcodes_url_tracking (
					`id` int(11) NOT NULL AUTO_INCREMENT,
					`shortcode_id` int(11),
					`clicked` int(1) DEFAULT 0,
					`ip_address` varchar(255),										
					`date` date,										
				PRIMARY KEY  (`id`)
			) ' .$charset_collate. ';';

			@dbDelta( $creation_query );
		}

		public static function removeTable() {
			global $wpdb;
			$query = 'DROP TABLE IF EXISTS prs_shortcodes;';
			$wpdb->query( $query );

			$query = 'DROP TABLE IF EXISTS prs_shortcodes_tracking;';
			$wpdb->query( $query );

			$query = 'DROP TABLE IF EXISTS prs_shortcodes_url_tracking;';
			$wpdb->query( $query );
		}

	}

}