<?php

if (!class_exists('MXAG_Silo')) {

    class MXAG_Silo extends MXAG_Model
    {

        public static function initialize ()
        {
            // Disable Model if not license is present
            if (!XAG_Licencator::isLicenseSet()) {
                return;
            }

            add_action('admin_post_xag_add_new_page_post', ['MXAG_Silo', 'addNewPagePost']);
            add_action('admin_post_xag_delete_page', ['MXAG_Silo', 'deletePage']);
            add_action('admin_post_xag_update_operator_data', ['MXAG_Silo', 'updateOperatorData']);
            add_action('admin_post_xag_get_operator_data', ['MXAG_Silo', 'getOperatorData']);
            add_action('admin_post_xag_set_page_post_title', ['MXAG_Silo', 'setPagePostTitle']);
            add_action('admin_post_xag_new_category', ['MXAG_Silo', 'newCategory']);
            add_action('admin_post_xag_new_tag', ['MXAG_Silo', 'newTag']);
            add_action('admin_post_xag_delete_tag', ['MXAG_Silo', 'deleteTag']);
            add_action('admin_post_xag_delete_category', ['MXAG_Silo', 'deleteCategory']);

            //add_action('save_post', ['MXAG_Silo', 'pageSaveSilo']);

            add_action('admin_post_xag_save_silo', ['MXAG_Silo', 'saveSilo']);
            add_action('admin_post_xag_load_silo', ['MXAG_Silo', 'loadSilo']);
            add_action('admin_post_xag_load_silo_names', ['MXAG_Silo', 'loadSiloNames']);
            add_action('admin_post_xag_new_silo', ['MXAG_Silo', 'newSILO']);
            add_action('admin_post_xag_silo_remove_name', ['MXAG_Silo', 'removeSiloName']);
            add_action('admin_post_xag_reset_parents_cats_tags', ['MXAG_Silo', 'resetParentsCategoriesTags']);

            add_action('admin_post_xag_generate_silo_links', ['MXAG_Silo', 'generateSiloLinks']);
            add_action('admin_post_xag_generate_silo_links_by_id', ['MXAG_Silo', 'generateSiloLinksByID']);
            add_action('admin_post_xag_generate_silo', ['MXAG_Silo', 'generateSilo']);

        }

        private static function _generateGrid ($size = 5000, $x_spacing = 280, $y_spacing = 280, $padding = 20)
        {
            $positions_grid = [];
            $columns        = $size / $x_spacing;
            $rows           = $size / $y_spacing;

            for ($i = 0; $i < $rows; $i++) {

                $row = [];

                for ($ii = 0; $ii < $columns; $ii++) {

                    $x = $ii * $x_spacing;
                    $y = $i * $y_spacing;

                    if ($x == 0) {
                        $x = $padding;
                    }
                    if ($y == 0) {
                        $y = $padding;
                    }

                    $row[] = [
                        'x' => $x,
                        'y' => $y,
                        'f' => TRUE
                    ];

                }

                $positions_grid[] = $row;

            }

            return $positions_grid;
        }

        private static function _createGridSlot_Posts (&$grid, $offset = FALSE, $id = '')
        {
            if ($offset == FALSE) {
                $offset = [
                    'r' => 0,
                    'c' => 0
                ];
            }

            // Loop through rows
            for ($r = $offset['r']; $r < sizeof($grid); $r++) {

                // Loop through columns
                for ($c = $offset['c']; $c < sizeof($grid[$r]); $c++) {

                    if ($grid[$r][$c]['f'] == TRUE) {
                        $grid[$r][$c]['f'] = FALSE;
                        $grid[$r][$c]['c'] = $c;
                        $grid[$r][$c]['r'] = $r;
                        $grid[$r][$c]['i'] = $id;
                        return $grid[$r][$c];
                    }

                }

            }

            return FALSE;
        }

        private static function _createGridSlot (&$grid, $parented_by = FALSE, $id = '', $vertical = FALSE)
        {
            if ($parented_by != FALSE) {

                if ($vertical == FALSE) {

                    $r = $parented_by['r'] + 1;

                    if ($r > sizeof($grid)) {
                        $r = sizeof($grid);
                    }

                    FIND_AGAIN:

                    // Loop through columns
                    for ($c = 0; $c < sizeof($grid[$r]); $c++) {

                        if ($grid[$r][$c]['f'] == TRUE) {
                            $grid[$r][$c]['f'] = FALSE;
                            $grid[$r][$c]['c'] = $c;
                            $grid[$r][$c]['r'] = $r;
                            $grid[$r][$c]['i'] = $id;
                            return $grid[$r][$c];
                        }

                    }

                    $r++;
                    goto FIND_AGAIN;

                } else {

                    $r = $parented_by['r'] + 1;
                    $c = $parented_by['c'];

                    if ($r > sizeof($grid)) {
                        $r = $parented_by['r'];
                        $c = $c + 1;
                    }

                    FIND_AGAIN2:

                    // Loop through columns
                    for ($rr = $r; $rr < sizeof($grid); $rr++) {

                        if ($grid[$rr][$c]['f'] == TRUE) {
                            $grid[$rr][$c]['f'] = FALSE;
                            $grid[$rr][$c]['c'] = $c;
                            $grid[$rr][$c]['r'] = $r;
                            $grid[$rr][$c]['i'] = $id;
                            return $grid[$rr][$c];
                        }

                    }

                    $c++;
                    goto FIND_AGAIN2;

                }

            } else {

                // Loop through rows
                for ($r = 0; $r < sizeof($grid); $r++) {

                    // Loop through columns
                    for ($c = 0; $c < sizeof($grid[$r]); $c++) {

                        if ($grid[$r][$c]['f'] == TRUE) {
                            $grid[$r][$c]['f'] = FALSE;
                            $grid[$r][$c]['c'] = $c;
                            $grid[$r][$c]['r'] = $r;
                            $grid[$r][$c]['i'] = $id;
                            return $grid[$r][$c];
                        }

                    }

                }

            }
            return FALSE;
        }

        private static function _findGridSlot (&$grid, $id)
        {
            // Loop through rows
            for ($r = 0; $r < sizeof($grid); $r++) {

                // Loop through columns
                for ($c = 0; $c < sizeof($grid[$r]); $c++) {
                    if (isset($grid[$r][$c]['i'])) {
                        if ($grid[$r][$c]['i'] == $id) {
                            return $grid[$r][$c];
                        }
                    }
                }

            }
            return FALSE;
        }

        public static function generateSiloLinksByID ()
        {
            sleep(1);

            $postID = $_POST['id'];
            $links  = [];

            $grid = self::_generateGrid();

            $silo = [
                'operators' => [],
                'links'     => [],
                'settings'  => [
                    "canvas_size" => "10000",

                    "external_color"          => "#ff3c3c",
                    "external_line_color"     => "#ff3c3c",
                    "external_line_thickness" => "2",
                    "external_line_type"      => "15",

                    "internal_line_color"     => "#6ec2ff",
                    "internal_line_thickness" => "2",
                    "internal_line_type"      => "15"
                ],
                'grid'      => NULL
            ];

            $args = [
                'posts_per_page' => -1,
                'orderby'        => 'ID',
                'order'          => 'ASC',
                'post_type'      => [
                    'post',
                    'page'
                ],
                'post_status'    => [
                    'publish'
                ]
            ];

            $post = get_post($postID);

            $content_post = get_post($post->ID);
            $content      = $content_post->post_content;
            $content      = apply_filters('the_content', $content);
            $content      = html_entity_decode($content);

            preg_match_all(
                '/<a.*?href="([^"]+)".*?>(.*?)<\/a>/s',
                stripslashes(do_shortcode($content)),
                $matches,
                PREG_SET_ORDER
            );

            // Find the parent ID
            $parent_id = self::_findOperator(
                $silo,
                $post->post_type,
                $post->ID
            );

            $parent_slot = FALSE;

            // Create a parent page if not exists
            if ($parent_id === NULL) {

                $parent_slot = self::_createGridSlot(
                    $grid,
                    FALSE,
                    $post->post_type . '-' . $post->ID
                );

                $silo['operators'][] = [
                    'properties' => [
                        'title'     => $post->post_title,
                        'subtitle'  => '',
                        'attached'  => MXAG_Projects::isAttachedToGroup($post->ID),
                        'icon'      => 'fa-file-text-o',
                        'permalink' => get_permalink($post->ID),
                        'inputs'    => [
                            'ins' => [
                                'label'    => '',
                                'multiple' => TRUE
                            ],
                        ],
                        'outputs'   => [
                            'outs' => [
                                'label'    => '',
                                'multiple' => TRUE
                            ]
                        ],
                        'class'     => 'operator-page op-' . $post->post_type . '-' . $post->ID,
                        'ID'        => 'op-' . $post->post_type . '-' . $post->ID,
                        'realID'    => $post->ID,
                        'type'      => $post->post_type
                    ],
                    'left'       => $parent_slot['x'],
                    'top'        => $parent_slot['y'],
                ];
                $parent_id           = sizeof($silo['operators']) - 1;

            } else {
                $parent_slot = self::_findGridSlot(
                    $grid,
                    $post->post_type . '-' . $post->ID
                );
            }

            if (!empty($matches)) {
                foreach ($matches as $url_data) {

                    $url = $url_data[1];

                    $post_id = url_to_postid($url);

                    $post_child = get_post($post_id);

                    if ($post_id == 0) {

                        // External Links
                        if (filter_var($url, FILTER_VALIDATE_URL)) {

                            // Check if image.... -.-
                            if (in_array(substr($url, -4), [
                                '.png',
                                '.jpg',
                                'jpeg',
                                '.gif',
                                'webp',
                            ])) {
                                continue;
                            }

                            // Check if internal
                            $domain = get_site_url();
                            $domain = parse_url($domain);
                            $domain = $domain['host'];

                            if (string_contains($domain, $url)) {

                                $out = self::curlHead($url);

                                if (isset($out['Location'])) {

                                    $post_id = url_to_postid($out['Location']);

                                    if ($post_id == 0) {

                                        $post_child             = new stdClass();
                                        $post_child->ID         = md5($out['Location']);
                                        $post_child->post_type  = 'page';
                                        $post_child->post_title = strip_tags($url_data[2]);
                                        $post_child->permalink  = $out['Location'];

                                    } else {
                                        $post_child = get_post($post_id);
                                    }

                                } else {

                                    if ($out['HTTP'] == '404 Not Found') {

                                        $post_child             = new stdClass();
                                        $post_child->ID         = md5($url);
                                        $post_child->post_type  = 'page';
                                        $post_child->post_title = strip_tags($url_data[2]);
                                        $post_child->permalink  = $url;
                                        $post_child->subtitle   = '<span class="subtitle-404">404 Page Not Found</span>';
                                        $post_child->class      = 'operator-404';

                                    } else {

                                        continue;

                                    }

                                }

                            } else {

                                $post_child             = new stdClass();
                                $post_child->ID         = md5($url);
                                $post_child->post_type  = 'external';
                                $post_child->post_title = strip_tags($url_data[2]);
                                $post_child->permalink  = $url;
                                $post_child->subtitle   = '<span class="uk-text-success">dofollow</span> <i class="fa fa-question-circle" data-uk-tooltip title="This is a normal, default link which search engines will follow and crawl."></i>';

                                if (strpos($url_data[0], 'rel') !== FALSE && strpos($url_data[0], 'nofollow') !== FALSE) {
                                    $post_child->subtitle = '<span class="uk-text-danger">nofollow</span> <i class="fa fa-question-circle" data-uk-tooltip title="This link will not be followed by search engines."></i>';
                                }

                            }

                        } else {

                            $checkURL = $url;
                            $checkURL = get_site_url(NULL, $checkURL);

                            // Check if image.... -.-
                            if (in_array(substr($checkURL, -4), [
                                '.png',
                                '.jpg',
                                'jpeg',
                                '.gif',
                                'webp',
                            ])) {
                                continue;
                            }

                            $out = self::curlHead($checkURL);

                            if (isset($out['Location'])) {

                                $post_id = url_to_postid($out['Location']);

                                if ($post_id == 0) {

                                    $post_child             = new stdClass();
                                    $post_child->ID         = md5($out['Location']);
                                    $post_child->post_type  = 'page';
                                    $post_child->post_title = strip_tags($url_data[2]);
                                    $post_child->permalink  = $out['Location'];

                                } else {
                                    $post_child = get_post($post_id);
                                }

                            } else {

                                if ($out['HTTP'] == '404 Not Found') {

                                    $post_child             = new stdClass();
                                    $post_child->ID         = md5($checkURL);
                                    $post_child->post_type  = 'page';
                                    $post_child->post_title = strip_tags($url_data[2]);
                                    $post_child->permalink  = $checkURL;
                                    $post_child->subtitle   = '<span class="subtitle-404">404 Page Not Found</span>';
                                    $post_child->class      = 'operator-404';

                                } else {

                                    continue;

                                }

                            }

                        }
                    }

                    if ($post_child == NULL) continue;

                    $operator_id = self::_findOperator(
                        $silo,
                        $post_child->post_type,
                        $post_child->ID
                    );

                    if ($operator_id === NULL) {

                        $child_slot = self::_createGridSlot(
                            $grid,
                            $parent_slot,
                            $post_child->post_type . '-' . $post_child->ID
                        );

                        $silo['operators'][] = [
                            'properties' => [
                                'title'     => $post_child->post_title,
                                'subtitle'  => isset($post_child->subtitle) ? $post_child->subtitle : '',
                                'attached'  => MXAG_Projects::isAttachedToGroup($post_child->ID),
                                'icon'      => 'fa-file-text-o',
                                'permalink' => isset($post_child->permalink) ? $post_child->permalink : get_permalink(
                                    $post_child->ID
                                ),
                                'inputs'    => [
                                    'ins' => [
                                        'label'    => '',
                                        'multiple' => TRUE
                                    ],
                                ],
                                'outputs'   => [
                                    'outs' => [
                                        'label'    => '',
                                        'multiple' => TRUE
                                    ]
                                ],
                                'class'     => 'operator-' . $post_child->post_type . ' op-' . $post_child->post_type . '-' . $post_child->ID . ' ' . ((isset($post_child->class) ? $post_child->class : '')),
                                'ID'        => 'op-' . $post_child->post_type . '-' . $post_child->ID,
                                'realID'    => $post_child->ID,
                                'type'      => $post_child->post_type
                            ],
                            'left'       => $child_slot['x'],
                            'top'        => $child_slot['y'],
                        ];
                        $operator_id         = sizeof($silo['operators']) - 1;

                    }

                    if (in_array(
                        md5($parent_id . '/' . $operator_id),
                        $links
                    )) {
                        continue;
                    }

                    // Find the last link
                    $subConnector_from = NULL;
                    $subConnector_to   = NULL;
                    $reversed          = array_reverse($silo['links']);
                    for ($i = 0; $i < sizeof($reversed); $i++) {
                        if ($reversed[$i]['fromOperator'] == $parent_id && $subConnector_from === NULL) {
                            $subConnector_from = $reversed[$i]['fromSubConnector'];
                        }
                        if ($reversed[$i]['toOperator'] == $operator_id && $subConnector_to === NULL) {
                            $subConnector_to = $reversed[$i]['toSubConnector'];
                        }
                    }

                    $links[] = md5($parent_id . '/' . $operator_id);

                    // Add the new link
                    $silo['links'][] = [
                        'fromOperator'     => $parent_id,
                        'fromConnector'    => 'outs',
                        'fromSubConnector' => ($subConnector_from === NULL) ? 0 : $subConnector_from + 1,
                        'toOperator'       => $operator_id,
                        'toConnector'      => 'ins',
                        'toSubConnector'   => ($subConnector_to === NULL) ? 0 : $subConnector_to + 1
                    ];

                }
            }

            $silo['grid'] = $grid;

            XAG_Init::json(
                'success',
                'Successfully built Links SILO by ID!',
                $silo
            );
        }

        public static function generateSiloLinks ()
        {
            sleep(1);

            $links = [];

            $grid = self::_generateGrid();

            $silo = [
                'operators' => [],
                'links'     => [],
                'settings'  => [
                    "canvas_size" => "10000",

                    "external_color"          => "#ff3c3c",
                    "external_line_color"     => "#ff3c3c",
                    "external_line_thickness" => "2",
                    "external_line_type"      => "15",

                    "internal_line_color"     => "#6ec2ff",
                    "internal_line_thickness" => "2",
                    "internal_line_type"      => "15"
                ],
                'grid'      => NULL
            ];

            $args = [
                'posts_per_page' => -1,
                'orderby'        => 'ID',
                'order'          => 'ASC',
                'post_type'      => [
                    'post',
                    'page'
                ],
                'post_status'    => [
                    'publish'
                ]
            ];

            $posts = get_posts($args);
            foreach ($posts as $post) {

                if (!wp_is_post_revision($post->ID)) {

                    $content_post = get_post($post->ID);
                    $content      = $content_post->post_content;
                    $content      = apply_filters('the_content', $content);
                    $content      = html_entity_decode($content);

                    preg_match_all(
                        '/<a.*?href="([^"]+)".*?>(.*?)<\/a>/s',
                        stripslashes(do_shortcode($content)),
                        $matches,
                        PREG_SET_ORDER
                    );

                    if (!empty($matches)) {

                        // Find the parent ID
                        $parent_id = self::_findOperator(
                            $silo,
                            $post->post_type,
                            $post->ID
                        );

                        $parent_slot = FALSE;

                        // Create a parent page if not exists
                        if ($parent_id === NULL) {

                            $parent_slot = self::_createGridSlot(
                                $grid,
                                FALSE,
                                $post->post_type . '-' . $post->ID
                            );

                            $silo['operators'][] = [
                                'properties' => [
                                    'title'     => $post->post_title,
                                    'subtitle'  => '',
                                    'attached'  => MXAG_Projects::isAttachedToGroup($post->ID),
                                    'icon'      => 'fa-file-text-o',
                                    'permalink' => get_permalink($post->ID),
                                    'inputs'    => [
                                        'ins' => [
                                            'label'    => '',
                                            'multiple' => TRUE
                                        ],
                                    ],
                                    'outputs'   => [
                                        'outs' => [
                                            'label'    => '',
                                            'multiple' => TRUE
                                        ]
                                    ],
                                    'class'     => 'operator-page op-' . $post->post_type . '-' . $post->ID,
                                    'ID'        => 'op-' . $post->post_type . '-' . $post->ID,
                                    'realID'    => $post->ID,
                                    'type'      => $post->post_type
                                ],
                                'left'       => $parent_slot['x'],
                                'top'        => $parent_slot['y'],
                            ];
                            $parent_id           = sizeof($silo['operators']) - 1;

                        } else {
                            $parent_slot = self::_findGridSlot(
                                $grid,
                                $post->post_type . '-' . $post->ID
                            );
                        }

                        foreach ($matches as $url_data) {

                            $url = $url_data[1];

                            $post_id    = url_to_postid($url);
                            $post_child = get_post($post_id);

                            if ($post_id == 0) {

                                // External Links
                                if (filter_var($url, FILTER_VALIDATE_URL)) {

                                    // Check if image.... -.-
                                    if (in_array(substr($url, -4), [
                                        '.png',
                                        '.jpg',
                                        'jpeg',
                                        '.gif',
                                        'webp',
                                    ])) {
                                        continue;
                                    }

                                    // Check if internal
                                    $domain = get_site_url();
                                    $domain = parse_url($domain);
                                    $domain = $domain['host'];

                                    if (string_contains($domain, $url)) {

                                        $out = self::curlHead($url);

                                        if (isset($out['Location'])) {

                                            $post_id = url_to_postid($out['Location']);

                                            if ($post_id == 0) {

                                                $post_child             = new stdClass();
                                                $post_child->ID         = md5($out['Location']);
                                                $post_child->post_type  = 'page';
                                                $post_child->post_title = strip_tags($url_data[2]);
                                                $post_child->permalink  = $out['Location'];

                                            } else {

                                                $post_child = get_post($post_id);

                                            }

                                        } else {

                                            if ($out['HTTP'] == '404 Not Found') {

                                                $post_child             = new stdClass();
                                                $post_child->ID         = md5($url);
                                                $post_child->post_type  = 'page';
                                                $post_child->post_title = strip_tags($url_data[2]);
                                                $post_child->permalink  = $url;
                                                $post_child->subtitle   = '<span class="subtitle-404">404 Page Not Found</span>';
                                                $post_child->class      = 'operator-404';

                                            } else {

                                                continue;

                                            }

                                        }

                                    } else {

                                        $post_child             = new stdClass();
                                        $post_child->ID         = md5($url);
                                        $post_child->post_type  = 'external';
                                        $post_child->post_title = strip_tags($url_data[2]);
                                        $post_child->permalink  = $url;
                                        $post_child->subtitle   = '<span class="uk-text-success">dofollow</span> <i class="fa fa-question-circle" data-uk-tooltip title="This is a normal, default link which search engines will follow and crawl."></i>';

                                        if (strpos($url_data[0], 'rel') !== FALSE && strpos($url_data[0], 'nofollow') !== FALSE) {
                                            $post_child->subtitle = '<span class="uk-text-danger">nofollow</span> <i class="fa fa-question-circle" data-uk-tooltip title="This link will not be followed by search engines."></i>';
                                        }

                                    }

                                } else {

                                    $checkURL = $url;
                                    $checkURL = get_site_url(NULL, $checkURL);

                                    // Check if image.... -.-
                                    if (in_array(substr($checkURL, -4), [
                                        '.png',
                                        '.jpg',
                                        'jpeg',
                                        '.gif',
                                        'webp',
                                    ])) {
                                        continue;
                                    }

                                    $out = self::curlHead($checkURL);

                                    if (isset($out['Location'])) {

                                        $post_id = url_to_postid($out['Location']);

                                        if ($post_id == 0) {

                                            $post_child             = new stdClass();
                                            $post_child->ID         = md5($out['Location']);
                                            $post_child->post_type  = 'page';
                                            $post_child->post_title = strip_tags($url_data[2]);
                                            $post_child->permalink  = $out['Location'];

                                        } else {

                                            $post_child = get_post($post_id);

                                        }

                                    } else {

                                        if ($out['HTTP'] == '404 Not Found') {

                                            $post_child             = new stdClass();
                                            $post_child->ID         = md5($checkURL);
                                            $post_child->post_type  = 'page';
                                            $post_child->post_title = strip_tags($url_data[2]);
                                            $post_child->permalink  = $checkURL;
                                            $post_child->subtitle   = '<span class="subtitle-404">404 Page Not Found</span>';
                                            $post_child->class      = 'operator-404';

                                        } else {

                                            continue;

                                        }

                                    }

                                }
                            }

                            if ($post_child == NULL) continue;

                            $operator_id = self::_findOperator(
                                $silo,
                                $post_child->post_type,
                                $post_child->ID
                            );

                            if ($operator_id === NULL) {

                                $child_slot = self::_createGridSlot(
                                    $grid,
                                    $parent_slot,
                                    $post_child->post_type . '-' . $post_child->ID
                                );

                                $silo['operators'][] = [
                                    'properties' => [
                                        'title'     => $post_child->post_title,
                                        'subtitle'  => isset($post_child->subtitle) ? $post_child->subtitle : '',
                                        'attached'  => MXAG_Projects::isAttachedToGroup($post_child->ID),
                                        'icon'      => 'fa-file-text-o',
                                        'permalink' => isset($post_child->permalink) ? $post_child->permalink : get_permalink(
                                            $post_child->ID
                                        ),
                                        'inputs'    => [
                                            'ins' => [
                                                'label'    => '',
                                                'multiple' => TRUE
                                            ],
                                        ],
                                        'outputs'   => [
                                            'outs' => [
                                                'label'    => '',
                                                'multiple' => TRUE
                                            ]
                                        ],
                                        'class'     => 'operator-' . $post_child->post_type . ' op-' . $post_child->post_type . '-' . $post_child->ID . ' ' . ((isset($post_child->class) ? $post_child->class : '')),
                                        'ID'        => 'op-' . $post_child->post_type . '-' . $post_child->ID,
                                        'realID'    => $post_child->ID,
                                        'type'      => $post_child->post_type
                                    ],
                                    'left'       => $child_slot['x'],
                                    'top'        => $child_slot['y'],
                                ];
                                $operator_id         = sizeof($silo['operators']) - 1;

                            }

                            if (in_array(
                                md5($parent_id . '/' . $operator_id),
                                $links
                            )) {
                                continue;
                            }

                            // Find the last link
                            $subConnector_from = NULL;
                            $subConnector_to   = NULL;
                            $reversed          = array_reverse($silo['links']);
                            for ($i = 0; $i < sizeof($reversed); $i++) {
                                if ($reversed[$i]['fromOperator'] == $parent_id && $subConnector_from === NULL) {
                                    $subConnector_from = $reversed[$i]['fromSubConnector'];
                                }
                                if ($reversed[$i]['toOperator'] == $operator_id && $subConnector_to === NULL) {
                                    $subConnector_to = $reversed[$i]['toSubConnector'];
                                }
                            }

                            $links[] = md5($parent_id . '/' . $operator_id);

                            // Add the new link
                            $silo['links'][] = [
                                'fromOperator'     => $parent_id,
                                'fromConnector'    => 'outs',
                                'fromSubConnector' => ($subConnector_from === NULL) ? 0 : $subConnector_from + 1,
                                'toOperator'       => $operator_id,
                                'toConnector'      => 'ins',
                                'toSubConnector'   => ($subConnector_to === NULL) ? 0 : $subConnector_to + 1
                            ];

                        }
                    }
                }
            }

            $silo['grid'] = $grid;

            XAG_Init::json(
                'success',
                'Successfully built Links SILO!',
                $silo
            );
        }

        private static function curlHead ($url)
        {
            $ch = curl_init();

            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_NOBODY, TRUE);
            curl_setopt($ch, CURLOPT_HEADER, TRUE);

            $response = curl_exec($ch);
            if (curl_errno($ch)) {
                return FALSE;
            }
            curl_close($ch);

            $return = [];
            $split  = explode("\n", $response);
            foreach ($split as $line) {
                if (empty($line)) continue;
                $line_split = explode(" ", $line, 2);
                $key        = $line_split[0];
                $value      = $line_split[1];

                $key = explode('/', $key);
                $key = $key[0];
                $key = str_replace(':', '', $key);

                $return[trim($key)] = trim($value);
            }

            return $return;
        }

        public static function generateSilo ()
        {
            sleep(0.5);

            $name = sanitize_text_field($_POST['name']);
            $type = $_POST['type'];
            $importAll = $_POST['importAll'] == 'yes';

            $silo = get_option('prs_silo_' . $type);

            if (!is_array($silo)) $silo = [];

            if ($type == 'pages') {

                $grid_pages = self::_generateGrid(20000);

                $pages = get_pages();

                $pages_op = [
                    'operators' => [],
                    'links'     => [],
                    'settings'  => [

                        'line_thickness' => '2',
                        'line_type'      => '0',
                        'line_color'     => '#559acc',

                        'canvas_size' => '20000'
                    ]
                ];

                // First, create pages by their parents
                $ids_alone = [];
                $temp_pages = [];
                foreach ($pages as $page) {
                    if ($page->post_parent != 0) {
                        if (!isset($temp_pages[$page->post_parent])) {
                            $temp_pages[$page->post_parent] = [];
                        }
                        $temp_pages[$page->post_parent][] = $page;
                    } else {
                        $ids_alone[] = $page;
                    }
                }
                $pages = $temp_pages;

                // Do all the alone pages first
                if ($importAll == true) {
                    foreach($ids_alone as $page) {

                        $alone_slot = self::_createGridSlot(
                            $grid_pages,
                            FALSE,
                            'page-' . $page->ID
                        );

                        $pages_op['operators'][] = [
                            'properties' => [
                                'title'    => $page->post_title,
                                'subtitle' => '',
                                'attached' => MXAG_Projects::isAttachedToGroup($page->ID),
                                'icon'     => 'fa-file-text-o',
                                'inputs'   => [
                                    'input_1' => [
                                        'label' => ''
                                    ],
                                ],
                                'outputs'  => [
                                    'outs' => [
                                        'label'    => '',
                                        'multiple' => TRUE
                                    ]
                                ],
                                'class'    => 'operator-page op-page-' . $page->ID,
                                'ID'       => 'op-page-' . $page->ID,
                                'realID'   => $page->ID,
                                'type'     => 'page'
                            ],
                            'left'       => $alone_slot['x'],
                            'top'        => $alone_slot['y'],
                        ];

                    }
                }

                // Go through each parents pages

                foreach ($pages as $post_parent => $parent_pages) {

                    foreach ($parent_pages as $page) {

                        // Find the parent ID
                        $parent_id = self::_findOperator(
                            $pages_op,
                            'page',
                            $page->post_parent
                        );

                        $parent_slot = FALSE;

                        // Create a parent page if not exists
                        if ($parent_id === NULL) {

                            $parent = get_post($page->post_parent);

                            $parent_slot = self::_createGridSlot(
                                $grid_pages,
                                FALSE,
                                'page-' . $page->post_parent
                            );

                            $pages_op['operators'][] = [
                                'properties' => [
                                    'title'    => $parent->post_title,
                                    'subtitle' => '',
                                    'attached' => MXAG_Projects::isAttachedToGroup($page->ID),
                                    'icon'     => 'fa-file-text-o',
                                    'inputs'   => [
                                        'input_1' => [
                                            'label' => ''
                                        ],
                                    ],
                                    'outputs'  => [
                                        'outs' => [
                                            'label'    => '',
                                            'multiple' => TRUE
                                        ]
                                    ],
                                    'class'    => 'operator-page op-page-' . $page->post_parent,
                                    'ID'       => 'op-page-' . $page->post_parent,
                                    'realID'   => $page->post_parent,
                                    'type'     => 'page'
                                ],
                                'left'       => $parent_slot['x'],
                                'top'        => $parent_slot['y'],
                            ];
                            $parent_id               = sizeof($pages_op['operators']) - 1;

                        } else {
                            $parent_slot = self::_findGridSlot(
                                $grid_pages,
                                'page-' . $page->post_parent
                            );
                        }

                        $operator_id = self::_findOperator(
                            $pages_op,
                            'page',
                            $page->ID
                        );

                        if ($operator_id === NULL) {

                            $child_slot = self::_createGridSlot(
                                $grid_pages,
                                $parent_slot,
                                'page-' . $page->ID
                            );

                            $pages_op['operators'][] = [
                                'properties' => [
                                    'title'    => $page->post_title,
                                    'subtitle' => '',
                                    'attached' => MXAG_Projects::isAttachedToGroup($page->ID),
                                    'icon'     => 'fa-file-text-o',
                                    'inputs'   => [
                                        'input_1' => [
                                            'label' => ''
                                        ],
                                    ],
                                    'outputs'  => [
                                        'outs' => [
                                            'label'    => '',
                                            'multiple' => TRUE
                                        ]
                                    ],
                                    'class'    => 'operator-page op-page-' . $page->ID,
                                    'ID'       => 'op-page-' . $page->ID,
                                    'realID'   => $page->ID,
                                    'type'     => 'page'
                                ],
                                'left'       => $child_slot['x'],
                                'top'        => $child_slot['y'],
                            ];
                            $operator_id             = sizeof($pages_op['operators']) - 1;
                        }

                        // Find the last link
                        $subConnector = NULL;
                        $reversed     = array_reverse($pages_op['links']);
                        for ($i = 0; $i < sizeof($reversed); $i++) {
                            if ($reversed[$i]['fromOperator'] == $parent_id) {
                                $subConnector = $reversed[$i]['fromSubConnector'];
                                break;
                            }
                        }
                        // Add the new link
                        $pages_op['links'][] = [
                            'fromOperator'     => $parent_id,
                            'fromConnector'    => 'outs',
                            'fromSubConnector' => ($subConnector === NULL) ? 0 : $subConnector + 1,
                            'toOperator'       => $operator_id,
                            'toConnector'      => 'input_1',
                            'toSubConnector'   => 0
                        ];

                    }

                }

                $silo[$name] = urlencode(json_encode($pages_op));

            } else {

                // Tags & Categories

                $grid_posts = self::_generateGrid(20000);

                $posts_op = [
                    'operators' => [],
                    'links'     => [],
                    'settings'  => [
                        'line_category_thickness' => '2',
                        'line_category_type'      => '15',
                        'line_category_color'     => '#6ec2ff',
                        'box_category_color'      => '#d7eeff',

                        'line_tag_thickness' => '2',
                        'line_tag_type'      => '15',
                        'line_tag_color'     => '#989898',
                        'box_tag_color'      => '#f1f1f1',

                        'canvas_size' => '20000'
                    ]
                ];

                $tags = get_tags(
                    [
                        "hide_empty" => 0,
                        "type"       => "post",
                        "orderby"    => "name",
                        "order"      => "ASC"
                    ]
                );

                $categories = get_categories(
                    [
                        "hide_empty" => 0,
                        "type"       => "post",
                        "orderby"    => "name",
                        "order"      => "ASC"
                    ]
                );

                // Do tags first
                foreach ($tags as $tag) {

                    // Create a parent operator / tag
                    $parent_id = self::_findOperator(
                        $posts_op,
                        'tag',
                        $tag->term_id
                    );

                    // Create a parent page if not exists
                    if ($parent_id === NULL) {

                        $parent_slot = self::_createGridSlot_Posts(
                            $grid_posts,
                            ['r' => 3, 'c' => 0],
                            'tag-' . $tag->term_id
                        );

                        $posts_op['operators'][] = [
                            'properties' => [
                                'title'    => $tag->name,
                                'subtitle' => '',
                                'attached' => 0,
                                'icon'     => 'fa-tag',
                                'inputs'   => [
                                    'ins' => [
                                        'label'    => '',
                                        'multiple' => TRUE
                                    ],
                                ],
                                'outputs'  => [],
                                'class'    => 'operator-tag op-tag-' . $tag->term_id,
                                'ID'       => 'op-tag-' . $tag->term_id,
                                'realID'   => $tag->term_id,
                                'type'     => 'tag'
                            ],
                            'left'       => $parent_slot['x'],
                            'top'        => $parent_slot['y'],
                        ];
                        $parent_id               = sizeof($posts_op['operators']) - 1;

                    } else {
                        $parent_slot = self::_findGridSlot(
                            $grid_posts,
                            'tag-' . $tag->term_id
                        );
                    }

                    // Get the posts from each tag
                    $args = [
                        'posts_per_page' => -1,
                        'tax_query'      => [
                            [
                                'taxonomy' => 'post_tag',
                                'field'    => 'slug',
                                'terms'    => $tag->slug
                            ]
                        ]
                    ];

                    // Go through each Post
                    $posts = get_posts($args);

                    foreach ($posts as $post) {

                        $operator_id = self::_findOperator(
                            $posts_op,
                            'post',
                            $post->ID
                        );

                        if ($operator_id === NULL) {

                            $child_slot = self::_createGridSlot_Posts(
                                $grid_posts,
                                FALSE,
                                'post-' . $post->ID
                            );

                            $posts_op['operators'][] = [
                                'properties' => [
                                    'title'    => $post->post_title,
                                    'subtitle' => '',
                                    'attached' => MXAG_Projects::isAttachedToGroup($post->ID),
                                    'icon'     => 'fa-file-text-o',
                                    'inputs'   => [],
                                    'outputs'  => [
                                        'outs' => [
                                            'label'    => '',
                                            'multiple' => TRUE
                                        ]
                                    ],
                                    'class'    => 'operator-post op-post-' . $post->ID,
                                    'ID'       => 'op-post-' . $post->ID,
                                    'realID'   => $post->ID,
                                    'type'     => 'post'
                                ],
                                'left'       => $child_slot['x'],
                                'top'        => $child_slot['y'],
                            ];
                            $operator_id             = sizeof($posts_op['operators']) - 1;


                        }

                        // Find the last link
                        $subConnector_from = NULL;
                        $subConnector_to   = NULL;
                        $reversed          = array_reverse($posts_op['links']);
                        for ($i = 0; $i < sizeof($reversed); $i++) {
                            if ($reversed[$i]['fromOperator'] == $operator_id && $subConnector_from === NULL) {
                                $subConnector_from = $reversed[$i]['fromSubConnector'];
                            }
                            if ($reversed[$i]['toOperator'] == $parent_id && $subConnector_to === NULL) {
                                $subConnector_to = $reversed[$i]['toSubConnector'];
                            }
                        }

                        // Add the new link
                        $posts_op['links'][] = [
                            'fromOperator'     => $operator_id,
                            'fromConnector'    => 'outs',
                            'fromSubConnector' => ($subConnector_from === NULL) ? 0 : $subConnector_from + 1,
                            'toOperator'       => $parent_id,
                            'toConnector'      => 'ins',
                            'toSubConnector'   => ($subConnector_to === NULL) ? 0 : $subConnector_to + 1
                        ];

                    }

                }

                // Do categories next
                foreach ($categories as $category) {

                    // Create a parent operator / tag
                    $parent_id = self::_findOperator(
                        $posts_op,
                        'category',
                        $category->term_id
                    );

                    // Create a parent page if not exists
                    if ($parent_id === NULL) {

                        $parent_slot = self::_createGridSlot_Posts(
                            $grid_posts,
                            ['r' => 4, 'c' => 0],
                            'category-' . $category->term_id
                        );

                        $posts_op['operators'][] = [
                            'properties' => [
                                'title'    => $category->name,
                                'subtitle' => '',
                                'attached' => 0,
                                'icon'     => 'fa-align-right',
                                'inputs'   => [
                                    'ins' => [
                                        'label'    => '',
                                        'multiple' => TRUE
                                    ],
                                ],
                                'outputs'  => [],
                                'class'    => 'operator-category op-category-' . $category->term_id,
                                'ID'       => 'op-category-' . $category->term_id,
                                'realID'   => $category->term_id,
                                'type'     => 'category'
                            ],
                            'left'       => $parent_slot['x'],
                            'top'        => $parent_slot['y'],
                        ];
                        $parent_id               = sizeof($posts_op['operators']) - 1;

                    } else {
                        $parent_slot = self::_findGridSlot(
                            $grid_posts,
                            'category-' . $category->term_id
                        );
                    }

                    // Get the posts from each tag
                    $args = [
                        'posts_per_page' => -1,
                        'tax_query'      => [
                            [
                                'taxonomy' => 'category',
                                'field'    => 'slug',
                                'terms'    => $category->slug
                            ]
                        ]
                    ];

                    // Go through each Post
                    $posts = get_posts($args);

                    foreach ($posts as $post) {

                        $operator_id = self::_findOperator(
                            $posts_op,
                            'post',
                            $post->ID
                        );

                        if ($operator_id === NULL) {

                            $child_slot = self::_createGridSlot_Posts(
                                $grid_posts,
                                FALSE,
                                'post-' . $post->ID
                            );

                            $posts_op['operators'][] = [
                                'properties' => [
                                    'title'    => $post->post_title,
                                    'subtitle' => '',
                                    'attached' => MXAG_Projects::isAttachedToGroup($post->ID),
                                    'icon'     => 'fa-file-text-o',
                                    'inputs'   => [],
                                    'outputs'  => [
                                        'outs' => [
                                            'label'    => '',
                                            'multiple' => TRUE
                                        ]
                                    ],
                                    'class'    => 'operator-post op-post-' . $post->ID,
                                    'ID'       => 'op-post-' . $post->ID,
                                    'realID'   => $post->ID,
                                    'type'     => 'post'
                                ],
                                'left'       => $child_slot['x'],
                                'top'        => $child_slot['y'],
                            ];
                            $operator_id             = sizeof($posts_op['operators']) - 1;

                        }

                        // Find the last link
                        $subConnector_from = NULL;
                        $subConnector_to   = NULL;
                        $reversed          = array_reverse($posts_op['links']);
                        for ($i = 0; $i < sizeof($reversed); $i++) {
                            if ($reversed[$i]['fromOperator'] == $operator_id && $subConnector_from === NULL) {
                                $subConnector_from = $reversed[$i]['fromSubConnector'];
                            }
                            if ($reversed[$i]['toOperator'] == $parent_id && $subConnector_to === NULL) {
                                $subConnector_to = $reversed[$i]['toSubConnector'];
                            }
                        }

                        // Add the new link
                        $posts_op['links'][] = [
                            'fromOperator'     => $operator_id,
                            'fromConnector'    => 'outs',
                            'fromSubConnector' => ($subConnector_from === NULL) ? 0 : $subConnector_from + 1,
                            'toOperator'       => $parent_id,
                            'toConnector'      => 'ins',
                            'toSubConnector'   => ($subConnector_to === NULL) ? 0 : $subConnector_to + 1
                        ];

                    }

                }

                $silo[$name] = urlencode(json_encode($posts_op));

            }

            update_option(
                'prs_silo_' . $type,
                $silo
            );

            XAG_Init::json('success', 'Successfully generated SILO.');

        }

        public static function setPagePostTitle ()
        {

            $type  = sanitize_text_field($_POST['type']);
            $id    = abs($_POST['id']);
            $title = sanitize_text_field($_POST['title']);

            if ($type == 'page' || $type == 'post') {

                $post_data = [
                    'ID'         => $id,
                    'post_title' => $title
                ];

                // Update the post into the database
                wp_update_post($post_data);

            } else if ($type == 'tag' || $type == 'category') {

                wp_update_term(
                    $id,
                    ($type == 'tag') ? 'post_tag' : $type,
                    [
                        'name' => $title
                    ]
                );

            }

            // Update the Operator as well
            $operators = self::_getOperators($type);

            // Find the operator
            $operator_id = self::_findOperator(
                $operators,
                $type,
                $id
            );

            // Modify the operator
            if ($operator_id !== NULL) {
                $operators['operators'][$operator_id]['properties']['title'] = $title;
                self::_updateOperators(
                    $operators,
                    $type
                );
            }

        }

        public static function newCategory ()
        {
            $name = $_POST['name'];

            wp_create_category($name);
        }

        public static function newTag ()
        {
            $name = $_POST['name'];

            wp_create_tag($name);
        }

        public static function resetParentsCategoriesTags ()
        {
//			$pages = get_pages();
//			$posts = get_posts();
//
//			foreach ($pages as $page) {
//				$post_data = [
//					'ID'          => $page->ID,
//					'post_parent' => 0
//				];
//
//				// Update the post into the database
//				wp_update_post($post_data);
//			}
//
//			foreach ($posts as $post) {
//				wp_set_post_categories($post->ID, [], FALSE);
//				wp_set_post_tags($post->ID, [], FALSE);
//			}

            update_option('prs_silo_ids_pages', FALSE);

            update_option('prs_silo_ids_posts', FALSE);

            update_option('prs_silo_pages', FALSE);
            update_option('prs_silo_posts', FALSE);

        }

        public static function pageSaveSilo ($post_id)
        {

            // Fix for trashing posts/pages
            if (!isset($_POST['post_ID'])) {
                return $post_id;
            }

            // Fix for Fusion Builder page ID
            if ($_POST['post_ID'] != $post_id) {
                $post_id = $_POST['post_ID'];
            }

            if (wp_is_post_revision($post_id)) {
                return $post_id;
            }

            if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
                return $post_id;
            }

            // Check the user's permissions.
            if ('page' === $_POST['post_type']) {

                if (!current_user_can(
                    'edit_page',
                    $post_id
                )) {
                    return $post_id;
                }

            } else {

                if (!current_user_can(
                    'edit_post',
                    $post_id
                )) {
                    return $post_id;
                }
            }

            // Only handle Posts & Pages
            if ($_POST['post_type'] != 'page' && $_POST['post_type'] != 'post') {
                return $post_id;
            }

            /**
             *  Prepare the Operators
             */

            $operators = NULL;

            $operators = get_option(($_POST['post_type'] == 'page') ? 'prs_silo_pages' : 'prs_silo_posts');
            $operators = urldecode($operators);
            $operators = stripslashes($operators);
            $operators = json_decode(
                $operators,
                TRUE
            );


            /**
             *   Update the H1 if found
             */
            $hasChanges = FALSE;

            /**
             *   Update the SILO Builder
             */

            if ($_POST['post_type'] == 'page') {

                $post = get_post($post_id);

                // Find the operator
                $operator_id = self::_findOperator(
                    $operators,
                    $_POST['post_type'],
                    $post_id
                );

                $hasChildren = self::_hasChildren(
                    $operators,
                    $operator_id
                );

                // Remove operator if doesn't have a parent and is not a parent
                if ($post->post_parent == 0 && $hasChildren == FALSE) {

                    self::_removeOperator(
                        $operators,
                        $operator_id
                    );

                    $hasChanges = TRUE;
                }

                if ($post->post_parent != 0) {

                    // Find the parent ID
                    $parent_id = self::_findOperator(
                        $operators,
                        'page',
                        $post->post_parent
                    );

                    // Create a parent page if not exists
                    if ($parent_id === NULL) {
                        $parent                   = get_post($post->post_parent);
                        $operators['operators'][] = [
                            'properties' => [
                                'title'    => $parent->post_title,
                                'subtitle' => '',
                                'attached' => MXAG_Projects::isAttachedToGroup($parent->ID),
                                'icon'     => 'fa-file-text-o',
                                'inputs'   => [
                                    'input_1' => [
                                        'label' => ''
                                    ],
                                ],
                                'outputs'  => [
                                    'outs' => [
                                        'label'    => '',
                                        'multiple' => TRUE
                                    ]
                                ],
                                'class'    => 'operator-page op-page-' . $parent->ID,
                                'ID'       => 'op-page-' . $parent->ID,
                                'realID'   => $parent->ID,
                                'type'     => 'page'
                            ],
                            'left'       => @$operators['operators'][sizeof($operators['operators']) - 1]['left'],
                            'top'        => @$operators['operators'][sizeof($operators['operators']) - 1]['top'] + 120
                        ];
                        $parent_id                = sizeof($operators['operators']) - 1;
                    }

                    if ($operator_id === NULL) {
                        $operators['operators'][] = [
                            'properties' => [
                                'title'    => $post->post_title,
                                'subtitle' => '',
                                'attached' => MXAG_Projects::isAttachedToGroup($post->ID),
                                'icon'     => 'fa-file-text-o',
                                'inputs'   => [
                                    'input_1' => [
                                        'label' => ''
                                    ],
                                ],
                                'outputs'  => [
                                    'outs' => [
                                        'label'    => '',
                                        'multiple' => TRUE
                                    ]
                                ],
                                'class'    => 'operator-page op-page-' . $post->ID,
                                'ID'       => 'op-page-' . $post->ID,
                                'realID'   => $post->ID,
                                'type'     => 'page'
                            ],
                            'left'       => @$operators['operators'][sizeof($operators['operators']) - 1]['left'],
                            'top'        => @$operators['operators'][sizeof($operators['operators']) - 1]['top'] + 120
                        ];
                        $operator_id              = sizeof($operators['operators']) - 1;
                    }

                    // Remove the existing links
                    for ($i = 0; $i < sizeof($operators['links']); $i++) {
                        if ($operators['links'][$i]['toOperator'] == $operator_id) {
                            unset($operators['links'][$i]);
                            break;
                        }
                    }

                    $operators['links'] = array_values($operators['links']);

                    // Find the last link
                    $subConnector = NULL;
                    $reversed     = array_reverse($operators['links']);
                    for ($i = 0; $i < sizeof($reversed); $i++) {
                        if ($reversed[$i]['fromOperator'] == $parent_id) {
                            $subConnector = $reversed[$i]['fromSubConnector'];
                            break;
                        }
                    }
                    // Add the new link
                    $operators['links'][] = [
                        'fromOperator'     => $parent_id,
                        'fromConnector'    => 'outs',
                        'fromSubConnector' => ($subConnector === NULL) ? 0 : $subConnector + 1,
                        'toOperator'       => $operator_id,
                        'toConnector'      => 'input_1',
                        'toSubConnector'   => 0
                    ];

                    $hasChanges = TRUE;
                }


            } else if ($_POST['post_type'] == 'post') {

                $post = get_post($post_id);

                // Find the operator
                $operator_id = self::_findOperator(
                    $operators,
                    $_POST['post_type'],
                    $post_id
                );

                $tags       = wp_get_post_tags($post_id);
                $categories = wp_get_post_categories($post_id);

                // Create a new operator
                if ($operator_id === NULL && (!empty($categories) || !empty($tags))) {

                    $operators['operators'][] = [
                        'properties' => [
                            'title'    => $post->post_title,
                            'subtitle' => '',
                            'attached' => MXAG_Projects::isAttachedToGroup($post->ID),
                            'icon'     => 'fa-file-text-o',
                            'inputs'   => [],
                            'outputs'  => [
                                'outs' => [
                                    'label'    => '',
                                    'multiple' => TRUE
                                ]
                            ],
                            'class'    => 'operator-post op-post-' . $post->ID,
                            'ID'       => 'op-post-' . $post->ID,
                            'realID'   => $post->ID,
                            'type'     => 'post'
                        ],
                        'left'       => @$operators['operators'][sizeof($operators['operators']) - 1]['left'],
                        'top'        => @$operators['operators'][sizeof($operators['operators']) - 1]['top'] + 120
                    ];

                    $operator_id = sizeof($operators['operators']) - 1;
                    $hasChanges  = TRUE;
                }

                // Remove existing links
                if ($operator_id !== NULL) {
                    self::_removeOperator(
                        $operators,
                        $operator_id,
                        'fromOperator'
                    );
                }

                // Check if tags are not empty, then create tag operator

                if (!empty($tags)) {
                    foreach ($tags as $tag) {

                        $tag_id = self::_findOperator(
                            $operators,
                            'tag',
                            $tag->term_id
                        );

                        if ($tag_id === NULL) {
                            $operators['operators'][] = [
                                'properties' => [
                                    'title'    => $tag->name,
                                    'subtitle' => '',
                                    'attached' => 0,
                                    'icon'     => 'fa-tag',
                                    'inputs'   => [
                                        'ins' => [
                                            'label'    => '',
                                            'multiple' => TRUE
                                        ]
                                    ],
                                    'outputs'  => [],
                                    'class'    => 'operator-tag op-tag-' . $tag->term_id,
                                    'ID'       => 'op-tag-' . $tag->term_id,
                                    'realID'   => $tag->term_id,
                                    'type'     => 'tag'
                                ],
                                'left'       => @$operators['operators'][sizeof($operators['operators']) - 1]['left'],
                                'top'        => @$operators['operators'][sizeof(
                                                                             $operators['operators']
                                                                         ) - 1]['top'] + 120
                            ];
                            $tag_id                   = sizeof($operators['operators']) - 1;
                            $hasChanges               = TRUE;
                        }

                        $hasLink = FALSE;

                        foreach ($operators['links'] as $link) {
                            if ($link['fromOperator'] == $operator_id && $link['toOperator'] == $tag_id) {
                                $hasLink = TRUE;
                                break;
                            }
                        }

                        if ($hasLink == FALSE) {
                            $hasChanges            = TRUE;
                            $subConnector_tag      = NULL;
                            $subConnector_operator = NULL;
                            $reversed              = array_reverse($operators['links']);
                            for ($i = 0; $i < sizeof($reversed); $i++) {
                                if ($reversed[$i]['toOperator'] == $tag_id && $subConnector_tag === NULL) {
                                    $subConnector_tag = $reversed[$i]['toSubConnector'];
                                }
                                if ($reversed[$i]['fromOperator'] == $operator_id && $subConnector_operator === NULL) {
                                    $subConnector_operator = $reversed[$i]['fromSubConnector'];
                                }
                            }

                            $operators['links'][] = [
                                'fromOperator'     => $operator_id,
                                'fromConnector'    => 'outs',
                                'fromSubConnector' => ($subConnector_operator === NULL) ? 0 : $subConnector_operator + 1,
                                'toOperator'       => $tag_id,
                                'toConnector'      => 'ins',
                                'toSubConnector'   => ($subConnector_tag === NULL) ? 0 : $subConnector_tag + 1
                            ];
                        }
                    }
                }

                // Check if categories are not empty, then create categories operator

                if (!empty($categories)) {
                    foreach ($categories as $term_id) {
                        $category = get_term($term_id);

                        $category_id = self::_findOperator(
                            $operators,
                            'category',
                            $term_id
                        );

                        if ($category_id === NULL) {
                            $operators['operators'][] = [
                                'properties' => [
                                    'title'    => $category->name,
                                    'subtitle' => '',
                                    'attached' => 0,
                                    'icon'     => 'fa-align-right',
                                    'inputs'   => [
                                        'ins' => [
                                            'label'    => '',
                                            'multiple' => TRUE
                                        ]
                                    ],
                                    'outputs'  => [],
                                    'class'    => 'operator-category op-category-' . $term_id,
                                    'ID'       => 'op-category-' . $term_id,
                                    'realID'   => $term_id,
                                    'type'     => 'category'
                                ],
                                'left'       => @$operators['operators'][sizeof($operators['operators']) - 1]['left'],
                                'top'        => @$operators['operators'][sizeof(
                                                                             $operators['operators']
                                                                         ) - 1]['top'] + 120
                            ];
                            $category_id              = sizeof($operators['operators']) - 1;
                            $hasChanges               = TRUE;
                        }

                        $hasLink = FALSE;

                        foreach ($operators['links'] as $link) {
                            if ($link['fromOperator'] == $operator_id && $link['toOperator'] == $category_id) {
                                $hasLink = TRUE;
                                break;
                            }
                        }

                        if ($hasLink == FALSE) {
                            $hasChanges            = TRUE;
                            $subConnector_category = NULL;
                            $subConnector_operator = NULL;
                            $reversed              = array_reverse($operators['links']);
                            for ($i = 0; $i < sizeof($reversed); $i++) {
                                if ($reversed[$i]['toOperator'] == $category_id && $subConnector_category === NULL) {
                                    $subConnector_category = $reversed[$i]['toSubConnector'];
                                }
                                if ($reversed[$i]['fromOperator'] == $operator_id && $subConnector_operator === NULL) {
                                    $subConnector_operator = $reversed[$i]['fromSubConnector'];
                                }
                            }

                            $operators['links'][] = [
                                'fromOperator'     => $operator_id,
                                'fromConnector'    => 'outs',
                                'fromSubConnector' => ($subConnector_operator === NULL) ? 0 : $subConnector_operator + 1,
                                'toOperator'       => $category_id,
                                'toConnector'      => 'ins',
                                'toSubConnector'   => ($subConnector_category === NULL) ? 0 : $subConnector_category + 1
                            ];
                        }
                    }
                }

            }

            if ($hasChanges == TRUE) {
                update_option(
                    ($_POST['post_type'] == 'page') ? 'prs_silo_pages' : 'prs_silo_posts',
                    urlencode(json_encode($operators))
                );
            }

            return $post_id;


        }

        public static function removeSiloName ()
        {
            $type = $_POST['type'];
            $name = sanitize_text_field($_POST['name']);

            $option = get_option('prs_silo_' . $type);
            if (!is_array($option)) $option = [];

            unset($option[$name]);

            update_option('prs_silo_' . $type, $option);
        }

        public static function newSILO ()
        {
            $type = $_POST['type'];
            $name = sanitize_text_field($_POST['name']);

            $option = get_option('prs_silo_' . $type);
            if (!is_array($option)) $option = [];

            if (isset($option[$name])) {
                XAG_Init::json('error', 'SILO with the same name already exists. Please choose a different name.');
                return;
            }

            $silo = NULL;
            if ($type == 'pages') {
                $silo = [
                    'operators' => [],
                    'links'     => [],
                    'settings'  => [

                        'line_thickness' => '2',
                        'line_type'      => '15',
                        'line_color'     => '#6ec2ff',

                        'canvas_size' => '10000'
                    ]
                ];
            } else if ($type == 'posts') {
                $silo = [
                    'operators' => [],
                    'links'     => [],
                    'settings'  => [
                        'line_category_thickness' => '2',
                        'line_category_type'      => '15',
                        'line_category_color'     => '#6ec2ff',
                        'box_category_color'      => '#d7eeff',

                        'line_tag_thickness' => '2',
                        'line_tag_type'      => '15',
                        'line_tag_color'     => '#989898',
                        'box_tag_color'      => '#f1f1f1',

                        'canvas_size' => '10000'
                    ]
                ];
            } else if ($type == 'links') {
                $silo = [
                    'operators' => [],
                    'links'     => [],
                    'settings'  => [
                        'internal_line_thickness' => '2',
                        'internal_line_type'      => '15',
                        'internal_line_color'     => '#6ec2ff',

                        'external_line_thickness' => '2',
                        'external_line_type'      => '15',
                        'external_line_color'     => '#ff3c3c',
                        'external_color'          => '#ff3c3c',

                        'canvas_size' => '10000'
                    ]
                ];
            }

            $option[$name] = urlencode(json_encode($silo));

            update_option('prs_silo_' . $type, $option);

            XAG_Init::json('success', 'Successfully created a new SILO.');
        }

        public static function loadSiloNames ()
        {
            $option_pages = get_option('prs_silo_pages');
            $option_posts = get_option('prs_silo_posts');
            $option_links = get_option('prs_silo_links');

            $data = [];

            if (is_array($option_pages) && !empty($option_pages)) {
                if (!in_array('Default', $data['pages'])) {
                    $data['pages'][] = 'Default';
                }
                $data['pages'] = array_merge($data['pages'], array_keys($option_pages));
                $data['pages'] = array_unique($data['pages']);
                $data['pages'] = array_values($data['pages']);
            } else {
                $data['pages'] = [
                    'Default'
                ];
            }

            if (is_array($option_posts) && !empty($option_posts)) {
                if (!in_array('Default', $data['posts'])) {
                    $data['posts'][] = 'Default';
                }
                $data['posts'] = array_merge($data['posts'], array_keys($option_posts));
                $data['posts'] = array_unique($data['posts']);
                $data['posts'] = array_values($data['posts']);
            } else {
                $data['posts'] = [
                    'Default'
                ];
            }

            if (is_array($option_links) && !empty($option_links)) {
                if (!in_array('Default', $data['links'])) {
                    $data['links'][] = 'Default';
                }
                $data['links'] = array_merge($data['links'], array_keys($option_links));
                $data['links'] = array_unique($data['links']);
                $data['links'] = array_values($data['links']);
            } else {
                $data['links'] = [
                    'Default'
                ];
            }

            XAG_Init::json('success', 'Successfully loaded SILO names.', $data);
        }

        public static function saveSilo ()
        {
            $name = sanitize_text_field($_POST['name']);
            $silo = $_POST['silo'];
            $type = $_POST['type'];

            // Get the SILO
            $option = get_option('prs_silo_' . $type);
            if (!is_array($option)) {
                $option = [];
            }

            $option[$name] = urlencode($silo);

            $silo = json_decode(
                stripslashes($silo),
                TRUE
            );

            if ($type == 'pages') {

                foreach ($silo['links'] as $link) {

                    $child  = $silo['operators'][$link['toOperator']]['properties'];
                    $parent = $silo['operators'][$link['fromOperator']]['properties'];

                    $childID = explode(
                        '-',
                        $child['ID']
                    );
                    $childID = $childID[sizeof($childID) - 1];

                    $parentID = explode(
                        '-',
                        $parent['ID']
                    );
                    $parentID = $parentID[sizeof($parentID) - 1];

                    $post_data = [
                        'ID'          => $childID,
                        'post_parent' => $parentID
                    ];

                    // Update the post into the database
                    wp_update_post($post_data);

                }

            } else if ($type == 'posts') {

                $posts_data = [];

                foreach ($silo['links'] as $link) {

                    $child  = $silo['operators'][$link['fromOperator']]['properties'];
                    $parent = $silo['operators'][$link['toOperator']]['properties'];

                    $childID = explode(
                        '-',
                        $child['ID']
                    );
                    $childID = $childID[sizeof($childID) - 1];

                    $parentID   = explode(
                        '-',
                        $parent['ID']
                    );
                    $parentType = $parentID[sizeof($parentID) - 2];
                    $parentID   = $parentID[sizeof($parentID) - 1];

                    if (!isset($posts_data[$childID])) {
                        $posts_data[$childID] = [
                            'categories' => [],
                            'tags'       => []
                        ];
                    }

                    if ($parentType == 'tag') {
                        $tag                            = get_tag($parentID);
                        $posts_data[$childID]['tags'][] = $tag->name;
                    } else {
                        $posts_data[$childID]['categories'][] = $parentID;
                    }

                }

                foreach ($posts_data as $ID => $data) {

                    wp_set_post_categories(
                        $ID,
                        $data['categories'],
                        FALSE
                    );
                    wp_set_post_tags(
                        $ID,
                        $data['tags'],
                        FALSE
                    );

                }

            }

            if ($type !== 'links') {

                // Loop through the whole silo and find the used IDs
                $_IDS_ = [];

                foreach ($option as $silo) {

                    $silo = json_decode(
                        stripslashes(urldecode($silo)),
                        TRUE
                    );

                    foreach ($silo['operators'] as $operator) {

                        if (!isset($_IDS_[$operator['properties']['type']])) {
                            $_IDS_[$operator['properties']['type']] = [];
                        }

                        $_IDS_[$operator['properties']['type']][] = $operator['properties']['realID'];

                        $_IDS_[$operator['properties']['type']] = array_unique($_IDS_[$operator['properties']['type']]);

                    }

                }

                update_option(
                    'prs_silo_ids_' . $type,
                    $_IDS_
                );

            }

            update_option(
                'prs_silo_' . $type,
                $option
            );

            XAG_Init::json(
                'success',
                'Silo changes have been successfully saved.',
                $_IDS_
            );
        }

        public static function loadSilo ()
        {
            $name = sanitize_text_field($_POST['name']);
            $type = $_POST['type'];

            $silo = get_option('prs_silo_' . $type);
            if (!is_array($silo)) $silo = [];

            if (isset($silo[$name])) {

                $silo = $silo[$name];

                $silo = stripslashes(urldecode($silo));

                $silo = json_decode(
                    $silo,
                    TRUE
                );

            } else {

                if ($type == 'pages') {
                    $silo = [
                        'operators' => [],
                        'links'     => [],
                        'settings'  => [

                            'line_thickness' => '2',
                            'line_type'      => '15',
                            'line_color'     => '#6ec2ff',

                            'canvas_size' => '10000'
                        ]
                    ];
                } else if ($type == 'posts') {
                    $silo = [
                        'operators' => [],
                        'links'     => [],
                        'settings'  => [
                            'line_category_thickness' => '2',
                            'line_category_type'      => '15',
                            'line_category_color'     => '#6ec2ff',
                            'box_category_color'      => '#d7eeff',

                            'line_tag_thickness' => '2',
                            'line_tag_type'      => '15',
                            'line_tag_color'     => '#989898',
                            'box_tag_color'      => '#f1f1f1',

                            'canvas_size' => '10000'
                        ]
                    ];
                } else if ($type == 'links') {
                    $silo = [
                        'operators' => [],
                        'links'     => [],
                        'settings'  => [
                            'internal_line_thickness' => '2',
                            'internal_line_type'      => '15',
                            'internal_line_color'     => '#6ec2ff',

                            'external_line_thickness' => '2',
                            'external_line_type'      => '15',
                            'external_line_color'     => '#ff3c3c',
                            'external_color'          => '#ff3c3c',

                            'canvas_size' => '10000'
                        ]
                    ];
                }

            }

            if ($type == 'pages') {

                for ($i = 0; $i < sizeof($silo['operators']); $i++) {
                    $silo['operators'][$i]['properties']['permalink'] = get_permalink(
                        $silo['operators'][$i]['properties']['realID']
                    );
                    $silo['operators'][$i]['properties']['title']     = get_the_title(
                        $silo['operators'][$i]['properties']['realID']
                    );
                }

            } else if ($type == 'posts') {

                for ($i = 0; $i < sizeof($silo['operators']); $i++) {

                    if ($silo['operators'][$i]['properties']['type'] != 'post') {
                        $silo['operators'][$i]['properties']['title']     = get_term(
                            $silo['operators'][$i]['properties']['realID']
                        )->name;
                        $silo['operators'][$i]['properties']['permalink'] = get_term_link(
                            $silo['operators'][$i]['properties']['realID']
                        );
                    } else {
                        $silo['operators'][$i]['properties']['title']     = get_the_title(
                            $silo['operators'][$i]['properties']['realID']
                        );
                        $silo['operators'][$i]['properties']['permalink'] = get_permalink(
                            $silo['operators'][$i]['properties']['realID']
                        );
                    }

                }

            }

            if ($type !== 'links') {

                $_IDS_ = get_option('prs_silo_ids_' . $type);

                $silo['IDS'] = $_IDS_;

            }

            XAG_Init::json(
                'success',
                'Silo has been loaded successfully.',
                $silo
            );

        }

        public static function addNewPagePost ()
        {
            $user_id = get_current_user_id();
            $title   = $_POST['title'];
            $content = $_POST['content'];
            $status  = $_POST['status'];
            $type    = $_POST['type'];
            $url     = $_POST['url'];

            $post_data = [
                'post_title'   => $title,
                'post_content' => $content,
                'post_status'  => $status,
                'post_author'  => $user_id,
                'post_type'    => $type,
                'post_name'    => $url
            ];

            wp_insert_post($post_data);
        }

        public static function deletePage ()
        {
            $id = $_POST['id'];
            wp_delete_post($id);
        }

        public static function deleteTag ()
        {
            $id = $_POST['id'];
            wp_delete_term(
                $id,
                'post_tag'
            );
        }

        public static function deleteCategory ()
        {
            $id = $_POST['id'];
            wp_delete_category($id);
        }

        public static function getOperatorData ()
        {
            $id   = abs($_POST['id']);
            $type = sanitize_text_field($_POST['type']);
            $data = [];

            if ($type == 'category' || $type == 'tag') {

                $term       = get_term($id);
                $data['h1'] = $term->name;
                $data['title'] = get_term_meta($id, 'term_seo_title', TRUE);
                $data['desc']  = get_term_meta($id, 'term_seo_description', TRUE);
                $data['slug']  = $term->slug;


            } else {

                $post          = get_post($id);
                $data['h1']    = $post->post_title;
                $data['title'] = get_post_meta($id, 'ps_seo_title', TRUE);
                $data['desc']  = get_post_meta($id, 'ps_seo_description', TRUE);
                $data['slug']  = $post->post_name;


            }

            XAG_Init::json(
                'success',
                'Loaded operator data #' . $id,
                $data
            );
        }

        public static function updateOperatorData ()
        {
            $id   = abs($_POST['id']);
            $type = sanitize_text_field($_POST['type']);

            $h1    = urldecode($_POST['h1']);
            $title = urldecode($_POST['title']);
            $desc  = urldecode($_POST['desc']);
            $slug  = $_POST['slug'];

            if ($type == 'category' || $type == 'tag') {

                update_term_meta($id, 'term_seo_title', $title);
                update_term_meta($id, 'term_seo_description', $desc);

                $term_update = [
                    'name' => $h1
                ];

                if (!empty($slug)) {
                    $term_update['slug'] = sanitize_title($slug);
                }

                wp_update_term(
                    $id,
                    (($type == 'category') ? $type : 'post_tag'),
                    $term_update
                );

            } else {

                update_post_meta($id, 'ps_seo_title', $title);
                update_post_meta($id, 'ps_seo_description', $desc);

                $post_update = [
                    'ID'         => $id,
                    'post_title' => $h1
                ];

                if (!empty($slug)) {
                    $post_update['post_name'] = sanitize_title($slug);
                }

                wp_update_post($post_update);

            }
        }

        public static function _updateOperators ($operators, $type)
        {
            $operators['operators'] = array_values($operators['operators']);
            $operators['links']     = array_values($operators['links']);
            update_option(
                ($type == 'page') ? 'prs_silo_pages' : 'prs_silo_posts',
                urlencode(json_encode($operators))
            );
        }

        public static function _getOperators ($type)
        {
            $operators = get_option(($type == 'page') ? 'prs_silo_pages' : 'prs_silo_posts');
            $operators = urldecode($operators);
            $operators = stripslashes($operators);
            $operators = json_decode(
                $operators,
                TRUE
            );
            return $operators;
        }

        public static function _removeOperator (&$operators, $operator_id, $type = 'toOperator')
        {
            $newLinks = [];
            for ($i = 0; $i < sizeof($operators['links']); $i++) {
                if ($operators['links'][$i][$type] != $operator_id) {
                    $newLinks[] = $operators['links'][$i];
                }
            }
            $operators['links'] = $newLinks;

            // can't do this, will cause a shitload of problems
            // unset($operators['operators'][$operator_id]);
        }

        public static function _hasChildren ($operators, $operator_id)
        {
            $hasChildren = FALSE;
            for ($i = 0; $i < sizeof($operators['links']); $i++) {
                if ($operators['links'][$i]['toOperator'] == $operator_id) {
                    $hasChildren = TRUE;
                    break;
                }
            }
            return $hasChildren;
        }

        public static function _findOperator ($operators, $type, $id)
        {
            for ($i = 0; $i < sizeof($operators['operators']); $i++) {
                if (
                    $operators['operators'][$i]['properties']['realID'] == $id &&
                    $operators['operators'][$i]['properties']['type'] == $type
                ) {
                    return $i;
                }
            }
            return NULL;
        }
    }

}
