<?php

if ( ! class_exists( 'MXAG_Sync' ) ) {

	class MXAG_Sync {

		public static function initialize() {

			add_action('xag_getAPIKeys', array('MXAG_Sync', 'getAPIKeys'));
			if (! wp_next_scheduled ( 'xag_getAPIKeys' )) {
				wp_schedule_event(time(), 'daily', 'xag_getAPIKeys');
			}

			add_action('xag_getBackupSettings', array('MXAG_Sync', 'getBackupSettings'));
			if (! wp_next_scheduled ( 'xag_getBackupSettings' )) {
				wp_schedule_event(time(), 'daily', 'xag_getBackupSettings');
			}

			add_action('xag_getSharedScripts', array('MXAG_Sync', 'getSharedScripts'));
			if (! wp_next_scheduled ( 'xag_getSharedScripts' )) {
				wp_schedule_event(time(), 'daily', 'xag_getSharedScripts');
			}
		}

		public static function getSharedScripts() {
			$http_code = 0;
			$result    = MXAG_Api::apiRequest(
				$endpoint = 'info',
				$method   = 'GET',
				array(
					'type' => 'shared_scripts',
				),
				$http_code
			);

			if ($http_code == 200) {
				update_option('ps_shared_scripts', $result['shared_scripts']);
			}
		}

		public static function getBackupSettings() {
			$http_code = 0;
			$result    = MXAG_Api::apiRequest(
				$endpoint = 'info',
				$method   = 'GET',
				array(
					'type' => 'backup_settings',
				),
				$http_code
			);

			if ($http_code == 200) {
				update_option('ps_backup_settings', $result['backup_settings']);
			}
		}

        public static function getAPIKeys(){
	        $http_code = 0;
	        $result    = MXAG_Api::apiRequest(
		        $endpoint = 'info',
		        $method   = 'GET',
		        array(
			        'type' => 'api_settings',
		        ),
		        $http_code
	        );

            if ($http_code == 200) {
	            update_option('ps_api_settings', $result['api_settings']);
            }
        }

	}
}