<?php

if ( ! class_exists( 'MXAG_Tinymce_buttons' ) ) {

	class MXAG_Tinymce_buttons {

		public static function initialize() {
			// Fix shitty elementor editor on frontend - don't load TinyMCE plugin when using Elementor editor
			if ( isset($_GET['elementor']) ) return;
            if ( isset($_GET['action']) ) {
                if ( $_GET['action'] == 'elementor' ) {
                    return;
                }
            }

			// Fix for Thrive editor (/?tve=true) when editing page
			// if tve is not set and if it's not on true, load plugin
			if ( isset($_GET['tve']) ) return;

			// Check if the page is set
			if (isset($_GET['page'])) {

				// Fix for Optimize Press page builder - don't load our tinymce plugin on their Live Editor
				if ($_GET['page'] == 'optimizepress-page-builder') return;

				// Again Thrive Apprentice conflict
				if ($_GET['page'] == 'tva_dashboard') return;

			}


			add_filter("mce_external_plugins",            array('MXAG_Tinymce_buttons', 'addPlugin'));
			add_filter('mce_buttons',                     array('MXAG_Tinymce_buttons', 'registerButtons'));
			add_action('admin_enqueue_scripts',           array('MXAG_Tinymce_buttons', 'loadAssets'), 10, 1 );
			add_action('admin_post_xag_pixabay_download', array('MXAG_Tinymce_buttons', 'pixabayDownloadImage'));

		}

		public static function loadAssets() {
		    global $post_type;

            if ( $post_type === 'page' || $post_type === 'post' || $post_type === 'product' )
		    {
                wp_localize_script( 'xag_admin', 'xag_tinymce_data',
                    array(
                        'shortcodes' => MXAG_Shortcodes::getAllData('xag_shortcodes'),
                        'keywords'   => self::getKeywords()
                    )
                );
            }
		}

		public static function pixabayDownloadImage() {

			// Load PEL Exif Class
			$aClass = XAG_PATH.'/ext/Pel/autoload.php';
			if (file_exists($aClass)) {
				require_once ( $aClass );
			} else {
				XAG_Init::json('error', 'Cannot load PEL Exif Class.');
			}

			$p         = $_POST;
			$uploads   = wp_upload_dir();
			$image_url = $p['img'];
			$name      = $p['title'] . '.jpg';

			$filename            = wp_unique_filename( $uploads['path'], $name, $unique_filename_callback = null );
			$wp_file_type        = wp_check_filetype( $filename, null );
			$full_path_file_name = $uploads['path'] . "/" . $filename;

			$image_string = self::fetch_image( $image_url );

			$fileSaved = file_put_contents( $uploads['path'] . "/" . $filename, $image_string );
			if ( ! $fileSaved ) {
				XAG_Init::json('error', 'Cannot save this selected image to server. Please contact support.');
			}

			$attachment = array(
				'post_mime_type' => $wp_file_type['type'],
				'post_title'     => preg_replace( '/\.[^.]+$/', '', $filename ),
				'post_content'   => '',
				'post_status'    => 'inherit',
				'guid'           => $uploads['url'] . "/" . $filename
			);
			$attach_id  = wp_insert_attachment( $attachment, $full_path_file_name, 0 );
			if ( ! $attach_id ) {
				XAG_Init::json('error', 'Failed save this selected image into the database. Please contact support.');
			}
			require_once( ABSPATH . 'wp-admin/includes/image.php' );
			$attach_data = wp_generate_attachment_metadata( $attach_id, $full_path_file_name );
			wp_update_attachment_metadata( $attach_id, $attach_data );

			// Write EXIF
			if ( ! empty( $p['lat'] ) || ! empty( $p['lon'] ) || ! empty( $p['desc'] ) ) {

				MXAG_Exif::writeEXIF( get_attached_file( $attach_id ), $p['lat'], $p['lon'], $p['desc'] );

				$dir  = str_replace( basename( get_attached_file( $attach_id ) ), '', get_attached_file( $attach_id ) );
				$meta = wp_get_attachment_metadata( $attach_id );

				foreach ( $meta['sizes'] as $f ) {
					MXAG_Exif::writeEXIF( $dir . $f['file'], $p['lat'], $p['lon'], $p['desc'] );
				}

			}

			XAG_Init::jsonc( array(
				'status'  => 'success',
				'message' => 'Image successfully downloaded.',
				'data'    => $attach_data,
				'id'      => $attach_id
			) );
		}

		/**
		Function for downloading Pixabay images
		 */
		public static function fetch_image($url) {
			if ( function_exists("curl_init") ) {
				return self::curl_fetch_image($url);
			} elseif ( ini_get("allow_url_fopen") ) {
				return self::fopen_fetch_image($url);
			}
		}
		public static function curl_fetch_image($url) {
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			$image = curl_exec($ch);
			curl_close($ch);
			return $image;
		}
		public static  function fopen_fetch_image($url) {
			$image = file_get_contents($url, false);
			return $image;
		}


		public static function addPlugin($plugin_array) {
            global $post_type;

            if ( $post_type === 'page' || $post_type === 'post' || $post_type === 'product' ) {
                $plugin_array['xag_keywords']   = XAG_URL . 'assets/js/tinymce_buttons/xag_keywords.js';
                $plugin_array['xag_shortcodes'] = XAG_URL . 'assets/js/tinymce_buttons/xag_shortcodes.js';
                $plugin_array['xag_youtube']    = XAG_URL . 'assets/js/tinymce_buttons/xag_youtube.js';
                $plugin_array['xag_pixabay']    = XAG_URL . 'assets/js/tinymce_buttons/xag_pixabay.js';
            }

            return $plugin_array;
		}

		public static function registerButtons($buttons) {

            global $post_type;

            if ( $post_type === 'page' || $post_type === 'post' || $post_type === 'product' ) {
                array_push($buttons, "xag_keywords");
                array_push($buttons, "xag_shortcodes");
                array_push($buttons, "xag_youtube");
                array_push($buttons, "xag_pixabay");
            }

            return $buttons;
		}

		public static function getKeywords() {
			$formatted = array();
			$data = MXAG_Keywords::query("
						SELECT
							prs_keywords.id,
							prs_keywords.keyword,
							prs_groups.url,
							prs_groups.group_name												
						FROM prs_keywords JOIN prs_groups ON prs_groups.id = prs_keywords.group_id
						ORDER BY prs_keywords.keyword ASC
					");
			if (sizeof($data) > 0) {
				foreach ($data as $d) {
					if ($d['keyword'] != '') {
						$d['url'] = sanitize_title_with_dashes($d['url']);
						$formatted[$d['group_name']][] = $d;
					}
				}
			}

			return $formatted;
		}


	}
}