<?php

if ( ! class_exists( 'MXAG_Troubleshooting' ) ) {

	class MXAG_Troubleshooting extends MXAG_Model {

		public static function initialize() {
			add_action('admin_post_xag_troubleshooting', array('MXAG_Troubleshooting', 'doTroubleshooting'));
		}

		public static function doTroubleshooting() {
			$status_messages = array();

			/**
			 *  Set the memory limit to Unlimited
			 */
			if (isset($_POST['ts_memory_limit'])) {
				if ($_POST['ts_memory_limit'] == 1) {
					update_option('prs_ts_memory_limit', TRUE);
					$status_messages[] = 'Lifted memory limit successfully.';
				} else {
					update_option('prs_ts_memory_limit', FALSE);
				}
			}

			/**
			 *   Regenerate Table Structure
			 */
			if (isset($_POST['ts_update_tables'])) {
				if ($_POST['ts_update_tables'] == 1) {
					XAG_Init::createTables();
					$status_messages[] = 'Updated Table Structure.';
				}
			}

			/**
			 *   Fix Stuck Keywords in Queue
			 */
			if (isset($_POST['ts_fix_queued_keywords'])) {
				if ($_POST['ts_fix_queued_keywords'] == 1) {
					MXAG_Keywords::updateData([
						'queued' => 0
					]);
					$status_messages[] = 'Fixed queued keywords.';
				}
			}

			/**
			 *   Regenerate Table Structure
			 */
			if (isset($_POST['ts_alternative_api'])) {
				$api_file      = XAG_PATH . '/ext/xagio-api.php';
				$root_api_file = ABSPATH . 'xagio-api.php';

				if ($_POST['ts_alternative_api'] == 1) {
					// Drop the file
					$result = self::deployApiFile();
					if ($result == true) {
						update_option('prs_ts_alternative_api', TRUE);
						$status_messages[] = 'Successfully copied V3 API file to the root of your WordPress installation.';
					} else {
						update_option('prs_ts_alternative_api', FALSE);
						$status_messages[] = 'There was a problem while copying V3 API file to the root of your WordPress installation.';
					}
				} else {
					// Remove the file
					self::deployApiFile( true);
					update_option('prs_ts_alternative_api', FALSE);
				}

			}



			XAG_Init::json('success', 'Operation completed!', $status_messages);
		}

		public static function deployApiFile ($remove = false) {
			$api_file      = XAG_PATH . '/ext/xagio-api.php';
			$root_api_file = ABSPATH . 'xagio-api.php';

            if (file_exists($root_api_file)) {
                @unlink($root_api_file);
            }

			if ($remove == false) {
                if (copy($api_file, $root_api_file)) {
                    return true;
                } else {
                    return false;
                }
			}

			return true;
		}

	}

}