<?php
	// Get default templates
	$post_types = get_option('ps_seo_post_types');
	$post_type = $post->post_type;

	$template = @$post_types[$post_type];

	// Load all variables
	$meta = MXAG_Seo::formatMetaVariables(get_post_meta($post->ID));

	$home_url = preg_replace('#^https?://#', '', get_home_url());

/**
 *  SPECIAL FIXES FOR SPECIALLY RETARDED THEMES & PLUGINS
 */
// THRIVE
// ------------------------------------------------------------------------
$custom_fields = get_post_custom($post->ID);
$body = '';
if (isset($custom_fields['tve_save_post_author-focused-homepage'])) {
	$body = $custom_fields['tve_save_post_author-focused-homepage'][0];
	$body = trim(preg_replace('/\s\s+/', ' ', $body));
	$body = preg_replace('~[\r\n]+~', '', $body);
	$body = str_replace("'","\\'", $body);
	echo "<script>var thriveBody = '$body';</script>";
}
// ------------------------------------------------------------------------

/**
 *  SPECIAL FIXES FOR SPECIALLY RETARDED THEMES Divi
 */
/*****************************************************************************/
$custom_fields_divi = get_post($post->ID);
$bodyDivi = '';
if(isset($custom_fields_divi->post_content) && strpos($custom_fields_divi->post_content, '[et_pb_section') !== false) {
    $bodyDivi = $custom_fields_divi->post_content;
	$bodyDivi = trim(preg_replace('/\s\s+/', ' ', $bodyDivi));
	$bodyDivi = preg_replace('~[\r\n]+~', '', $bodyDivi);
	$bodyDivi = str_replace("'","\\'", $bodyDivi);
	$bodyDivi = strip_tags($bodyDivi);
	echo "<script>var DiviBody = '$bodyDivi';</script>";
}
/*****************************************************************************/

?>
<input type="hidden" id="xag_post_id" value="<?=$post->ID;?>"/>

<button type="button" data-target="seo" class="tab-button activated beParent"><i class="fa fa-gears"></i> General</button>
<button type="button" data-target="robots" class="tab-button beParent"><i class="fa fa-bug"></i> Robots</button>
<button type="button" data-target="social" class="tab-button beParent"><i class="fa fa-facebook-square"></i> Social</button>
<button type="button" data-target="schema" class="tab-button beParent"><i class="fa fa-code"></i> Schema</button>
<button type="button" data-target="notes" class="tab-button beParent"><i class="fa fa-file-text"></i> Notes</button>
<button type="button" data-target="scripts" class="tab-button beParent"><i class="fa fa-file-code-o"></i> Scripts</button>

<!-- SEO Enabled -->
<input type="hidden" name="ps_seo_enabled" id="ps_seo_enabled" value="<?php echo (@$meta['ps_seo_enabled'] == 1 || XAG_FORCE_SEO == 1) ? '1' : '0'; ?>"/>

<!-- NoOnce -->
<?php wp_nonce_field( 'xag_nonce_box', 'xag_nonce' ); ?>

<div class="prs-slider-frame beParent">
	<span class="slider-button <?php echo (@$meta['ps_seo_enabled'] == 1 || XAG_FORCE_SEO == 1) ? 'on' : ''; ?>" data-element="ps_seo_enabled"><?php echo (@$meta['ps_seo_enabled'] == 1 || XAG_FORCE_SEO == 1) ? 'ON' : 'OFF'; ?></span>
</div>


<div class="prs-box activated seo">
	<!-- SEO -->
	<div class="tab-box displayed uk-grid uk-grid-collapse">
		<div class="uk-width-large-1-2 uk-width-medium-1-1 uk-width-small-1-1">
			<label class="ps-label"><i class="fa fa-search"></i> Search Engine Results Page - Preview:</label>
			<p class="uk-form-help-block"><span class="uk-badge uk-badge-success"><i class="fa fa-info-circle"></i></span>
				Below you can check how your page will approximately look like on search engines.
			</p>

			<div class="prs-serp left">
				<!-- SEO Title -->
				<input type="hidden" name="ps_seo_title" id="seo_title" value="<?php echo @$meta['ps_seo_title']; ?>"/>
				<div class="prs-editor" data-target="seo_title" id="prs-title" contenteditable="true" placeholder="<?=MXAG_Seo::replaceVars(@$template['title'], $post->ID);?>"><?php echo @$meta['ps_seo_title']; ?></div>

				<!-- SEO URL -->
				<input type="hidden" name="ps_seo_url" value="<?php echo MXAG_Seo::extract_url($post->ID);  ?>"/>
				<div class="prs-editor" id="prs-url" contenteditable="false">
					<?php echo site_url(MXAG_Seo::extract_url($post->ID));  ?>
				</div>

				<!-- SEO Description -->
				<input type="hidden" name="ps_seo_description" id="seo_description" value="<?php echo @$meta['ps_seo_description']; ?>"/>
				<div class="prs-editor" data-target="seo_description" id="prs-description" contenteditable="true" placeholder="<?=MXAG_Seo::replaceVars(@$template['description'], $post->ID);?>"><?php echo @$meta['ps_seo_description']; ?></div>
			</div>

		</div>
		<div class="uk-width-large-1-2 uk-width-medium-1-1 uk-width-small-1-1">

			<label class="ps-label"><i class="fa fa-dashboard"></i> On Page Health Analysis:</label>
			<p class="uk-form-help-block"><span class="uk-badge uk-badge-success"><i class="fa fa-info-circle"></i></span>
				Below you can see the approximate on page SEO health of your current page.
			</p>

			<div class="prs-serp right">
				<div class="uk-grid uk-grid-collapse">
					<div class="uk-width-large-4-10" style="border-right: 1px solid #bcbbbb">
						<label class="ps-label ps-label-block">Target Keyword <i class="fa fa-info-circle" data-uk-tooltip="" title="You can insert a keyword here that you wish to target this post on."></i></label>
						<small class="ps-metric">
							<input type="text" name="ps_seo_keyword" id="seo_keyword" placeholder="eg. cheap cars" value="<?php echo @$meta['ps_seo_keyword']; ?>"/>
						</small>

						<label class="ps-label ps-label-block">Title Length <i class="fa fa-info-circle" data-uk-tooltip="" title="Displays the current number of characters in SEO Title."></i></label>
						<small class="ps-metric">

                            <div class="count-seo-container-left">

                                <i class="fa fa-desktop" data-uk-tooltip="" title="Desktop devices limits."></i>
                                <span class="count-seo-bold">
                                    <span class="count-seo-title">0</span> / 70
                                </span>
                                chars.

                            </div>

                            <div class="count-seo-container-right">

                                <i class="fa fa-mobile" data-uk-tooltip="" title="Mobile devices limits."></i>
                                <span class="count-seo-bold">
                                    <span class="count-seo-title-mobile">0</span> / 78
                                </span>
                                chars.

                            </div>

                            <div class="clear"></div>

                        </small>

						<label class="ps-label ps-label-block">Description Length <i class="fa fa-info-circle" data-uk-tooltip="" title="Displays the current number of characters in SEO Description."></i></label>
						<small class="ps-metric">

                            <div class="count-seo-container-left">

                                <i class="fa fa-desktop" data-uk-tooltip="" title="Desktop devices limits."></i>
                                <span class="count-seo-bold">
                                    <span class="count-seo-description">0</span> / 300
                                </span>
                                chars.

                            </div>

                            <div class="count-seo-container-right">

                                <i class="fa fa-mobile" data-uk-tooltip="" title="Mobile devices limits."></i>
                                <span class="count-seo-bold">
                                    <span class="count-seo-description-mobile">0</span> / 120
                                </span>
                                chars.

                            </div>

                            <div class="clear"></div>

                        </small>

						<label class="ps-label ps-label-block">Keyword Density <i class="fa fa-info-circle" data-uk-tooltip="" title="Displays the percentage of your Target Keyword appearing in your post content."></i></label>
						<small class="ps-metric" style="padding-left: 4px;">

                            <span class="count-seo-bold">
                                <span class="count-seo-density">0</span>
                            </span>

                            Density in Total

                            <span class="count-seo-bold">
                                <span class="count-seo-words">0</span>
                            </span>

                            Words
                        </small>
					</div>
					<div class="uk-width-large-6-10" style="padding-left: 20px">
						<label class="ps-label ps-label-block"><i class="fa fa-edit"></i> Content Analysis</label>
						<ul class="content-ul">
							<li id="xag_ca_keyword_title"></li>
							<li id="xag_ca_keyword_desc"></li>
							<li id="xag_ca_keyword_body"></li>
							<li id="xag_ca_keyword_url"></li>
							<li id="xag_ca_h1_keyword"></li>
							<li id="xag_ca_h2_keyword"></li>
							<li id="xag_ca_h3_keyword"></li>
						</ul>
					</div>
				</div>
			</div>

		</div>
	</div>
</div>
<div class="prs-box robots">
	<!-- Meta -->
	<div class="uk-grid uk-grid-collapse">
		<div class="uk-width-1-2 responsive">
			<label class="ps-label"><i class="fa fa-bug"></i> Meta Robots - Settings:</label>
			<p class="uk-form-help-block"><span class="uk-badge uk-badge-success"><i class="fa fa-info-circle"></i></span>
				Below you can set up what robots your page will display.
			</p>

			<div class="uk-grid uk-grid-collapse uk-grid-form-row">
				<div class="uk-width-1-2">
					<label>Meta Robots State:</label>
				</div>
				<div class="uk-width-1-2">
					<input type="hidden" name="ps_seo_metarobots_enabled" id="seo_robots_enabled" value="<?php echo @$meta['ps_seo_metarobots_enabled']; ?>"/>
					<div class="prs-slider-frame small">
						<span class="seo_robots_enabled slider-button  <?php echo (@$meta['ps_seo_metarobots_enabled']) ? 'on' : ''; ?>" data-element="seo_robots_enabled"><?php echo (@$meta['ps_seo_metarobots_enabled']) ? 'ON' : 'OFF'; ?></span>
					</div>
				</div>
			</div>

			<div class="uk-grid uk-grid-collapse uk-grid-form-row">
				<div class="uk-width-1-2">
					<label for="seo_robots_index">Meta Robots - Index Type:</label>
				</div>
				<div class="uk-width-1-2">
					<select name="ps_seo_metarobots_index" id="seo_robots_index" class="render_select" data-selected="<?php echo @$meta['ps_seo_metarobots_index']; ?>">
						<option value="">–– Select ––</option>
						<option value="index">Index this Page</option>
						<option value="noindex">Do not Index this Page</option>
					</select>
				</div>
			</div>

			<div class="uk-grid uk-grid-collapse uk-grid-form-row">
				<div class="uk-width-1-2">
					<label for="seo_robots_follow">Meta Robots - Follow Type:</label>
				</div>
				<div class="uk-width-1-2">
					<select name="ps_seo_metarobots_follow" id="seo_robots_follow" class="render_select" data-selected="<?php echo @$meta['ps_seo_metarobots_follow']; ?>">
                        <option value="">–– Select ––</option>
                        <option value="follow">Follow this Page</option>
						<option value="nofollow">Do not Follow this Page</option>
					</select>
				</div>
			</div>

			<div class="uk-grid uk-grid-collapse uk-grid-form-row">
				<div class="uk-width-1-1">
					<label for="seo_robots_advanced">Meta Robots - Advanced:</label>

					<select name="ps_seo_metarobots_advanced[]" class="chosen-select" multiple id="seo_robots_advanced" data-selected="<?php echo @$meta['ps_seo_metarobots_advanced']; ?>">
						<option value="noodp">NO ODP</option>
						<option value="noydir">NO YDIR</option>
						<option value="noimageindex">No Image Index</option>
						<option value="noarchive">No Archive</option>
						<option value="nosnippet">No Snippet</option>
					</select>

				</div>
			</div>


		</div>
		<div class="uk-width-1-2 responsive">
			<label class="ps-label"><i class="fa fa-eye"></i> Meta Robots - Preview:</label>
			<p class="uk-form-help-block"><span class="uk-badge uk-badge-success"><i class="fa fa-info-circle"></i></span>
				Below you can see how your meta robots looks like in page source.
			</p>

			<pre class="meta-robots-preview">This is a preview</pre>

			<div class="uk-form-row">
				<label for="seo_canonical">Canonical (Alternative) URL:</label>
				<input placeholder="eg. http://yourwebsite.com/YourDifferentURL" type="text" id="seo_canonical" name="ps_seo_canonical" value="<?php echo @$meta['ps_seo_canonical']; ?>"/>
			</div>

		</div>
	</div>
</div>
<div class="prs-box social">
	<!-- Social -->
	<div class="uk-grid uk-grid-collapse">
        <div class="uk-width-1-1" style="margin-bottom: 20px">
            <div class="uk-form-row" style="background: #e2faff;border-radius: 4px;">
                <span class="uk-badge uk-badge-success"><i class="fa fa-info-circle"></i></span> After SAVING your page with your new Open Graph changes, make sure to visit this url to clear out the old cache in Facebook so that your posts show correctly immediately:
                <a href="https://developers.facebook.com/tools/debug/sharing/?q=<?php echo urlencode(site_url(MXAG_Seo::extract_url($post->ID)));  ?>" target="_blank">Facebook Sharing Tool</a>
            </div>
        </div>
		<div class="uk-width-1-2 responsive">
			<label class="ps-label"><i class="fa fa-twitter-square"></i> Twitter OG Settings:</label>
			<p class="uk-form-help-block"><span class="uk-badge uk-badge-success"><i class="fa fa-info-circle"></i></span>
				Set up how your page will appear when shared on Twitter.
			</p>

			<div class="uk-form-row m-t-10">
				<label for="seo_tw_title">Title:</label>
				<input placeholder="My Title" type="text" id="seo_tw_title" name="ps_seo_tw_title" value="<?php echo @$meta['ps_seo_tw_title']; ?>"/>
			</div>

			<div class="uk-form-row">
				<label for="seo_tw_description">Description:</label>
				<textarea id="seo_tw_description" name="ps_seo_tw_desc" rows="5" placeholder="eg. My Description"><?php echo @$meta['ps_seo_tw_desc']; ?></textarea>
			</div>

			<div class="uk-form-row">
				<label for="seo_tw_image">Image: <button class="uk-button uk-button-mini uk-button-primary imageSelect" type="button" data-target="seo_tw_image">Browse</button></label>
				<input placeholder="eg. http://mywebsite.com/myimage.png" type="text" id="seo_tw_image" name="ps_seo_tw_img" value="<?php echo @$meta['ps_seo_tw_img']; ?>"/>
			</div>

            <div class="uk-form-row" style="height: 383px;">
                <h3><i class="fa fa-image"></i> Preview:</h3>

                <div class="tw_post_preview_holder">
                    <div class="tw_post_preview_img">
                        <a href="" target="_blank">
                            <img src="" style="width: 100%">
                        </a>
                    </div>

                    <div class="tw_post_preview_body">
                        <div class="tw_post_preview_title">Facebook Title</div>
                        <div class="tw_post_preview_desc">Facebook Description</div>
                        <div class="tw_post_preview_host"><?php echo $home_url ?></div>
                    </div>
                </div>
            </div>

		</div>
		<div class="uk-width-1-2 responsive">
			<label class="ps-label"><i class="fa fa-facebook-square"></i> Facebook OG Settings:</label>
			<p class="uk-form-help-block"><span class="uk-badge uk-badge-success"><i class="fa fa-info-circle"></i></span>
				Set up how your page will appear when shared on Facebook.
			</p>

			<div class="uk-form-row m-t-10">
				<label for="seo_fb_app_id">App ID:</label>
				<input placeholder="My App ID" type="text" id="seo_fb_app_id" name="ps_seo_fb_app_id" value="<?php echo @$meta['ps_seo_fb_app_id']; ?>"/>
			</div>

			<div class="uk-form-row m-t-10">
				<label for="seo_fb_title">Title:</label>
				<input placeholder="My Title" type="text" id="seo_fb_title" name="ps_seo_fb_title" value="<?php echo @$meta['ps_seo_fb_title']; ?>"/>
			</div>

			<div class="uk-form-row">
				<label for="seo_fb_description">Description:</label>
				<textarea id="seo_fb_description" name="ps_seo_fb_desc" rows="5" placeholder="eg. My Description"><?php echo @$meta['ps_seo_fb_desc']; ?></textarea>
			</div>

			<div class="uk-form-row">
				<label for="seo_fb_image">Image: <button class="uk-button uk-button-mini uk-button-primary imageSelect" type="button" data-target="seo_fb_image">Browse</button></label>
				<input placeholder="eg. http://mywebsite.com/myimage.png" type="text" id="seo_fb_image" name="ps_seo_fb_img" value="<?php echo @$meta['ps_seo_fb_img']; ?>"/>
			</div>

            <div class="uk-form-row">
                <h3><i class="fa fa-image"></i> Preview:</h3>

                <div class="fb_post_preview_holder">
                    <div class="fb_post_preview_img">
                        <a href="" target="_blank">
                            <img src="">
                        </a>
                    </div>

                    <div class="fb_post_preview_body">
                        <div class="fb_post_preview_title">Facebook Title</div>
                        <div class="fb_post_preview_desc">Facebook Description</div>
                        <div class="fb_post_preview_host"><?php echo $home_url ?></div>
                    </div>
                </div>
            </div>
		</div>
	</div>
</div>
<div class="prs-box schema">
	<!-- Schema -->
	<div class="uk-grid uk-grid-small">
		<div class="uk-width-large-1-3">
			<h1 class="prs-h1"><i class="fa fa-dashboard"></i> Schema Validator</h1>
			<p class="uk-form-help-block"><span class="uk-badge uk-badge-success"><i class="fa fa-info-circle"></i></span>
				Quickly validate Schemas on this page.
			</p>
			<button class="uk-button uk-button-primary uk-width-1-1" type="button" data-url="<?=get_permalink($post->ID); ?>" id="validateSchema"><i class="fa fa-gears"></i> Validate Schema</button>

			<div class="schemaValidationResult">
				<div class="schemaValidationOutput">
					<i class="fa fa-info-circle"></i> Results will be displayed here...
				</div>
			</div>

		</div>
		<div class="uk-width-large-2-3">
			<h1 class="prs-h1"><i class="fa fa-code"></i> Assigned Schemas
                –
                <button class="uk-button uk-button-primary" type="button" data-id="<?=$post->ID;?>" id="renderSchema"><i class="fa fa-code"></i> Render (Preview) Schema</button>
                -
                <button class="uk-button uk-button-primary" type="button" data-id="<?=$post->ID;?>" id="wizardSchema"><i class="fa fa-magic"></i> Schema Wizard</button>
            </h1>
			<p class="uk-form-help-block"><span class="uk-badge uk-badge-success"><i class="fa fa-info-circle"></i></span>
				Assign specific Schemas for this page only.
			</p>

			<?php
				$schemas = MXAG_Schema::getSchemas($post->ID);
				$selectedSchemas = '';
				if (sizeof($schemas) > 0 && $schemas !== false) {
					$selectedSchemas = array();
					foreach($schemas as $s) {
						$selectedSchemas[] = $s['id'];
					}
					$selectedSchemas = join(',', $selectedSchemas);
				}
			?>

			<input type="hidden" name="selectedSchemas" id="selectedSchemas" value="<?=$selectedSchemas;?>"/>
			<div class="schemasForPage">

				<?php if (is_array($schemas) && sizeof($schemas) > 0) { ?>
					<div class="schemaContainer uk-grid uk-grid-small">
					<?php foreach($schemas as $s) { ?>
						<div class="uk-width-1-3">
							<div class="schemaTag" data-name="<?=$s['name'];?>" data-id="<?=$s['id'];?>"><?=$s['name'];?> <br> (<?=$s['type'];?>)
								<a href="#" class="removeSchemaTag"><i class="fa fa-close"></i></a></div>
						</div>
					<?php } ?>
					</div>
					<button class="uk-button uk-button-mini uk-button-primary uk-width-1-3" type="button" id="assignSchema"><i class="fa fa-plus"></i> Assign Schema(s)</button>
				<?php } else { ?>
					<i class="fa fa-info-circle noSchemas"></i> You do not have any Schema(s) assigned for this page. <button class="uk-button uk-button-mini uk-button-primary" type="button" id="assignSchema"><i class="fa fa-plus"></i> Assign Schema(s)</button>
				<?php } ?>

			</div>
		</div>
	</div>
</div>
<div class="prs-box notes">
    <!-- Notes -->
    <div class="uk-grid uk-grid-small">
        <div class="uk-width-large-1-1">
            <label for="ps_seo_notes" class="ps-label"><i class="fa fa-file-text"></i> Notes for this Page/Post:</label>
            <p class="uk-form-help-block"><span class="uk-badge uk-badge-success"><i class="fa fa-info-circle"></i></span>
                Quickly write down anything that may be helpful to know about this particular Page/Post.
            </p>
            <textarea id="ps_seo_notes" rows="5" name="ps_seo_notes"><?php echo @$meta['ps_seo_notes']; ?></textarea>
        </div>
    </div>
</div>
<div class="prs-box scripts">
    <!-- Scripts -->
    <div class="uk-grid uk-grid-small">
        <div class="uk-width-large-1-1">
            <label for="ps_seo_notes" class="ps-label"><i class="fa fa-file-code-o"></i> Custom Scripts for this Page/Post:</label>
            <p class="uk-form-help-block"><span class="uk-badge uk-badge-success"><i class="fa fa-info-circle"></i></span>
                Insert any scripts here that you want to be included to your website globally (include <kbd>&lt;script&gt;</kbd> & <kbd>&lt;/script&gt;</kbd> tags as well).

            </p>
            <input type="hidden" value="0" name="ps_seo_disable_global_scripts"/>
            <input type="hidden" value="0" name="ps_seo_disable_global_footer_scripts"/>
            <input type="hidden" value="0" name="ps_seo_disable_page_scripts"/>

            <br>

            <label id="seo_header_scripts" for="seo_header_scripts"><b>Header Code : </b></label>
            <label for="ps_seo_disable_global_scripts"><input <?php checked(@$meta['ps_seo_disable_global_scripts'], true); ?> type="checkbox" value="1" name="ps_seo_disable_global_scripts" id="ps_seo_disable_global_scripts"> <b>Do not render Global Header Scripts</b></label>
            <label for="ps_seo_disable_page_scripts"><input <?php checked(@$meta['ps_seo_disable_page_scripts'], true); ?> type="checkbox" value="1" name="ps_seo_disable_page_scripts" id="ps_seo_disable_page_scripts"> <b>Stop render header scripts for this page</b></label>
            <!--                                    Changed xag_stripAllSlashes to stripslashes_deep because of Avada Update                                -->
            <textarea id="ps_seo_scripts" rows="6" name="ps_seo_scripts"><?php echo stripslashes_deep(@$meta['ps_seo_scripts']); ?></textarea>

            <label id="seo_footer_scripts" for="seo_footer_scripts"><b>Footer Code : </b></label>
            <label for="ps_seo_disable_global_footer_scripts"><input <?php checked(@$meta['ps_seo_disable_global_footer_scripts'], true); ?> type="checkbox" value="1" name="ps_seo_disable_global_footer_scripts" id="ps_seo_disable_global_footer_scripts"> <b>Do not render Global Footer Scripts</b></label>
            <label for="ps_seo_disable_page_footer_scripts"><input <?php checked(@$meta['ps_seo_disable_page_footer_scripts'], true); ?> type="checkbox" value="1" name="ps_seo_disable_page_footer_scripts" id="ps_seo_disable_page_footer_scripts"> <b>Stop render footer scripts for this page</b></label>
            <textarea id="ps_seo_footer_scripts" rows="6" name="ps_seo_footer_scripts"><?php echo stripslashes_deep(@$meta['ps_seo_footer_scripts']); ?></textarea>
        </div>
    </div>
</div>


<!-- Modal for displaying Rendered Schemas -->
<div class="uk-modal" id="renderSchemasModal">
    <div class="uk-modal-dialog uk-modal-dialog-large">
        <button type="button" class="uk-modal-close uk-close"><i class="fa fa-close"></i></button>
        <div class="uk-modal-header">
            <h1><i class="fa fa-code"></i> Render Schema(s)</h1>
        </div>

        <pre id="renderedSchema"><code class="json"></code></pre>

        <div class="uk-modal-footer">
            <button type="button" class="uk-button uk-button-close-modal"><i class="fa fa-close"></i> Close</button>
        </div>
    </div>
</div>

<!-- Modal for YouTube -->
<div class="uk-modal" id="youtubeModal">
    <div class="uk-modal-dialog">
        <div class="uk-modal-header">
            <h1><i class="fa fa-youtube"></i> YouTube - search for videos</h1></div>
        <div class="xag_youtube_search">
            <div class="uk-input-group">
                <input class="uk-input" type="text" id="xag_youtube_query" placeholder="type in your search query..." />
                <button type="button" id="xag_youtube_search" class="uk-input-button"><i class="fa fa-search"></i></button>
            </div>
            <div class="xag_youtube_results"><span class="xag_youtube_results_msg"><i class="fa fa-info-circle"></i> Your search results will appear here.</span></div>
            <div class="xag_youtube_pagination" style="display: none">
                <input type="hidden" id="xag_youtube_prev_page" value="">
                <input type="hidden" id="xag_youtube_next_page" value="">
                <input type="hidden" id="xag_youtube_curr_page" value="">
                <ul class="uk-pagination">
                    <li class="uk-pagination-previous"><a href="#" class="xag_youtube_prev"><i class="fa fa-backward"></i> Previous</a></li>
                    <li class="uk-pagination-next"><a href="#" class="xag_youtube_next">Next <i class="fa fa-forward"></i></a></li>
                </ul>
            </div>
        </div>
        <div class="xag_youtube_video" style="display: none">
            <button class="uk-button uk-button-mini xag_youtube_back" type="button"><i class="fa fa-backward"></i> Go Back</button>
            <input type="hidden" id="xag_youtube_id" />
            <div class="xag_youtube_preview"><img src="/wp-content/plugins/xagio/assets/img/videoPlaceholder.jpg" /></div>
            <div class="uk-grid uk-grid-small">
                <div class="uk-width-medium-3-5">
                    <div class="input-container">
                        <label for="xag_youtube_title" class="input-label">Title:</label>
                        <input id="xag_youtube_title" type="text" class="input-tag" disabled>
                    </div>
                    <div class="input-container">
                        <label for="xag_youtube_url" class="input-label">URL:</label>
                        <input id="xag_youtube_url" type="text" class="input-tag" disabled>
                    </div>
                </div>
                <div class="uk-width-medium-1-5">
                    <div class="input-container">
                        <label for="xag_youtube_width" class="input-label">Width:</label>
                        <input id="xag_youtube_width" type="number" class="input-tag" placeholder="eg. 640" value="560">
                    </div>
                    <div class="input-container">
                        <label for="xag_youtube_height" class="input-label">Height:</label>
                        <input id="xag_youtube_height" type="number" class="input-tag" placeholder="eg. 480" value="315">
                    </div>
                </div>
                <div class="uk-width-medium-1-5">
                    <div class="slider-container">
                        <label class="slider-label">Autoplay <i class="fa fa-info-circle"></i></label>
                        <div class="prs-slider-frame ">
                            <input type="hidden" id="xag_youtube_autoplay" value="0" /><span class="slider-button" data-element="xag_youtube_autoplay">OFF</span></div>
                        <div class="slider-clear"></div>
                    </div>
                    <div class="slider-container">
                        <label class="slider-label">Strip <i class="fa fa-info-circle"></i></label>
                        <div class="prs-slider-frame">
                            <input type="hidden" id="xag_youtube_strip" value="0" /><span class="slider-button" data-element="xag_youtube_strip">OFF</span></div>
                        <div class="slider-clear"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="uk-modal-footer">
            <button type="button" class="uk-button uk-button-close-modal"><i class="fa fa-close"></i> Close</button>
            <button type="button" class="uk-button uk-button-primary xag_youtube_insert" style="display: none;"><i class="fa fa-plus"></i> Insert Video</button>
        </div>
    </div>
</div>

<!-- Modal for PixaBay -->
<div class="uk-modal" id="pixabayModal">
    <div class="uk-modal-dialog uk-modal-dialog-large">
        <div class="uk-modal-header">
            <h1><i class="fa fa-image"></i> Pixabay - search for images</h1></div>
        <div class="xag_pixabay_search_area">
            <div class="uk-input-group">
                <input class="uk-input" type="text" id="xag_pixabay_query" placeholder="type in your search query..." />
                <button type="button" id="xag_pixabay_search" class="uk-input-button"><i class="fa fa-search"></i></button>
            </div>
            <div class="xag_pixabay_results"><span class="xag_pixabay_results_msg"><i class="fa fa-info-circle"></i> Your search results will appear here.</span></div>
        </div>
        <div class="xag_pixabay_image_area" style="display: none;">
            <button class="uk-button uk-button-mini xag_pixabay_back" type="button"><i class="fa fa-backward"></i> Go Back</button>
            <div class="xag_pixabay_image_container"><img src="" class="xag_pixabay_image_selected" /></div>
            <div class="input-container">
                <label for="xag_pixabay_image_title" class="input-label">Image Title:</label>
                <input id="xag_pixabay_image_title" type="text" class="input-tag" placeholder="eg. My Image Title">
            </div>
            <div class="input-container">
                <label for="xag_pixabay_image_alt" class="input-label">Image Alt:</label>
                <input id="xag_pixabay_image_alt" type="text" class="input-tag" placeholder="eg. My Image Title #2">
            </div>
            <div class="uk-accordion" data-uk-accordion="{showfirst: false}">
                <h3 class="uk-accordion-title"><i class="fa fa-map-marker"></i> EXIF Information</h3>
                <div class="uk-accordion-content">
                    <div class="uk-input-group">
                        <input class="uk-input" type="text" id="xag_pixabay_exif_search" placeholder="type in your address to search maps..." />
                        <button type="button" id="xag_pixabay_search_maps" class="uk-input-button"><i class="fa fa-search"></i></button>
                    </div>
                    <div id="xag_pixabay_map"></div>
                    <div class="uk-grid">
                        <div class="uk-width-medium-1-2">
                            <div class="input-container">
                                <label for="xag_pixabay_exif_latitude" class="input-label">Latitude:</label>
                                <input id="xag_pixabay_exif_latitude" type="text" class="input-tag" placeholder="eg. 32.4564">
                            </div>
                        </div>
                        <div class="uk-width-medium-1-2">
                            <div class="input-container">
                                <label for="xag_pixabay_exif_longtitude" class="input-label">Longtitude:</label>
                                <input id="xag_pixabay_exif_longtitude" type="text" class="input-tag" placeholder="eg. -117.15464">
                            </div>
                        </div>
                    </div>
                    <div class="input-container">
                        <label for="xag_pixabay_exif_description" class="input-label">Description:</label>
                        <textarea id="xag_pixabay_exif_description" class="input-tag" placeholder="eg. some information about this image"></textarea>
                    </div>
                </div>
            </div>
        </div>
        <div class="uk-modal-footer">
            <button type="button" class="uk-button uk-button-close-modal"><i class="fa fa-close"></i> Close</button>
            <button type="button" class="uk-button uk-button-primary xag_pixabay_insert" style="display: none;"><i class="fa fa-plus"></i> Insert Video</button>
        </div>
    </div>
</div>

<!-- Schema Wizard Modal -->
<div class="uk-modal" id="wizardSchemaModal">

    <input type="hidden" id="sw_schema_type" value="0"/>
    <input type="hidden" id="sw_post_id" value="0"/>

    <div class="uk-modal-dialog">

        <button type="button" class="uk-modal-close uk-close"><i class="fa fa-close"></i></button>

        <div class="uk-modal-header">
            <h1><i class="fa fa-magic"></i> Schema Wizard</h1>
        </div>

        <div class="swSteps">

            <!-- Pick a Schema -->
            <div class="swStep1">
                <p>
                    <i class="fa fa-info-circle"></i>
                    This wizard will help you quickly generate schemas for certain pages/posts without having to go to Schema Editor and do all the work manually. Simply, select the type of your current page/post, fill in the blanks and schema will be automatically generated for current page/post.
                </p>

                <h2><i class="fa fa-question-circle"></i> What is this post about?</h2>

                <div class="swTypes">

                </div>
            </div>

            <!-- Fill the Fields -->
            <div class="swStep2">
                <p>
                    <i class="fa fa-info-circle"></i>
                    Awesome, you have selected <span class="swSelectedType">...</span> schema type. <br>Now, fill in the blanks and press <b>Next</b> once you're ready.
                </p>

                <div class="swFields">

                </div>
            </div>

            <!-- Name this schema -->
            <div class="swStep3">
                <p>
                    <i class="fa fa-info-circle"></i>
                    <label for="swName">In the field below, set up a unique name by which you will know that this generated schema belongs to this page/post inside of the Schema Editor.</label>
                    <input id="swName" name="swName" placeholder="eg. Web Design services page"/>
                    <label class="ps-info">
                        <i class="fa fa-question-circle"></i> If you want to adjust this generated schema further, press the <b>Generate Schema</b> button below and once the schema is generated, use the
                        Schema Editor from Panel to add more properties & fields according to your needs.
                    </label>
                </p>
            </div>

        </div>

        <div class="uk-modal-footer">
            <button type="button" class="uk-button uk-button-close-modal"><i class="fa fa-close"></i> Cancel</button>
            <button type="button" class="uk-button uk-button-primary swPreviousStep" style="display: none;"><i class="fa fa-arrow-left"></i> Previous</button>
            <button type="button" class="uk-button uk-button-primary swNextStep" style="display: none;"><i class="fa fa-arrow-right"></i> Next</button>
            <button type="button" class="uk-button uk-button-primary swFinish" style="display: none;"><i class="fa fa-gears"></i> Generate Schema</button>
        </div>

    </div>
</div>

<!-- Schema Assign Modal -->
<div class="uk-modal" id="remoteSchemas">
	<div class="uk-modal-dialog">
        <button type="button" class="uk-modal-close uk-close"><i class="fa fa-close"></i></button>
		<div class="uk-modal-header">
			<h1><i class="fa fa-home"></i> Local Schema(s) </h1>
		</div>

        <p>
            <i class="fa fa-info-circle text-info"></i>
            Below are the schemas that you have created using Schema Editor on Panel.
            Press the <i class="fa fa-arrow-down"></i> icon next to schema to assign it.
        </p>

        <div class="schema-actions">

            <input type="search" class="table-actions-input manage-schema-search" placeholder="Search Schemas..."/>

            <span class="split-actions">|</span>

	        <?php
	            $domain = site_url();
	            $domain = parse_url($domain);
	            $domain = $domain['host']
	        ?>
            <select data-default-group="<?php echo $domain; ?>" class="table-actions-input manage-schema-groups">
                <option value="">– Schema Group –</option>
            </select>

            <span class="split-actions">|</span>

            <select class="table-actions-input manage-schema-types">
                <option value="">– Schema Type –</option>
            </select>


        </div>

        <div class="schema-box">

            <div class="schema-container-title">

                <div class="uk-pull-left">
                    <i class="fa fa-search"></i> Found <b class="schema-count">...</b> Schemas
                </div>

                <div class="uk-pull-right">
                    <a href="#" class="schema-toggle-collapse" data-value="expanded"><i class="fa fa-magic"></i> Toggle Folding</a>
                </div>

                <div class="uk-clear"></div>

            </div>

            <div class="schema-container localSchemas">

            </div>

        </div>

		<div class="uk-modal-footer">

            <button type="button" class="uk-button uk-button-close-modal"><i class="fa fa-close"></i> Close</button>

		</div>
	</div>
</div>

<!-- Schema tag templates -->
<div class="schema-type-container template">

    <h4>
        <span class="schema-type-container-name">...</span>
        <i class="fa fa-caret-up schema-type-container-toggle"></i>
        <div class="uk-clear"></div>
    </h4>
    <div class="schema-type-container-schemas">

    </div>

</div>
<div class="schema-loading template">
    <h4><i class="fa fa-refresh fa-spin"></i></h4>
    <p>Fetching Schemas ...</p>
</div>
<div class="schema-tag template" data-id="0">

    <div class="schema-name"></div>

    <div class="schema-add" title="Assign this schema to the current page.">
        <i class="fa fa-arrow-down"></i>
    </div>

    <div class="schema-close" title="Unassign this schema from the current page.">
        <i class="fa fa-close"></i>
    </div>

    <div class="uk-clear"></div>
</div>
