<?php
    $id   = $tag->term_id;
    $tax  = $tag->taxonomy;
    $meta = get_option( $tax . '_' . $id);

    // Default Values
    $taxonomies  = get_option('ps_seo_taxonomies');
    $title       = '';
    $description = '';

    if (isset($taxonomies[$tax])) {
        $title       = MXAG_Seo::replaceVars($taxonomies[$tax]['title'], 0, array(
                '%%term_title%%' => $tag->name
        ));
	    $description = MXAG_Seo::replaceVars($taxonomies[$tax]['description'], 0, array(
	            '%%term_title%%' => $tag->name
	    ));
    }

?>

<tr class="form-field ps">
    <th colspan="2">
        <h2>Xagio – On Page SEO</h2>
    </th>
</tr>

<input type="hidden" name="meta[taxonomy]" value="<?php echo $tax;?>"/>

<tr class="form-field ps">
    <th scope="row" valign="top"><label for="term_seo_title">SEO Title</label></th>
    <td>
        <input type="text" name="meta[term_seo_title]" placeholder="<?php echo $title; ?>" id="term_seo_title" size="40" value="<?php echo @$meta['term_seo_title'];?>">
        <p class="description">Title of taxonomy that appears on search engines.</p>

        <small class="ps-metric">

            <div class="count-seo-container-left">

                <i class="fa fa-desktop" data-uk-tooltip="" title="Desktop devices limits."></i>
                <span class="count-seo-bold">
                                    <span class="count-seo-title">0</span> / 70
                                </span>
                chars.

            </div>

            <div class="count-seo-container-right">

                <i class="fa fa-mobile" data-uk-tooltip="" title="Mobile devices limits."></i>
                <span class="count-seo-bold">
                                    <span class="count-seo-title-mobile">0</span> / 78
                                </span>
                chars.

            </div>

            <div class="clear"></div>

        </small>

    </td>
</tr>

<tr class="form-field ps">
    <th valign="top" scope="row"><label for="term_seo_description">SEO Description</label></th>
    <td>
        <textarea name="meta[term_seo_description]" placeholder="<?php echo $description; ?>" id="term_seo_description" rows="5" cols="40"><?php echo @$meta['term_seo_description'];?></textarea>
        <p class="description">Description of taxonomy that appears on search engines.</p>

        <small class="ps-metric">

            <div class="count-seo-container-left">

                <i class="fa fa-desktop" data-uk-tooltip="" title="Desktop devices limits."></i>
                <span class="count-seo-bold">
                                    <span class="count-seo-description">0</span> / 300
                                </span>
                chars.

            </div>

            <div class="count-seo-container-right">

                <i class="fa fa-mobile" data-uk-tooltip="" title="Mobile devices limits."></i>
                <span class="count-seo-bold">
                                    <span class="count-seo-description-mobile">0</span> / 120
                                </span>
                chars.

            </div>

            <div class="clear"></div>

        </small>

    </td>
</tr>

<tr class="form-field ps">
    <th valign="top" scope="row"><label>Don't Index & Follow</label></th>
    <td>
        <label for="term_seo_nofollow">
            <input type="hidden" name="meta[term_seo_nofollow]" value="0">
            <input name="meta[term_seo_nofollow]" type="checkbox" id="term_seo_nofollow" value="1" <?php echo (@$meta['term_seo_nofollow'] == TRUE) ? 'checked' : ''; ?>>
            Enable
        </label>
        <p class="description">Do not index but add meta robots follow.</p>
    </td>
</tr>

<tr class="form-field ps">

    <th colspan="2">

        <div class="">
            <h1 class="prs-h1"><i class="fa fa-code"></i> Assigned Schemas
                <button class="uk-button uk-button-primary uk-pull-right" type="button" data-id="<?php echo $id; ?>" id="renderSchema"><i class="fa fa-code"></i> Render (Preview) Schema</button>
            </h1>
            <p class="uk-form-help-block"><span class="uk-badge uk-badge-success"><i class="fa fa-info-circle"></i></span>
                Assign specific Schemas for this taxonomy only.
            </p>

		    <?php
		    $schemas = MXAG_Schema::getSchemas($id, 'term', $meta);
		    $selectedSchemas = '';
		    if (sizeof($schemas) > 0 && $schemas !== false) {
			    $selectedSchemas = array();
			    foreach($schemas as $s) {
				    $selectedSchemas[] = $s['id'];
			    }
			    $selectedSchemas = join(',', $selectedSchemas);
		    }
		    ?>

            <input type="hidden" name="selectedSchemas" id="selectedSchemas" value="<?=$selectedSchemas;?>"/>
            <div class="schemasForPage">

			    <?php if (is_array($schemas) && sizeof($schemas) > 0) { ?>
                    <div class="schemaContainer uk-grid uk-grid-small">
					    <?php foreach($schemas as $s) { ?>
                            <div class="uk-width-1-3">
                                <div class="schemaTag" data-name="<?=$s['name'];?>" data-id="<?=$s['id'];?>"><?=$s['name'];?> <br> (<?=$s['type'];?>)
                                    <a href="#" class="removeSchemaTag"><i class="fa fa-close"></i></a></div>
                            </div>
					    <?php } ?>
                    </div>
                    <button class="uk-button uk-button-mini uk-button-primary uk-width-1-3" type="button" id="assignSchema"><i class="fa fa-plus"></i> Assign Schema(s)</button>
			    <?php } else { ?>
                    <i class="fa fa-info-circle noSchemas"></i> You do not have any Schema(s) assigned for this taxonomy. <button class="uk-button uk-button-mini uk-button-primary" type="button" id="assignSchema"><i class="fa fa-plus"></i> Assign Schema(s)</button>
			    <?php } ?>

            </div>
        </div>

    </th>

</tr>

<!-- Schema Wizard Modal -->
<div class="uk-modal" id="wizardSchemaModal">

    <input type="hidden" id="sw_schema_type" value="0"/>
    <input type="hidden" id="sw_post_id" value="0"/>

    <div class="uk-modal-dialog">

        <button type="button" class="uk-modal-close uk-close"><i class="fa fa-close"></i></button>

        <div class="uk-modal-header">
            <h1><i class="fa fa-magic"></i> Schema Wizard</h1>
        </div>

        <div class="swSteps">

            <!-- Pick a Schema -->
            <div class="swStep1">
                <p>
                    <i class="fa fa-info-circle"></i>
                    This wizard will help you quickly generate schemas for certain pages/posts without having to go to Schema Editor and do all the work manually. Simply, select the type of your current page/post, fill in the blanks and schema will be automatically generated for current page/post.
                </p>

                <h2><i class="fa fa-question-circle"></i> What is this post about?</h2>

                <div class="swTypes">

                </div>
            </div>

            <!-- Fill the Fields -->
            <div class="swStep2">
                <p>
                    <i class="fa fa-info-circle"></i>
                    Awesome, you have selected <span class="swSelectedType">...</span> schema type. <br>Now, fill in the blanks and press <b>Next</b> once you're ready.
                </p>

                <div class="swFields">

                </div>
            </div>

            <!-- Name this schema -->
            <div class="swStep3">
                <p>
                    <i class="fa fa-info-circle"></i>
                    <label for="swName">In the field below, set up a unique name by which you will know that this generated schema belongs to this page/post inside of the Schema Editor.</label>
                    <input id="swName" name="swName" placeholder="eg. Web Design services page"/>
                    <label class="ps-info">
                        <i class="fa fa-question-circle"></i> If you want to adjust this generated schema further, press the <b>Generate Schema</b> button below and once the schema is generated, use the
                        Schema Editor from Panel to add more properties & fields according to your needs.
                    </label>
                </p>
            </div>

        </div>

        <div class="uk-modal-footer">
            <button type="button" class="uk-button uk-button-close-modal"><i class="fa fa-close"></i> Cancel</button>
            <button type="button" class="uk-button uk-button-primary swPreviousStep" style="display: none;"><i class="fa fa-arrow-left"></i> Previous</button>
            <button type="button" class="uk-button uk-button-primary swNextStep" style="display: none;"><i class="fa fa-arrow-right"></i> Next</button>
            <button type="button" class="uk-button uk-button-primary swFinish" style="display: none;"><i class="fa fa-gears"></i> Generate Schema</button>
        </div>

    </div>
</div>

<!-- Schema Assign Modal -->
<div class="uk-modal" id="remoteSchemas">
    <div class="uk-modal-dialog">
        <button type="button" class="uk-modal-close uk-close"><i class="fa fa-close"></i></button>
        <div class="uk-modal-header">
            <h1><i class="fa fa-home"></i> Local Schema(s) </h1>
        </div>

        <p>
            <i class="fa fa-info-circle text-info"></i>
            Below are the schemas that you have created using Schema Editor on Panel.
            Press the <i class="fa fa-arrow-down"></i> icon next to schema to assign it.
        </p>

        <div class="schema-actions">

            <input type="search" class="table-actions-input manage-schema-search" placeholder="Search Schemas..."/>

            <span class="split-actions">|</span>

			<?php
			$domain = site_url();
			$domain = parse_url($domain);
			$domain = $domain['host']
			?>
            <select data-default-group="<?php echo $domain; ?>" class="table-actions-input manage-schema-groups">
                <option value="">– Schema Group –</option>
            </select>

            <span class="split-actions">|</span>

            <select class="table-actions-input manage-schema-types">
                <option value="">– Schema Type –</option>
            </select>


        </div>

        <div class="schema-box">

            <div class="schema-container-title">

                <div class="uk-pull-left">
                    <i class="fa fa-search"></i> Found <b class="schema-count">...</b> Schemas
                </div>

                <div class="uk-pull-right">
                    <a href="#" class="schema-toggle-collapse" data-value="expanded"><i class="fa fa-magic"></i> Toggle Folding</a>
                </div>

                <div class="uk-clear"></div>

            </div>

            <div class="schema-container localSchemas">

            </div>

        </div>

        <div class="uk-modal-footer">

            <button type="button" class="uk-button uk-button-close-modal"><i class="fa fa-close"></i> Close</button>

        </div>
    </div>
</div>

<!-- Schema tag templates -->
<div class="schema-type-container template">

    <h4>
        <span class="schema-type-container-name">...</span>
        <i class="fa fa-caret-up schema-type-container-toggle"></i>
        <div class="uk-clear"></div>
    </h4>
    <div class="schema-type-container-schemas">

    </div>

</div>
<div class="schema-loading template">
    <h4><i class="fa fa-refresh fa-spin"></i></h4>
    <p>Fetching Schemas ...</p>
</div>
<div class="schema-tag template" data-id="0">

    <div class="schema-name"></div>

    <div class="schema-add" title="Assign this schema to the current page.">
        <i class="fa fa-arrow-down"></i>
    </div>

    <div class="schema-close" title="Unassign this schema from the current page.">
        <i class="fa fa-close"></i>
    </div>

    <div class="uk-clear"></div>
</div>
