<!-- HTML STARTS HERE -->
<?php
$redirect_mask = get_option('prs_redirect_mask');
if ( !$redirect_mask ) $redirect_mask = 'ps_redirect';
?>
<script>
    var redirect_mask = '<?= $redirect_mask ?>';
</script>
<div class="wrap prs" style="max-width: 1200px;margin-left: auto;margin-right: auto;">

    <h2 class="logo-title">
        <span class="logo-title-center">
            <img class="logo-image" src="<?= XAG_URL; ?>assets/img/logo-xagio.png"/>
            Xagio - Link Management
            -
            <small class="hand">Set up how your affiliate links...</small>

            <button type="button" class="uk-button uk-button-success uk-button-show-tutorial" data-page="<?php echo (isset($_GET['page']) && !empty($_GET['page'])) ? $_GET['page'] : ''; ?>"><i class="fa fa-film"></i> Tutorials</button>
        </span>
    </h2>

    <p class="logo-paragraph">
        <b><i class="fa fa-question-circle"></i> What should you do here?</b> From here you can create and manage shortcode affiliate links from different affiliate programs.
    </p>

    <div class="uk-grid uk-grid-small">

        <div class="uk-width-1-1">

            <div class="shortcode-container">

                <ul class="uk-tab uk-tab-big" data-uk-tab="{connect:'#tab-shortcodes'}">
                    <li class="uk-active"><a href=""><i class="fa fa-code"></i> Your Shortcodes</a></li>
                    <li><a href=""><i class="fa fa-code"></i> Mask Settings</a></li>
                </ul>

                <div id="tab-shortcodes" class="uk-switcher">
                    <!--Your Shortcodes-->
                    <div style="padding: 0px;background: #f1f1f1;">
                        <button class="filters-button"><i class="fa fa-filter"></i> Filters</button>
                        <div class="shortcode-filters uk-hidden">
                            <form class="filters uk-form uk-form-stacked">

                                <input type="hidden" name="page" id="page" value="0"/>

                                <div class="uk-grid uk-grid-small">
                                    <div class="uk-width-1-2">
                                        <div class="uk-form-row">
                                            <label class="uk-form-label" for="filter_shortcode">Shortcode:</label>
                                            <div class="uk-form-controls">
                                                <input type="text" name="shortcode" id="filter_shortcode" placeholder="eg. my_shortcode">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="uk-width-1-2">
                                        <div class="uk-form-row">
                                            <label class="uk-form-label" for="filter_title">Title:</label>
                                            <div class="uk-form-controls">
                                                <input type="text" name="title" id="filter_title" placeholder="eg. mytitle">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="uk-grid uk-grid-small">
                                    <div class="uk-width-1-2">
                                        <div class="uk-form-row">
                                            <label class="uk-form-label" for="filter_url">URL:</label>
                                            <div class="uk-form-controls">
                                                <input type="text" name="url" id="filter_url" placeholder="eg. myurl">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="uk-width-1-2">
                                        <div class="uk-form-row">
                                            <label class="uk-form-label" for="filter_group">Group</label>
                                            <div class="uk-form-controls">
                                                <select id="filter_group" name="group">
                                                    <option value="all">All</option>
                                                    <option value="Custom">Custom Shortcodes</option>
                                                    <option value="Clickbank">Clickbank</option>
                                                    <option value="Markethealth">MarketHealth</option>
                                                    <option value="Amazon">Amazon</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="uk-grid uk-grid-small">
                                    <div class="uk-width-1-2">
                                        <div class="uk-form-row">
                                            <div class="uk-form-controls">
                                                <input type="checkbox" name="target_blank" value="1" id="filter_target_blank"> <label for="filter_target_blank">Opens in a New Window</label><br>
                                                <input type="checkbox" name="mask" value="1" id="filter_mask"> <label for="filter_mask">Masked URL</label><br>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="uk-width-1-2">
                                        <div class="uk-form-row">
                                            <div class="uk-form-controls">
                                                <input type="checkbox" name="nofollow" value="1" id="filter_nofollow"> <label for="filter_nofollow">Has No Follow</label><br>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="uk-grid uk-grid-small">
                                    <div class="uk-width-1-1">
                                        <div class="uk-form-row">
                                            <div class="uk-form-controls uk-text-right">
                                                <button type="submit" class="uk-button uk-button-primary uk-button-mini"><i class="fa fa-check"></i> Apply Filters</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </form>
                        </div>

                        <div class="shortcode-body">
                            <h4><i class="fa fa-refresh fa-spin"></i> Loading ...</h4>
                        </div>

                        <div class="shortcode-footer">
                            <button class="uk-button uk-button-primary create-shortcode" data-url="" data-group="Custom"><i class="fa fa-plus"></i> Create Shortcode</button>
                            <ul class="uk-pagination uk-pagination-shortcodes uk-pagination-left"></ul>
                            <div class="uk-clearfix"></div>
                        </div>
                    </div>

                    <!--Shortcode Setup-->
                    <div>
                        <div class="uk-panel">
                            <form id="shortcode_setup">
                                <input type="hidden" name="action" value="xag_save_shortcode_setup">
                                <div class="uk-alert uk-alert-info">
                                    <i class="fa fa-warning"></i> Use field below to edit how your masked URL look like. Default value for masked URL is <b>ps_redirect</b> and now you can change that.
                                    You can also see your masked URL preview, but keep in mind that the best practise is to write something unique like: <b>ps_id</b>, <b>ps_goto</b> etc, because this will be setup
                                    globally and if any other plugin or theme have some functionality bind to for example <b>?id=1</b> it could lead to conflict and unexpected behavior.
                                </div>
                                <div class="uk-form-row">
                                    <label class="uk-form-label" for="redirect_mask"><i class="user-secret"></i> Your URL Mask</label>
                                    <div class="uk-form-controls">
                                        <input type="text" name="redirect_mask" id="redirect_mask" placeholder="eg. ps_redirect" value="<?= $redirect_mask ?>">
                                    </div>
                                </div>

                                <div class="uk-form-row">
                                    <label class="uk-form-label"><i class="user-secret"></i> Masked URL preview:</label>
                                    <code><?= get_site_url(); ?>/?<span class="redirect_mask_preview"><?= $redirect_mask ?></span>=internal-name</code>

                                    <button type="submit" class="uk-button uk-button-primary uk-button-mini save-shortcode-setup pull-right">Save Changes</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>


            </div>

        </div>
    </div>

</div> <!-- .wrap -->

<div class="product uk-hidden">
    <div class="image">
        <img src=""/>
    </div>
    <a target="_blank" href="#" class="name"></a>
    <span class="price"></span>

    <div class="uk-button-dropdown" data-uk-dropdown>

        <!-- This is the button toggling the dropdown -->
        <button class="uk-button uk-button-primary uk-button-mini"><i class="fa fa-plus"></i> Create Shortcode</button>

        <!-- This is the dropdown -->
        <div class="uk-dropdown uk-dropdown-small">
            <ul class="uk-nav uk-nav-dropdown">
                <li><a href="#" class="create-shortcode regular">Regular URL</a></li>
                <li><a href="#" class="create-shortcode asin">ASIN URL</a></li>
            </ul>
        </div>

    </div>

</div>

<!-- Shortcode Template -->
<div class="shortcode uk-hidden">
    <div class="uk-grid uk-grid-small">
        <div class="uk-width-1-1">

            <div class="body">
                <div class="uk-float-left shortcode-link-holder">
                    <span class="name"></span>
                    <a class="url" href="#" target="_blank"></a>
                    <div class="shortcode-actions">
                        <a class="copy-shortcode copy-shortcode-tag" href="#" data-uk-tooltip title="Copy this shortcode"><i class="fa fa-code"></i> Copy Shortcode</a>
                        <span class="divider">|</span>
                        <a class="copy-masked-tag" href="#" data-uk-tooltip title="Copy this shortcode's masked URL."><i class="fa fa-user-secret"></i> Copy Masked URL</a>
                        <span class="divider">|</span>
                        <a class="shortcode-duplicate" href="#" data-uk-tooltip title="Duplicate this shortcode."><i class="fa fa-copy"></i> Duplicate</a>
                    </div>
                </div>

                <div class="uk-float-right">
                    <button data-uk-tooltip title="Edit this shortcode" class="uk-button uk-button-primary shortcode-edit"><i class="fa fa-edit"></i> Edit</button>
                    <button data-uk-tooltip title="Delete this shortcode" class="uk-button uk-button-danger shortcode-delete"><i class="fa fa-trash-o"></i> Delete</button>
                </div>

                <div class="uk-float-right">
                    <div class="uk-clearfix uk-margin-right">
                        <div class="uk-float-right uk-margin-right stats-container">
                            <button data-uk-tooltip title="View tracking chart for this shortcode" class="uk-button shortcode-tracking"><i class="fa fa-bar-chart-o"></i> Shortcode Stats</button>
                            <div class="impressions metrics" data-uk-tooltip title="Impressions for this shortcode">...</div>
                            <div class="unique_clicks metrics" data-uk-tooltip title="Unique Clicks for this shortcode">...</div>
                            <div class="ctr metrics" data-uk-tooltip title="Conversion shown in % for this shortcode">...</div>
                        </div>                    
                    </div>

                    <div class="uk-clearfix uk-margin-right">
                        <div class="uk-float-right uk-margin-right stats-container">
                            <button data-uk-tooltip title="View tracking chart for this masked URL" class="uk-button shortcode-url-tracking"><i class="fa fa-bar-chart-o"></i> Masked URL Stats</button>
                            <div class="url_impressions metrics" data-uk-tooltip title="Impressions for this masked URL">...</div>
                            <div class="url_unique_clicks metrics" data-uk-tooltip title="Unique Clicks for this masked URL">...</div>
                            <div class="url_ctr metrics" data-uk-tooltip title="Conversion shown in % for this masked URL">...</div>
                        </div>                    
                    </div>                    
                </div>

                <div class="uk-clearfix"></div>
            </div>

        </div>
    </div>

    <div class="info uk-hidden">

        <div class="info-box">
            <span class="info-title"><i class="fa fa-link"></i> URL:</span>
            <span class="info-value url">http://google.com</span>
            <div class="uk-clearfix"></div>
        </div>

        <div class="info-box">
            <span class="info-title"><i class="fa fa-comment"></i> Title:</span>
            <span class="info-value title">My Shortcode Info</span>
            <div class="uk-clearfix"></div>
        </div>

        <div class="info-box">
            <span class="info-title"><i class="fa fa-comment"></i> Group:</span>
            <span class="info-value group">Amazon</span>
            <div class="uk-clearfix"></div>
        </div>

        <div class="uk-grid uk-grid-small">
            <div class="uk-width-1-3">
                <div class="tracking-box" id="impressions">
                    <div class="tracking-heading">Impressions</div>
                    <div class="tracking-value"><i class="fa fa-refresh fa-spin"></i></div>
                </div>
            </div>
            <div class="uk-width-1-3">
                <div class="tracking-box" id="unique_clicks">
                    <div class="tracking-heading">Unique Clicks</div>
                    <div class="tracking-value"><i class="fa fa-refresh fa-spin"></i></div>
                </div>
            </div>
            <div class="uk-width-1-3">
                <div class="tracking-box" id="ctr">
                    <div class="tracking-heading">CTR</div>
                    <div class="tracking-value"><i class="fa fa-refresh fa-spin"></i></div>
                </div>
            </div>
        </div>

    </div>

</div>

<!-- Short Code Modal -->

<div id="shortModal" class="uk-modal">
    <input type="hidden" class="ID"/>
    <div class="uk-modal-dialog uk-modal-dialog-small">
        <button type="button" class="uk-modal-close uk-close"></button>
        <div class="uk-modal-header">
            <h2><i class="fa fa-user-secret"></i> Copy Shortcode</h2>
        </div>

        <input type="text" class="uk-input uk-width-1-1" id="shortURL" readonly/>

        <div class="uk-modal-footer uk-text-right">
            <button type="button" class="uk-button uk-button-primary copy-short-url"><i class="fa fa-copy"></i> Copy to Clipboard</button>
            <button type="button" class="uk-button uk-modal-close"><i class="fa fa-close"></i> Close</button>
        </div>

    </div>
</div>

<!-- Masked URL Modal -->
<div id="maskedModal" class="uk-modal">
    <input type="hidden" class="ID"/>
    <div class="uk-modal-dialog uk-modal-dialog-small">
        <button type="button" class="uk-modal-close uk-close"></button>
        <div class="uk-modal-header">
            <h2><i class="fa fa-user-secret"></i> Copy Masked URL</h2>
        </div>

        <input type="text" class="uk-input uk-width-1-1" id="maskedURL" readonly/>

        <div class="uk-modal-footer uk-text-right">
            <button type="button" class="uk-button uk-button-primary copy-masked-url"><i class="fa fa-copy"></i> Copy to Clipboard</button>
            <button type="button" class="uk-button uk-modal-close"><i class="fa fa-close"></i> Close</button>
        </div>

    </div>
</div>

<!-- Tracking Modal -->
<div id="trackingModal" class="uk-modal">
    <input type="hidden" class="ID"/>
    <div class="uk-modal-dialog uk-modal-dialog-large">
        <button type="button" class="uk-modal-close uk-close"></button>
        <div class="uk-modal-header">
            <h2><i class="fa fa-bar-chart-o"></i> Tracking for <b class="shortcode"></b></h2>
        </div>

        <div id="tracking_charts" style="width: 100%; height: 350px;"></div>

        <div class="uk-modal-footer uk-text-right">
            <button type="button" class="uk-button uk-button-danger uk-button-truncate-tracking uk-modal-close"><i class="fa fa-trash-o"></i> Reset Statistics</button>
            <button type="button" class="uk-button uk-modal-close"><i class="fa fa-close"></i> Close</button>
        </div>

    </div>
</div>

<!-- URL Tracking Modal -->
<div id="urlTrackingModal" class="uk-modal">
    <input type="hidden" class="ID"/>
    <div class="uk-modal-dialog uk-modal-dialog-large">
        <button type="button" class="uk-modal-close uk-close"></button>
        <div class="uk-modal-header">
            <h2><i class="fa fa-bar-chart-o"></i> Tracking for <b class="shortcode"></b></h2>
        </div>

        <div id="url_tracking_charts" style="width: 100%; height: 350px;"></div>

        <div class="uk-modal-footer uk-text-right">
            <button type="button" class="uk-button uk-button-danger uk-button-url-truncate-tracking uk-modal-close"><i class="fa fa-trash-o"></i> Reset Statistics</button>
            <button type="button" class="uk-button uk-modal-close"><i class="fa fa-close"></i> Close</button>
        </div>

    </div>
</div>

<!-- Shortcode Modal -->
<div id="shortcodeModal" class="uk-modal">
    <form class="uk-form uk-form-stacked shortcodeForm">
        <input type="hidden" class="id" name="id" value="0"/>
        <input type="hidden" class="group" name="group" value="Custom"/>
        <input type="hidden" name="action" value="xag_saveShortcode"/>
        <div class="uk-modal-dialog">
            <button type="button" class="uk-modal-close uk-close"></button>
            <div class="uk-modal-header">
                <h2>...</h2>
            </div>

            <div class="shortcode-preview">
                <span class="empty">Fill in the fields to preview</span>
            </div>

            <div class="uk-grid uk-grid-small">
                <div class="uk-width-3-5">
                    <div class="uk-form-row">
                        <label class="uk-form-label" for="title"><i class="fa fa-file-text-o"></i> Internal Name: <i class="fa fa-info-circle"></i></label>
                        <div class="uk-form-controls">
                            <input type="text" id="name" name="name" placeholder="eg. myshortcode" pattern="[a-z]{4,}" required>
                            <small class="small-help">(only lowercase letters, minimum 4 characters)</small>
                        </div>
                    </div>
                    <div class="uk-form-row">
                        <label class="uk-form-label" for="shortcode"><i class="fa fa-code"></i> Shortcode: <i class="fa fa-info-circle"></i> <small class="small-help">(format: my_shortcode)</small></label>
                        <div class="uk-form-controls">
                            <input pattern="[a-zA-Z0-9_]{3,}" type="text" id="shortcode" name="shortcode" placeholder="eg. my_shortcode_name" required>
                        </div>
                    </div>
                    <div class="uk-form-row">
                        <label class="uk-form-label" for="title"><i class="fa fa-file-text-o"></i> Title: <i class="fa fa-info-circle"></i></label>
                        <div class="uk-form-controls">
                            <input type="text" id="title" name="title" placeholder="eg. Buy product here!" required>
                        </div>
                    </div>
                    <div class="uk-form-row">
                        <label class="uk-form-label" for="url"><i class="fa fa-globe"></i> URL: <i class="fa fa-info-circle"></i></label>
                        <div class="uk-form-controls">
                            <input type="url" id="url" name="url" placeholder="eg. http://affiliate.com/ref=123" required>
                        </div>
                    </div>
                </div>
                <div class="uk-width-2-5">
                    <div class="uk-form-row">
                        <label class="uk-form-label" for="target_blank"><i class="fa fa-desktop"></i> Open in a new Window</label>
                        <div class="uk-form-controls">
                            <input type="hidden" name="target_blank" id="target_blank" value="0"/>
                            <div class="prs-slider-frame">
                                <span class="slider-button" data-element="target_blank">No</span>
                            </div>
                        </div>
                    </div>
                    <div class="uk-form-row">
                        <label class="uk-form-label" for="nofollow"><i class="fa fa-ban"></i> No Follow Link</label>
                        <div class="uk-form-controls">
                            <input type="hidden" name="nofollow" id="nofollow" value="0"/>
                            <div class="prs-slider-frame">
                                <span class="slider-button" data-element="nofollow">No</span>
                            </div>
                        </div>
                    </div>
                    <div class="uk-form-row">
                        <label class="uk-form-label" for="mask"><i class="fa fa-user-secret"></i> Mask URL</label>
                        <div class="uk-form-controls">
                            <input type="hidden" name="mask" id="mask" value="0"/>
                            <div class="prs-slider-frame">
                                <span class="slider-button" data-element="mask">No</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="uk-grid">
                <div class="uk-width-1-1">
                    <div class="uk-form-row">
                        <label class="uk-form-label" for="image"><i class="fa fa-image"></i> Image:
                            <button type="button" class="uk-button uk-button-primary uk-button-mini imageSelect" data-target="image"><i class="fa fa-folder-open-o"></i> Browse</button>
                            <i class="fa fa-info-circle"></i></label>
                        <div class="uk-form-controls">
                            <input type="url" id="image" name="image" placeholder="eg. http://www.website.com/myimage.png">
                        </div>
                    </div>
                </div>
            </div>

            <div class="uk-modal-footer uk-text-right">
                <button type="submit" class="uk-button uk-button-primary"><i class="fa fa-save"></i> Save</button>
                <button type="button" class="uk-button uk-modal-close">Cancel</button>
            </div>
        </div>
    </form>
</div>

<!-- Tutorials -->
<div id="tutorials" class="uk-modal">
    <div class="uk-modal-dialog uk-modal-dialog-large">
        <button type="button" class="uk-modal-close uk-close"></button>
        <div class="uk-modal-header">
            <h2><i class="fa fa-info-circle"></i> Tutorials</h2>
        </div>
        <div class="uk-modal-body">

        </div>
        <div class="uk-modal-footer uk-text-right">
            <button type="button" class="uk-button uk-modal-close">Close</button>
        </div>
    </div>
</div>

<div class="tut_holder hide">
    <h2 style="margin-top: 20px"></h2>
    <iframe width="100%" height="480" frameborder="0" allowfullscreen="allowfullscreen" mozallowfullscreen="mozallowfullscreen" msallowfullscreen="msallowfullscreen" oallowfullscreen="oallowfullscreen" webkitallowfullscreen="webkitallowfullscreen"
            src="">
    </iframe>
</div>
<!-- Tutorials -->