<style>
	table.CSV_example_table,
	.CSV_example_table th,
	.CSV_example_table td {
	  border-collapse: collapse !important;
	  border: 1px solid black !important;
	}
	.CSV_example_table th,
	.CSV_example_table td {
	  padding: 5px;
	  text-align: center;    
	}
	table.CSV_example_table{
		margin-left:auto;
		margin-right:auto;
	}
    div#wpwrap {
        background: #f5f7fb;
    }
    .footer-buttons button.uk-button {
        background: #082440;
        border-radius: 5px !important;
        box-shadow: 0 2px 2px #dddddd;
        font-weight: normal;
        padding: 7px 20px !important;
        border: none;
    }
    .footer-buttons button.uk-button:hover {
        background: #0c355d;
    }

    table button.uk-button {
        background: #082440;
        border-radius: 5px !important;
        box-shadow: 0 2px 2px #dddddd;
        font-weight: normal;
        padding: 4px 12px !important;
        border: none;
    }
    table button.uk-button:hover {
        background: #0c355d;
    }
    .table-redirects.seopage {
        border: none;
        box-shadow: 0 2px 2px #dddddd;
        border-radius: 5px;
    }
    table input[type=checkbox] {
        width: 20px !important;
        height: 20px !important;
        border-radius: 3px !important;
        box-shadow: 0 1px 1px #dddddd !important;
    }
    .uk-block-xagio table.wp-list-table tbody tr td input[type=checkbox]:checked:before {
        margin: -3px 0 0 -5px !important;
        width: 26px !important;
        content: url("data:image/svg+xml;utf8,%3Csvg%20xmlns%3D%27http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%27%20viewBox%3D%270%200%2020%2020%27%3E%3Cpath%20d%3D%27M14.83%204.89l1.34.94-5.81%208.38H9.02L5.78%209.67l1.34-1.25%202.57%202.4z%27%20fill%3D%27%233582c4%27%2F%3E%3C%2Fsvg%3E") !important;
    }

    .add-new-404-redirect, .open-404-redirect {
        background: #0084E6 !important;
        border-radius: 5px !important;
        box-shadow: 0 2px 2px #dddddd;
        font-weight: normal;
        padding: 4px 9px !important;
        border: none;
    }

    table.logTable {
        border: none;
        box-shadow: 0 2px 2px #dddddd;
        border-radius: 5px;
    }
    .logTable-actions {
        padding: 10px 15px;
    }
    .logTable-actions input.uk-form-small {
        padding: 15px !important;
        border: 1px solid #f3f3fa !important;
        border-radius: 5px !important;
        box-shadow: 0 1px 1px #dddddd !important;
        height: 40px !important;
    }
    .logTable-actions select.uk-form-small {
        padding: 1px 13px !important;
        border: 1px solid #f3f3fa !important;
        border-radius: 5px !important;
        box-shadow: 0 1px 1px #dddddd !important;
        height: 40px !important;
        font-size: 15px;
    }

    .uk-pagination>.uk-disabled>span {
        padding: 5px 23px;
        height: 26px;
        box-shadow: 0 1px 1px 1px rgb(115 121 130 / 13%);
        border: none;
        border-radius: 5px !important;
        line-height: 26px;
    }
    .uk-pagination>li>a, .uk-pagination>.uk-active>span {
        padding: 5px 12px;
        height: 26px;
        box-shadow: 0 1px 1px 1px rgb(115 121 130 / 13%);
        border: none;
        border-radius: 4px !important;
        line-height: 26px;
    }
    #xag_max_log_limit, input[name="xag_global_404_redirections_url"], textarea#ignored-urls-list {
        padding: 15px;
        font-size: 18px;
        border: 1px solid #f3f3fa;
        border-radius: 5px !important;
        box-shadow: 0 1px 1px #dddddd !important;
    }
    textarea#ignored-urls-list {
        border-bottom: 2px solid #0084e3 !important;
    }
    .dataTables_info {
        text-align: right;
    }

</style>
<div class="wrap prs" style="max-width: 1200px;margin-left: auto;margin-right: auto;">

	<h2 class="logo-title">
        <span class="logo-title-center">
            	<img class="logo-image" src="<?= XAG_URL; ?>assets/img/logo-xagio.png"/>
		Xagio - 301 & 404 Management
		-
		<small class="hand">Manage your website redirection & 404 log...</small>
        </span>
	</h2>

	<p class="logo-paragraph uk-block-xagio log-info">
		<b><i class="fa fa-question-circle"></i> What should you do here?</b> Here you can manage your website 301 redirects and 404 monitor.
	</p>

	<ul class="uk-tab uk-tab-big" data-uk-tab="{connect:'#tab-content'}">
		<li class="uk-active"><a href=""><i class="fa fa-refresh"></i> 301 Redirects</a></li>
		<li><a href=""><i class="fa fa-history"></i> 404 Monitor</a></li>
		<li><a href=""><i class="fa fa-cogs"></i> Settings</a></li>
	</ul>

    <div id="tab-content" class="uk-switcher">

		<!-- Mange Redirects -->
        <div>
            <div class="uk-block uk-block-muted uk-block-xagio" style="padding: 0 0 18px 0 !important">
                <table class="wp-list-table widefat fixed dataTable table-redirects seopage" style="box-shadow: none;">
                    <thead>
                    <tr>
                        <th style="width: 20px;" class="uk-text-center"><i class="fa fa-check-square-o select-all-redirects"></i></th>
                        <th style="width: 11%;"><i class="fa fa fa-ban "></i> Ignore Parameters </th>
                        <th style="width: 25%;"><i class="fa fa-globe"></i> URL</th>
                        <th><i class="fa fa-refresh"></i> Redirects to</th>
                        <th style="width: 120px;" class="uk-text-center"><i class="fa fa-calendar"></i> Date Created</th>
                        <th style="width: 160px;" class="uk-text-center"><i class="fa fa-gears"></i> Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr><td colspan="5">Can't find any active redirects.</td></tr>
                    </tbody>
                </table>

                <div class="uk-grid uk-grid-small uk-margin-top footer-buttons" style="padding: 2px 18px">
                    <div class="uk-width-1-2">
                        <button type="button" class="uk-button uk-button-success add-new-redirect"><i class="fa fa-plus"></i> Add New Redirect</button>
                        <div class="upload-btn-wrapper">
                            <button class="uk-button uk-button-success" id="csv_file_modal">Upload CSV File</button>
                            <!-- <input type="file" id="csv_file" name="csv_file" /> -->
                        </div>
                    </div>
                    <div class="uk-width-1-2 uk-text-right">
                        <button type="button" class="uk-button uk-button-danger remove-selected-redirects"><i class="fa fa-trash"></i> Remove Selected Redirects</button>
                        <button type="button" class="uk-button uk-button-danger remove-all-redirects"><i class="fa fa-trash"></i> Remove All Redirects</button>
                    </div>
                </div>
            </div>

            <!-- Add Bulk Redirects By CSV -->
			<div id="csv_modal" class="uk-modal">
				<div class="uk-modal-dialog">

					<button type="button" class="uk-modal-close uk-close"></button>
					<div class="uk-modal-header">
						<h2><i class="fa fa-edit"></i>Upload CSV</h2>
					</div>
					<div class="uk-modal-body">
						<h3 class="uk-modal-title">CSV format needed to import. <i class="fa fa-question-circle"></i></h3>
						<h3 class="uk-modal-title">For example : </h3>
						<table class="CSV_example_table">
						  <tr>
						    <th></th><th>A</th><th>B</th><th>C</th><th>D</th><th>E</th>
						  </tr>
						  <tr>
						    <td>1</td><td>/oldUrl1</td><td>/newurl1</td><td></td><td></td><td></td>
						  </tr>
						  <tr>
						    <td>2</td><td>/oldUrl2</td><td>/newurl2</td><td></td><td></td><td></td>
						  </tr>
						  <tr>
						    <td>3</td><td>/oldUrl3</td><td>/newur3</td><td></td><td></td><td></td>
						  </tr>
						  <tr>
						    <td>4</td><td>/oldUrl4</td><td>/newurl4</td><td></td><td></td><td></td>
						  </tr>
						  <tr>
						    <td>5</td><td>/oldUrl5</td><td>/newurl5</td><td></td><td></td><td></td>
						  </tr>
						  <tr>
						    <td>6</td><td>/oldUrl6</td><td>/newurl6</td><td></td><td></td><td></td>
						  </tr>
						  <tr>
						    <td>7</td><td>/oldUrl7</td><td>/newurl7</td><td></td><td></td><td></td>
						  </tr>
						  <tr>
						    <td>8</td><td></td><td></td><td></td><td></td><td></td>
						  </tr>
						  <tr>
						    <td>9</td><td></td><td></td><td></td><td></td><td></td>
						  </tr>
						  <tr>
						    <td>10</td><td></td><td></td><td></td><td></td><td></td>
						  </tr>
						</table>
				        <p>
				        	<ul>
							  <li><b>*</b> Need only two columns in a single row.</li>
							  <li><b>*</b> The first column( <b>A</b> ) contains the old-URL/ <b>( <i class='fa fa-globe'></i> URL )</b> and the second column( <b>B</b> ) contains the new-URL/ <b>( <i class='fa fa-refresh'></i> Redirects to )</b>.</li>
							</ul>
				    	</p>
				        <div class="upload-btn-wrapper">
	                        <button class="uk-button uk-button-success">Upload CSV Here</button>
	                        <input type="file" id="csv_file" name="csv_file" />
	                    </div>
				    </div>
					<div class="uk-modal-footer uk-text-right">
						<button type="button" class="uk-button uk-modal-close">Cancel</button>
					</div>

				</div>
			</div>

        </div>

		<!-- 404 -->
        <div>
            <div class="uk-block uk-block-muted uk-block-xagio" style="padding: 0 0 18px 0 !important;">
                <table class="wp-list-table widefat fixed logTable" cellspacing="0" width="100%" style="    box-shadow: none;">
                    <thead>
                    <tr>
                        <th style="width: 20px; padding-right: 13px;" class="check-column chkLogCol uk-text-center"><i class="fa fa-check-square-o select-all-log404"></i></th>
                        <th style="width: 50px;" class="column-hits uk-text-center"><i class="fa fa-database"></i> Hits</th>
                        <th style="width: 300px;" class="column-url"><i class="fa fa-globe"></i> 404 URL</th>
                        <th style="width: 90px;" class="column-last-hit uk-text-center"><i class="fa fa-calendar"></i> Last Hit</th>
                        <th style="width: 100px;" class="column-ip uk-text-center"><i class="fa fa-map-marker"></i> IP Addresses</th>
                        <th style="width: 70px;" class="column-referers uk-text-center"><i class="fa fa-refresh"></i> Referers</th>
                        <th style="width: 100px;" class="column-agent uk-text-center"><i class="fa fa-user-secret"></i> User Agents</th>
                        <th style="width: 100px;" class="column-action uk-text-center"><i class="fa fa-gears"></i> Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td colspan="8">Can't find any active logs.</td>
                    </tr>
                    </tbody>
                    <tfoot>
                    </tfoot>
                </table>
                <div class="uk-grid uk-grid-small uk-margin-top footer-buttons" style="padding: 3px 15px;">
                    <div class="uk-width-1-2">
                        <button title="Export 404s Log" type="button" class="uk-button uk-button-success export_404s_log"><i class="fa fa-download"></i> Export Logs</button>
                    </div>
                    <div class="uk-width-1-2 uk-text-right">
                        <button type="button" class="uk-button uk-button-danger remove-selected-log404"><i class="fa fa-trash"></i> Remove Selected Logs</button>
                        <button type="button" class="uk-button uk-button-danger clear-log404"><i class="fa fa-trash"></i> Clear Logs</button>
                    </div>
                </div>
            </div>
        </div>

		<!-- Settings -->
		<div>
            <div class="uk-grid">


            <div class="uk-width-1-1">
                <div class="uk-panel uk-block-muted uk-block-xagio">
                    <h3 class="uk-panel-title"><i class="fa fa-gears"></i> Settings</h3>

                    <form class="frmLogSettings">
				<input type="hidden" name="action" value="xag_log_404s_settings"/>
				<?php wp_nonce_field( 'xag_log_404s_settings', '_wpnonce' ); ?>

				<!-- Enable/Disable 404s log setting -->
				<div class="slider-container">
					<input type="hidden" name="xag_disable_log404s" id="xag_disable_log404s"
						   value="<?= ( XAG_DISABLE_Log404s == true ) ? 1 : 0; ?>"/>
					<div class="prs-slider-frame">
						<span class="slider-button <?= ( XAG_DISABLE_Log404s == true ) ? 'on' : ''; ?>"
							  data-element="xag_disable_log404s"><?= ( XAG_DISABLE_Log404s == true ) ? 'Yes' : 'No'; ?></span>
					</div>
					<p class="slider-label">Disable <b>404's Logs</b> <i
								class="fa fa-info-circle help-icon" data-uk-tooltip
								title="This will enabled/disable track of 404s log monitor."></i>
					</p>
				</div>

				<!-- Enable/Disable 404s spider log -->
				<div class="slider-container">
					<input type="hidden" name="xag_enable_spider404s" id="xag_enable_spider404s"
						   value="<?= ( XAG_ENABLE_SPIDER404s == true ) ? 1 : 0; ?>"/>
					<div class="prs-slider-frame">
						<span class="slider-button <?= ( XAG_ENABLE_SPIDER404s == true ) ? 'on' : ''; ?>"
							  data-element="xag_enable_spider404s"><?= ( XAG_ENABLE_SPIDER404s == true ) ? 'Yes' : 'No'; ?></span>
					</div>
					<p class="slider-label">Log <b>404's</b> From <b>Spider Bot</b> <i
								class="fa fa-info-circle help-icon" data-uk-tooltip
								title="This will enabled/disable track of 404s generated by spider visits."></i>
					</p>
				</div>

				<!-- Enable/Disable 404s with referring URLs -->
				<div class="slider-container">
					<input type="hidden" name="xag_enable_404s_with_referr_url" id="xag_enable_404s_with_referr_url"
						   value="<?= ( XAG_ENABLE_404s_with_REFERR == true ) ? 1 : 0; ?>"/>
					<div class="prs-slider-frame">
						<span class="slider-button <?= ( XAG_ENABLE_404s_with_REFERR == true ) ? 'on' : ''; ?>"
							  data-element="xag_enable_404s_with_referr_url"><?= ( XAG_ENABLE_404s_with_REFERR == true ) ? 'Yes' : 'No'; ?></span>
					</div>
					<p class="slider-label">Log Only <b>404's</b> With <b>Referring URLs</b> <i
								class="fa fa-info-circle help-icon" data-uk-tooltip
								title="This will enabled/disable track of 404s URLs with referring URLs Only."></i>
					</p>
				</div>

				<!-- Set global 404 to 301 redirections -->
				<?php $prsGlobal404RedirectUrl = get_option('prs_global_404_redirections_url'); ?>
				<div class="m-t-20">
                    <label>Global 301 Redirect URL:
                        <i class="fa fa-info-circle" data-uk-tooltip=""
                           title="This will allow to redirect all 404 URLs to this 301 URL (If not added redirect in 301 redirect section) but track of 404s log will not disabled. (DANGER: Creating invalid redirects may result in breaking of your website)"></i>
                    </label>
                    <input type="url" class="uk-input-custom text-left"
                           name="xag_global_404_redirections_url" placeholder="http://testsite.com"
                           value="<?= $prsGlobal404RedirectUrl ? $prsGlobal404RedirectUrl : '' ?>" />
				</div>

				<!-- Select maximum log limit -->
				<?php $prsMaxLogLimit = get_option('prs_max_log_limit'); ?>
				<div class="m-t-20">
                    <label>Maximum Log Entries:
                        <i class="fa fa-info-circle" data-uk-tooltip=""
                           title="This will allow to choose amount of fresh logs to keep before deleting oldest."></i>
                    </label>
                    <input type="text" class="uk-input-custom text-left" id="xag_max_log_limit"
                           name="xag_max_log_limit" placeholder="Set maximum log limit"
                           value="<?= $prsMaxLogLimit ? $prsMaxLogLimit : '' ?>" />
				</div>

				<!-- Ignored URLs -->
				<?php $ignoredUrls = get_option('prs_ignore_404_urls');
				$ignoredUrls = implode("\n", $ignoredUrls); ?>
				<div class="m-t-20">
                    <label>URLs to Ignore:
                        <i class="fa fa-info-circle" data-uk-tooltip=""
                           title="This will allow users to filter out vists to specific filetypes or paths. Insert URLs separated by a new line. (e.g. */xmlrpc.php , *.png)"></i>
                    </label>
                    <span>(e.g. */xmlrpc.php <b>,</b> *.png)</span>
                    <textarea id="ignored-urls-list"
                              name="ignored-urls-list"
                              rows="6"
                              placeholder="e.g. */xmlrpc.php OR */xmlrpc.php/"
                              class="uk-width-1-1"><?= $ignoredUrls ? $ignoredUrls : ''; ?></textarea>
				</div>

				<button type="submit"
						class="uk-button uk-button-primary uk-button-big btn-save-changes">
					<i class="fa fa-save"></i> Save Changes
				</button>

			</form>
            </div>
            </div>
            </div>
		</div>
    </div>

</div>
