<?php
// Set the domain name
$domain = parse_url(admin_url());
$domain = $domain['host'];
$domain = str_replace('www.', '', $domain);
?>

<!-- HTML STARTS HERE -->
<script>
    var domain = "<?php echo $domain ?>";
</script>
<div class="wrap prs">

    <h2 class="logo-title">
        <span class="logo-title-center" style="display: block;max-width: 1200px;margin: auto;padding: 20px 0;">

            <img class="logo-image" src="<?= XAG_URL; ?>assets/img/logo-xagio.png"/>
        Xagio - Projects
        -
        <small class="hand">Manage your projects...</small>

        <button type="button" class="uk-button uk-button-success uk-button-show-tutorial"
                data-page="<?php
                echo (isset($_GET['page']) && !empty($_GET['page'])) ? $_GET['page'] : ''; ?>"><i
                    class="fa fa-film"></i> Tutorials
        </button>

            <!-- This is the container enabling the JavaScript -->
        <div class="uk-button-dropdown settings-button" data-uk-dropdown="{mode:'click'}">

            <!-- This is the button toggling the dropdown -->
            <button class="uk-button uk-button-success"><i class="fa fa-gears"></i> Manage <i
                        class="fa fa-caret-down"></i></button>

            <!-- This is the dropdown -->
            <div class="uk-dropdown uk-dropdown-small">
                <ul class="uk-nav uk-nav-dropdown">
                    <li><a href="#importProject" data-uk-modal class="uk-dropdown-close"><i class="fa fa-download"></i>
                            Import existing Project</a></li>
                    <li class="uk-nav-divider"></li>
                    <li><a href="#conditional-formatting" data-uk-modal class="uk-dropdown-close"><i
                                    class="fa fa-paint-brush"></i> Conditional Formatting</a></li>
                    <li class="uk-nav-divider"></li>
                    <li><a href="#redirects" data-uk-modal class="uk-dropdown-close"><i class="fa fa-refresh"></i>
                            Manage Redirects</a></li>
                    <li class="uk-nav-divider"></li>
                    <li><a href="#" class="uk-text-danger stop-captcha-solving"><i class="fa fa-warning"></i> Abort
                            Captcha Solving</a></li>
                </ul>
            </div>

        </div>

        <button type="button" class="uk-button uk-button-primary new-project"><i class="fa fa-plus"></i> New Project</button>

            <!-- Keyword Volume and CPC scrape -->
        <div class="keyword-volume-scraping-allowance">
            <div class="value">
                <i class="fa fa-refresh fa-spin"></i>
            </div>
            <div class="title" title="This show how many Volume and CPC keywords you can pull monthly.">
                <i class="fa fa-rocket"></i>
            </div>
        </div>

            <!-- Keyword Scraping Allowance -->
        <div class="keyword-scraping-allowance">
            <div class="value">
                <i class="fa fa-refresh fa-spin"></i>
            </div>
            <div class="title" title="This show how many keywords you can scrape until the end of this month.">
                <i class="fa fa-bolt"></i>
            </div>
        </div>
        </span>
    </h2>

    <p class="logo-paragraph uk-block-xagio" style="max-width: 1042px;margin-left: auto;margin-right: auto;">
        <b><i class="fa fa-question-circle"></i> What should you do here?</b> Here you can maintain your Project
        Supremacy projects.
    </p>

    <div class="cloud template hide" style="display: none;"></div>
    <!-- Projects Table -->
    <div class="uk-block uk-block-muted uk-block-xagio projects-table" style="padding-right: 0 !important;padding-left: 0 !important;max-width: 1200px;margin-left: auto;margin-right: auto;">
        <table class="uk-table uk-table-hover pTable" cellspacing="0" width="100%">
            <thead>
            <tr>
                <th class="uk-text-center"><i class="fa fa-reorder"></i> ID</th>
                <th><i class="fa fa-folder"></i> Project Name</th>
                <th class="uk-text-center"><i class="fa fa-clock-o"></i> Created Date</th>
                <th class="uk-text-right"><i class="fa fa-gears"></i> Actions</th>
            </tr>
            </thead>
            <tbody>

            </tbody>
        </table>
    </div>

    <!-- Project Dashboard -->
    <div class="project-dashboard" style="display: none">
        <h1 class="project-name">
            [Project Name]
        </h1>
        <div class="project-actions">

            <div class="uk-float-left">

                <!-- Go back to Projects -->
                <button class="uk-button closeProject"><i class="fa fa-arrow-left"></i> Back to Projects</button>

                <!-- Project Actions -->
                <div class="uk-button-dropdown actions-button" data-uk-dropdown="{mode:'click'}">

                    <!-- This is the button toggling the dropdown -->
                    <button class="uk-button uk-button-success proj_management_actions"><i class="fa fa-gears"></i>
                        Actions <i class="fa fa-caret-down"></i></button>

                    <!-- This is the dropdown -->
                    <div class="uk-dropdown uk-dropdown-small">
                        <ul class="uk-nav uk-nav-dropdown">
                            <li><a href="#" class="addGroup uk-dropdown-close"><i class="fa fa-plus"></i> Add a new Group</a></li>
                            <li><a href="#" class="addGroupFromExisting uk-dropdown-close"><i class="fa fa-plus"></i> Create Group(s) from existing Page/Post</a></li>
                            <li class="uk-nav-divider"></li>
                            <li><a href="#" class="deleteGroups uk-dropdown-close"><i class="fa fa-trash-o"></i> Delete selected Groups</a></li>
                            <li class="uk-nav-divider"></li>
                            <li><a href="#importKeywordPlanner" data-uk-modal class="uk-dropdown-close"><i class="fa fa-download"></i> Import from CSV</a></li>
                            <li><a href="#" class="importKWS uk-dropdown-close"><i class="fa fa-download"></i> Import from KeywordSupremacy.com</a></li>
                            <li class="uk-nav-divider"></li>
                            <li><a href="#" class="automaticallyGenerateGroups uk-dropdown-close"><i class="fa fa-code"></i> Automatically Generate Groups</a></li>
                            <li><a href="#" class="phraseMatch uk-dropdown-close"><i class="fa fa-magic"></i> Phrase Match into a new Project</a></li>
                            <li class="uk-nav-divider"></li>
                            <li><a href="#" class="createPagesPosts uk-dropdown-close"><i class="fa fa-bolt"></i> Create Pages/Posts from current Groups</a></li>
                            <li class="uk-nav-divider"></li>
                            <li><a href="#" class="expandKeywordGroups uk-dropdown-close"><i class="fa fa-expand"></i> Expand Keyword Groups</a></li>
                            <li><a href="#" class="collapseKeywordGroups uk-dropdown-close"><i class="fa fa-compress"></i> Collapse Keyword Groups</a></li>
                            <li><a href="#" class="expandAllGroups uk-dropdown-close"><i class="fa fa-expand"></i> Expand All</a></li>
                            <li><a href="#" class="collapseAllGroups uk-dropdown-close"><i class="fa fa-compress"></i> Collapse All</a></li>
                        </ul>
                    </div>

                </div>

            </div>

            <!-- Filter by Post Types -->
            <div class="uk-float-right">

                <div class="uk-button uk-form-select" data-uk-form-select>
                    <span><i class="fa fa-folder-open-o"></i> Filter by Post Type</span>
                    <select id="filterPostTypes">
                        <option value="">All Types</option>
                    </select>
                </div>

            </div>

            <div class="uk-clearfix"></div>

        </div>

        <div class="project-groups">


            <ul id="groupSort" class="uk-subnav uk-subnav-pill">
                <li class="uk-active" data-uk-sort="name:asc"><a href="#">Ascending</a></li>
                <li data-uk-sort="name:desc"><a href="#">Descending</a></li>
            </ul>

            <div class="uk-grid-width-small-1-1 uk-grid-width-medium-1-2 uk-grid-width-medium-1-2 data" data-uk-grid="{gutter: 20, controls: '#groupSort'}">

            </div>

        </div>

        <div class="project-empty" style="display: none">
            <h3><i class="fa fa-warning"></i> No created groups</h3>
            <p>To get started, please
                <button class="uk-button uk-button-primary uk-button-mini addGroup"><i class="fa fa-plus"></i> Add a
                    Group
                </button>
                to this project.
            </p>
        </div>
    </div>

    <!-- Redirects -->
    <div id="redirects" class="uk-modal">
        <div class="uk-modal-dialog uk-modal-lg">
            <button type="button" class="uk-modal-close uk-close"></button>
            <div class="uk-modal-header">
                <h2><i class="fa fa-refresh"></i> Manage Redirects</h2>
            </div>

            <table class="uk-table uk-table-hover table-redirects">
                <thead>
                <tr>
                    <th><i class="fa fa-globe"></i> URL</th>
                    <th><i class="fa fa-refresh"></i> Redirects to</th>
                    <th><i class="fa fa-gears"></i></th>
                </tr>
                </thead>
                <tbody>
                <tr>
                    <td colspan="4">Can't find any active redirects.</td>
                </tr>
                </tbody>
                <tfoot>
                <tr>
                    <th><i class="fa fa-globe"></i> URL</th>
                    <th><i class="fa fa-refresh"></i> Redirects to</th>
                    <th><i class="fa fa-gears"></i></th>
                </tr>
                </tfoot>
            </table>

            <div class="uk-modal-footer uk-text-right">
                <button type="button" class="uk-button uk-button-success add-new-redirect"><i class="fa fa-plus"></i>
                    Add New Redirect
                </button>
                <button type="button" class="uk-button uk-modal-close">Cancel</button>
            </div>
        </div>
    </div>

    <!-- addGroupFromExisting -->
    <div id="addGroupFromExistingModal" class="uk-modal">
        <div class="uk-modal-dialog uk-modal-no-padding">
            <button type="button" class="uk-modal-close uk-close"></button>

            <div class="uk-modal-header">
                <h2><i class="fa fa-refresh"></i> Create Group(s) From Existing Pages/Posts</h2>
                <p><i class="fa fa-info-circle"></i>
                    Select posts/pages you want to create groups from and press Create Groups.
                </p>
            </div>

            <table class="wp-list-table widefat fixed striped postsTable2" cellspacing="0" width="100%">
                <thead>
                <tr>
                    <td class="check-column"><input class="select-posts-all" type="checkbox"></td>
                    <th style="width: 40px">ID</th>
                    <th>Title</th>
                    <th>Date</th>
                </tr>
                </thead>
                <tbody>
                <tr>
                    <td colspan="4" class="uk-text-center"><i class="fa fa-spin fa-refresh"></i> Loading</td>
                </tr>
                </tbody>
                <tfoot>
                <tr>
                    <td class="check-column"><input class="select-posts-all" type="checkbox"></td>
                    <th style="width: 40px">ID</th>
                    <th>Title</th>
                    <th>Date</th>
                </tr>
                </tfoot>
            </table>

            <div class="uk-modal-footer">
                <div class="uk-float-left">
                    <button style="margin-top: 10px;" type="button" class="uk-button uk-modal-close"><i
                                class="fa fa-close"></i> Close
                    </button>
                </div>
                <div class="uk-float-right">
                    <span class="selected-posts"><b class="value">0</b> entries selected</span>
                    <button type="submit" class="uk-button uk-button-success add-group-from-existing"><i
                                class="fa fa-plus"></i> Create Groups from Selected
                    </button>
                </div>
                <div class="uk-clearfix"></div>
            </div>

        </div>

    </div>

    <!-- Tutorials -->
    <div id="tutorials" class="uk-modal">
        <div class="uk-modal-dialog uk-modal-dialog-large">
            <button type="button" class="uk-modal-close uk-close"></button>
            <div class="uk-modal-header">
                <h2><i class="fa fa-info-circle"></i> Tutorials</h2>
            </div>
            <div class="uk-modal-body">

            </div>
            <div class="uk-modal-footer uk-text-right">
                <button type="button" class="uk-button uk-modal-close">Close</button>
            </div>
        </div>
    </div>

    <div class="tut_holder hide">
        <h2 style="margin-top: 20px"></h2>
        <iframe width="100%" height="480" frameborder="0" allowfullscreen="allowfullscreen"
                mozallowfullscreen="mozallowfullscreen" msallowfullscreen="msallowfullscreen"
                oallowfullscreen="oallowfullscreen" webkitallowfullscreen="webkitallowfullscreen"
                src="">
        </iframe>
    </div>
    <!-- Tutorials -->

    <!-- Conditional Formatting Modal -->
    <div id="conditional-formatting" class="uk-modal">
        <div class="uk-modal-dialog">
            <button type="button" class="uk-modal-close uk-close"></button>
            <div class="uk-modal-header">
                <h2><i class="fa fa-paint-brush"></i> Conditional Formatting Setup</h2>
            </div>
            <div class="uk-grid">
                <div class="uk-width-medium-3-10">

                    <ul class="uk-nav uk-nav-side"
                        data-uk-switcher="{connect:'#conditional-formatting-local',animation: 'fade'}">
                        <li><a href="#">Search Volume</a></li>
                        <li class="separator"><a href="#">Cost per Click</a></li>

                        <li><a href="#">Broad Results</a></li>
                        <li><a href="#">Phrase Results</a></li>
                        <li><a href="#">InTitle Results</a></li>
                        <li class="separator"><a href="#">InURL Results</a></li>

                        <li><a href="#">Title Ratio</a></li>
                        <li class="separator"><a href="#">URL Ratio</a></li>

                        <li><a href="#">InTitle Golden Bar</a></li>
                        <li><a href="#">InURL Golden Bar</a></li>
                    </ul>

                    <div class="cf-templates">
                        <label for="cf-templates">Templates:</label>
                        <select class="uk-width-1-1" id="cf-templates">
                            <option value="new">---</option>
                            <option value="Default">Default</option>
                        </select>
                    </div>
                </div>
                <div class="uk-width-medium-6-10">
                    <div>
                        <form class="uk-form" id="conditional-formatting-local-form">
                            <ul id="conditional-formatting-local" class="uk-switcher">
                                <!-- Search Volume -->
                                <li>
                                    <div class="uk-panel">
                                        <div class="uk-panel-badge uk-badge uk-badge-danger"><i class="fa fa-close"></i>
                                        </div>
                                        <h3 class="uk-panel-title">RED</h3>
                                        below
                                        <input type="number" pattern="[0-9]" name="volume_red" id="volume_red"
                                               class="uk-width-1-1" placeholder="eg. 20" required>
                                    </div>
                                    <hr>
                                    <div class="uk-panel">
                                        <div class="uk-panel-badge uk-badge uk-badge-warning"><i
                                                    class="fa fa-warning"></i></div>
                                        <h3 class="uk-panel-title">YELLOW</h3>
                                        between
                                        <input type="number" readonly class="uk-width-1-1 volume_yellow_1 volume_red"
                                               placeholder="eg. 20">
                                        and
                                        <input type="number" readonly class="uk-width-1-1 volume_yellow_2 volume_green"
                                               placeholder="eg. 100">
                                    </div>
                                    <hr>
                                    <div class="uk-panel">
                                        <div class="uk-panel-badge uk-badge uk-badge-success"><i
                                                    class="fa fa-check"></i></div>
                                        <h3 class="uk-panel-title">GREEN</h3>
                                        from
                                        <input type="number" pattern="[0-9]" name="volume_green" id="volume_green"
                                               class="uk-width-1-1" placeholder="eg. 100">
                                    </div>
                                </li>
                                <!-- Cost Per Click -->
                                <li>
                                    <div class="uk-panel">
                                        <div class="uk-panel-badge uk-badge uk-badge-danger"><i class="fa fa-close"></i>
                                        </div>
                                        <h3 class="uk-panel-title">RED</h3>
                                        below
                                        <input type="number" pattern="[0-9]" name="cpc_red" id="cpc_red"
                                               class="uk-width-1-1" placeholder="eg. 20">
                                    </div>
                                    <hr>
                                    <div class="uk-panel">
                                        <div class="uk-panel-badge uk-badge uk-badge-warning"><i
                                                    class="fa fa-warning"></i></div>
                                        <h3 class="uk-panel-title">YELLOW</h3>
                                        between
                                        <input type="number" readonly class="uk-width-1-1 cpc_yellow_1 cpc_red"
                                               placeholder="eg. 20">
                                        and
                                        <input type="number" readonly class="uk-width-1-1 cpc_yellow_2 cpc_green"
                                               placeholder="eg. 100">
                                    </div>
                                    <hr>
                                    <div class="uk-panel">
                                        <div class="uk-panel-badge uk-badge uk-badge-success"><i
                                                    class="fa fa-check"></i></div>
                                        <h3 class="uk-panel-title">GREEN</h3>
                                        from
                                        <input type="number" pattern="[0-9]" name="cpc_green" id="cpc_green"
                                               class="uk-width-1-1" placeholder="eg. 100">
                                    </div>
                                </li>
                                <!-- Broad Results -->
                                <li>
                                    <div class="uk-panel">
                                        <div class="uk-panel-badge uk-badge uk-badge-danger"><i class="fa fa-close"></i>
                                        </div>
                                        <h3 class="uk-panel-title">RED</h3>
                                        above
                                        <input type="number" pattern="[0-9]" name="broad_red" id="broad_red"
                                               class="uk-width-1-1" placeholder="eg. 20">
                                    </div>
                                    <hr>
                                    <div class="uk-panel">
                                        <div class="uk-panel-badge uk-badge uk-badge-warning"><i
                                                    class="fa fa-warning"></i></div>
                                        <h3 class="uk-panel-title">YELLOW</h3>
                                        between
                                        <input type="number" readonly class="uk-width-1-1 broad_yellow_1 broad_red"
                                               placeholder="eg. 20">
                                        and
                                        <input type="number" readonly class="uk-width-1-1 broad_yellow_2 broad_green"
                                               placeholder="eg. 100">
                                    </div>
                                    <hr>
                                    <div class="uk-panel">
                                        <div class="uk-panel-badge uk-badge uk-badge-success"><i
                                                    class="fa fa-check"></i></div>
                                        <h3 class="uk-panel-title">GREEN</h3>
                                        below
                                        <input type="number" pattern="[0-9]" name="broad_green" id="broad_green"
                                               class="uk-width-1-1" placeholder="eg. 100">
                                    </div>
                                </li>
                                <!-- Phrase Results -->
                                <li>
                                    <div class="uk-panel">
                                        <div class="uk-panel-badge uk-badge uk-badge-danger"><i class="fa fa-close"></i>
                                        </div>
                                        <h3 class="uk-panel-title">RED</h3>
                                        above
                                        <input type="number" pattern="[0-9]" name="phrase_red" id="phrase_red"
                                               class="uk-width-1-1" placeholder="eg. 20">
                                    </div>
                                    <hr>
                                    <div class="uk-panel">
                                        <div class="uk-panel-badge uk-badge uk-badge-warning"><i
                                                    class="fa fa-warning"></i></div>
                                        <h3 class="uk-panel-title">YELLOW</h3>
                                        between
                                        <input type="number" readonly class="uk-width-1-1 phrase_yellow_1 phrase_red"
                                               placeholder="eg. 20">
                                        and
                                        <input type="number" readonly class="uk-width-1-1 phrase_yellow_2 phrase_green"
                                               placeholder="eg. 100">
                                    </div>
                                    <hr>
                                    <div class="uk-panel">
                                        <div class="uk-panel-badge uk-badge uk-badge-success"><i
                                                    class="fa fa-check"></i></div>
                                        <h3 class="uk-panel-title">GREEN</h3>
                                        below
                                        <input type="number" pattern="[0-9]" name="phrase_green" id="phrase_green"
                                               class="uk-width-1-1" placeholder="eg. 100">
                                    </div>
                                </li>
                                <!-- InTitle Results -->
                                <li>
                                    <div class="uk-panel">
                                        <div class="uk-panel-badge uk-badge uk-badge-danger"><i class="fa fa-close"></i>
                                        </div>
                                        <h3 class="uk-panel-title">RED</h3>
                                        above
                                        <input type="number" pattern="[0-9]" name="intitle_red" id="intitle_red"
                                               class="uk-width-1-1" placeholder="eg. 20">
                                    </div>
                                    <hr>
                                    <div class="uk-panel">
                                        <div class="uk-panel-badge uk-badge uk-badge-warning"><i
                                                    class="fa fa-warning"></i></div>
                                        <h3 class="uk-panel-title">YELLOW</h3>
                                        between
                                        <input type="number" readonly class="uk-width-1-1 intitle_yellow_1 intitle_red"
                                               placeholder="eg. 20">
                                        and
                                        <input type="number" readonly
                                               class="uk-width-1-1 intitle_yellow_2 intitle_green"
                                               placeholder="eg. 100">
                                    </div>
                                    <hr>
                                    <div class="uk-panel">
                                        <div class="uk-panel-badge uk-badge uk-badge-success"><i
                                                    class="fa fa-check"></i></div>
                                        <h3 class="uk-panel-title">GREEN</h3>
                                        below
                                        <input type="number" pattern="[0-9]" name="intitle_green" id="intitle_green"
                                               class="uk-width-1-1" placeholder="eg. 100">
                                    </div>
                                </li>
                                <!-- InURL Results -->
                                <li>
                                    <div class="uk-panel">
                                        <div class="uk-panel-badge uk-badge uk-badge-danger"><i class="fa fa-close"></i>
                                        </div>
                                        <h3 class="uk-panel-title">RED</h3>
                                        above
                                        <input type="number" pattern="[0-9]" name="inurl_red" id="inurl_red"
                                               class="uk-width-1-1" placeholder="eg. 20">
                                    </div>
                                    <hr>
                                    <div class="uk-panel">
                                        <div class="uk-panel-badge uk-badge uk-badge-warning"><i
                                                    class="fa fa-warning"></i></div>
                                        <h3 class="uk-panel-title">YELLOW</h3>
                                        between
                                        <input type="number" readonly class="uk-width-1-1 inurl_yellow_1 inurl_red"
                                               placeholder="eg. 20">
                                        and
                                        <input type="number" readonly class="uk-width-1-1 inurl_yellow_2 inurl_green"
                                               placeholder="eg. 100">
                                    </div>
                                    <hr>
                                    <div class="uk-panel">
                                        <div class="uk-panel-badge uk-badge uk-badge-success"><i
                                                    class="fa fa-check"></i></div>
                                        <h3 class="uk-panel-title">GREEN</h3>
                                        below
                                        <input type="number" pattern="[0-9]" name="inurl_green" id="inurl_green"
                                               class="uk-width-1-1" placeholder="eg. 100">
                                    </div>
                                </li>
                                <!-- Title Ratio Results -->
                                <li>
                                    <div class="uk-panel">
                                        <div class="uk-panel-badge uk-badge uk-badge-danger"><i class="fa fa-close"></i>
                                        </div>
                                        <h3 class="uk-panel-title">RED</h3>
                                        above
                                        <input type="number" pattern="[0-9]" name="title_ratio_red" id="title_ratio_red"
                                               class="uk-width-1-1" placeholder="eg. 20">
                                    </div>
                                    <hr>
                                    <div class="uk-panel">
                                        <div class="uk-panel-badge uk-badge uk-badge-warning"><i
                                                    class="fa fa-warning"></i></div>
                                        <h3 class="uk-panel-title">YELLOW</h3>
                                        between
                                        <input type="number" readonly
                                               class="uk-width-1-1 title_ratio_yellow_1 title_ratio_red"
                                               placeholder="eg. 20">
                                        and
                                        <input type="number" readonly
                                               class="uk-width-1-1 title_ratio_yellow_2 title_ratio_green"
                                               placeholder="eg. 100">
                                    </div>
                                    <hr>
                                    <div class="uk-panel">
                                        <div class="uk-panel-badge uk-badge uk-badge-success"><i
                                                    class="fa fa-check"></i></div>
                                        <h3 class="uk-panel-title">GREEN</h3>
                                        below
                                        <input type="number" pattern="[0-9]" name="title_ratio_green"
                                               id="title_ratio_green" class="uk-width-1-1" placeholder="eg. 100">
                                    </div>
                                </li>
                                <!-- URL Ratio Results -->
                                <li>
                                    <div class="uk-panel">
                                        <div class="uk-panel-badge uk-badge uk-badge-danger"><i class="fa fa-close"></i>
                                        </div>
                                        <h3 class="uk-panel-title">RED</h3>
                                        above
                                        <input type="number" pattern="[0-9]" name="url_ratio_red" id="url_ratio_red"
                                               class="uk-width-1-1" placeholder="eg. 20">
                                    </div>
                                    <hr>
                                    <div class="uk-panel">
                                        <div class="uk-panel-badge uk-badge uk-badge-warning"><i
                                                    class="fa fa-warning"></i></div>
                                        <h3 class="uk-panel-title">YELLOW</h3>
                                        between
                                        <input type="number" readonly
                                               class="uk-width-1-1 url_ratio_yellow_1 url_ratio_red"
                                               placeholder="eg. 20">
                                        and
                                        <input type="number" readonly
                                               class="uk-width-1-1 url_ratio_yellow_2 url_ratio_green"
                                               placeholder="eg. 100">
                                    </div>
                                    <hr>
                                    <div class="uk-panel">
                                        <div class="uk-panel-badge uk-badge uk-badge-success"><i
                                                    class="fa fa-check"></i></div>
                                        <h3 class="uk-panel-title">GREEN</h3>
                                        below
                                        <input type="number" pattern="[0-9]" name="url_ratio_green" id="url_ratio_green"
                                               class="uk-width-1-1" placeholder="eg. 100">
                                    </div>
                                </li>
                                <!-- Title Ratio Value -->
                                <li>
                                    <div class="uk-panel">
                                        <h3 class="uk-panel-title">inTitle Golden Ratio Bar </h3>
                                        <p class="uk-alert uk-alert-info">Values below selected Volume & inTitle will appear as Gold Bars: <img src="<?php
                                            echo XAG_URL . 'assets/img/gold.png' ?>"></p>

                                        <h3 class="uk-panel-title">Volume</h3>
                                        below
                                        <input type="number" pattern="[0-9]" id="tr_goldbar_volume" name="tr_goldbar_volume" class="uk-width-1-1"
                                               placeholder="eg. 1000">

                                        <div class="small-separator">and</div>

                                        <h3 class="uk-panel-title">InTitle</h3>
                                        below
                                        <input type="number" pattern="[0-9]" id="tr_goldbar_intitle" name="tr_goldbar_intitle" class="uk-width-1-1"
                                               placeholder="eg. 20">

                                    </div>
                                </li>
                                <!-- URL Ratio Value -->
                                <li>
                                    <div class="uk-panel">
                                        <h3 class="uk-panel-title">inURL Golden Ratio Bar </h3>
                                        <p class="uk-alert uk-alert-info">Values below selected Volume & inURL will appear as Gold Bars: <img src="<?php
                                            echo XAG_URL . 'assets/img/gold.png' ?>"></p>

                                        <h3 class="uk-panel-title">Volume</h3>
                                        below
                                        <input type="number" pattern="[0-9]" id="ur_goldbar_volume" name="ur_goldbar_volume" class="uk-width-1-1"
                                               placeholder="eg. 1000">

                                        <div class="small-separator">and</div>

                                        <h3 class="uk-panel-title">InURL</h3>
                                        below
                                        <input type="number" pattern="[0-9]" id="ur_goldbar_intitle" name="ur_goldbar_intitle" class="uk-width-1-1"
                                               placeholder="eg. 20">

                                    </div>
                                </li>
                            </ul>
                        </form>
                    </div>
                </div>
            </div>

            <div class="uk-modal-footer uk-text-right">
                <button type="button" class="uk-button uk-button-danger" id="deleteCfTemplate" title="Delete Template">
                    <i class="fa fa-trash"></i></button>
                <button type="button" class="uk-button uk-button-primary" id="saveCfTemplate"><i class="fa fa-save"></i>
                    Save Template
                </button>
                <button type="button" class="uk-button uk-button-success" id="applyCfTemplate"><i
                            class="fa fa-check"></i> Apply Template
                </button>
            </div>
        </div>
    </div>

    <!-- Templates -->
    <div data-name="Group Name" class="group template" data-post-type="">
        <div class="attached" style="display: none;"></div>
        <div class="uk-panel-box">
            <div class="action-buttons-holder">
                <!-- Actions Button -->
                <div class="uk-button-dropdown groupSettings-button" data-uk-dropdown="{mode:'click'}" data-uk-tooltip title="Actions">
                    <button type="button" class="uk-button uk-button-mini groupSettings"><i class="fa fa-bolt"></i></button>

                    <div class="uk-dropdown uk-dropdown-small">
                        <ul class="uk-nav uk-nav-dropdown">

                            <li class="uk-nav-header">
                                <i class="fa fa-search"></i> KEYWORD MANAGEMENT
                            </li>

                            <li><a href="#" class="addKeyword uk-dropdown-close"><i class="fa fa-plus"></i>
                                    Add new Keyword(s)</a></li>
                            <li><a href="#" class="deleteKeywords uk-dropdown-close"><i
                                            class="fa fa-trash-o"></i> Delete Keyword(s)</a></li>
                            <li><a href="#" class="getVolumeAndCPC uk-dropdown-close"><i
                                            class="fa fa-rocket"></i> Get Keyword Vol & CPC</a></li>
                            <li><a href="#" class="getKeywordData uk-dropdown-close"><i
                                            class="fa fa-beer"></i> Get Keyword Competition</a></li>
                            <li><a href="#" class="track_rankings uk-dropdown-close"><i
                                            class="fa fa-key"></i> Track Keyword Rankings</a></li>

                            <li class="uk-nav-header">
                                <i class="fa fa-folder-open-o"></i> GROUP MANAGEMENT
                            </li>

                            <li><a href="#" class="createNewPagePost uk-dropdown-close" data-type="page"><i
                                            class="fa fa-file-code-o"></i> Create New Page From Group</a>
                            </li>
                            <li><a href="#" class="createNewPagePost uk-dropdown-close" data-type="post"><i
                                            class="fa fa-file-code-o"></i> Create New Post From Group</a>
                            </li>
                            <li><a href="#" class="attachToPagePost uk-dropdown-close"><i
                                            class="fa fa-bullseye"></i> Attach to Page/Post</a></li>
                            <li><a href="#" class="goToPagePost uk-dropdown-close" target="_blank"><i
                                            class="fa fa-arrow-right"></i> Go to attached Page/Post</a></li>
                            <li><a href="#" class="moveToProject uk-dropdown-close" target="_blank"><i
                                            class="fa fa-copy"></i> Move to a different Project</a></li>
                            <li><a href="#" class="deleteGroup uk-dropdown-close"><i
                                            class="fa fa-trash-o"></i> Delete Group</a></li>
                        </ul>
                    </div>

                </div>
                <button type="button" class="uk-button uk-button-mini openNotes" data-uk-tooltip title="Open Notes"><i class="fa fa-sticky-note"></i></button>
                <button type="button" class="uk-button uk-button-mini wordCloud" data-uk-tooltip title="Open Word Cloud"><i class="fa fa-cloud"></i></button>
                <!-- Minimize -->
                <button type="button" class="uk-button uk-button-mini minimizeGroup" data-uk-tooltip title="Hide Keywords"><i class="fa fa-chevron-up"></i></button>
                <!-- Save Button -->
                <button type="submit" class="uk-button uk-button-success uk-button-mini saveGroup" data-uk-tooltip title="Save Changes"><i class="fa fa-save"></i></button>
                <!-- Bulk Manage Groups -->
                <input type="checkbox" class="groupSelect"/>
            </div>

            <!-- Group Settings -->
            <form class="updateGroup">
                <input type="hidden" name="action" value="xag_updateGroup"/>
                <input type="hidden" name="group_id" value="0"/>
                <input type="hidden" name="project_id" value="0"/>
                <input type="hidden" name="request_type" value="single"/>
                <input type="hidden" name="oriUrl" value=""/>
                <!-- Group Name -->
                <input type="text" class="groupInput" placeholder="eg. My Group" value="" name="group_name"/>
                <table class="uk-table groupSettings">
                    <thead>
                    <tr>
                        <td>
                            <div class="h-1-holder">H1</div>
                        </td>
                        <td>
                            <input type="text" class="groupInput" placeholder="eg. My Header" value="" name="h1" style="margin: 0;line-height: 34px;" />
                        </td>
                    </tr>
                    </thead>

                    <tbody class="groupSettingsTbody">


                    <tr>
                        <td colspan="2" style="padding: 0;">
                            <div class="tab-box displayed uk-grid uk-grid-collapse">

                                <div class="uk-width-large-1-1 uk-width-medium-1-1 uk-width-small-1-1">
                                    <div class="prs-serp left">
                                        <div class="title-length-holder">
                                            <div class="title-length-desk">
                                                <i class="fa fa-desktop" data-uk-tooltip="" title="Desktop devices limits."></i>
                                                <span class="count-seo-bold"><span class="count-seo-title">0</span> / 70</span>
                                            </div>
                                            <div class="title-length-mob">
                                                <i class="fa fa-mobile" data-uk-tooltip="" title="Mobile devices limits."></i>
                                                <span class="count-seo-bold"><span class="count-seo-title-mobile">0</span> / 78</span>
                                            </div>
                                        </div>
                                        <!-- SEO Title -->
                                        <input type="hidden" name="title" class="groupInput" value=""/>
                                        <div class="prs-editor prs-title" data-target="title" contenteditable="true" placeholder="SEO Title"></div>

                                        <!-- SEO URL -->
                                        <div class="url-container">
                                            <input type="hidden" name="url" value=""/>
                                            <div class="prs-editor url-container-inner" contenteditable="false">
                                                <label class="host-url"><?php
                                                    echo site_url(); ?> </label>
                                                <label class="pre-url"></label>
                                                <div spellcheck="false" class="url-edit" contenteditable="true"></div>
                                                <label class="post-url"></label>
                                            </div>
                                        </div>

                                        <div class="description-length-holder">
                                            <div class="description-length-desk">
                                                <i class="fa fa-desktop" data-uk-tooltip="" title="Desktop devices limits."></i>
                                                <span class="count-seo-bold"><span class="count-seo-description">0</span> / 300</span>
                                            </div>
                                            <div class="description-length-mob">
                                                <i class="fa fa-mobile" data-uk-tooltip="" title="Mobile devices limits."></i>
                                                <span class="count-seo-bold"><span class="count-seo-description-mobile">0</span> / 120</span>
                                            </div>
                                        </div>
                                        <!-- SEO Description -->
                                        <input type="hidden" name="description" class="groupInput" value=""/>
                                        <div class="prs-editor prs-description" data-target="description" contenteditable="true" placeholder="SEO Description"></div>
                                    </div>
                                </div>

                            </div>
                        </td>
                    </tr>
                    <tr class="notes-row" style="display: none">
                        <td>Notes</td>
                        <td>
                            <textarea rows="3" class="groupInput" placeholder="eg. Notes about this project"
                                      name="notes"></textarea>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </form>

            <!-- Keywords -->
            <form class="updateKeywords">
                <table class="uk-table uk-table-striped uk-table-hover keywords">
                    <thead>
                    <tr>
                        <th class="select-all uk-text-center"><i class="fa fa-asterisk"></i></th>
                        <th>Keyword</th>
                        <th>Volume</th>
                        <th>CPC ($)</th>
                        <th>Broad</th>
                        <th>Phrase</th>
                        <th>inTitle</th>
                        <th>inURL</th>
                        <th data-uk-tooltip="{pos:'left'}" title="Title Ratio (Volume / InTitle)"
                            class="uk-text-center">TR
                        </th>
                        <th data-uk-tooltip="{pos:'left'}" title="URL Ratio (Volume / InURL)" class="uk-text-center">
                            UR
                        </th>
                        <th>Rank</th>
                    </tr>
                    </thead>
                    <tbody class="keywords-data uk-sortable">
                    <tr>
                        <td colspan="11"><i class="fa fa-warning"></i> No added keywords yet...</td>
                    </tr>
                    </tbody>
                </table>
            </form>

        </div>
    </div>

    <!-- Add Keywords -->
    <div id="addKeywords" class="uk-modal">

        <div class="uk-modal-dialog">

            <div>
                <div class="uk-modal-content uk-form"><b>Insert keywords separated by a new line:</b></div>

                <div class="uk-margin-small-top uk-modal-content uk-form">
                    <p>
                        <textarea id="keywords-input" rows="6" class="uk-width-1-1"></textarea>
                    </p>
                </div>

                <div class="uk-modal-footer uk-text-right">
                    <button type="button" class="uk-button uk-modal-close"><i class="fa fa-close"></i> Cancel</button>
                    <button type="button" class="uk-button uk-button-primary add-keywords"><i class="fa fa-plus"></i>
                        Add
                    </button>
                </div>
            </div>

        </div>

    </div>

    <!-- Attach to Page/Post -->
    <div id="attachToPagePost" class="uk-modal">

        <input type="hidden" name="group_id" value="0"/>
        <input type="hidden" name="post_id" value="0"/>

        <div class="uk-modal-dialog uk-modal-no-padding">
            <button type="button" class="uk-modal-close uk-close"></button>

            <div class="uk-modal-header">
                <h2><i class="fa fa-bullseye"></i> Attach to Page/Post</h2>
                <p><i class="fa fa-info-circle"></i>
                    Attach specified group to pre-existing Page or Post.
                </p>
            </div>

            <table class="wp-list-table widefat fixed striped postsTable" cellspacing="0" width="100%">
                <thead>
                <tr>
                    <th style="width: 40px">ID</th>
                    <th>Title</th>
                    <th>Date</th>
                </tr>
                </thead>
                <tbody>
                <tr>
                    <td colspan="3" class="uk-text-center"><i class="fa fa-spin fa-refresh"></i> Loading</td>
                </tr>
                </tbody>
                <tfoot>
                <tr>
                    <th style="width: 40px">ID</th>
                    <th>Title</th>
                    <th>Date</th>
                </tr>
                </tfoot>
            </table>

            <div class="uk-modal-footer uk-text-left">
                <button type="button" class="uk-button uk-modal-close"><i class="fa fa-close"></i> Close</button>
            </div>

        </div>
    </div>

    <!-- Import Project Modal -->
    <div id="importProject" class="uk-modal">
        <div class="uk-modal-dialog">
            <button type="button" class="uk-modal-close uk-close"></button>

            <div class="uk-modal-header">
                <h2><i class="fa fa-cloud-download"></i> Project Importer</h2>
                <p><i class="fa fa-info-circle"></i>
                    Import a previously exported project.
                </p>
            </div>

            <div class="uk-placeholder upload-drop">
                <i class="fa fa-cloud-upload"></i> Drag your CSV here or browse
                <a class="uk-form-file">
                    by selecting a file
                    <input class="file-import" name="file-import" type="file" required>
                </a>.
            </div>

            <div class="uk-progress uk-hidden">
                <div class="uk-progress-bar" style="width: 0%;">...</div>
            </div>
        </div>
    </div>

    <!-- Import Keyword Planner Modal -->
    <div id="importKeywordPlanner" class="uk-modal">
        <div class="uk-modal-dialog">
            <button type="button" class="uk-modal-close uk-close"></button>

            <div class="uk-modal-header">
                <h2><i class="fa fa-download"></i> Import from CSV</h2>
                <br>
                <b><i class="fa fa-info-circle"></i>
                    We support the following CSV formats:
                </b>
                <div class="uk-grid uk-grid-small uk-margin-top">
                    <div class="uk-width-1-4" data-uk-dropdown>
                        <div class="csv-options">
                            Adwords Keyword Planner CSV
                            <img src="<?= XAG_URL; ?>assets/img/csv/adwords.png"/>
                        </div>
                        <div class="uk-dropdown max-width">This is the default format of <a href="https://ads.google.com/home/tools/keyword-planner/" target="_blank">Adwords Keyword Planner's</a> CSV.</div>
                    </div>
                    <div class="uk-width-1-4" data-uk-dropdown>
                        <div class="csv-options" data-uk-dropdown>
                            Keyword Supremacy CSV
                            <img src="<?= XAG_URL; ?>assets/img/csv/kws.png"/>
                        </div>
                        <div class="uk-dropdown max-width">This is the format of exported CSV from Keyword Supremacy at <a href="https://app.keywordsupremacy.com/results_area" target="_blank">My Searches page</a>.</div>
                    </div>
                    <div class="uk-width-1-4" data-uk-dropdown>
                        <div class="csv-options" data-uk-dropdown>
                            SurferSEO<br/>CSV
                            <img src="<?= XAG_URL; ?>assets/img/csv/surfseo.png"/>
                        </div>
                        <div class="uk-dropdown max-width">This is the CSV format used by <a href="https://surferseo.com/" target="_blank">SurferSEO</a>.</div>
                    </div>
                    <div class="uk-width-1-4" data-uk-dropdown>
                        <div class="csv-options" data-uk-dropdown>
                            Custom <br/>CSV
                            <img src="<?= XAG_URL; ?>assets/img/csv/csv.png"/>
                        </div>
                        <div class="uk-dropdown max-width">You can supply a custom CSV here in the following format: <b>Keyword,Volume,CPC</b></div>
                    </div>
                </div>
            </div>

            <div class="uk-placeholder upload-drop">
                <i class="fa fa-cloud-upload"></i> Drag your CSV here or browse
                <a class="uk-form-file">
                    by selecting a file
                    <input class="file-import" name="file-import" type="file" required>
                </a>.
            </div>

            <div class="uk-progress uk-hidden">
                <div class="uk-progress-bar" style="width: 0%;">...</div>
            </div>
        </div>
    </div>

    <!-- Move Group -->
    <div id="moveToProjectGroup" class="uk-modal">
        <div class="uk-modal-dialog uk-modal-dialog-small">
            <div class="uk-modal-header">
                <h2><i class="fa fa-copy"></i> Move Group to a Project</h2>
            </div>

            <div class="uk-grid">
                <form id="moveToProjectForm" class="uk-form uk-width-1-1">
                    <fieldset>
                        <div class="uk-form-row">
                            <label class="uk-form-label" for="moveToProjectInput"><i class="fa fa-folder"></i>
                                Destination Project:</label>
                            <select id="moveToProjectInput" name="project_id" class="uk-width-1-1"
                                    style="margin-top: 4px" required>

                            </select>
                        </div>
                        <div class="uk-form-row" style="margin-top: 10px">
                            <button class="uk-button uk-button-success" type="submit"><i class="fa fa-check"></i> Move
                            </button>
                            <button class="uk-button uk-modal-close" type="button" style="float: right"><i
                                        class="fa fa-close"></i> Cancel
                            </button>
                        </div>
                    </fieldset>
                </form>

            </div>
        </div>
    </div>

    <!-- Automatically Generate Groups -->
    <div id="phraseMatchModal" class="uk-modal">
        <div class="uk-modal-dialog">
            <div class="uk-modal-header">
                <h2><i class="fa fa-magic"></i> Phrase Matching</h2>
            </div>

            <form id="phraseMatchForm" class="uk-form uk-width-1-1">
                <fieldset>

                    <div class="uk-form-row">
                        <label class="uk-form-label" for="project_name_phr"><i class="fa fa-file-text"></i> Enter a new Project Name:</label>
                        <input type="text" name="project_name" id="project_name_phr" class="uk-width-1-1" required
                               placeholder="eg. My New Project #1">
                        <small><b>*a new project with inserted name will be created containing Phrased Matched keywords</b>
                        </small>
                    </div>


                    <div class="uk-grid uk-grid-small uk-margin-top">

                        <div class="uk-width-medium-1-4" data-uk-tooltip title="Minimum number of matching words in group name">
                            <div class="uk-form-row">
                                <label class="uk-form-label" for="min_match"><i class="fa fa-sort-numeric-asc"></i> Min. Words:</label>
                                <input type="number" min="1" value="2" name="min_match" id="min_match" class="uk-width-1-1 uk-text-center" required>
                            </div>
                        </div>
                        <div class="uk-width-medium-1-4" data-uk-tooltip title="Minimum number of keywords in the group">
                            <div class="uk-form-row">
                                <label class="uk-form-label" for="min_kws"><i class="fa fa-sort-numeric-desc"></i> Min. Keywords:</label>
                                <input type="number" min="1" value="3" name="min_kws" id="min_kws" class="uk-width-1-1 uk-text-center" required>
                            </div>
                        </div>
                        <div class="uk-width-medium-2-4" data-uk-tooltip title="Include or exclude common prepositions in group names such as: for, and, or, of, in, the, etc.">
                            <div class="uk-form-row">
                                <label class="uk-form-label" for="project_name_phr"><i class="fa fa-link"></i> Prepositions:</label>
                                <label class="include_prepositions"><input type="checkbox" name="include_prepositions" value="true"> Include common prepositions</label>
                            </div>
                        </div>

                    </div>

                    <hr>

                    <div class="uk-form-row">
                        <label class="uk-form-label">
                            <i class="fa fa-key"></i> Select Keywords to Phrase Match:
                            <button type="button" class="uk-button uk-button-small uk-button-primary uk-float-right phraseMatchSelectAll"><i class="fa fa-asterisk"></i> Select All</button>
                        </label>
                        <div class="phraseMatchingKeywords">
                            <div class="uk-grid uk-grid-small">
                                <div class="uk-width-medium-1-2">
                                    <div class="kw-group-1"></div>
                                </div>
                                <div class="uk-width-medium-1-2">
                                    <div class="kw-group-2"></div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="uk-form-row uk-margin-small-top">
                        <label class="uk-form-label" for="excluded_words"><i class="fa fa-file-text"></i> Excluded Words:</label>
                        <input type="text" name="excluded_words" id="excluded_words" class="uk-width-1-1" placeholder="eg. flowers, blanket, bicycle, house">
                        <small><b>*insert word(s) separated by a comma <kbd>,</kbd> to be excluded from group names</b>
                        </small>
                    </div>

                    <div class="uk-form-row" style="margin-top: 10px">
                        <button class="uk-button uk-modal-close" type="button"><i
                                    class="fa fa-close"></i> Cancel
                        </button>
                        <button class="uk-button uk-button-success autoGenerateGroupsBtn" type="submit" style="float: right"><i
                                    class="fa fa-check"></i> Phrase Match and Create a New Project from selected Keywords
                        </button>
                    </div>
                </fieldset>

            </form>
        </div>
    </div>

    <!-- Automatically Generate Groups -->
    <div id="automaticallyGenerateGroupsModal" class="uk-modal">
        <div class="uk-modal-dialog">
            <div class="uk-modal-header">
                <h2><i class="fa fa-cloud-download"></i> Automatically Generate Groups</h2>
            </div>

            <form id="autoGenerateGroupsForm" class="uk-form uk-width-1-1">
                <fieldset>
                    <div class="uk-form-row">
                        <label class="uk-form-label" for="seed_keyword"><i class="fa fa-key"></i> Enter a seed keyword:</label>
                        <input type="text" name="seed_keyword" id="seed_keyword" class="uk-width-1-1" required
                               placeholder="eg. tasty seafood">
                        <small><b>*by using your seed keyword, we will generate groups and keywords based on it</b>
                        </small>
                    </div>
                    <div class="uk-form-row">
                        <div class="uk-alert uk-alert-warning" data-uk-alert="" style="margin-bottom: 5px;">
                            <a href="" class="uk-alert-close uk-close"></a>
                            <p>
                                <i class="fa fa-warning"></i> Set maximum amount of keywords to pull for your groups
                                inside of current Project.
                                <span class="fat-warning">This operation costs <b>50</b> credits each time you use it.</span>
                            </p>
                        </div>
                        <label class="uk-form-label" for="max_keywords"><i class="fa fa-key"></i> Maximum keywords to
                            pull:</label>
                        <input type="number" name="max_keywords" id="max_keywords" min="1" max="700" value="700"
                               class="uk-width-1-1 uk-form-warning uk-text-center" required placeholder="eg. 10">
                    </div>

                    <hr>

                    <div class="uk-grid" style="margin-top: 10px">
                        <div class="uk-width-1-2">
                            <label class="uk-form-label" for="min_search_volume"><i class="fa fa-key"></i> Min. Search
                                Volume:</label>
                            <input type="number" name="min_search_volume" id="min_search_volume" class="uk-width-1-1"
                                   required="" min="10" value="10" placeholder="eg. 1000">
                        </div>
                        <div class="uk-width-1-2">
                            <label class="uk-form-label" for="min_cpc"><i class="fa fa-key"></i> Min. Cost Per
                                Click:</label>
                            <input type="number" name="min_cpc" id="min_cpc" class="uk-width-1-1" required step="0.01"
                                   min="0.50" value="0.50" placeholder="eg. 0.50">
                        </div>
                    </div>

                    <div class="uk-grid" style="margin-top: 0;">
                        <div class="uk-width-1-2">
                            <div class="uk-form-row" style="margin-top: 10px">
                                <label class="uk-form-label" for="autoCreateGroups_languageCode"><i class="fa fa-key"></i>
                                    Language:</label>
                                <select id="autoCreateGroups_languageCode" name="language" class="uk-width-1-1"
                                        style="margin-top: 4px">
                                    <option value="0000" selected="">-- All Languages --</option>
                                    <option value="1019">Arabic</option>
                                    <option value="1020">Bulgarian</option>
                                    <option value="1038">Catalan</option>
                                    <option value="1017">Chinese (simplified)</option>
                                    <option value="1018">Chinese (traditional)</option>
                                    <option value="1039">Croatian</option>
                                    <option value="1021">Czech</option>
                                    <option value="1009">Danish</option>
                                    <option value="1010">Dutch</option>
                                    <option value="1000">English</option>
                                    <option value="1043">Estonian</option>
                                    <option value="1042">Filipino</option>
                                    <option value="1011">Finnish</option>
                                    <option value="1002">French</option>
                                    <option value="1001">German</option>
                                    <option value="1022">Greek</option>
                                    <option value="1027">Hebrew</option>
                                    <option value="1023">Hindi</option>
                                    <option value="1024">Hungarian</option>
                                    <option value="1026">Icelandic</option>
                                    <option value="1025">Indonesian</option>
                                    <option value="1004">Italian</option>
                                    <option value="1005">Japanese</option>
                                    <option value="1012">Korean</option>
                                    <option value="1028">Latvian</option>
                                    <option value="1029">Lithuanian</option>
                                    <option value="1102">Malay</option>
                                    <option value="1013">Norwegian</option>
                                    <option value="1064">Persian</option>
                                    <option value="1030">Polish</option>
                                    <option value="1014">Portuguese</option>
                                    <option value="1032">Romanian</option>
                                    <option value="1031">Russian</option>
                                    <option value="1035">Serbian</option>
                                    <option value="1033">Slovak</option>
                                    <option value="1034">Slovenian</option>
                                    <option value="1003">Spanish</option>
                                    <option value="1015">Swedish</option>
                                    <option value="1044">Thai</option>
                                    <option value="1037">Turkish</option>
                                    <option value="1036">Ukrainian</option>
                                    <option value="1041">Urdu</option>
                                    <option value="1040">Vietnamese</option>
                                </select>
                                <small><b class="uk-text-danger">*current groups and keywords will be removed</b></small>
                            </div>
                        </div>
                        <div class="uk-width-1-2">
                            <div class="uk-form-row">
                                <label style="margin-top: 34px;display: block;" class="uk-form-label" for="autoCreateGroups_disable_cache"><input type="checkbox" name="disable_cache" value="on" id="autoCreateGroups_disable_cache"/> Disable cache lookup <br><small class="uk-text-danger">(increases
                                        cost by 50 credits)</small></label>
                            </div>
                        </div>
                    </div>

                    <div class="uk-form-row" style="margin-top: 10px">
                        <button class="uk-button uk-modal-close" type="button"><i
                                    class="fa fa-close"></i> Cancel
                        </button>
                        <button class="uk-button uk-button-success autoGenerateGroupsBtn" type="submit" style="float: right"><i
                                    class="fa fa-check"></i> Start Operation
                        </button>
                    </div>
                </fieldset>

            </form>
        </div>
    </div>

    <!--New Page Post From ALL Modal-->
    <div id="pagePostMulti" class="uk-modal">
        <div class="uk-modal-dialog">
            <form id="pagePostMultiPost">
                <input type="hidden" name="request_type" value="multi"/>
                <h2 style="margin-top: 2px;text-align: center;">Create All Pages/Posts</h2>
                <div class="uk-overflow-container table_holder_all">

                </div>
                <div class="postMultiButtons">
                    <button class="uk-button uk-button-success pagePostMultiBtn" type="submit"><i
                                class="fa fa-check"></i> Create All
                    </button>
                    <button class="uk-button uk-modal-close" type="button" style="float: right"><i
                                class="fa fa-close"></i> Cancel
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Vol&CPC Model -->
    <div id="VolumeAndCPCModal" class="uk-modal">
        <div class="uk-modal-dialog">
            <div class="uk-grid">
                <div class="uk-width-1-1">
                    <form id="VolumeAndCPCForm" class="uk-form-stacked">
                        <h2><i class="fa fa-key"></i> Retrieve Volume & CPC</h2>
                        <div class="uk-form-row">
                            <label class="uk-form-label" for=""><i class="fa fa-key"></i> Selected Keywords</label>
                            <div class="uk-form-controls">
                                <input style="width: 97% !important;" name="keywords" id="keywords">
                            </div>
                        </div>
                        <input type="hidden" name="ids" id="ids">
                        <div class="uk-grid uk-grid-small uk-margin-top">

                            <div class="uk-width-large-1-3">
                                <div class="uk-form-row">
                                    <label class="uk-form-label" for="autoCreateGroups_languageCode"><i class="fa fa-user"></i> Language:</label>
                                    <select id="getVolAndCpc_languageCode" class="uk-form-select" name="language" class="uk-width-1-1"
                                            style="margin-top: 4px">
                                        <option value="0000">-- All Languages --</option>
                                        <option value="1019">Arabic</option>
                                        <option value="1020">Bulgarian</option>
                                        <option value="1038">Catalan</option>
                                        <option value="1017">Chinese (simplified)</option>
                                        <option value="1018">Chinese (traditional)</option>
                                        <option value="1039">Croatian</option>
                                        <option value="1021">Czech</option>
                                        <option value="1009">Danish</option>
                                        <option value="1010">Dutch</option>
                                        <option value="1000" selected="">English</option>
                                        <option value="1043">Estonian</option>
                                        <option value="1042">Filipino</option>
                                        <option value="1011">Finnish</option>
                                        <option value="1002">French</option>
                                        <option value="1001">German</option>
                                        <option value="1022">Greek</option>
                                        <option value="1027">Hebrew</option>
                                        <option value="1023">Hindi</option>
                                        <option value="1024">Hungarian</option>
                                        <option value="1026">Icelandic</option>
                                        <option value="1025">Indonesian</option>
                                        <option value="1004">Italian</option>
                                        <option value="1005">Japanese</option>
                                        <option value="1012">Korean</option>
                                        <option value="1028">Latvian</option>
                                        <option value="1029">Lithuanian</option>
                                        <option value="1102">Malay</option>
                                        <option value="1013">Norwegian</option>
                                        <option value="1064">Persian</option>
                                        <option value="1030">Polish</option>
                                        <option value="1014">Portuguese</option>
                                        <option value="1032">Romanian</option>
                                        <option value="1031">Russian</option>
                                        <option value="1035">Serbian</option>
                                        <option value="1033">Slovak</option>
                                        <option value="1034">Slovenian</option>
                                        <option value="1003">Spanish</option>
                                        <option value="1015">Swedish</option>
                                        <option value="1044">Thai</option>
                                        <option value="1037">Turkish</option>
                                        <option value="1036">Ukrainian</option>
                                        <option value="1041">Urdu</option>
                                        <option value="1040">Vietnamese</option>
                                    </select>
                                </div>
                            </div>
                            <div class="uk-width-large-2-3">
                                <div class="uk-form-row">
                                    <label style="margin-top: 24px;" class="uk-form-label" for="volumeCPC_disable_cache"><input type="checkbox" name="disable_cache" value="on" id="volumeCPC_disable_cache"/> Disable cache lookup <br><small>(increases cost by 1 credit per keyword)</small></label>
                                </div>
                            </div>

                        </div>

                        <div class="uk-margin-top">
                            <button class="uk-button uk-modal-close" type="button"><i class="fa fa-close"></i> Cancel
                            </button>
                            <button class="uk-button uk-button-primary uk-float-right submitKeywords" type="submit"><i
                                        class="fa fa-check"></i> Retrieve Volume & CPC
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Rank Tracking Modal -->
    <div id="rankTrackingModal" class="uk-modal">
        <div class="uk-modal-dialog">
            <div class="uk-grid">
                <div class="uk-width-1-1">
                    <form id="rankTrackingForm" class="uk-form uk-form-stacked">
                        <h2><i class="fa fa-key"></i> Track Keyword Rankings</h2>
                        <div class="uk-form-row">
                            <label class="uk-form-label" for=""><i class="fa fa-key"></i> Selected Keywords</label>
                            <div class="uk-form-controls">
                                <input style="width: 97% !important;" name="keywords" id="keywords">
                            </div>
                        </div>
                        <div class="uk-grid uk-margin-top">
                            <div class="uk-width-1-2">
                                <label class="uk-form-label" for=""><i class="fa fa-search"></i> Search Engines</label>
                                <div class="uk-form-controls">
                                    <select id="search_engine" class="" multiple="" style="width: 100%"
                                            name="search_engine[]">
                                        <option value="5820">google.com.af (Afghanistan/Arabic)</option>
                                        <option value="5297">google.com.af (Afghanistan/English)</option>
                                        <option value="37">google.com.af (Afghanistan/Pashto)</option>
                                        <option value="38">google.com.af (Afghanistan/Persian)</option>
                                        <option value="39">google.al (Albania/Albanian)</option>
                                        <option value="5765">google.al (Albania/English)</option>
                                        <option value="1013">search.yahoo.com (Albania/All Languages)</option>
                                        <option value="828">search.yahoo.com (Albania/English)</option>
                                        <option value="41">google.dz (Algeria/Arabic)</option>
                                        <option value="5339">google.dz (Algeria/English)</option>
                                        <option value="40">google.dz (Algeria/French)</option>
                                        <option value="1014">search.yahoo.com (Algeria/All Languages)</option>
                                        <option value="829">search.yahoo.com (Algeria/Arabic)</option>
                                        <option value="830">search.yahoo.com (Algeria/French)</option>
                                        <option value="42">google.as (American Samoa/English)</option>
                                        <option value="43">google.ad (Andorra/Catalan)</option>
                                        <option value="5271">google.ad (Andorra/English)</option>
                                        <option value="5291">google.co.ao (Angola/English)</option>
                                        <option value="44">google.co.ao (Angola/Kongo)</option>
                                        <option value="45">google.co.ao (Angola/Portuguese)</option>
                                        <option value="46">google.com.ai (Anguilla/English)</option>
                                        <option value="438">yandex.com (Antarctica/English)</option>
                                        <option value="47">google.com.ag (Antigua and Barbuda/English)</option>
                                        <option value="1015">ar.search.yahoo.com (Argentina/All Languages)</option>
                                        <option value="831">ar.search.yahoo.com (Argentina/English)</option>
                                        <option value="832">ar.search.yahoo.com (Argentina/Spanish)</option>
                                        <option value="962">bing.com (Argentina/All Languages)</option>
                                        <option value="400">bing.com (Argentina/Spanish)</option>
                                        <option value="3402">google.com.ar (Argentina/English)</option>
                                        <option value="48">google.com.ar (Argentina/Espanol (Latinoamerica))</option>
                                        <option value="5437">google.com.ar (Argentina/Spanish)</option>
                                        <option value="440">yandex.com (Argentina/English)</option>
                                        <option value="49">google.am (Armenia/Armenian)</option>
                                        <option value="5273">google.am (Armenia/English)</option>
                                        <option value="50">google.am (Armenia/Russian)</option>
                                        <option value="1016">search.yahoo.com (Armenia/All Languages)</option>
                                        <option value="833">search.yahoo.com (Armenia/English)</option>
                                        <option value="834">search.yahoo.com (Armenia/Russian)</option>
                                        <option value="443">yandex.com (Armenia/English)</option>
                                        <option value="6222">google.com (Aruba/English)</option>
                                        <option value="2908">amazon.com.au (Australia/English)</option>
                                        <option value="1017">au.search.yahoo.com (Australia/All Languages)</option>
                                        <option value="835">au.search.yahoo.com (Australia/English)</option>
                                        <option value="963">bing.com (Australia/All Languages)</option>
                                        <option value="387">bing.com (Australia/English)</option>
                                        <option value="51">google.com.au (Australia/English)</option>
                                        <option value="441">yandex.com (Australia/English)</option>
                                        <option value="1018">at.search.yahoo.com (Austria/All Languages)</option>
                                        <option value="836">at.search.yahoo.com (Austria/English)</option>
                                        <option value="837">at.search.yahoo.com (Austria/German)</option>
                                        <option value="964">bing.com (Austria/All Languages)</option>
                                        <option value="383">bing.com (Austria/German)</option>
                                        <option value="3385">google.at (Austria/English)</option>
                                        <option value="52">google.at (Austria/German)</option>
                                        <option value="442">yandex.com (Austria/English)</option>
                                        <option value="53">google.az (Azerbaijan/Azerbaijani)</option>
                                        <option value="3386">google.az (Azerbaijan/English)</option>
                                        <option value="13">google.az (Azerbaijan/Russian)</option>
                                        <option value="1019">search.yahoo.com (Azerbaijan/All Languages)</option>
                                        <option value="838">search.yahoo.com (Azerbaijan/English)</option>
                                        <option value="839">search.yahoo.com (Azerbaijan/Russian)</option>
                                        <option value="439">yandex.com (Azerbaijan/English)</option>
                                        <option value="55">google.bs (Bahamas/English)</option>
                                        <option value="56">google.com.bh (Bahrain/Arabic)</option>
                                        <option value="2868">google.com.bh (Bahrain/English)</option>
                                        <option value="1020">search.yahoo.com (Bahrain/All Languages)</option>
                                        <option value="840">search.yahoo.com (Bahrain/Arabic)</option>
                                        <option value="57">google.com.bd (Bangladesh/Bengali)</option>
                                        <option value="3403">google.com.bd (Bangladesh/English)</option>
                                        <option value="5708">google.com (Barbados/English)</option>
                                        <option value="58">google.by (Belarus/Belarusian)</option>
                                        <option value="5285">google.by (Belarus/English)</option>
                                        <option value="12">google.by (Belarus/Russian)</option>
                                        <option value="437">yandex.by (Belarus/Belarusian)</option>
                                        <option value="447">yandex.by (Belarus/English)</option>
                                        <option value="2116">yandex.by (Belarus/Russian)</option>
                                        <option value="965">bing.com (Belgium/All Languages)</option>
                                        <option value="421">bing.com (Belgium/Dutch)</option>
                                        <option value="408">bing.com (Belgium/French)</option>
                                        <option value="842">fr.search.yahoo.com (Belgium/French)</option>
                                        <option value="60">google.be (Belgium/Dutch)</option>
                                        <option value="3387">google.be (Belgium/English)</option>
                                        <option value="61">google.be (Belgium/French)</option>
                                        <option value="62">google.be (Belgium/German)</option>
                                        <option value="841">nl.search.yahoo.com (Belgium/Dutch)</option>
                                        <option value="1021">search.yahoo.com (Belgium/All Languages)</option>
                                        <option value="5972">search.yahoo.com (Belgium/English)</option>
                                        <option value="444">yandex.com (Belgium/English)</option>
                                        <option value="63">google.com.bz (Belize/English)</option>
                                        <option value="64">google.com.bz (Belize/Espanol (Latinoamerica))</option>
                                        <option value="5782">google.com.bz (Belize/Spanish)</option>
                                        <option value="5283">google.bj (Benin/English)</option>
                                        <option value="65">google.bj (Benin/French)</option>
                                        <option value="66">google.bj (Benin/Yoruba)</option>
                                        <option value="5761">google.com (Bermuda/English)</option>
                                        <option value="3388">google.bt (Bhutan/English)</option>
                                        <option value="5299">google.com.bo (Bolivia/English)</option>
                                        <option value="67">google.com.bo (Bolivia/Espanol (Latinoamerica))</option>
                                        <option value="68">google.com.bo (Bolivia/Quechua)</option>
                                        <option value="1022">search.yahoo.com (Bolivia/All Languages)</option>
                                        <option value="843">search.yahoo.com (Bolivia/English)</option>
                                        <option value="69">google.ba (Bosnia and Herzegovina/Bosnian)</option>
                                        <option value="71">google.ba (Bosnia and Herzegovina/Croatian)</option>
                                        <option value="5275">google.ba (Bosnia and Herzegovina/English)</option>
                                        <option value="70">google.ba (Bosnia and Herzegovina/Serbian)</option>
                                        <option value="1023">search.yahoo.com (Bosnia and Herzegovina/All Languages)
                                        </option>
                                        <option value="844">search.yahoo.com (Bosnia and Herzegovina/Croatian)</option>
                                        <option value="845">search.yahoo.com (Bosnia and Herzegovina/English)</option>
                                        <option value="5293">google.co.bw (Botswana/English)</option>
                                        <option value="72">google.co.bw (Botswana/Tswana)</option>
                                        <option value="2907">amazon.com.br (Brasil/Portuguese (Brasil))</option>
                                        <option value="966">bing.com (Brazil/All Languages)</option>
                                        <option value="424">bing.com (Brazil/Portuguese)</option>
                                        <option value="1024">br.search.yahoo.com (Brazil/All Languages)</option>
                                        <option value="846">br.search.yahoo.com (Brazil/English)</option>
                                        <option value="847">br.search.yahoo.com (Brazil/Portuguese)</option>
                                        <option value="3405">google.com.br (Brazil/English)</option>
                                        <option value="73">google.com.br (Brazil/Portuguese (Brasil))</option>
                                        <option value="445">yandex.com (Brazil/English)</option>
                                        <option value="360">google.vg (British Virgin Islands/English)</option>
                                        <option value="75">google.com.bn (Brunei/Chinese (Simplified Han))</option>
                                        <option value="3404">google.com.bn (Brunei/English)</option>
                                        <option value="74">google.com.bn (Brunei/Malay)</option>
                                        <option value="967">bing.com (Bulgaria/All Languages)</option>
                                        <option value="380">bing.com (Bulgaria/Bulgarian)</option>
                                        <option value="76">google.bg (Bulgaria/Bulgarian)</option>
                                        <option value="5279">google.bg (Bulgaria/English)</option>
                                        <option value="1025">search.yahoo.com (Bulgaria/All Languages)</option>
                                        <option value="848">search.yahoo.com (Bulgaria/Bulgarian)</option>
                                        <option value="849">search.yahoo.com (Bulgaria/English)</option>
                                        <option value="446">yandex.com (Bulgaria/English)</option>
                                        <option value="5277">google.bf (Burkina Faso/English)</option>
                                        <option value="77">google.bf (Burkina Faso/French)</option>
                                        <option value="5281">google.bi (Burundi/English)</option>
                                        <option value="79">google.bi (Burundi/French)</option>
                                        <option value="78">google.bi (Burundi/Kirundi)</option>
                                        <option value="80">google.bi (Burundi/Swahili)</option>
                                        <option value="3409">google.com.kh (Cambodia/English)</option>
                                        <option value="81">google.com.kh (Cambodia/Khmer)</option>
                                        <option value="3391">google.cm (Cameroon/English)</option>
                                        <option value="82">google.cm (Cameroon/French)</option>
                                        <option value="2909">amazon.ca (Canada/English)</option>
                                        <option value="2910">amazon.ca (Canada/French)</option>
                                        <option value="968">bing.com (Canada/All Languages)</option>
                                        <option value="388">bing.com (Canada/English)</option>
                                        <option value="409">bing.com (Canada/French)</option>
                                        <option value="1026">ca.search.yahoo.com (Canada/All Languages)</option>
                                        <option value="850">ca.search.yahoo.com (Canada/English)</option>
                                        <option value="851">ca.search.yahoo.com (Canada/French)</option>
                                        <option value="23">google.ca (Canada/English)</option>
                                        <option value="84">google.ca (Canada/French)</option>
                                        <option value="448">yandex.com (Canada/English)</option>
                                        <option value="5333">google.cv (Cape Verde/English)</option>
                                        <option value="85">google.cv (Cape Verde/Portuguese)</option>
                                        <option value="5783">google.cv (Cape Verde/Portuguese (Brasil))</option>
                                        <option value="267">google.cat (Catalonia/Catalan)</option>
                                        <option value="5763">google.com (Cayman Islands/English)</option>
                                        <option value="5287">google.cf (Central African Republic/English)</option>
                                        <option value="86">google.cf (Central African Republic/French)</option>
                                        <option value="87">google.td (Chad/Arabic)</option>
                                        <option value="5381">google.td (Chad/English)</option>
                                        <option value="88">google.td (Chad/French)</option>
                                        <option value="969">bing.com (Chile/All Languages)</option>
                                        <option value="401">bing.com (Chile/Spanish)</option>
                                        <option value="853">espanol.search.yahoo.com (Chile/Spanish)</option>
                                        <option value="3390">google.cl (Chile/English)</option>
                                        <option value="89">google.cl (Chile/Espanol (Latinoamerica))</option>
                                        <option value="5769">google.cl (Chile/Spanish)</option>
                                        <option value="1027">search.yahoo.com (Chile/All Languages)</option>
                                        <option value="970">bing.com (China/All Languages)</option>
                                        <option value="434">bing.com (China/Chinese)</option>
                                        <option value="90">google.com.hk (China/Chinese (Simplified Han))</option>
                                        <option value="1028">search.yahoo.com (China/All Languages)</option>
                                        <option value="5974">search.yahoo.com (China/Chinese (Simplified Han))</option>
                                        <option value="854">search.yahoo.com (China/Chinese (Traditional))</option>
                                        <option value="855">search.yahoo.com (China/English)</option>
                                        <option value="449">yandex.com (China/English)</option>
                                        <option value="856">espanol.search.yahoo.com (Colombia/Spanish)</option>
                                        <option value="3406">google.com.co (Colombia/English)</option>
                                        <option value="91">google.com.co (Colombia/Espanol (Latinoamerica))</option>
                                        <option value="5742">google.com.co (Colombia/Spanish)</option>
                                        <option value="1029">search.yahoo.com (Colombia/All Languages)</option>
                                        <option value="857">search.yahoo.com (Colombia/English)</option>
                                        <option value="5799">google.com (Comoros/French)</option>
                                        <option value="101">google.co.ck (Cook Islands/English)</option>
                                        <option value="3392">google.co.cr (Costa Rica/English)</option>
                                        <option value="102">google.co.cr (Costa Rica/Espanol (Latinoamerica))</option>
                                        <option value="5781">google.co.cr (Costa Rica/Spanish)</option>
                                        <option value="1030">search.yahoo.com (Costa Rica/All Languages)</option>
                                        <option value="859">search.yahoo.com (Costa Rica/English)</option>
                                        <option value="858">search.yahoo.com (Costa Rica/Spanish)</option>
                                        <option value="5289">google.ci (Cote dIvoire/English)</option>
                                        <option value="103">google.ci (Cote dIvoire/French)</option>
                                        <option value="971">bing.com (Croatia/All Languages)</option>
                                        <option value="413">bing.com (Croatia/Croatian)</option>
                                        <option value="104">google.hr (Croatia/Croatian)</option>
                                        <option value="5767">google.hr (Croatia/English)</option>
                                        <option value="1031">search.yahoo.com (Croatia/All Languages)</option>
                                        <option value="860">search.yahoo.com (Croatia/Croatian)</option>
                                        <option value="5301">google.com.cu (Cuba/English)</option>
                                        <option value="105">google.com.cu (Cuba/Espanol (Latinoamerica))</option>
                                        <option value="6225">google.com (Curacao/English)</option>
                                        <option value="106">google.com.cy (Cyprus/English)</option>
                                        <option value="107">google.com.cy (Cyprus/Greek)</option>
                                        <option value="108">google.com.cy (Cyprus/Turkish)</option>
                                        <option value="450">yandex.com (Cyprus/English)</option>
                                        <option value="972">bing.com (Czechia/All Languages)</option>
                                        <option value="381">bing.com (Czechia/Czech)</option>
                                        <option value="109">google.cz (Czechia/Czech)</option>
                                        <option value="5335">google.cz (Czechia/English)</option>
                                        <option value="1032">search.yahoo.com (Czechia/All Languages)</option>
                                        <option value="861">search.yahoo.com (Czechia/Czech)</option>
                                        <option value="95">google.cd (Democratic Republic of the Congo/Alur)</option>
                                        <option value="96">google.cd (Democratic Republic of the Congo/French)</option>
                                        <option value="99">google.cd (Democratic Republic of the Congo/Kongo)</option>
                                        <option value="100">google.cd (Democratic Republic of the Congo/Lingala)
                                        </option>
                                        <option value="98">google.cd (Democratic Republic of the Congo/Swahili)</option>
                                        <option value="97">google.cd (Democratic Republic of the Congo/Tshiluba)
                                        </option>
                                        <option value="1033">search.yahoo.com (Democratic Republic of the
                                            Congo/AllLanguages)
                                        </option>
                                        <option value="862">search.yahoo.com (Democratic Republic of the Congo/French)
                                        </option>
                                        <option value="973">bing.com (Denmark/All Languages)</option>
                                        <option value="382">bing.com (Denmark/Danish)</option>
                                        <option value="1034">dk.search.yahoo.com (Denmark/All Languages)</option>
                                        <option value="863">dk.search.yahoo.com (Denmark/Danish)</option>
                                        <option value="864">dk.search.yahoo.com (Denmark/English)</option>
                                        <option value="110">google.dk (Denmark/Danish)</option>
                                        <option value="3421">google.dk (Denmark/English)</option>
                                        <option value="111">google.dk (Denmark/Faroese)</option>
                                        <option value="451">yandex.com (Denmark/English)</option>
                                        <option value="114">google.dj (Djibouti/Arabic)</option>
                                        <option value="5337">google.dj (Djibouti/English)</option>
                                        <option value="113">google.dj (Djibouti/French)</option>
                                        <option value="112">google.dj (Djibouti/Somali)</option>
                                        <option value="115">google.dm (Dominica/English)</option>
                                        <option value="5303">google.com.do (Dominican Republic/English)</option>
                                        <option value="116">google.com.do (Dominican Republic/Espanol (Latinoamerica))
                                        </option>
                                        <option value="5760">google.com.do (Dominican Republic/Spanish)</option>
                                        <option value="5305">google.com.ec (Ecuador/English)</option>
                                        <option value="117">google.com.ec (Ecuador/Espanol (Latinoamerica))</option>
                                        <option value="5774">google.com.ec (Ecuador/Spanish)</option>
                                        <option value="1035">search.yahoo.com (Ecuador/All Languages)</option>
                                        <option value="865">search.yahoo.com (Ecuador/English)</option>
                                        <option value="118">google.com.eg (Egypt/Arabic)</option>
                                        <option value="2873">google.com.eg (Egypt/English)</option>
                                        <option value="1036">search.yahoo.com (Egypt/All Languages)</option>
                                        <option value="866">search.yahoo.com (Egypt/Arabic)</option>
                                        <option value="867">search.yahoo.com (Egypt/English)</option>
                                        <option value="484">yandex.com (Egypt/English)</option>
                                        <option value="5321">google.com.sv (El Salvador/English)</option>
                                        <option value="119">google.com.sv (El Salvador/Espanol (Latinoamerica))</option>
                                        <option value="5743">google.com.sv (El Salvador/Spanish)</option>
                                        <option value="1037">search.yahoo.com (El Salvador/All Languages)</option>
                                        <option value="868">search.yahoo.com (El Salvador/English)</option>
                                        <option value="5787">google.com (Eritrea/Arabic)</option>
                                        <option value="974">bing.com (Estonia/All Languages)</option>
                                        <option value="406">bing.com (Estonia/Estonian)</option>
                                        <option value="3422">google.ee (Estonia/English)</option>
                                        <option value="121">google.ee (Estonia/Estonian)</option>
                                        <option value="120">google.ee (Estonia/Russian)</option>
                                        <option value="1038">search.yahoo.com (Estonia/All Languages)</option>
                                        <option value="869">search.yahoo.com (Estonia/Estonian)</option>
                                        <option value="870">search.yahoo.com (Estonia/Russian)</option>
                                        <option value="122">google.com.et (Ethiopia/Amharic)</option>
                                        <option value="3407">google.com.et (Ethiopia/English)</option>
                                        <option value="123">google.com.et (Ethiopia/Oromo)</option>
                                        <option value="125">google.com.et (Ethiopia/Somali)</option>
                                        <option value="124">google.com.et (Ethiopia/Tigrinya)</option>
                                        <option value="5789">google.com (Faroe Islands/Faroese)</option>
                                        <option value="126">google.com.fj (Fiji/English)</option>
                                        <option value="975">bing.com (Finland/All Languages)</option>
                                        <option value="407">bing.com (Finland/Finnish)</option>
                                        <option value="1039">fi.search.yahoo.com (Finland/All Languages)</option>
                                        <option value="871">fi.search.yahoo.com (Finland/English)</option>
                                        <option value="872">fi.search.yahoo.com (Finland/Finnish)</option>
                                        <option value="873">fi.search.yahoo.com (Finland/Swedish)</option>
                                        <option value="3423">google.fi (Finland/English)</option>
                                        <option value="128">google.fi (Finland/Finnish)</option>
                                        <option value="127">google.fi (Finland/Swedish)</option>
                                        <option value="452">yandex.com (Finland/English)</option>
                                        <option value="2911">amazon.fr (France/French)</option>
                                        <option value="976">bing.com (France/All Languages)</option>
                                        <option value="411">bing.com (France/French)</option>
                                        <option value="1040">fr.search.yahoo.com (France/All Languages)</option>
                                        <option value="874">fr.search.yahoo.com (France/French)</option>
                                        <option value="2838">google.fr (France/English)</option>
                                        <option value="129">google.fr (France/French)</option>
                                        <option value="453">yandex.com (France/English)</option>
                                        <option value="5793">google.com (French Guiana/French)</option>
                                        <option value="5816">google.com (French Polynesia/French)</option>
                                        <option value="5341">google.ga (Gabon/English)</option>
                                        <option value="130">google.ga (Gabon/French)</option>
                                        <option value="131">google.gm (Gambia/English)</option>
                                        <option value="132">google.gm (Gambia/Wolof)</option>
                                        <option value="5343">google.ge (Georgia/English)</option>
                                        <option value="133">google.ge (Georgia/Georgian)</option>
                                        <option value="1041">search.yahoo.com (Georgia/All Languages)</option>
                                        <option value="875">search.yahoo.com (Georgia/English)</option>
                                        <option value="2917">amazon.de (Germany/Czech)</option>
                                        <option value="2914">amazon.de (Germany/Dutch)</option>
                                        <option value="2913">amazon.de (Germany/English)</option>
                                        <option value="2912">amazon.de (Germany/German)</option>
                                        <option value="2915">amazon.de (Germany/Polish)</option>
                                        <option value="2916">amazon.de (Germany/Turkish)</option>
                                        <option value="977">bing.com (Germany/All Languages)</option>
                                        <option value="385">bing.com (Germany/German)</option>
                                        <option value="1042">de.search.yahoo.com (Germany/All Languages)</option>
                                        <option value="876">de.search.yahoo.com (Germany/German)</option>
                                        <option value="2927">google.de (Germany/English)</option>
                                        <option value="25">google.de (Germany/German)</option>
                                        <option value="454">yandex.com (Germany/English)</option>
                                        <option value="136">google.com.gh (Ghana/Akan)</option>
                                        <option value="138">google.com.gh (Ghana/English)</option>
                                        <option value="137">google.com.gh (Ghana/Ewe)</option>
                                        <option value="139">google.com.gh (Ghana/Ga)</option>
                                        <option value="135">google.com.gh (Ghana/Hausa)</option>
                                        <option value="141">google.com.gi (Gibraltar/English)</option>
                                        <option value="5400">google.com.gi (Gibraltar/Espanol (Latinoamerica))</option>
                                        <option value="143">google.com.gi (Gibraltar/Italian)</option>
                                        <option value="140">google.com.gi (Gibraltar/Portuguese)</option>
                                        <option value="142">google.com.gi (Gibraltar/Spanish)</option>
                                        <option value="978">bing.com (Greece/All Languages)</option>
                                        <option value="386">bing.com (Greece/Greek)</option>
                                        <option value="3424">google.gr (Greece/English)</option>
                                        <option value="144">google.gr (Greece/Greek)</option>
                                        <option value="1043">gr.search.yahoo.com (Greece/All Languages)</option>
                                        <option value="877">gr.search.yahoo.com (Greece/English)</option>
                                        <option value="878">gr.search.yahoo.com (Greece/Greek)</option>
                                        <option value="455">yandex.com (Greece/English)</option>
                                        <option value="145">google.gl (Greenland/Danish)</option>
                                        <option value="5345">google.gl (Greenland/English)</option>
                                        <option value="5791">google.com (Grenada/English)</option>
                                        <option value="5347">google.gp (Guadeloupe/English)</option>
                                        <option value="146">google.gp (Guadeloupe/French)</option>
                                        <option value="5702">google.com (Guam/English)</option>
                                        <option value="3673">google.com.gt (Guatemala/English)</option>
                                        <option value="147">google.com.gt (Guatemala/Espanol (Latinoamerica))</option>
                                        <option value="5772">google.com.gt (Guatemala/Spanish)</option>
                                        <option value="1044">search.yahoo.com (Guatemala/All Languages)</option>
                                        <option value="879">search.yahoo.com (Guatemala/English)</option>
                                        <option value="148">google.gg (Guernsey/English)</option>
                                        <option value="149">google.gg (Guernsey/French)</option>
                                        <option value="5795">google.com (Guinea/French)</option>
                                        <option value="150">google.gy (Guyana/English)</option>
                                        <option value="5351">google.ht (Haiti/English)</option>
                                        <option value="152">google.ht (Haiti/French)</option>
                                        <option value="151">google.ht (Haiti/Haitian)</option>
                                        <option value="5349">google.hn (Honduras/English)</option>
                                        <option value="153">google.hn (Honduras/Espanol (Latinoamerica))</option>
                                        <option value="5768">google.hn (Honduras/Spanish)</option>
                                        <option value="1045">search.yahoo.com (Honduras/All Languages)</option>
                                        <option value="880">search.yahoo.com (Honduras/English)</option>
                                        <option value="979">bing.com (Hong Kong/All Languages)</option>
                                        <option value="435">bing.com (Hong Kong/Chinese (Traditional Han))</option>
                                        <option value="5733">google.com.hk (Hong Kong/Chinese)</option>
                                        <option value="3611">google.com.hk (Hong Kong/Chinese (Simplified))</option>
                                        <option value="154">google.com.hk (Hong Kong/Chinese (Traditional))</option>
                                        <option value="5735">google.com.hk (Hong Kong/Chinese (Traditional Han))
                                        </option>
                                        <option value="2843">google.com.hk (Hong Kong/English)</option>
                                        <option value="1046">hk.search.yahoo.com (Hong Kong/All Languages)</option>
                                        <option value="881">hk.search.yahoo.com (Hong Kong/Chinese (Traditional Han))
                                        </option>
                                        <option value="882">hk.search.yahoo.com (Hong Kong/English)</option>
                                        <option value="980">bing.com (Hungary/All Languages)</option>
                                        <option value="414">bing.com (Hungary/Hungarian)</option>
                                        <option value="3425">google.hu (Hungary/English)</option>
                                        <option value="155">google.hu (Hungary/Hungarian)</option>
                                        <option value="1047">search.yahoo.com (Hungary/All Languages)</option>
                                        <option value="883">search.yahoo.com (Hungary/English)</option>
                                        <option value="884">search.yahoo.com (Hungary/Hungarian)</option>
                                        <option value="456">yandex.com (Hungary/English)</option>
                                        <option value="3426">google.is (Iceland/English)</option>
                                        <option value="156">google.is (Iceland/Icelandic)</option>
                                        <option value="1048">search.yahoo.com (Iceland/All Languages)</option>
                                        <option value="885">search.yahoo.com (Iceland/English)</option>
                                        <option value="2919">amazon.in (India/English)</option>
                                        <option value="981">bing.com (India/All Languages)</option>
                                        <option value="392">bing.com (India/English)</option>
                                        <option value="159">google.co.in (India/Bengali)</option>
                                        <option value="163">google.co.in (India/English)</option>
                                        <option value="161">google.co.in (India/Gujarati)</option>
                                        <option value="166">google.co.in (India/Hindi)</option>
                                        <option value="164">google.co.in (India/Kannada)</option>
                                        <option value="157">google.co.in (India/Malayalam)</option>
                                        <option value="165">google.co.in (India/Marathi)</option>
                                        <option value="160">google.co.in (India/Panjabi)</option>
                                        <option value="158">google.co.in (India/Tamil)</option>
                                        <option value="162">google.co.in (India/Telugu)</option>
                                        <option value="1049">in.search.yahoo.com (India/All Languages)</option>
                                        <option value="886">in.search.yahoo.com (India/English)</option>
                                        <option value="457">yandex.com (India/English)</option>
                                        <option value="982">bing.com (Indonesia/All Languages)</option>
                                        <option value="390">bing.com (Indonesia/English)</option>
                                        <option value="5836">bing.com (Indonesia/Indonesian)</option>
                                        <option value="5295">google.co.id (Indonesia/Balinese)</option>
                                        <option value="168">google.co.id (Indonesia/Basa Jawa)</option>
                                        <option value="2901">google.co.id (Indonesia/English)</option>
                                        <option value="167">google.co.id (Indonesia/Indonesian)</option>
                                        <option value="1050">id.search.yahoo.com (Indonesia/All Languages)</option>
                                        <option value="887">id.search.yahoo.com (Indonesia/English)</option>
                                        <option value="5975">id.search.yahoo.com (Indonesia/Indonesian)</option>
                                        <option value="170">google.iq (Iraq/Arabic)</option>
                                        <option value="2878">google.iq (Iraq/English)</option>
                                        <option value="169">google.iq (Iraq/Kurdish)</option>
                                        <option value="1051">search.yahoo.com (Iraq/All Languages)</option>
                                        <option value="888">search.yahoo.com (Iraq/Arabic)</option>
                                        <option value="983">bing.com (Ireland/All Languages)</option>
                                        <option value="391">bing.com (Ireland/English)</option>
                                        <option value="172">google.ie (Ireland/English)</option>
                                        <option value="171">google.ie (Ireland/Irish)</option>
                                        <option value="1052">ie.search.yahoo.com (Ireland/All Languages)</option>
                                        <option value="889">ie.search.yahoo.com (Ireland/English)</option>
                                        <option value="173">google.im (Isle of Man/English)</option>
                                        <option value="984">bing.com (Israel/All Languages)</option>
                                        <option value="412">bing.com (Israel/Hebrew)</option>
                                        <option value="175">google.co.il (Israel/Arabic)</option>
                                        <option value="3393">google.co.il (Israel/English)</option>
                                        <option value="174">google.co.il (Israel/Hebrew)</option>
                                        <option value="1053">search.yahoo.com (Israel/All Languages)</option>
                                        <option value="890">search.yahoo.com (Israel/Arabic)</option>
                                        <option value="891">search.yahoo.com (Israel/Hebrew)</option>
                                        <option value="458">yandex.com (Israel/English)</option>
                                        <option value="2920">amazon.it (Italy/Italian)</option>
                                        <option value="985">bing.com (Italy/All Languages)</option>
                                        <option value="415">bing.com (Italy/Italian)</option>
                                        <option value="3427">google.it (Italy/English)</option>
                                        <option value="176">google.it (Italy/Italian)</option>
                                        <option value="1054">it.search.yahoo.com (Italy/All Languages)</option>
                                        <option value="892">it.search.yahoo.com (Italy/English)</option>
                                        <option value="893">it.search.yahoo.com (Italy/Italian)</option>
                                        <option value="459">yandex.com (Italy/English)</option>
                                        <option value="177">google.com.jm (Jamaica/English)</option>
                                        <option value="2918">amazon.co.jp (Japan/Chinese (Simplified Han))</option>
                                        <option value="2922">amazon.co.jp (Japan/English)</option>
                                        <option value="2921">amazon.co.jp (Japan/Japanese)</option>
                                        <option value="986">bing.com (Japan/All Languages)</option>
                                        <option value="416">bing.com (Japan/Japanese)</option>
                                        <option value="3394">google.co.jp (Japan/English)</option>
                                        <option value="178">google.co.jp (Japan/Japanese)</option>
                                        <option value="5435">search.yahoo.co.jp (Japan/English)</option>
                                        <option value="5436">search.yahoo.co.jp (Japan/Japanese)</option>
                                        <option value="1055">search.yahoo.com (Japan/All Languages)</option>
                                        <option value="894">search.yahoo.com (Japan/English)</option>
                                        <option value="895">search.yahoo.com (Japan/Japanese)</option>
                                        <option value="460">yandex.com (Japan/English)</option>
                                        <option value="179">google.je (Jersey/English)</option>
                                        <option value="180">google.je (Jersey/French)</option>
                                        <option value="181">google.jo (Jordan/Arabic)</option>
                                        <option value="2863">google.jo (Jordan/English)</option>
                                        <option value="5355">google.kz (Kazakhstan/English)</option>
                                        <option value="183">google.kz (Kazakhstan/Kazakh)</option>
                                        <option value="11">google.kz (Kazakhstan/Russian)</option>
                                        <option value="377">yandex.kz (Kazakhstan/English)</option>
                                        <option value="378">yandex.kz (Kazakhstan/Kazakh)</option>
                                        <option value="19">yandex.kz (Kazakhstan/Russian)</option>
                                        <option value="5959">bing.com (Kenya/Swahili)</option>
                                        <option value="3395">google.co.ke (Kenya/English)</option>
                                        <option value="184">google.co.ke (Kenya/Swahili)</option>
                                        <option value="1056">search.yahoo.com (Kenya/All Languages)</option>
                                        <option value="896">search.yahoo.com (Kenya/English)</option>
                                        <option value="185">google.ki (Kiribati/English)</option>
                                        <option value="187">google.com.kw (Kuwait/Arabic)</option>
                                        <option value="2853">google.com.kw (Kuwait/English)</option>
                                        <option value="1057">search.yahoo.com (Kuwait/All Languages)</option>
                                        <option value="897">search.yahoo.com (Kuwait/Arabic)</option>
                                        <option value="5353">google.kg (Kyrgyzstan/English)</option>
                                        <option value="189">google.kg (Kyrgyzstan/Kyrgyz)</option>
                                        <option value="188">google.kg (Kyrgyzstan/Russian)</option>
                                        <option value="3428">google.la (Laos/English)</option>
                                        <option value="190">google.la (Laos/Lao)</option>
                                        <option value="987">bing.com (Latvia/All Languages)</option>
                                        <option value="419">bing.com (Latvia/Latvian)</option>
                                        <option value="3431">google.lv (Latvia/English)</option>
                                        <option value="193">google.lv (Latvia/Latvian)</option>
                                        <option value="191">google.lv (Latvia/Lithuanian)</option>
                                        <option value="192">google.lv (Latvia/Russian)</option>
                                        <option value="1058">search.yahoo.com (Latvia/All Languages)</option>
                                        <option value="898">search.yahoo.com (Latvia/English)</option>
                                        <option value="899">search.yahoo.com (Latvia/Latvian)</option>
                                        <option value="901">search.yahoo.com (Latvia/Russian)</option>
                                        <option value="463">yandex.com (Latvia/English)</option>
                                        <option value="194">google.com.lb (Lebanon/Arabic)</option>
                                        <option value="196">google.com.lb (Lebanon/Armenian)</option>
                                        <option value="2883">google.com.lb (Lebanon/English)</option>
                                        <option value="195">google.com.lb (Lebanon/French)</option>
                                        <option value="1059">search.yahoo.com (Lebanon/All Languages)</option>
                                        <option value="902">search.yahoo.com (Lebanon/Arabic)</option>
                                        <option value="903">search.yahoo.com (Lebanon/French)</option>
                                        <option value="197">google.co.ls (Lesotho/English)</option>
                                        <option value="198">google.co.ls (Lesotho/Southern Sotho)</option>
                                        <option value="5803">google.com (Liberia/English)</option>
                                        <option value="199">google.com.ly (Libya/Arabic)</option>
                                        <option value="3410">google.com.ly (Libya/English)</option>
                                        <option value="200">google.com.ly (Libya/Italian)</option>
                                        <option value="1060">search.yahoo.com (Libya/All Languages)</option>
                                        <option value="904">search.yahoo.com (Libya/Arabic)</option>
                                        <option value="905">search.yahoo.com (Libya/Italian)</option>
                                        <option value="5357">google.li (Liechtenstein/English)</option>
                                        <option value="201">google.li (Liechtenstein/German)</option>
                                        <option value="988">bing.com (Lithuania/All Languages)</option>
                                        <option value="418">bing.com (Lithuania/Lithuanian)</option>
                                        <option value="3429">google.lt (Lithuania/English)</option>
                                        <option value="202">google.lt (Lithuania/Lithuanian)</option>
                                        <option value="1061">search.yahoo.com (Lithuania/All Languages)</option>
                                        <option value="906">search.yahoo.com (Lithuania/English)</option>
                                        <option value="900">search.yahoo.com (Lithuania/Lithuanian)</option>
                                        <option value="464">yandex.com (Lithuania/English)</option>
                                        <option value="3430">google.lu (Luxembourg/English)</option>
                                        <option value="204">google.lu (Luxembourg/French)</option>
                                        <option value="203">google.lu (Luxembourg/German)</option>
                                        <option value="1062">search.yahoo.com (Luxembourg/All Languages)</option>
                                        <option value="907">search.yahoo.com (Luxembourg/French)</option>
                                        <option value="908">search.yahoo.com (Luxembourg/German)</option>
                                        <option value="5770">google.com (Macao/Chinese (Traditional Han))</option>
                                        <option value="5363">google.mk (Macedonia/English)</option>
                                        <option value="205">google.mk (Macedonia/Macedonian)</option>
                                        <option value="1063">search.yahoo.com (Macedonia/All Languages)</option>
                                        <option value="909">search.yahoo.com (Macedonia/English)</option>
                                        <option value="5361">google.mg (Madagascar/English)</option>
                                        <option value="207">google.mg (Madagascar/French)</option>
                                        <option value="206">google.mg (Madagascar/Malagasy)</option>
                                        <option value="208">google.mw (Malawi/Chichewa)</option>
                                        <option value="5369">google.mw (Malawi/English)</option>
                                        <option value="209">google.mw (Malawi/Malawi)</option>
                                        <option value="989">bing.com (Malaysia/All Languages)</option>
                                        <option value="393">bing.com (Malaysia/English)</option>
                                        <option value="2896">google.com.my (Malaysia/English)</option>
                                        <option value="210">google.com.my (Malaysia/Malay)</option>
                                        <option value="1064">malaysia.search.yahoo.com (Malaysia/All Languages)</option>
                                        <option value="910">malaysia.search.yahoo.com (Malaysia/English)</option>
                                        <option value="5976">malaysia.search.yahoo.com (Malaysia/Malay)</option>
                                        <option value="211">google.mv (Maldives/English)</option>
                                        <option value="5365">google.ml (Mali/English)</option>
                                        <option value="212">google.ml (Mali/French)</option>
                                        <option value="3412">google.com.mt (Malta/English)</option>
                                        <option value="213">google.com.mt (Malta/Maltese)</option>
                                        <option value="1065">search.yahoo.com (Malta/All Languages)</option>
                                        <option value="911">search.yahoo.com (Malta/English)</option>
                                        <option value="465">yandex.com (Malta/English)</option>
                                        <option value="5810">google.com (Martinique/French)</option>
                                        <option value="5812">google.com (Mauritania/Arabic)</option>
                                        <option value="214">google.mu (Mauritius/English)</option>
                                        <option value="215">google.mu (Mauritius/French)</option>
                                        <option value="216">google.mu (Mauritius/Kreol morisien)</option>
                                        <option value="2923">amazon.com.mx (Mexico/Espanol (Latinoamerica))</option>
                                        <option value="990">bing.com (Mexico/All Languages)</option>
                                        <option value="403">bing.com (Mexico/Spanish)</option>
                                        <option value="3413">google.com.mx (Mexico/English)</option>
                                        <option value="217">google.com.mx (Mexico/Espanol (Latinoamerica))</option>
                                        <option value="5741">google.com.mx (Mexico/Spanish)</option>
                                        <option value="1066">mx.search.yahoo.com (Mexico/All Languages)</option>
                                        <option value="912">mx.search.yahoo.com (Mexico/English)</option>
                                        <option value="913">mx.search.yahoo.com (Mexico/Spanish)</option>
                                        <option value="466">yandex.com (Mexico/English)</option>
                                        <option value="218">google.fm (Micronesia/English)</option>
                                        <option value="219">google.md (Moldova/Moldovian)</option>
                                        <option value="5753">google.md (Moldova/Romanian)</option>
                                        <option value="220">google.md (Moldova/Russian)</option>
                                        <option value="467">yandex.com (Moldova/English)</option>
                                        <option value="5367">google.mn (Mongolia/English)</option>
                                        <option value="221">google.mn (Mongolia/Mongolian)</option>
                                        <option value="222">google.me (Montenegro/Bosnian)</option>
                                        <option value="5359">google.me (Montenegro/English)</option>
                                        <option value="223">google.me (Montenegro/Montenegro)</option>
                                        <option value="224">google.me (Montenegro/Serbian)</option>
                                        <option value="225">google.ms (Montserrat/English)</option>
                                        <option value="227">google.co.ma (Morocco/Arabic)</option>
                                        <option value="3397">google.co.ma (Morocco/English)</option>
                                        <option value="226">google.co.ma (Morocco/French)</option>
                                        <option value="1067">search.yahoo.com (Morocco/All Languages)</option>
                                        <option value="914">search.yahoo.com (Morocco/Arabic)</option>
                                        <option value="915">search.yahoo.com (Morocco/French)</option>
                                        <option value="229">google.co.mz (Mozambique/Chichewa)</option>
                                        <option value="3398">google.co.mz (Mozambique/English)</option>
                                        <option value="231">google.co.mz (Mozambique/Portuguese)</option>
                                        <option value="5785">google.co.mz (Mozambique/Portuguese (Brasil))</option>
                                        <option value="230">google.co.mz (Mozambique/Shona)</option>
                                        <option value="228">google.co.mz (Mozambique/Swahili)</option>
                                        <option value="5832">google.com.mm (Myanmar/Burmese)</option>
                                        <option value="3411">google.com.mm (Myanmar/English)</option>
                                        <option value="234">google.com.na (Namibia/Afrikaans)</option>
                                        <option value="233">google.com.na (Namibia/English)</option>
                                        <option value="232">google.com.na (Namibia/German)</option>
                                        <option value="235">google.nr (Nauru/English)</option>
                                        <option value="3414">google.com.np (Nepal/English)</option>
                                        <option value="236">google.com.np (Nepal/Nepali)</option>
                                        <option value="2926">amazon.nl (Netherlands/Dutch)</option>
                                        <option value="991">bing.com (Netherlands/All Languages)</option>
                                        <option value="422">bing.com (Netherlands/Dutch)</option>
                                        <option value="24">google.nl (Netherlands/Dutch)</option>
                                        <option value="237">google.nl (Netherlands/English)</option>
                                        <option value="5373">google.nl (Netherlands/Frisian)</option>
                                        <option value="1068">nl.search.yahoo.com (Netherlands/All Languages)</option>
                                        <option value="916">nl.search.yahoo.com (Netherlands/Dutch)</option>
                                        <option value="917">nl.search.yahoo.com (Netherlands/English)</option>
                                        <option value="468">yandex.com (Netherlands/English)</option>
                                        <option value="5814">google.com (New Caledonia/French)</option>
                                        <option value="992">bing.com (New Zealand/All Languages)</option>
                                        <option value="394">bing.com (New Zealand/English)</option>
                                        <option value="239">google.co.nz (New Zealand/English)</option>
                                        <option value="240">google.co.nz (New Zealand/Maori)</option>
                                        <option value="1069">search.yahoo.com (New Zealand/All Languages)</option>
                                        <option value="918">search.yahoo.com (New Zealand/English)</option>
                                        <option value="469">yandex.com (New Zealand/English)</option>
                                        <option value="5307">google.com.ni (Nicaragua/English)</option>
                                        <option value="241">google.com.ni (Nicaragua/Espanol (Latinoamerica))</option>
                                        <option value="5830">google.com.ni (Nicaragua/Spanish)</option>
                                        <option value="1070">search.yahoo.com (Nicaragua/All Languages)</option>
                                        <option value="919">search.yahoo.com (Nicaragua/English)</option>
                                        <option value="5371">google.ne (Niger/English)</option>
                                        <option value="242">google.ne (Niger/French)</option>
                                        <option value="243">google.ne (Niger/Hausa)</option>
                                        <option value="248">google.com.ng (Nigeria/English)</option>
                                        <option value="245">google.com.ng (Nigeria/Hausa)</option>
                                        <option value="246">google.com.ng (Nigeria/Igbo)</option>
                                        <option value="244">google.com.ng (Nigeria/Pidgin)</option>
                                        <option value="247">google.com.ng (Nigeria/Yoruba)</option>
                                        <option value="249">google.nu (Niue/English)</option>
                                        <option value="250">google.com.nf (Norfolk Island/English)</option>
                                        <option value="5808">google.com (Northern Mariana Islands/English)</option>
                                        <option value="993">bing.com (Norway/All Languages)</option>
                                        <option value="5837">bing.com (Norway/English)</option>
                                        <option value="420">bing.com (Norway/Norwegian)</option>
                                        <option value="3432">google.no (Norway/English)</option>
                                        <option value="251">google.no (Norway/Norwegian)</option>
                                        <option value="3680">google.no (Norway/Norwegian Bokmal)</option>
                                        <option value="252">google.no (Norway/Norwegian Nynorsk)</option>
                                        <option value="1071">no.search.yahoo.com (Norway/All Languages)</option>
                                        <option value="920">no.search.yahoo.com (Norway/English)</option>
                                        <option value="921">no.search.yahoo.com (Norway/Norwegian)</option>
                                        <option value="470">yandex.com (Norway/English)</option>
                                        <option value="253">google.com.om (Oman/Arabic)</option>
                                        <option value="2894">google.com.om (Oman/English)</option>
                                        <option value="1072">search.yahoo.com (Oman/All Languages)</option>
                                        <option value="922">search.yahoo.com (Oman/Arabic)</option>
                                        <option value="254">google.com.pk (Pakistan/English)</option>
                                        <option value="5313">google.com.pk (Pakistan/Pashto, Pushto)</option>
                                        <option value="5315">google.com.pk (Pakistan/Sindhi)</option>
                                        <option value="255">google.com.pk (Pakistan/Urdu)</option>
                                        <option value="1073">search.yahoo.com (Pakistan/All Languages)</option>
                                        <option value="923">search.yahoo.com (Pakistan/English)</option>
                                        <option value="5818">google.com (Palau/English)</option>
                                        <option value="256">google.ps (Palestine/Arabic)</option>
                                        <option value="2892">google.ps (Palestine/English)</option>
                                        <option value="5309">google.com.pa (Panama/English)</option>
                                        <option value="257">google.com.pa (Panama/Espanol (Latinoamerica))</option>
                                        <option value="1074">search.yahoo.com (Panama/All Languages)</option>
                                        <option value="924">search.yahoo.com (Panama/English)</option>
                                        <option value="3416">google.com.pg (Papua New Guina/English)</option>
                                        <option value="5319">google.com.py (Paraguay/English)</option>
                                        <option value="258">google.com.py (Paraguay/Espanol (Latinoamerica))</option>
                                        <option value="5775">google.com.py (Paraguay/Spanish)</option>
                                        <option value="1075">search.yahoo.com (Paraguay/All Languages)</option>
                                        <option value="925">search.yahoo.com (Paraguay/English)</option>
                                        <option value="5977">espanol.search.yahoo.com (Peru/Spanish)</option>
                                        <option value="3415">google.com.pe (Peru/English)</option>
                                        <option value="259">google.com.pe (Peru/Espanol (Latinoamerica))</option>
                                        <option value="260">google.com.pe (Peru/Quechua)</option>
                                        <option value="5776">google.com.pe (Peru/Spanish)</option>
                                        <option value="1076">search.yahoo.com (Peru/All Languages)</option>
                                        <option value="926">search.yahoo.com (Peru/English)</option>
                                        <option value="994">bing.com (Philippines/All Languages)</option>
                                        <option value="395">bing.com (Philippines/English)</option>
                                        <option value="5311">google.com.ph (Philippines/Cebuano)</option>
                                        <option value="3417">google.com.ph (Philippines/English)</option>
                                        <option value="5746">google.com.ph (Philippines/Filipino)</option>
                                        <option value="261">google.com.ph (Philippines/Tagalog)</option>
                                        <option value="1077">ph.search.yahoo.com (Philippines/All Languages)</option>
                                        <option value="927">ph.search.yahoo.com (Philippines/English)</option>
                                        <option value="5978">ph.search.yahoo.com (Philippines/Spanish)</option>
                                        <option value="262">google.pn (Pitcairn Islands/English)</option>
                                        <option value="995">bing.com (Poland/All Languages)</option>
                                        <option value="5838">bing.com (Poland/English)</option>
                                        <option value="423">bing.com (Poland/Polish)</option>
                                        <option value="3433">google.pl (Poland/English)</option>
                                        <option value="21">google.pl (Poland/Polish)</option>
                                        <option value="1078">pl.search.yahoo.com (Poland/All Languages)</option>
                                        <option value="928">pl.search.yahoo.com (Poland/English)</option>
                                        <option value="929">pl.search.yahoo.com (Poland/Polish)</option>
                                        <option value="471">yandex.com (Poland/English)</option>
                                        <option value="996">bing.com (Portugal/All Languages)</option>
                                        <option value="425">bing.com (Portugal/Portuguese)</option>
                                        <option value="3434">google.pt (Portugal/English)</option>
                                        <option value="264">google.pt (Portugal/Portuguese)</option>
                                        <option value="1079">search.yahoo.com (Portugal/All Languages)</option>
                                        <option value="930">search.yahoo.com (Portugal/Portuguese)</option>
                                        <option value="5317">google.com.pr (Puerto Rico/English)</option>
                                        <option value="265">google.com.pr (Puerto Rico/Espanol (Latinoamerica))</option>
                                        <option value="5739">google.com.pr (Puerto Rico/Spanish)</option>
                                        <option value="1080">search.yahoo.com (Puerto Rico/All Languages)</option>
                                        <option value="931">search.yahoo.com (Puerto Rico/English)</option>
                                        <option value="266">google.com.qa (Qatar/Arabic)</option>
                                        <option value="2895">google.com.qa (Qatar/English)</option>
                                        <option value="1081">search.yahoo.com (Qatar/All Languages)</option>
                                        <option value="932">search.yahoo.com (Qatar/Arabic)</option>
                                        <option value="92">google.cg (Republic of the Congo/French)</option>
                                        <option value="94">google.cg (Republic of the Congo/Kongo)</option>
                                        <option value="93">google.cg (Republic of the Congo/Lingala)</option>
                                        <option value="5807">google.com (Reunion/French)</option>
                                        <option value="997">bing.com (Romania/All Languages)</option>
                                        <option value="426">bing.com (Romania/Romanian)</option>
                                        <option value="3435">google.ro (Romania/English)</option>
                                        <option value="269">google.ro (Romania/German)</option>
                                        <option value="268">google.ro (Romania/Hungarian)</option>
                                        <option value="270">google.ro (Romania/Romanian)</option>
                                        <option value="1082">ro.search.yahoo.com (Romania/All Languages)</option>
                                        <option value="933">ro.search.yahoo.com (Romania/German)</option>
                                        <option value="934">ro.search.yahoo.com (Romania/Romanian)</option>
                                        <option value="998">bing.com (Russia/All Languages)</option>
                                        <option value="427">bing.com (Russia/Russian)</option>
                                        <option value="3437">google.ru (Russia/English)</option>
                                        <option value="3">google.ru (Russia/Russian)</option>
                                        <option value="1083">ru.search.yahoo.com (Russia/All Languages)</option>
                                        <option value="935">ru.search.yahoo.com (Russia/English)</option>
                                        <option value="936">ru.search.yahoo.com (Russia/Russian)</option>
                                        <option value="376">yandex.ru (Russia/English)</option>
                                        <option value="1">yandex.ru (Russia/Russian)</option>
                                        <option value="274">google.rw (Rwanda/English)</option>
                                        <option value="275">google.rw (Rwanda/French)</option>
                                        <option value="273">google.rw (Rwanda/Kinyarwanda)</option>
                                        <option value="272">google.rw (Rwanda/Swahili)</option>
                                        <option value="276">google.sh (Saint Helena/English)</option>
                                        <option value="5801">google.com (Saint Kitts and Nevis/English)</option>
                                        <option value="277">google.com.vc (Saint Vincent and the Grenadines/English)
                                        </option>
                                        <option value="278">google.ws (Samoa/English)</option>
                                        <option value="5375">google.sm (San Marino/English)</option>
                                        <option value="279">google.sm (San Marino/Italian)</option>
                                        <option value="280">google.st (Sao Tome and Principe/Portuguese)</option>
                                        <option value="5824">google.st (Sao Tome and Principe/Portuguese (Brazil))
                                        </option>
                                        <option value="5956">bing.com (Saudi Arabia/Arabic)</option>
                                        <option value="5957">bing.com (Saudi Arabia/English)</option>
                                        <option value="281">google.com.sa (Saudi Arabia/Arabic)</option>
                                        <option value="2858">google.com.sa (Saudi Arabia/English)</option>
                                        <option value="1084">search.yahoo.com (Saudi Arabia/All Languages)</option>
                                        <option value="937">search.yahoo.com (Saudi Arabia/Arabic)</option>
                                        <option value="5377">google.sn (Senegal/English)</option>
                                        <option value="282">google.sn (Senegal/French)</option>
                                        <option value="283">google.sn (Senegal/Wolof)</option>
                                        <option value="3436">google.rs (Serbia/English)</option>
                                        <option value="284">google.rs (Serbia/Serbian)</option>
                                        <option value="5402">google.rs (Serbia/Serbian (Latin))</option>
                                        <option value="473">yandex.com (Serbia/English)</option>
                                        <option value="286">google.sc (Seychelles/English)</option>
                                        <option value="285">google.sc (Seychelles/French)</option>
                                        <option value="287">google.sc (Seychelles/Kreol Seselwa)</option>
                                        <option value="288">google.com.sl (Sierra Leone/English)</option>
                                        <option value="289">google.com.sl (Sierra Leone/Krio)</option>
                                        <option value="999">bing.com (Singapore/All Languages)</option>
                                        <option value="396">bing.com (Singapore/English)</option>
                                        <option value="5731">google.com.sg (Singapore/Chinese)</option>
                                        <option value="290">google.com.sg (Singapore/Chinese (Simplified))</option>
                                        <option value="5732">google.com.sg (Singapore/Chinese (Traditional))</option>
                                        <option value="5737">google.com.sg (Singapore/Chinese (Traditional Han))
                                        </option>
                                        <option value="293">google.com.sg (Singapore/English)</option>
                                        <option value="291">google.com.sg (Singapore/Malay)</option>
                                        <option value="292">google.com.sg (Singapore/Tamil)</option>
                                        <option value="1085">sg.search.yahoo.com (Singapore/All Languages)</option>
                                        <option value="938">sg.search.yahoo.com (Singapore/English)</option>
                                        <option value="1000">bing.com (Slovakia/All Languages)</option>
                                        <option value="428">bing.com (Slovakia/Slovak)</option>
                                        <option value="3439">google.sk (Slovakia/English)</option>
                                        <option value="294">google.sk (Slovakia/Slovak)</option>
                                        <option value="474">yandex.com (Slovakia/English)</option>
                                        <option value="1001">bing.com (Slovenia/All Languages)</option>
                                        <option value="429">bing.com (Slovenia/Slovene)</option>
                                        <option value="3438">google.si (Slovenia/English)</option>
                                        <option value="295">google.si (Slovenia/Slovene)</option>
                                        <option value="475">yandex.com (Slovenia/English)</option>
                                        <option value="296">google.com.sb (Solomon Islands/English)</option>
                                        <option value="297">google.so (Somalia/Arabic)</option>
                                        <option value="5379">google.so (Somalia/English)</option>
                                        <option value="298">google.so (Somalia/Somali)</option>
                                        <option value="1002">bing.com (South Africa/All Languages)</option>
                                        <option value="399">bing.com (South Africa/English)</option>
                                        <option value="303">google.co.za (South Africa/Afrikaans)</option>
                                        <option value="301">google.co.za (South Africa/English)</option>
                                        <option value="299">google.co.za (South Africa/Northern Sotho)</option>
                                        <option value="305">google.co.za (South Africa/Southern Sotho or Sesotho)
                                        </option>
                                        <option value="304">google.co.za (South Africa/Tswana or Setswana)</option>
                                        <option value="302">google.co.za (South Africa/Xhosa or IsiXhosa)</option>
                                        <option value="300">google.co.za (South Africa/Zulu or IsiZulu)</option>
                                        <option value="5982">search.yahoo.com (South Africa/English)</option>
                                        <option value="1003">bing.com (South Korea/All Languages)</option>
                                        <option value="417">bing.com (South Korea/Korean)</option>
                                        <option value="3396">google.co.kr (South Korea/English)</option>
                                        <option value="186">google.co.kr (South Korea/Korean)</option>
                                        <option value="1086">search.yahoo.com (South Korea/All Languages)</option>
                                        <option value="939">search.yahoo.com (South Korea/Korean)</option>
                                        <option value="462">yandex.com (South Korea/English)</option>
                                        <option value="2924">amazon.es (Spain/Spanish)</option>
                                        <option value="1004">bing.com (Spain/All Languages)</option>
                                        <option value="5835">bing.com (Spain/Catalan)</option>
                                        <option value="402">bing.com (Spain/Spanish)</option>
                                        <option value="1087">es.search.yahoo.com (Spain/All Languages)</option>
                                        <option value="940">es.search.yahoo.com (Spain/English)</option>
                                        <option value="941">es.search.yahoo.com (Spain/Spanish)</option>
                                        <option value="307">google.es (Spain/Basque)</option>
                                        <option value="309">google.es (Spain/Catalan)</option>
                                        <option value="2849">google.es (Spain/English)</option>
                                        <option value="5401">google.es (Spain/Espanol (Latinoamerica))</option>
                                        <option value="306">google.es (Spain/Galician)</option>
                                        <option value="26">google.es (Spain/Spanish)</option>
                                        <option value="476">yandex.com (Spain/English)</option>
                                        <option value="310">google.lk (Sri Lanka/English)</option>
                                        <option value="311">google.lk (Sri Lanka/Sinhala)</option>
                                        <option value="312">google.lk (Sri Lanka/Tamil)</option>
                                        <option value="5822">google.sr (Suriname/French)</option>
                                        <option value="5805">google.com (Swaziland/English)</option>
                                        <option value="1005">bing.com (Sweden/All Languages)</option>
                                        <option value="430">bing.com (Sweden/Swedish)</option>
                                        <option value="2893">google.se (Sweden/English)</option>
                                        <option value="313">google.se (Sweden/Swedish)</option>
                                        <option value="1088">se.search.yahoo.com (Sweden/All Languages)</option>
                                        <option value="942">se.search.yahoo.com (Sweden/English)</option>
                                        <option value="943">se.search.yahoo.com (Sweden/Swedish)</option>
                                        <option value="477">yandex.com (Sweden/English)</option>
                                        <option value="1006">bing.com (Switzerland/All Languages)</option>
                                        <option value="410">bing.com (Switzerland/French)</option>
                                        <option value="384">bing.com (Switzerland/German)</option>
                                        <option value="5834">bing.com (Switzerland/Italian)</option>
                                        <option value="6226">chfr.search.yahoo.com (Switzerland/French)</option>
                                        <option value="6227">chit.search.yahoo.com (Switzerland/Italian)</option>
                                        <option value="1089">ch.search.yahoo.com (Switzerland/All Languages)</option>
                                        <option value="944">ch.search.yahoo.com (Switzerland/English)</option>
                                        <option value="945">ch.search.yahoo.com (Switzerland/French)</option>
                                        <option value="946">ch.search.yahoo.com (Switzerland/German)</option>
                                        <option value="5973">ch.search.yahoo.com (Switzerland/Italian)</option>
                                        <option value="3389">google.ch (Switzerland/English)</option>
                                        <option value="316">google.ch (Switzerland/French)</option>
                                        <option value="315">google.ch (Switzerland/German)</option>
                                        <option value="317">google.ch (Switzerland/Italian)</option>
                                        <option value="314">google.ch (Switzerland/Romansh)</option>
                                        <option value="478">yandex.com (Switzerland/English)</option>
                                        <option value="1007">bing.com (Taiwan/All Languages)</option>
                                        <option value="436">bing.com (Taiwan/Chinese)</option>
                                        <option value="318">google.com.tw (Taiwan/Chinese)</option>
                                        <option value="5727">google.com.tw (Taiwan/Chinese (Simplified))</option>
                                        <option value="5730">google.com.tw (Taiwan/Chinese (Traditional))</option>
                                        <option value="3419">google.com.tw (Taiwan/English)</option>
                                        <option value="3682">tw.search.yahoo.com (Taiwan/Chinese (Traditional))</option>
                                        <option value="5323">google.com.tj (Tajikistan/English)</option>
                                        <option value="319">google.com.tj (Tajikistan/Russian)</option>
                                        <option value="320">google.com.tj (Tajikistan/Tajik)</option>
                                        <option value="479">yandex.com (Tajikistan/English)</option>
                                        <option value="3400">google.co.tz (Tanzania/English)</option>
                                        <option value="321">google.co.tz (Tanzania/Swahili)</option>
                                        <option value="1008">bing.com (Thailand/All Languages)</option>
                                        <option value="431">bing.com (Thailand/Thai)</option>
                                        <option value="3399">google.co.th (Thailand/English)</option>
                                        <option value="322">google.co.th (Thailand/Thai)</option>
                                        <option value="1091">th.search.yahoo.com (Thailand/All Languages)</option>
                                        <option value="948">th.search.yahoo.com (Thailand/English)</option>
                                        <option value="5979">th.search.yahoo.com (Thailand/Thai)</option>
                                        <option value="480">yandex.com (Thailand/English)</option>
                                        <option value="323">google.tl (Timor-Leste/Portuguese)</option>
                                        <option value="5383">google.tg (Togo/English)</option>
                                        <option value="325">google.tg (Togo/Ewe)</option>
                                        <option value="324">google.tg (Togo/French)</option>
                                        <option value="326">google.tk (Tokelau/English)</option>
                                        <option value="327">google.to (Tonga/English)</option>
                                        <option value="328">google.to (Tonga/Tonga (Tonga Islands))</option>
                                        <option value="329">google.tt (Trinidad and Tobago/Chinese (Traditional Han))
                                        </option>
                                        <option value="333">google.tt (Trinidad and Tobago/English)</option>
                                        <option value="332">google.tt (Trinidad and Tobago/Espanol (Latinoamerica))
                                        </option>
                                        <option value="331">google.tt (Trinidad and Tobago/French)</option>
                                        <option value="330">google.tt (Trinidad and Tobago/Hindi)</option>
                                        <option value="334">google.tn (Tunisia/Arabic)</option>
                                        <option value="5387">google.tn (Tunisia/English)</option>
                                        <option value="335">google.tn (Tunisia/French)</option>
                                        <option value="1092">search.yahoo.com (Tunisia/All Languages)</option>
                                        <option value="949">search.yahoo.com (Tunisia/Arabic)</option>
                                        <option value="950">search.yahoo.com (Tunisia/French)</option>
                                        <option value="1009">bing.com (Turkey/All Languages)</option>
                                        <option value="432">bing.com (Turkey/Turkish)</option>
                                        <option value="3418">google.com.tr (Turkey/English)</option>
                                        <option value="336">google.com.tr (Turkey/Turkish)</option>
                                        <option value="1093">tr.search.yahoo.com (Turkey/All Languages)</option>
                                        <option value="951">tr.search.yahoo.com (Turkey/English)</option>
                                        <option value="952">tr.search.yahoo.com (Turkey/Turkish)</option>
                                        <option value="482">yandex.com (Turkey/English)</option>
                                        <option value="5385">google.tm (Turkmenistan/English)</option>
                                        <option value="337">google.tm (Turkmenistan/Russian)</option>
                                        <option value="339">google.tm (Turkmenistan/Turkmen)</option>
                                        <option value="338">google.tm (Turkmenistan/Uzbek)</option>
                                        <option value="5826">google.com (Turks and Caicos Islands/English)</option>
                                        <option value="3401">google.co.ug (Uganda/English)</option>
                                        <option value="342">google.co.ug (Uganda/Ganda)</option>
                                        <option value="340">google.co.ug (Uganda/Kinyarwanda)</option>
                                        <option value="341">google.co.ug (Uganda/Luo)</option>
                                        <option value="5327">google.co.ug (Uganda/Nyankole)</option>
                                        <option value="343">google.co.ug (Uganda/Runyakitara)</option>
                                        <option value="344">google.co.ug (Uganda/Swahili)</option>
                                        <option value="1010">bing.com (Ukraine/All Languages)</option>
                                        <option value="433">bing.com (Ukraine/Ukrainian)</option>
                                        <option value="3420">google.com.ua (Ukraine/English)</option>
                                        <option value="5">google.com.ua (Ukraine/Russian)</option>
                                        <option value="372">google.com.ua (Ukraine/Ukrainian)</option>
                                        <option value="1094">search.yahoo.com (Ukraine/All Languages)</option>
                                        <option value="953">search.yahoo.com (Ukraine/English)</option>
                                        <option value="954">search.yahoo.com (Ukraine/Russian)</option>
                                        <option value="5954">bing.com (United Arab Emirates/Arabic)</option>
                                        <option value="5955">bing.com (United Arab Emirates/English)</option>
                                        <option value="345">google.ae (United Arab Emirates/Arabic)</option>
                                        <option value="826">google.ae (United Arab Emirates/English)</option>
                                        <option value="347">google.ae (United Arab Emirates/Hindi)</option>
                                        <option value="346">google.ae (United Arab Emirates/Persian)</option>
                                        <option value="348">google.ae (United Arab Emirates/Urdu)</option>
                                        <option value="1095">search.yahoo.com (United Arab Emirates/All Languages)
                                        </option>
                                        <option value="955">search.yahoo.com (United Arab Emirates/Arabic)</option>
                                        <option value="956">search.yahoo.com (United Arab Emirates/English)</option>
                                        <option value="481">yandex.com (United Arab Emirates/English)</option>
                                        <option value="2925">amazon.co.uk (United Kingdom/English)</option>
                                        <option value="1011">bing.com (United Kingdom/All Languages)</option>
                                        <option value="389">bing.com (United Kingdom/English)</option>
                                        <option value="22">google.co.uk (United Kingdom/English)</option>
                                        <option value="1096">uk.search.yahoo.com (United Kingdom/All Languages)</option>
                                        <option value="957">uk.search.yahoo.com (United Kingdom/English)</option>
                                        <option value="485">yandex.com (United Kingdom/English)</option>
                                        <option value="2897">amazon.com (United States/English)</option>
                                        <option value="2906">amazon.com (United States/Espanol)</option>
                                        <option value="1012">bing.com (United States/All Languages)</option>
                                        <option value="5958">bing.com (United States/Arabic)</option>
                                        <option value="397">bing.com (United States/English)</option>
                                        <option value="404">bing.com (United States/Spanish)</option>
                                        <option value="959">espanol.search.yahoo.com (United States/Spanish)</option>
                                        <option value="3667">google.com (United States/Chinese (Simplified))</option>
                                        <option value="3636">google.com (United States/Chinese (Traditional))</option>
                                        <option value="3641">google.com (United States/Danish)</option>
                                        <option value="3656">google.com (United States/Dutch)</option>
                                        <option value="14">google.com (United States/English)</option>
                                        <option value="2833">google.com (United States/Espanol (Latinoamerica))</option>
                                        <option value="3651">google.com (United States/French)</option>
                                        <option value="3646">google.com (United States/German)</option>
                                        <option value="3631">google.com (United States/Norwegian)</option>
                                        <option value="3616">google.com (United States/Portuguese (Portugal))</option>
                                        <option value="3621">google.com (United States/Russian)</option>
                                        <option value="2828">google.com (United States/Spanish)</option>
                                        <option value="3626">google.com (United States/Swedish)</option>
                                        <option value="3662">google.com (United States/Vietnamese)</option>
                                        <option value="1097">search.yahoo.com (United States/All Languages)</option>
                                        <option value="958">search.yahoo.com (United States/English)</option>
                                        <option value="486">yandex.com (United States/English)</option>
                                        <option value="5325">google.com.uy (Uruguay/English)</option>
                                        <option value="351">google.com.uy (Uruguay/Espanol (Latinoamerica))</option>
                                        <option value="5777">google.com.uy (Uruguay/Spanish)</option>
                                        <option value="5329">google.co.uz (Uzbekistan/English)</option>
                                        <option value="353">google.co.uz (Uzbekistan/Russian)</option>
                                        <option value="352">google.co.uz (Uzbekistan/Uzbek)</option>
                                        <option value="487">yandex.com (Uzbekistan/English)</option>
                                        <option value="355">google.vu (Vanuatu/English)</option>
                                        <option value="354">google.vu (Vanuatu/French)</option>
                                        <option value="5980">espanol.search.yahoo.com (Venezuela/Spanish)</option>
                                        <option value="5331">google.co.ve (Venezuela/English)</option>
                                        <option value="356">google.co.ve (Venezuela/Espanol)</option>
                                        <option value="5779">google.co.ve (Venezuela/Spanish)</option>
                                        <option value="357">google.com.vn (Vietnam/Chinese (Traditional Han))</option>
                                        <option value="2977">google.com.vn (Vietnam/English)</option>
                                        <option value="359">google.com.vn (Vietnam/French)</option>
                                        <option value="358">google.com.vn (Vietnam/Vietnamese)</option>
                                        <option value="1098">vn.search.yahoo.com (Vietnam/All Languages)</option>
                                        <option value="960">vn.search.yahoo.com (Vietnam/Chinese (Traditional Han))
                                        </option>
                                        <option value="961">vn.search.yahoo.com (Vietnam/English)</option>
                                        <option value="5981">vn.search.yahoo.com (Vietnam/Vietnamese)</option>
                                        <option value="361">google.co.vi (Virgin Islands US/English)</option>
                                        <option value="5828">google.com (Yemen/Arabic)</option>
                                        <option value="363">google.co.zm (Zambia/Chichewa)</option>
                                        <option value="365">google.co.zm (Zambia/Chitumbuka-Chisenga)</option>
                                        <option value="366">google.co.zm (Zambia/English)</option>
                                        <option value="364">google.co.zm (Zambia/IciBemba)</option>
                                        <option value="362">google.co.zm (Zambia/Silozi)</option>
                                        <option value="367">google.co.zw (Zimbabwe/Chichewa)</option>
                                        <option value="368">google.co.zw (Zimbabwe/English)</option>
                                        <option value="370">google.co.zw (Zimbabwe/Shona)</option>
                                        <option value="369">google.co.zw (Zimbabwe/Tswana)</option>
                                        <option value="371">google.co.zw (Zimbabwe/Zulu)</option>
                                    </select>
                                </div>
                            </div>
                            <div class="uk-width-1-2">
                                <label class="uk-form-label" for=""><i class="fa fa-search"></i> Location</label>
                                <div class="uk-form-controls">
                                    <select id="search_location" style="width: 100%" name="search_location">
                                        <option value="2004">Afghanistan</option>
                                        <option value="2008">Albania</option>
                                        <option value="2010">Antarctica</option>
                                        <option value="2012">Algeria</option>
                                        <option value="2016">American Samoa</option>
                                        <option value="2020">Andorra</option>
                                        <option value="2024">Angola</option>
                                        <option value="2028">Antigua and Barbuda</option>
                                        <option value="2031">Azerbaijan</option>
                                        <option value="2032">Argentina</option>
                                        <option value="2036">Australia</option>
                                        <option value="2040">Austria</option>
                                        <option value="2044">The Bahamas</option>
                                        <option value="2048">Bahrain</option>
                                        <option value="2050">Bangladesh</option>
                                        <option value="2051">Armenia</option>
                                        <option value="2052">Barbados</option>
                                        <option value="2056">Belgium</option>
                                        <option value="2060">Bermuda</option>
                                        <option value="2064">Bhutan</option>
                                        <option value="2068">Bolivia</option>
                                        <option value="2070">Bosnia and Herzegovina</option>
                                        <option value="2072">Botswana</option>
                                        <option value="2074">Bouvet Island</option>
                                        <option value="2076">Brazil</option>
                                        <option value="2084">Belize</option>
                                        <option value="2086">British Indian Ocean Territory</option>
                                        <option value="2090">Solomon Islands</option>
                                        <option value="2092">British Virgin Islands</option>
                                        <option value="2096">Brunei</option>
                                        <option value="2100">Bulgaria</option>
                                        <option value="2104">Myanmar (Burma)</option>
                                        <option value="2108">Burundi</option>
                                        <option value="2112">Belarus</option>
                                        <option value="2116">Cambodia</option>
                                        <option value="2120">Cameroon</option>
                                        <option value="2124">Canada</option>
                                        <option value="2132">Cape Verde</option>
                                        <option value="2136">Cayman Islands</option>
                                        <option value="2140">Central African Republic</option>
                                        <option value="2144">Sri Lanka</option>
                                        <option value="2148">Chad</option>
                                        <option value="2152">Chile</option>
                                        <option value="2156">China</option>
                                        <option value="2158">Taiwan</option>
                                        <option value="2162">Christmas Island</option>
                                        <option value="2166">Cocos (Keeling) Islands</option>
                                        <option value="2170">Colombia</option>
                                        <option value="2174">Comoros</option>
                                        <option value="2175">Mayotte</option>
                                        <option value="2178">Republic of the Congo</option>
                                        <option value="2180">Democratic Republic of the Congo</option>
                                        <option value="2184">Cook Islands</option>
                                        <option value="2188">Costa Rica</option>
                                        <option value="2191">Croatia</option>
                                        <option value="2196">Cyprus</option>
                                        <option value="2203">Czechia</option>
                                        <option value="2204">Benin</option>
                                        <option value="2208">Denmark</option>
                                        <option value="2212">Dominica</option>
                                        <option value="2214">Dominican Republic</option>
                                        <option value="2218">Ecuador</option>
                                        <option value="2222">El Salvador</option>
                                        <option value="2226">Equatorial Guinea</option>
                                        <option value="2231">Ethiopia</option>
                                        <option value="2232">Eritrea</option>
                                        <option value="2233">Estonia</option>
                                        <option value="2234">Faroe Islands</option>
                                        <option value="2238">Falkland Islands (Islas Malvinas)</option>
                                        <option value="2239">South Georgia and the South Sandwich Islands</option>
                                        <option value="2242">Fiji</option>
                                        <option value="2246">Finland</option>
                                        <option value="2250">France</option>
                                        <option value="2254">French Guiana</option>
                                        <option value="2258">French Polynesia</option>
                                        <option value="2260">French Southern and Antarctic Lands</option>
                                        <option value="2262">Djibouti</option>
                                        <option value="2266">Gabon</option>
                                        <option value="2268">Georgia</option>
                                        <option value="2270">The Gambia</option>
                                        <option value="2275">Palestine</option>
                                        <option value="2276">Germany</option>
                                        <option value="2288">Ghana</option>
                                        <option value="2292">Gibraltar</option>
                                        <option value="2296">Kiribati</option>
                                        <option value="2300">Greece</option>
                                        <option value="2304">Greenland</option>
                                        <option value="2308">Grenada</option>
                                        <option value="2312">Guadeloupe</option>
                                        <option value="2316">Guam</option>
                                        <option value="2320">Guatemala</option>
                                        <option value="2324">Guinea</option>
                                        <option value="2328">Guyana</option>
                                        <option value="2332">Haiti</option>
                                        <option value="2334">Heard Island and McDonald Islands</option>
                                        <option value="2336">Vatican City</option>
                                        <option value="2340">Honduras</option>
                                        <option value="2344">Hong Kong</option>
                                        <option value="2348">Hungary</option>
                                        <option value="2352">Iceland</option>
                                        <option value="2356">India</option>
                                        <option value="2360">Indonesia</option>
                                        <option value="2368">Iraq</option>
                                        <option value="2372">Ireland</option>
                                        <option value="2376">Israel</option>
                                        <option value="2380">Italy</option>
                                        <option value="2384">Cote d'Ivoire</option>
                                        <option value="2388">Jamaica</option>
                                        <option value="2392">Japan</option>
                                        <option value="2398">Kazakhstan</option>
                                        <option value="2400">Jordan</option>
                                        <option value="2404">Kenya</option>
                                        <option value="2410">South Korea</option>
                                        <option value="2414">Kuwait</option>
                                        <option value="2417">Kyrgyzstan</option>
                                        <option value="2418">Laos</option>
                                        <option value="2422">Lebanon</option>
                                        <option value="2426">Lesotho</option>
                                        <option value="2428">Latvia</option>
                                        <option value="2430">Liberia</option>
                                        <option value="2434">Libya</option>
                                        <option value="2438">Liechtenstein</option>
                                        <option value="2440">Lithuania</option>
                                        <option value="2442">Luxembourg</option>
                                        <option value="2446">Macau</option>
                                        <option value="2450">Madagascar</option>
                                        <option value="2454">Malawi</option>
                                        <option value="2458">Malaysia</option>
                                        <option value="2462">Maldives</option>
                                        <option value="2466">Mali</option>
                                        <option value="2470">Malta</option>
                                        <option value="2474">Martinique</option>
                                        <option value="2478">Mauritania</option>
                                        <option value="2480">Mauritius</option>
                                        <option value="2484">Mexico</option>
                                        <option value="2492">Monaco</option>
                                        <option value="2496">Mongolia</option>
                                        <option value="2498">Moldova</option>
                                        <option value="2499">Montenegro</option>
                                        <option value="2500">Montserrat</option>
                                        <option value="2504">Morocco</option>
                                        <option value="2508">Mozambique</option>
                                        <option value="2512">Oman</option>
                                        <option value="2516">Namibia</option>
                                        <option value="2520">Nauru</option>
                                        <option value="2524">Nepal</option>
                                        <option value="2528">Netherlands</option>
                                        <option value="2530">Netherlands Antilles</option>
                                        <option value="2531">Curacao</option>
                                        <option value="2533">Aruba</option>
                                        <option value="2534">Sint Maarten</option>
                                        <option value="2535">Caribbean Netherlands</option>
                                        <option value="2540">New Caledonia</option>
                                        <option value="2548">Vanuatu</option>
                                        <option value="2554">New Zealand</option>
                                        <option value="2558">Nicaragua</option>
                                        <option value="2562">Niger</option>
                                        <option value="2566">Nigeria</option>
                                        <option value="2570">Niue</option>
                                        <option value="2574">Norfolk Island</option>
                                        <option value="2578">Norway</option>
                                        <option value="2580">Northern Mariana Islands</option>
                                        <option value="2581">United States Minor Outlying Islands</option>
                                        <option value="2583">Federated States of Micronesia</option>
                                        <option value="2584">Marshall Islands</option>
                                        <option value="2585">Palau</option>
                                        <option value="2586">Pakistan</option>
                                        <option value="2591">Panama</option>
                                        <option value="2598">Papua New Guinea</option>
                                        <option value="2600">Paraguay</option>
                                        <option value="2604">Peru</option>
                                        <option value="2608">Philippines</option>
                                        <option value="2612">Pitcairn Islands</option>
                                        <option value="2616">Poland</option>
                                        <option value="2620">Portugal</option>
                                        <option value="2624">Guinea-Bissau</option>
                                        <option value="2626">Timor-Leste</option>
                                        <option value="2630">Puerto Rico</option>
                                        <option value="2634">Qatar</option>
                                        <option value="2638">Reunion</option>
                                        <option value="2642">Romania</option>
                                        <option value="2643">Russia</option>
                                        <option value="2646">Rwanda</option>
                                        <option value="2654">Saint Helena, Ascension and Tristan da Cunha</option>
                                        <option value="2659">Saint Kitts and Nevis</option>
                                        <option value="2660">Anguilla</option>
                                        <option value="2662">Saint Lucia</option>
                                        <option value="2666">Saint Pierre and Miquelon</option>
                                        <option value="2670">Saint Vincent and the Grenadines</option>
                                        <option value="2674">San Marino</option>
                                        <option value="2678">Sao Tome and Principe</option>
                                        <option value="2682">Saudi Arabia</option>
                                        <option value="2686">Senegal</option>
                                        <option value="2688">Serbia</option>
                                        <option value="2690">Seychelles</option>
                                        <option value="2694">Sierra Leone</option>
                                        <option value="2702">Singapore</option>
                                        <option value="2703">Slovakia</option>
                                        <option value="2704">Vietnam</option>
                                        <option value="2705">Slovenia</option>
                                        <option value="2706">Somalia</option>
                                        <option value="2710">South Africa</option>
                                        <option value="2716">Zimbabwe</option>
                                        <option value="2724">Spain</option>
                                        <option value="2732">Western Sahara</option>
                                        <option value="2740">Suriname</option>
                                        <option value="2744">Svalbard and Jan Mayen</option>
                                        <option value="2748">Eswatini</option>
                                        <option value="2752">Sweden</option>
                                        <option value="2756">Switzerland</option>
                                        <option value="2762">Tajikistan</option>
                                        <option value="2764">Thailand</option>
                                        <option value="2768">Togo</option>
                                        <option value="2772">Tokelau</option>
                                        <option value="2776">Tonga</option>
                                        <option value="2780">Trinidad and Tobago</option>
                                        <option value="2784">United Arab Emirates</option>
                                        <option value="2788">Tunisia</option>
                                        <option value="2792">Turkey</option>
                                        <option value="2795">Turkmenistan</option>
                                        <option value="2796">Turks and Caicos Islands</option>
                                        <option value="2798">Tuvalu</option>
                                        <option value="2800">Uganda</option>
                                        <option value="2804">Ukraine</option>
                                        <option value="2807">North Macedonia</option>
                                        <option value="2818">Egypt</option>
                                        <option value="2826">United Kingdom</option>
                                        <option value="2831">Guernsey</option>
                                        <option value="2832">Jersey</option>
                                        <option value="2834">Tanzania</option>
                                        <option value="2840" selected>United States</option>
                                        <option value="2850">U.S. Virgin Islands</option>
                                        <option value="2854">Burkina Faso</option>
                                        <option value="2858">Uruguay</option>
                                        <option value="2860">Uzbekistan</option>
                                        <option value="2862">Venezuela</option>
                                        <option value="2876">Wallis and Futuna</option>
                                        <option value="2882">Samoa</option>
                                        <option value="2887">Yemen</option>
                                        <option value="2894">Zambia</option>
                                    </select>
                                </div>
                            </div>
                        </div>


                        <div class="uk-margin-large-top">
                            <button class="uk-button uk-modal-close" type="button"><i class="fa fa-close"></i> Cancel
                            </button>
                            <button class="uk-button uk-button-primary uk-float-right submitKeywords" type="submit"><i
                                        class="fa fa-check"></i> Submit Keywords to Rank Tracker
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <table class="uk-table uk-table-striped pagePostAllTableTemplate uk-hidden">
        <thead>
        <tr>
            <th class="uk-text-center">Group Name</th>
            <th class="uk-text-center">Page or Post</th>
        </tr>
        </thead>
        <tbody class="uk-text-center body_template">
        <tr class="tr_template">
            <td class="group_name" data-id=""></td>
            <td class="createMultiResults">
                <div data-uk-button-radio="">
                    <button class="uk-button uk-button-success uk-active" aria-checked="true" data-type="page"><i
                                class="fa fa-file-o"></i> Page
                    </button>
                    <button class="uk-button uk-button-primary" aria-checked="false" data-type="post"><i
                                class="fa fa-file-text-o"></i> Post
                    </button>
                </div>
            </td>
        </tr>
        </tbody>
    </table>

    <!--New Page Post Results Modal-->
    <div id="resultsPagePost" class="uk-modal">
        <div class="uk-modal-dialog">
            <button type="button" class="uk-modal-close uk-close"></button>

            <div class="uk-modal-header">
                <h2><i class="fa fa-info-circle"></i> Create Page/Post from Group</h2>
            </div>

            <p class="pagePostResultsMessage">
                Successfully created page/post. You can click below to edit page right away
            </p>
            <p class="update_parent_page">
                <label for="parentPage">Parent : </label>
                <select name="parentPage" id="parentPage"></select>
            </p>
            <p class="update_page_post_status">
                <label for="pagePostStatus">Status : </label>
                <select name="pagePostStatus" id="pagePostStatus"></select>
            </p>
            <p class="edit_page_post_link"></p>

            <div class="uk-modal-footer uk-text-right">
                <button type="button" class="uk-button uk-modal-close">Close</button>
            </div>
        </div>
    </div>

    <div class="creating_block block_template">
        <h1 class="creating">Creating Page</h1>
        <p class="creating_please_wait">Please Wait ...</p>
        <div class="creating_gears">
            <i class="one fa fa-gear fa-spin fa-3x"></i>
            <i class="two fa fa-gear fa-spin fa-2x"></i>
            <i class="three fa fa-gear fa-spin fa-2x"></i>
        </div>
    </div>

</div> <!-- .wrap -->