<?php

?>
<style>
    button.uk-button.uk-button-large {
        background: #0084E6 !important;
        padding: 6px 15px !important;
        border-radius: 4px !important;
        color: #f8fcff !important;
        border: none !important;
    }
    button.uk-button.uk-button-large:hover {
        background: #169afa !important;
    }
    button.uk-button.uk-button-large.uk-button-primary.uk-width-1-1.rescue-scan-plugins-themes, button.uk-button.uk-button-large.uk-button-primary.uk-width-1-1.rescue-scan-uploads {
        padding: 23px 15px !important;
    }
</style>

<!-- HTML STARTS HERE -->
<div class="wrap prs" style="max-width: 1200px;margin-left: auto;margin-right: auto;">

	<h2 class="logo-title">
		<span class="logo-title-center">
            <img class="logo-image" src="<?= XAG_URL; ?>assets/img/logo-xagio.png"/>
		Xagio - Rescue Center
		-
		<small class="hand">Recover your files to their original state...</small>
        </span>
	</h2>

	<p class="logo-paragraph uk-block-xagio rescue-info">
		<b><i class="fa fa-question-circle"></i> How to use?</b> Rescue Center is to be used after a suspected activity on your WordPress. <br>This means that if you believe your website got hacked and some files are infected or added, you should use the Rescue Center to revert any changes to your WordPress back to initial state.
	</p>

    <ul class="uk-tab uk-tab-big" data-uk-tab="{connect:'#tab-content'}">
        <li class="uk-active"><a href=""><i class="fa fa-wordpress"></i> WordPress</a></li>
        <li><a href=""><i class="fa fa-plug"></i> Plugins & Themes</a></li>
        <li><a href=""><i class="fa fa-upload"></i> Uploads</a></li>
        <li><a href=""><i class="fa fa-code-fork"></i> Clone</a></li>
    </ul>


    <div id="tab-content" class="uk-switcher">

        <!-- WordPress -->
        <div>
            <?php if (file_exists(XAG_PATH . '/tmp/wordpress')) { ?>

                <p class="logo-paragraph logo-paragraph-warning logo-paragraph-small uk-block-xagio old-core-files-message">
                    <i class="fa fa-warning"></i> <b>Previous WordPress core files detected!</b> It's highly advisable to remove these files from previous WordPress Rescue process.

                    <button class="uk-button uk-button-small uk-button-danger remove-old-core-files"><i class="fa fa-trash-o"></i> Remove Old Files</button>
                </p>

            <?php } ?>

            <div class="uk-grid rescue-select-mode">
                <div class="uk-width-1-2">

                    <div class="uk-panel uk-block-xagio">
                        <h2><i class="fa fa-thumbs-up"></i> Easy Mode</h2>
                        <p>If you want to remove all non-WordPress core files and overwrite existing core files with the ones from WordPress repository, select this mode.</p>

                        <button data-type="easy" class="uk-button uk-button-large begin-core-rescue" type="button"><i class="fa fa-life-saver"></i> Begin Procedure</button>

                    </div>

                </div>

                <div class="uk-width-1-2">

                    <div class="uk-panel uk-block-xagio">
                        <h2><i class="fa fa-gears"></i> Advanced Mode</h2>
                        <p>If there are specific non-WordPress core files in your WordPress installation that you want to keep while overwriting existing WordPress core files, select this mode.</p>

                        <button data-type="advanced" class="uk-button uk-button-large begin-core-rescue" type="button"><i class="fa fa-life-saver"></i> Begin Procedure</button>

                    </div>

                </div>
            </div>

            <div class="rescue-container uk-hidden">

                <h2><i class="fa fa-life-saver"></i> WordPress Rescue <small>(<span class="rescue-core-type">...</span> mode)</small></h2>

                <a href="" class="uk-close rescue-core-close"></a>

                <!-- Select WP Version -->
                <div class="rescue-core-version">

                    <div class="uk-alert uk-alert-large" data-uk-alert="">
                        <h2>Select a WordPress Version.</h2>
                        <p>
                            Please pick a version of WordPress core files to download. Usually, you should go for the current version of your WordPress, but in some cases where you think that the current
                            version is compromised, you can use the latest one offered.
                        </p>
                    </div>

                    <div class="uk-form-row m-b-10">
                        <label class="uk-form-label" for="rescue-core-version-value"><i class="fa fa-wordpress"></i> WordPress Version:</label>

                        <select id="rescue-core-version-value">
                            <optgroup label="Current Version">
                                <option value="<?php echo get_bloginfo('version');?>"><?php echo get_bloginfo('version');?></option>
                            </optgroup>

                            <!-- There has to be a better way to do this -->
                             <optgroup label="All Versions">
                                 <?php foreach(MXAG_Rescue::getAvailableCoreVersions() as $version) { ?>
                                    <option value="<?php echo $version;?>"><?php echo $version;?></option>
                                 <?php } ?>
                             </optgroup>

                        </select>
                    </div>

                    <hr>

                    <div class="uk-alert uk-alert-warning uk-alert-large" data-uk-alert="">
                        <p><i class="fa fa-info-circle"></i> If you choose to proceed, your WordPress core files will be downloaded to <kbd><?php echo XAG_PATH;?>/tmp/wordpress</kbd> folder.</p>
                    </div>


                    <button class="uk-button uk-button-primary select-core-version" type="button"><i class="fa fa-download"></i> Download selected WordPress version</button>

                </div>

                <!-- Download WP -->
                <div class="rescue-core-download uk-hidden">

                    <div class="download-core-progress uk-progress uk-progress-striped uk-active">
                        <div class="uk-progress-bar" style="width: 100%;">Downloading WordPress Core Files...</div>
                    </div>

                    <div class="download-core-message uk-alert uk-alert-large uk-hidden" data-uk-alert="">
                        <h2>...</h2>
                        <p>...</p>
                    </div>

                    <hr>

                    <button class="uk-button download-core-close rescue-core-close uk-hidden" type="button"><i class="fa fa-close"></i> Close</button>
                    <button class="uk-button uk-button-primary preview-core-files uk-hidden" type="button"><i class="fa fa-search"></i> Perform File Analysis</button>

                </div>

                <!-- Preview Files -->
                <div class="rescue-core-files uk-hidden">

                    <div class="uk-alert uk-alert-large" data-uk-alert="">
                        <h2>Preview files changes.</h2>
                        <p>
                            Below you'll see a list of files and their changes. <b data-action="overwrite">Black</b> files are identical both locally and remotely. <b data-action="add">Green</b> are present remotely but not locally and will be added. <b data-action="force-overwrite">Blue</b> files are different locally and should be overwritten by all means, while <b data-action="delete">Red</b> files are new files locally that does not exist remotely.
                        </p>

                        <h3>Easy Mode and Advanced Mode</h3>

                        <p>In Easy Mode, <b data-action="add">Green</b> files will be automatically added to local file base, <b data-action="force-overwrite">Blue</b> files will be automatically overwritten by remote file counterparts while <b data-action="delete">Red</b> files will be deleted. However, if you pick Advanced mode, you will be able to custom select files to rescue.</p>

                        <h3>wp-config.php</h3>

                        <p>WordPress configuration file will be automatically re-built during the rescue operation, no matter the mode selected.</p>
                    </div>

                    <div id="rescue-core-files-list"></div>

                    <hr>

                    <button class="uk-button uk-button-large uk-button-success start-core-rescue" type="button"><i class="fa fa-magic"></i> Start Rescue Operation</button>

                </div>


                <!-- Start Rescue -->
                <div class="rescue-core-operation uk-hidden">

                    <div class="rescue-core-progress uk-progress uk-progress-striped uk-active">
                        <div class="uk-progress-bar" style="width: 100%;">Making changes....</div>
                    </div>

                    <div class="rescue-core-message uk-alert uk-alert-large uk-hidden" data-uk-alert="">
                        <h2>...</h2>
                        <p>...</p>
                    </div>

                </div>


            </div>


        </div>

        <!-- Plugins -->
        <div>
            <div class="uk-panel uk-block-xagio">
                <button type="button" class="uk-button uk-button-large uk-button-primary uk-width-1-1 rescue-scan-plugins-themes"><i class="fa fa-search"></i> Start scanning for Plugins & Themes</button>

                <div class="uk-grid uk-grid-small rescue-plugins-themes-list uk-hidden">
                    <div class="uk-width-1-2">

                        <div class="rescue-container-multi">

                            <h2><i class="fa fa-wordpress"></i> Rescue from WordPress Repository</h2>

                            <div class="uk-alert" data-uk-alert="">
                                <p>
                                    Plugins & Themes in this list can easily be rescued by automatically downloading them from their official WordPress repository. We will match the
                                    version of plugin / theme you currently have installed when rescuing.
                                </p>
                            </div>

                            <div class="uk-accordion" data-uk-accordion>

                                <h3 class="uk-accordion-title">
                                    <i class="fa fa-plug"></i> Plugins
                                </h3>
                                <div class="uk-accordion-content rescue-found-plugins">

                                </div>

                                <h3 class="uk-accordion-title">
                                    <i class="fa fa-paint-brush"></i> Themes
                                </h3>
                                <div class="uk-accordion-content rescue-found-themes">

                                </div>

                            </div>

                        </div>

                    </div>
                    <div class="uk-width-1-2">

                        <div class="rescue-container-multi">

                            <h2><i class="fa fa-upload"></i> Rescue by Upload</h2>

                            <div class="uk-alert" data-uk-alert="">
                                <p>
                                    Since we couldn't find the official WordPress repository for these plugins & themes in the list below, you will need to supply your own original zip
                                    files of plugins / themes.
                                </p>
                            </div>

                            <div class="uk-accordion" data-uk-accordion>

                                <h3 class="uk-accordion-title">
                                    <i class="fa fa-plug"></i> Plugins
                                </h3>
                                <div class="uk-accordion-content rescue-missing-plugins">

                                </div>

                                <h3 class="uk-accordion-title">
                                    <i class="fa fa-paint-brush"></i> Themes
                                </h3>
                                <div class="uk-accordion-content rescue-missing-themes">

                                </div>

                            </div>

                        </div>

                    </div>
                </div>
            </div>

        </div>

        <!-- Uploads -->
        <div>
            <div class="uk-panel uk-block-xagio">
                <button type="button" class="uk-button uk-button-large uk-button-primary uk-width-1-1 rescue-scan-uploads"><i class="fa fa-search"></i> Start scanning Uploads directory</button>

                <div class="uk-alert uk-alert-large rescue-uploads-alert uk-hidden">
                    <h2>...</h2>
                    <p>
                        ...
                    </p>
                </div>

                <ul class="rescue-uploads-files uk-hidden"></ul>

                <button type="button" class="uk-button uk-button-large uk-button-danger rescue-uploads-remove-selected uk-width-1-1 uk-hidden"><i class="fa fa-trash-o"></i> Remove Selected Files</button>
            </div>
        </div>

        <!-- Clone -->
        <div>
            <form class="verify">

                <div class="uk-grid uk-grid-small">

                    <input type="hidden" name="action" value="xag_verify_connection"/>

                    <div class="uk-form-icon uk-width-6-10">
                        <i class="uk-icon-globe"></i>
                        <input name="url" type="url" class="uk-input-big clone-url" placeholder="Website to clone from... eg. https://website.com" required value=""/>
                    </div>

                    <button type="submit" class="verify-button uk-button uk-button-success uk-button-large uk-width-2-10"><i class="fa fa-plug"></i> Verify Connection</button>

                    <button type="button" class="clone-button uk-button uk-button-primary uk-button-large uk-width-2-10" disabled><i class="fa fa-code-fork"></i> Start Cloning</button>

                </div>

                <div class="uk-grid uk-grid-small ">

                    <div class="uk-width-2-10">
                        <p class="clone-status api-key">
                            <i class="fa fa-key"></i>
                            Obtaining API key for Remote Website
                        </p>
                    </div>

                    <div class="uk-width-2-10">
                        <p class="clone-status creating-copy">
                            <i class="fa fa-copy"></i>
                            Creating copy of Remote Website
                        </p>
                    </div>

                    <div class="uk-width-2-10">
                        <p class="clone-status downloading-copy">
                            <i class="fa fa-download"></i>
                            Downloading copy of Remote Website
                        </p>
                    </div>

                    <div class="uk-width-2-10">
                        <p class="clone-status extracting-files-merging-databases">
                            <i class="fa fa-database"></i>
                            Extracting Files & Merging Databases
                        </p>
                    </div>

                    <div class="uk-width-2-10">
                        <p class="clone-status finishing-cloning">
                            <i class="fa fa-question-circle"></i>
                            Finishing Cloning and Verify Status
                        </p>
                    </div>


                </div>

            </form>

        </div>

    </div>

    <div class="rescue-plugin-theme-template uk-hidden">

        <h3 class="rescue-name">...</h3>
        <span class="rescue-version">...</span>

        <div class="rescue-plugin-theme-buttons">

            <button class="uk-button uk-button-small uk-button-primary begin-plugin-theme-rescue uk-hidden" type="button"><i class="fa fa-life-saver"></i> Rescue</button>

            <label for="plugin-theme-upload" class="uk-button uk-button-small uk-button-primary upload-plugin-theme-rescue uk-hidden">
                <i class="fa fa-cloud-upload"></i> Upload & Rescue
            </label>

            <input id="plugin-theme-upload" class="plugin-theme-upload" type="file"/>

            <button class="uk-button uk-button-small uk-button-danger remove-plugin-theme-rescue" type="button"><i class="fa fa-trash-o"></i> Uninstall</button>

        </div>

        <div class="rescue-plugin-theme-progress uk-progress uk-progress-striped uk-active uk-hidden">
            <div class="uk-progress-bar" style="width: 100%;"><i class="fa fa-life-saver fa-spin"></i> Performing Rescue...</div>
        </div>

        <div class="rescue-plugin-theme-alert uk-alert uk-hidden">
            Successfully finished rescue operation.
        </div>

    </div>

</div> <!-- .wrap -->

