<?php

?>

<!-- HTML STARTS HERE -->
<div class="wrap prs" style="max-width: 1200px;margin-left: auto;margin-right: auto;">

	<h2 class="logo-title">
        <span class="logo-title-center">
            	<img class="logo-image" src="<?= XAG_URL; ?>assets/img/logo-xagio.png"/>
		Xagio - Security Center
		-
		<small class="hand">A place to monitor and set up your website security....</small>
        </span>
	</h2>

	<p class="logo-paragraph">
		<b><i class="fa fa-question-circle"></i> How to use?</b> Rescue Center is to be used after a suspected activity on your WordPress. This means that if you believe your website got hacked and some files are infected or added, you should use the Rescue Center to revert any changes to your WordPress back to initial state.
	</p>

    <ul class="uk-tab uk-tab-big" data-uk-tab="{connect:'#tab-content'}">
        <li class="uk-active"><a href=""><i class="fas fa-wrench"></i> General Settings</a></li>
        <li><a href=""><i class="fas fa-syringe"></i> Anti-Exploit</a></li>
        <li><a href=""><i class="fas fa-shield-alt"></i> Firewall</a></li>
    </ul>


    <div id="tab-content" class="uk-switcher">

        <!-- Settings -->
        <div>

            <form class="wpc-settings-form">

                <input type="hidden" name="action" value="wpc_save_options"/>

		        <?php

		        $wpc = get_option('wpc');

		        $auto_update_core = isset($wpc['auto_update_core']) ? $wpc['auto_update_core'] : 0;

		        $auto_update_plugins = isset($wpc['auto_update_plugins']) ? $wpc['auto_update_plugins'] : 0;

		        $auto_update_themes = isset($wpc['auto_update_themes']) ? $wpc['auto_update_themes'] : 0;

		        $disable_editor = isset($wpc['disable_editor']) ? $wpc['disable_editor'] : 0;

		        $disable_errors = isset($wpc['disable_errors']) ? $wpc['disable_errors'] : 0;

		        $hide_author_names = isset($wpc['hide_author_names']) ? $wpc['hide_author_names'] : 0;

		        $disable_login_hints = isset($wpc['disable_login_hints']) ? $wpc['disable_login_hints'] : 0;

		        $remove_unnecessary_header_info = isset($wpc['remove_unnecessary_header_info']) ? $wpc['remove_unnecessary_header_info'] : 0;

		        $force_cdn_jquery = isset($wpc['force_cdn_jquery']) ? $wpc['force_cdn_jquery'] : 0;

		        $remove_wp_version_from_scripts = isset($wpc['remove_wp_version_from_scripts']) ? $wpc['remove_wp_version_from_scripts'] : 0;

		        $disable_xmlrpc = isset($wpc['disable_xmlrpc']) ? $wpc['disable_xmlrpc'] : 0;

		        $disable_feeds = isset($wpc['disable_feeds']) ? $wpc['disable_feeds'] : 0;

		        $disable_xpingback = isset($wpc['disable_xpingback']) ? $wpc['disable_xpingback'] : 0;

		        $remove_wp_version = isset($wpc['remove_wp_version']) ? $wpc['remove_wp_version'] : 0;

		        $disable_dashboard_for_non_admin_users = isset($wpc['disable_dashboard_for_non_admin_users']) ? $wpc['disable_dashboard_for_non_admin_users'] : 0;

		        $disable_auto_url_in_comments = isset($wpc['disable_auto_url_in_comments']) ? $wpc['disable_auto_url_in_comments'] : 0;

		        $disable_login_redirect = isset($wpc['disable_login_redirect']) ? $wpc['disable_login_redirect'] : 0;

		        /* Rewrite URLs */
		        $rewrite_search = isset($wpc['rewrite_search']) ? $wpc['rewrite_search'] : 0;

		        ?>

                <div class="uk-alert"><b><i class="fa fa-question-circle"></i> What is the use of these settings?</b>
                    By tweaking these settings, not only that you will improve your WordPress security, but you will also optimize its performance and stability.
                    Many of these settings already exist in WordPress by default, but are considered advanced and are not shown to normal WordPress users without this plugin.
                </div>

                <div class="uk-grid uk-margin-bottom">
                    <div class="uk-width-large-1-3">
                        <div class="uk-form uk-form-stacked">
                            <!-- Auto Update - Core -->
                            <div class="uk-form-row">
                                <label class="uk-form-label" for="auto_update_core">
                                    <input type="hidden" name="wpc[auto_update_core]" class="form-control" value="0"/>
                                    <input id="auto_update_core" type="checkbox" name="wpc[auto_update_core]" value="1" <?php checked($auto_update_core, 1) ?>>
                                    Auto Update - WordPress
                                </label>

                                <div class="uk-form-controls">
                                    <p class="uk-form-help-block">
                                        <span class="uk-badge">NOTE</span>
                                        One of the most probable security optimizations would be to always have the latest version of WordPress installed.
                                        This setting will always install the latest version of WordPress on your website, without asking you. However, be warned,
                                        since if you're using out-dated plugins or themes, this may break your WordPress is left checked.
                                    </p>
                                </div>
                            </div>

                            <!-- Auto Update - Plugins -->
                            <div class="uk-form-row">
                                <label class="uk-form-label" for="auto_update_plugins">
                                    <input type="hidden" name="wpc[auto_update_plugins]" class="form-control" value="0"/>
                                    <input id="auto_update_plugins" type="checkbox" name="wpc[auto_update_plugins]" value="1" <?php checked($auto_update_plugins, 1) ?>>
                                    Auto Update - Plugins
                                </label>

                                <div class="uk-form-controls">
                                    <p class="uk-form-help-block">
                                        <span class="uk-badge">NOTE</span>
                                        Second best security tip is to always have your plugins updated. Many plugins are vulnerable and keeping them updated
                                        to their latest versions always - keeps you safe from the danger of you forgetting to update manually a possibly vulnerable plugin.
                                    </p>
                                </div>
                            </div>

                            <!-- Auto Update - Themes -->
                            <div class="uk-form-row">
                                <label class="uk-form-label" for="auto_update_themes">
                                    <input type="hidden" name="wpc[auto_update_themes]" class="form-control" value="0"/>
                                    <input id="auto_update_themes" type="checkbox" name="wpc[auto_update_themes]" value="1" <?php checked($auto_update_themes, 1) ?>>
                                    Auto Update - Themes
                                </label>

                                <div class="uk-form-controls">
                                    <p class="uk-form-help-block">
                                        <span class="uk-badge">NOTE</span>
                                        If you read the text about the vulnerable plugins, well, the same goes for themes. Usually, WordPress administrators tend to forget to update their
                                        themes regularly, therefore increasing the risks of keeping a vulnerable theme active on their website. Keeping it automatically updated always, saves that problem.
                                    </p>
                                </div>
                            </div>

                            <!-- Disable Editor -->
                            <div class="uk-form-row">
                                <label class="uk-form-label" for="disable_editor">
                                    <input type="hidden" name="wpc[disable_editor]" class="form-control" value="0"/>
                                    <input id="disable_editor" type="checkbox" name="wpc[disable_editor]" value="1" <?php checked($disable_editor, 1) ?>>
                                    Disable Plugin and Theme Editor
                                </label>

                                <div class="uk-form-controls">
                                    <p class="uk-form-help-block">
                                        <span class="uk-badge">NOTE</span>
                                        While the Plugin and Theme Editor is enabled by default in WordPress, disabling it can harden your overall security and stability, especially if you're
                                        not the only one with the access to it. This will prevent someone from making changes in your plugins or themes.
                                    </p>
                                </div>
                            </div>

                            <!-- Disable Errors -->
                            <div class="uk-form-row">
                                <label class="uk-form-label" for="disable_errors">
                                    <input type="hidden" name="wpc[disable_errors]" class="form-control" value="0"/>
                                    <input id="disable_errors" type="checkbox" name="wpc[disable_errors]" value="1" <?php checked($disable_errors, 1) ?>>
                                    Disable PHP Errors
                                </label>

                                <div class="uk-form-controls">
                                    <p class="uk-form-help-block">
                                        <span class="uk-badge">NOTE</span>
                                        By disabling PHP errors in your WordPress, you are basically making your attackers blind, as their primary source of information whether their
                                        exploit works or not is exactly coming from those errors. Be warned, you will not be able to see PHP errors, so if you're debugging a plugin or theme, make sure this is checked off.
                                    </p>
                                </div>
                            </div>

                            <!-- Hide Author Names -->
                            <div class="uk-form-row">
                                <label class="uk-form-label" for="hide_author_names">
                                    <input type="hidden" name="wpc[hide_author_names]" class="form-control" value="0"/>
                                    <input id="hide_author_names" type="checkbox" name="wpc[hide_author_names]" value="1" <?php checked($hide_author_names, 1) ?>>
                                    Disable Author Redirects
                                </label>

                                <div class="uk-form-controls">
                                    <p class="uk-form-help-block">
                                        <span class="uk-badge">NOTE</span>
                                        With this setting, you're disabling access to Author's profile page on WordPress. While this may not be that useful, it's always handy to
                                        hide everything possible from public access that isn't really important to them.
                                    </p>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="uk-width-large-1-3">
                        <div class="uk-form uk-form-stacked">

                            <!-- Disable X-Pingback -->
                            <div class="uk-form-row">
                                <label class="uk-form-label" for="disable_xpingback">
                                    <input type="hidden" name="wpc[disable_xpingback]" class="form-control" value="0"/>
                                    <input id="disable_xpingback" type="checkbox" name="wpc[disable_xpingback]" value="1" <?php checked($disable_xpingback, 1) ?>>
                                    Disable X-Pingback Header
                                </label>

                                <div class="uk-form-controls">
                                    <p class="uk-form-help-block">
                                        <span class="uk-badge">NOTE</span>
                                        Prevents WordPress from sending a response <code>X-Pingback</code> header that is related to XMLRPC and could be involved in exposing
                                        the fact that you're using WordPress.
                                    </p>
                                </div>
                            </div>

                            <!-- Remove WP Version -->
                            <div class="uk-form-row">
                                <label class="uk-form-label" for="remove_wp_version">
                                    <input type="hidden" name="wpc[remove_wp_version]" class="form-control" value="0"/>
                                    <input id="remove_wp_version" type="checkbox" name="wpc[remove_wp_version]" value="1" <?php checked($remove_wp_version, 1) ?>>
                                    Remove WP Version
                                </label>

                                <div class="uk-form-controls">
                                    <p class="uk-form-help-block">
                                        <span class="uk-badge">NOTE</span>
                                        This will remove the meta tag responsible for exposing your WordPress version. It's useful to have this setting on as it can make the attackers not know
                                        which version your WordPress is.
                                    </p>
                                </div>
                            </div>

                            <!-- Disable Dashboard for non-admin Users -->
                            <div class="uk-form-row">
                                <label class="uk-form-label" for="disable_dashboard_for_non_admin_users">
                                    <input type="hidden" name="wpc[disable_dashboard_for_non_admin_users]" class="form-control" value="0"/>
                                    <input id="disable_dashboard_for_non_admin_users" type="checkbox" name="wpc[disable_dashboard_for_non_admin_users]" value="1" <?php checked($disable_dashboard_for_non_admin_users, 1) ?>>
                                    Disable Dashboard for non-admin Users
                                </label>

                                <div class="uk-form-controls">
                                    <p class="uk-form-help-block">
                                        <span class="uk-badge">NOTE</span>
                                        If you would like to prevent the access to the Dashboard to the users that aren't Administrators, check this setting.
                                    </p>
                                </div>
                            </div>

                            <!-- Disable Auto-URLs in Comments -->
                            <div class="uk-form-row">
                                <label class="uk-form-label" for="disable_auto_url_in_comments">
                                    <input type="hidden" name="wpc[disable_auto_url_in_comments]" class="form-control" value="0"/>
                                    <input id="disable_auto_url_in_comments" type="checkbox" name="wpc[disable_auto_url_in_comments]" value="1" <?php checked($disable_auto_url_in_comments, 1) ?>>
                                    Disable Auto-URLs in Comments
                                </label>

                                <div class="uk-form-controls">
                                    <p class="uk-form-help-block">
                                        <span class="uk-badge">NOTE</span>
                                        A very helpful setting to fight spam content and spam backlinks. This will prevent WordPress from automatically creating URLs in your comments, making them only plain text.
                                    </p>
                                </div>
                            </div>

                            <!-- Disable Login Multi-Site Redirect -->
                            <div class="uk-form-row">
                                <label class="uk-form-label" for="disable_login_redirect">
                                    <input type="hidden" name="wpc[disable_login_redirect]" class="form-control" value="0"/>
                                    <input id="disable_login_redirect" type="checkbox" name="wpc[disable_login_redirect]" value="1" <?php checked($disable_login_redirect, 1) ?>>
                                    Disable Login Multi-Site Redirect
                                </label>

                                <div class="uk-form-controls">
                                    <p class="uk-form-help-block">
                                        <span class="uk-badge">NOTE</span>
                                        If you are using Multi-Site and if one of your websites isn't there, it will redirect to a different WordPress instance of Multi-Site. To prevent that, check this option.
                                    </p>
                                </div>
                            </div>

                            <!-- Rewrite Search URL -->
                            <div class="uk-form-row">
                                <label class="uk-form-label" for="rewrite_search">
                                    <input type="hidden" name="wpc[rewrite_search]" class="form-control" value="0"/>
                                    <input id="rewrite_search" type="checkbox" name="wpc[rewrite_search]" value="1" <?php checked($rewrite_search, 1) ?>>
                                    Rewrite Search URL
                                </label>

                                <div class="uk-form-controls">
                                    <p class="uk-form-help-block">
                                        <span class="uk-badge">NOTE</span>
                                        Changes the default search url to look better and make it harder for attackers to know that you're on WordPress. New search url will be rendered as <code>/search/term</code>.
                                    </p>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="uk-width-large-1-3">
                        <div class="uk-form uk-form-stacked">

                            <!-- Remove Version from Scripts -->
                            <div class="uk-form-row">
                                <label class="uk-form-label" for="remove_wp_version_from_scripts">
                                    <input type="hidden" name="wpc[remove_wp_version_from_scripts]" class="form-control" value="0"/>
                                    <input id="remove_wp_version_from_scripts" type="checkbox" name="wpc[remove_wp_version_from_scripts]" value="1" <?php checked($remove_wp_version_from_scripts, 1) ?>>
                                    Remove Version from Scripts
                                </label>

                                <div class="uk-form-controls">
                                    <p class="uk-form-help-block">
                                        <span class="uk-badge">NOTE</span>
                                        Used to hide your WordPress version from public access. Instead of requesting scripts with the <code>?ver=4.4.2</code> at the end, WordPress
                                        will skip that part out and just load the script directly without telling anyone what version of WordPress you have.
                                    </p>
                                </div>
                            </div>

                            <!-- Disable XMLRPC -->
                            <div class="uk-form-row">
                                <label class="uk-form-label" for="disable_xmlrpc">
                                    <input type="hidden" name="wpc[disable_xmlrpc]" class="form-control" value="0"/>
                                    <input id="disable_xmlrpc" type="checkbox" name="wpc[disable_xmlrpc]" value="1" <?php checked($disable_xmlrpc, 1) ?>>
                                    Disable XMLRPC
                                </label>

                                <div class="uk-form-controls">
                                    <p class="uk-form-help-block">
                                        <span class="uk-badge">NOTE</span>
                                        XMLRPC has been a well known target in the past for attackers. Many websites were exploited by using the methods that involved XMLRPC. This setting will disable it, rendering those attacks useless.
                                    </p>
                                </div>
                            </div>

                            <!-- Disable Feeds -->
                            <div class="uk-form-row">
                                <label class="uk-form-label" for="disable_feeds">
                                    <input type="hidden" name="wpc[disable_feeds]" class="form-control" value="0"/>
                                    <input id="disable_feeds" type="checkbox" name="wpc[disable_feeds]" value="1" <?php checked($disable_feeds, 1) ?>>
                                    Disable Feeds
                                </label>

                                <div class="uk-form-controls">
                                    <p class="uk-form-help-block">
                                        <span class="uk-badge">NOTE</span>
                                        If you are a normal WordPress user and do not use any of its feeds, you can safely check this option. It will basically disable all feeds on WordPress
                                        that are usually not necessary for a regular WordPress users and also they can expose that you're running WordPress as well.
                                    </p>
                                </div>
                            </div>

                            <!-- Disable Login Hints -->
                            <div class="uk-form-row">
                                <label class="uk-form-label" for="disable_login_hints">
                                    <input type="hidden" name="wpc[disable_login_hints]" class="form-control" value="0"/>
                                    <input id="disable_login_hints" type="checkbox" name="wpc[disable_login_hints]" value="1" <?php checked($disable_login_hints, 1) ?>>
                                    Disable Login Hints
                                </label>

                                <div class="uk-form-controls">
                                    <p class="uk-form-help-block">
                                        <span class="uk-badge">NOTE</span>
                                        Used to keep things complicated with brute force attacks. Use this option to prevent WordPress from notifying users whether their username or password
                                        is wrong when they try to login with incorrect credentials together with the Login Guard and nobody will be able to brute force your Administrator account.
                                    </p>
                                </div>
                            </div>

                            <!-- Remove Unnecessary Header Information -->
                            <div class="uk-form-row">
                                <label class="uk-form-label" for="remove_unnecessary_header_info">
                                    <input type="hidden" name="wpc[remove_unnecessary_header_info]" class="form-control" value="0"/>
                                    <input id="remove_unnecessary_header_info" type="checkbox" name="wpc[remove_unnecessary_header_info]" value="1" <?php checked($remove_unnecessary_header_info, 1) ?>>
                                    Remove Unnecessary Header Information
                                </label>

                                <div class="uk-form-controls">
                                    <p class="uk-form-help-block">
                                        <span class="uk-badge">NOTE</span>
                                        What this basically do is hide most of the information in your WordPress header that tells somebody that your website is using WordPress.
                                        This is useful to hide the fact that you're on WordPress, so the attackers could just give up on you.
                                    </p>
                                </div>
                            </div>

                            <!-- Force jQuery CDN -->
                            <div class="uk-form-row">
                                <label class="uk-form-label" for="force_cdn_jquery">
                                    <input type="hidden" name="wpc[force_cdn_jquery]" class="form-control" value="0"/>
                                    <input id="force_cdn_jquery" type="checkbox" name="wpc[force_cdn_jquery]" value="1" <?php checked($force_cdn_jquery, 1) ?>>
                                    Force usage of jQuery CDN Version
                                </label>

                                <div class="uk-form-controls">
                                    <p class="uk-form-help-block">
                                        <span class="uk-badge">NOTE</span>
                                        Not as much as a security optimization as it is more of a performance optimization. When having jQuery loaded over CDN, browsers will skip downloading jQuery
                                        from your website over and over again as they already have it downloaded from a previous website that was using jQuery's CDN version.
                                    </p>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

                <button type="submit" name="submit" id="submit-changes" class="uk-button uk-button-primary"><i
                            class="fa fa-save"></i> Save All Changes
                </button>

            </form>

        </div>

        <!-- Anti-Exploit -->
        <div>

            <!-- Request Filtering -->
            <h4 class="uk-panel-title"><i class="fas fa-syringe"></i> Request Filtering
                <small>- sanitize incoming web requests and file uploads</small>
            </h4>
            <div class="uk-alert"><b><i class="fa fa-question-circle"></i> How can this help me?</b>
                Sanitizing web requests will prevent any malicious actions against your website. This will remove
                all the potentially unsafe content from <code>GET</code>, <code>POST</code> and <code>FILES</code>
                requests that are
                being accepted by your website, meaning even after somebody tries to exploit your already
                exploitable plugin, they will fail as unsafe content will be automatically removed. Request Filter
                protects you from
                XSS, MySQL Injections and malicious File Uploads.
            </div>

	        <?php
	        $wpc = get_option( 'wpc' );

	        // MySQL Injection
	        $mysqli_enabled = isset( $wpc['mysqli_enabled'] ) ? checked( $wpc['mysqli_enabled'] ,true ,false ) : checked( false ,true ,false );
	        $mysqli_post    = isset( $wpc['mysqli_post'] ) ? checked( $wpc['mysqli_post'] ,true ,false ) : checked( false ,true ,false );
	        $mysqli_get     = isset( $wpc['mysqli_get'] ) ? checked( $wpc['mysqli_get'] ,true ,false ) : checked( false ,true ,false );
	        $mysqli_common  = isset( $wpc['mysqli_common'] ) ? checked( $wpc['mysqli_common'] ,true ,false ) : checked( false ,true ,false );
	        $mysqli_escapes = isset( $wpc['mysqli_escapes'] ) ? checked( $wpc['mysqli_escapes'] ,true ,false ) : checked( false ,true ,false );
	        $mysqli_abs     = isset( $wpc['mysqli_abs'] ) ? checked( $wpc['mysqli_abs'] ,true ,false ) : checked( false ,true ,false );

	        // XSS Injection
	        $xssi_enabled = isset( $wpc['xssi_enabled'] ) ? checked( $wpc['xssi_enabled'] ,true ,false ) : checked( false ,true ,false );
	        $xssi_get     = isset( $wpc['xssi_get'] ) ? checked( $wpc['xssi_get'] ,true ,false ) : checked( false ,true ,false );
	        $xssi_post    = isset( $wpc['xssi_post'] ) ? checked( $wpc['xssi_post'] ,true ,false ) : checked( false ,true ,false );

	        // File Injection
	        $filei_enabled = isset( $wpc['filei_enabled'] ) ? checked( $wpc['filei_enabled'] ,true ,false ) : checked( false ,true ,false );
	        $filei_mimes   = isset( $wpc['filei_mimes'] ) ? checked( $wpc['filei_mimes'] ,true ,false ) : checked( false ,true ,false );
	        $filei_scan    = isset( $wpc['filei_enabled'] ) ? checked( $wpc['filei_scan'] ,true ,false ) : checked( false ,true ,false );
	        ?>

            <form class="wpc-settings-form">

                <input type="hidden" name="action" value="wpc_save_options"/>

                <div class="uk-form uk-form-stacked">

                    <div class="uk-grid">
                        <!-- MySQL Injection -->
                        <div class="uk-width-1-3">
                            <div class="uk-form-row">
                                <label class="uk-form-label" for="mysqli_enabled">
                                    <input type="hidden" name="wpc[mysqli_enabled]" class="form-control" value="0">
                                    <input id="mysqli_enabled" type="checkbox" name="wpc[mysqli_enabled]"
                                           value="1" <?php echo $mysqli_enabled; ?>>
                                    MySQL Injection Filtering
                                </label>

                                <input type="hidden" name="wpc[mysqli_post]" class="form-control" value="0"/>
                                <input id="mysqli_post" type="checkbox" name="wpc[mysqli_post]"
                                       value="1" <?php echo $mysqli_post; ?>>
                                <label for="mysqli_post">Filter <code>POST</code> Requests</label>

                                <br>

                                <input type="hidden" name="wpc[mysqli_get]" class="form-control" value="0"/>
                                <input id="mysqli_get" type="checkbox" name="wpc[mysqli_get]"
                                       value="1" <?php echo $mysqli_get; ?>>
                                <label for="mysqli_get">Filter <code>GET</code> Requests</label>

                                <br>

                                <input type="hidden" name="wpc[mysqli_common]" class="form-control" value="0"/>
                                <input id="mysqli_common" type="checkbox" name="wpc[mysqli_common]"
                                       value="1" <?php echo $mysqli_common; ?>>
                                <label for="mysqli_common">Filter Common MySQL Phrases</label>

                                <br>

                                <input type="hidden" name="wpc[mysqli_escapes]" class="form-control" value="0"/>
                                <input id="mysqli_escapes" type="checkbox" name="wpc[mysqli_escapes]"
                                       value="1" <?php echo $mysqli_escapes; ?>>
                                <label for="mysqli_escapes">Escape <code>'</code> and <code>"</code> in
                                    Requests</label>

                                <br>

                                <input type="hidden" name="wpc[mysqli_abs]" class="form-control" value="0"/>
                                <input id="mysqli_abs" type="checkbox" name="wpc[mysqli_abs]"
                                       value="1" <?php echo $mysqli_abs; ?>>
                                <label for="mysqli_abs">Convert Negative Numbers into Positive</label>

                                <p class="uk-form-help-block"><span class="uk-badge">NOTE</span> Protection against
                                    MySQL Injection attacks who could lead to database integrity dangers.</p>

                            </div>
                        </div>
                        <!-- XSS Injection -->
                        <div class="uk-width-1-3">
                            <div class="uk-form-row">
                                <label class="uk-form-label" for="xssi_enabled">
                                    <input type="hidden" name="wpc[xssi_enabled]" class="form-control" value="0">
                                    <input id="xssi_enabled" type="checkbox" name="wpc[xssi_enabled]"
                                           value="1" <?php echo $xssi_enabled; ?>>
                                    XSS Injection Filtering
                                </label>

                                <input type="hidden" name="wpc[xssi_post]" class="form-control" value="0"/>
                                <input id="xssi_post" type="checkbox" name="wpc[xssi_post]"
                                       value="1" <?php echo $xssi_post; ?>>
                                <label for="xssi_post">Filter <code>POST</code> Requests</label>

                                <br>

                                <input type="hidden" name="wpc[xssi_get]" class="form-control" value="0"/>
                                <input id="xssi_get" type="checkbox" name="wpc[xssi_get]"
                                       value="1" <?php echo $xssi_get; ?>>
                                <label for="xssi_get">Filter <code>GET</code> Requests</label>

                                <p class="uk-form-help-block"><span class="uk-badge">NOTE</span> Protection against
                                    XSS based JavaScript attacks who may lead to credentials theft.</p>

                            </div>
                        </div>
                        <!-- File Uploads -->
                        <div class="uk-width-1-3">
                            <div class="uk-form-row">
                                <label class="uk-form-label" for="filei_enabled">
                                    <input type="hidden" name="wpc[filei_enabled]" class="form-control" value="0">
                                    <input id="filei_enabled" type="checkbox" name="wpc[filei_enabled]"
                                           value="1" <?php echo $filei_enabled; ?>>
                                    File Upload Filtering
                                </label>

                                <input type="hidden" name="wpc[filei_mimes]" class="form-control" value="0"/>
                                <input id="filei_mimes" type="checkbox" name="wpc[filei_mimes]"
                                       value="1" <?php echo $filei_mimes; ?>>
                                <label for="filei_mimes">Filter Files with Unsafe Mime Types</label>

                                <br>

                                <input type="hidden" name="wpc[filei_enabled]" class="form-control" value="0"/>
                                <input id="filei_enabled" type="checkbox" name="wpc[filei_enabled]"
                                       value="1" <?php echo $filei_enabled; ?>>
                                <label for="filei_enabled">Filter Files for Common Unsafe Phrases</label>

                                <p class="uk-form-help-block"><span class="uk-badge">NOTE</span> Protection against
                                    malicious file uploads such as shells and viruses.</p>

                            </div>
                        </div>
                    </div>

                    <div class="uk-alert uk-alert-warning"><b><i class="fa fa-warning"></i> Important Warning: </b>
                        While preventing many attack vectors and exploits, some of the modules above can generally
                        affect functionality of some of your plugins.
                        For example, while having MySQL Injection Filtering turned on, plugins who use raw MySQL
                        queries (very bad thing to do) in requests will be rendered useless. Also,
                        while having File Upload Filtering turned on, you won't be able to upload <b>any</b> PHP
                        files using your WordPress, therefore we suggest using FTP if you need to upload
                        some PHP files to your WordPress.
                    </div>

                    <div class="uk-grid">
                        <div class="uk-width-1-1">
                            <button type="submit" name="submit" id="submit-wpc-changes"
                                    class="uk-button uk-button-primary"><i
                                        class="fa fa-save"></i> Save All Changes
                            </button>
                        </div>
                    </div>
                </div>

            </form>




        </div>

        <!-- Firewall -->
        <div>

            <div class="uk-panel uk-panel-box uk-panel-header">
                <ul class="uk-tab" data-uk-tab="{connect:'#tab-global'}">
                    <li class="uk-active">
                        <a href="">
                            <img src="<?php echo plugins_url(); ?>/wpcrusaderassets/img/firewall_monitor.png"> Live
                            Traffic Monitor
                        </a>
                    </li>
                    <li>
                        <a href="">
                            <img src="<?php echo plugins_url(); ?>/wpcrusaderassets/img/firewall.png"> Firewall
                        </a>
                    </li>
                    <li>
                        <a href="">
                            <img src="<?php echo plugins_url(); ?>/wpcrusaderassets/img/gears.png"> Settings
                        </a>
                    </li>
                </ul>

                <ul id="tab-global" class="uk-switcher">
                    <li class="uk-active" aria-hidden="false">
                        <div class="uk-grid">
                            <div class="uk-width-medium-1-1">
                                <div class="uk-overflow-container uk-overflow-css">
                                    <table class="uk-table uk-table-hover" style="background: white;">
                                        <div class="uk-grid" id="geo_monitor_table">
                                            <input type="hidden" id="lastID" value="0"/>
                                            <div class="uk-text-center more_data"><i class="fa fa-refresh fa-spin"></i>
                                                Loading Data...
                                            </div>
                                        </div>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </li>
                    <li aria-hidden="true" class="">

                        <ul class="uk-tab m-t-10" data-uk-tab="{connect:'#tab-firewall'}">
                            <li class="uk-active">
                                <a href=""><i class="fa fa-code"></i> IP Management</a>
                            </li>
                            <li class="map-container">
                                <a href=""><i class="fa fa-globe"></i> Country Management</a>
                            </li>
                            <li>
                                <a href=""><i class="fa fa-bug"></i> Crawler Management</a>
                            </li>
                        </ul>

                        <ul id="tab-firewall" class="uk-switcher">
                            <li class="uk-active" aria-hidden="false">
                                <div class="uk-grid uk-grid-collapse">
                                    <div class="uk-width-medium-1-2">
                                        <div class="uk-overflow-container uk-overflow-css">

                                            <form class="ban-ip">

                                                <div class="uk-form uk-form-stacked">

                                                    <div class="uk-form-row uk-form-row-default">
                                                        <label class="uk-form-label" for="ban_ip">
                                                            <i class="fa fa-gavel"></i> Ban a Single IP Address
                                                        </label>

                                                        <div class="uk-form-controls">

                                                            <input type="text"
                                                                   class="uk-width-1-1 uk-ip-address ban-ips"
                                                                   id="ban_ip" name="ban_ip"
                                                                   placeholder="XXX.XXX.XXX.XXX"/>

                                                            <p class="uk-form-help-block">
                                                                <span class="uk-badge">NOTE</span>
                                                                Here you can ban a single IP address by typing it in the text box above and pressing the button below.
                                                        </div>
                                                    </div>

                                                    <div class="uk-form-row uk-form-row-default">
                                                        <label class="uk-form-label" for="ban_ip_range">
                                                            <i class="fa fa-gavel"></i> Ban a IP Address Range
                                                        </label>

                                                        <div class="uk-form-controls">

                                                            <div class="uk-grid uk-grid-small">
                                                                <div class="uk-width-medium-1-2">
                                                                    <input type="text"
                                                                           class="uk-width-1-1 uk-ip-address ban-ips"
                                                                           id="ban_ip_range_1" name="ban_ip_range[0]"
                                                                           placeholder="XXX.XXX.XXX.XXX"/>
                                                                </div>
                                                                <div class="uk-width-medium-1-2">
                                                                    <input type="text"
                                                                           class="uk-width-1-1 uk-ip-address ban-ips"
                                                                           id="ban_ip_range_2" name="ban_ip_range[1]"
                                                                           placeholder="XXX.XXX.XXX.XXX"/>
                                                                </div>
                                                            </div>

                                                            <p class="uk-form-help-block">
                                                                <span class="uk-badge">NOTE</span>
                                                                Here you can ban an entire IP Address range. Be sure that values from first text box are lower than those in the first, otherwise problems may occur. Leave blank if you only wish to ban a single IP address from above.
                                                            </p>
                                                        </div>
                                                    </div>

                                                    <div class="uk-form-row uk-form-row-default uk-text-center">
                                                        <button class="uk-button uk-button-large uk-button-primary"
                                                                type="submit"><i class="fa fa-ban"></i> Add to Banned IP List
                                                        </button>
                                                    </div>

                                                </div>

                                            </form>

                                        </div>
                                    </div>
                                    <div class="uk-width-medium-1-2">
                                        <div class="uk-overflow-container uk-overflow-css">
                                            <table class="uk-table uk-table-hover" style="background: white;">
                                                <thead>
                                                <tr>
                                                    <th width="33%">IP Address</th>
                                                    <th width="33%">Date Banned</th>
                                                    <th width="33%">Action</th>
                                                </tr>
                                                </thead>
                                                <tbody id="firewall_banned_ip">

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li aria-hidden="true">
                                <div class="uk-grid uk-grid-collapse">
                                    <div class="uk-width-medium-1-2">
                                        <div class="uk-overflow-container uk-overflow-css">
                                            <!-- Map -->
                                            <div class="uk-width-1-1 m-b-10" id="country-map"></div>

                                            <!-- Current Country -->
                                            <div class="uk-width-1-1 m-b-10">
                                                <div class="ban_country_form">
                                                    <b><i class="fa fa-globe"></i> Selected Country</b>: <input placeholder="None" readonly class="selected-country" name="country"/>
                                                    <button type="button" class="uk-button uk-button-danger uk-button-small firewall_ban selected_country_button" data-id="" data-type="location"><i class="fa fa-ban"></i> Ban Country</button>
                                                </div>
                                                <p class="uk-form-help-block">
                                                    <span class="uk-badge">NOTE</span>
                                                    Here you can view currently banned countries and ban more by selecting them on map and pressing the button above.
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="uk-width-medium-1-2">
                                        <div class="uk-overflow-container uk-overflow-css">
                                            <table class="uk-table uk-table-hover" style="background: white;">
                                                <thead>
                                                <tr>
                                                    <th width="33%">Country</th>
                                                    <th width="33%">Date Banned</th>
                                                    <th width="33%">Action</th>
                                                </tr>
                                                </thead>
                                                <tbody id="firewall_banned_location">

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li aria-hidden="true" class="">
                                <div class="uk-overflow-container uk-overflow-css">

                                    <div class="uk-grid uk-grid-collapse">
                                        <div class="uk-width-medium-1-2">
                                            <form class="uk-search uk-width-1-1" data-uk-search>
                                                <input class="uk-search-field" id="search-crawlers" style="width: 100%;" type="search" placeholder="search for a crawler...">
                                            </form>
                                        </div>
                                        <div class="uk-width-medium-1-2 uk-text-right">
                                            <button class="uk-button uk-button-primary unban_all_crw" type="button"><i class="fa fa-check"></i> UnBan All Crawler</button>
                                            <button class="uk-button uk-button-danger ban_all_crw" type="button"><i class="fa fa-close"></i> Ban All Crawler</button>
                                        </div>

                                    </div>



                                    <p class="uk-form-help-block m-b-10">
                                        <span class="uk-badge">NOTE</span>
                                        Simply click the crawlers that you want to ban from your website. By clicking on the crawler you will toggle whether the selected crawler is allowed or banned to visit your website.
                                    </p>

                                    <div class="uk-grid uk-grid-small crawler-list">


                                    </div>
                                </div>
                            </li>
                        </ul>

                    </li>
                    <li aria-hidden="true" class="">
                        <form class="wpc-settings-form">
                            <input type="hidden" name="action" value="wpc_save_options"/>

					        <?php
					        $wpc = get_option( 'wpc' );
					        $firewall_monitor = isset( $wpc['firewall_monitor'] ) ? $wpc['firewall_monitor'] : 0;
					        $firewall_admin = isset( $wpc['firewall_monitor_admin'] ) ? $wpc['firewall_monitor_admin'] : 0;
					        $firewall_skip = isset( $wpc['firewall_skip_common'] ) ? $wpc['firewall_skip_common'] : 0;
					        $firewall = isset( $wpc['firewall'] ) ? $wpc['firewall'] : 0;
					        $firewall_sync = isset( $wpc['firewall_sync'] ) ? $wpc['firewall_sync'] : 0;
					        ?>

                            <div class="uk-form uk-form-stacked">
                                <div class="uk-form-row">
                                    <label class="uk-form-label" for="firewall_monitor">
                                        <input type="hidden" name="wpc[firewall_monitor]" class="form-control"
                                               value="0"/>
                                        <input id="firewall_monitor" type="checkbox" name="wpc[firewall_monitor]"
                                               value="1" <?php checked( $firewall_monitor, 1 ) ?>>
                                        Live Traffic Monitor
                                    </label>

                                    <div class="uk-form-controls">
                                        <p class="uk-form-help-block">
                                            <span class="uk-badge">NOTE</span>
                                            By activating Live Traffic Monitor, all requests that pass through WordPress
                                            core will be cached inside of database for your later inspection. This is a
                                            good way
                                            of catching some bad guys trying to harm your website.
                                        </p>
                                    </div>
                                </div>

                                <div class="uk-form-row">
                                    <label class="uk-form-label" for="firewall_monitor_admin">
                                        <input type="hidden" name="wpc[firewall_monitor_admin]" class="form-control"
                                               value="0"/>
                                        <input id="firewall_monitor_admin" type="checkbox"
                                               name="wpc[firewall_monitor_admin]"
                                               value="1" <?php checked( $firewall_admin, 1 ) ?>>
                                        Live Traffic Monitor <i>(Admin Area)</i>
                                    </label>

                                    <div class="uk-form-controls">
                                        <p class="uk-form-help-block">
                                            <span class="uk-badge">NOTE</span>
                                            Same as the Live Traffic Monitor, but when this option is turned on, it will
                                            monitor the traffic coming from the WordPress admin area as well. This is
                                            good to have
                                            if you have a website that has registrations turned on and you want to
                                            monitor what's going on.
                                        </p>
                                    </div>
                                </div>

                                <div class="uk-form-row">
                                    <label class="uk-form-label" for="firewall_skip_common">
                                        <input type="hidden" name="wpc[firewall_skip_common]" class="form-control"
                                               value="0"/>
                                        <input id="firewall_skip_common" type="checkbox"
                                               name="wpc[firewall_skip_common]"
                                               value="1" <?php checked( $firewall_skip, 1 ) ?>>
                                        Skip common WordPress requests
                                    </label>

                                    <div class="uk-form-controls">
                                        <p class="uk-form-help-block">
                                            <span class="uk-badge">NOTE</span>
                                            It is advisable to turn this option on if you have Live Traffic Monitor
                                            turned on for Admin Area as you will probably see a lot of common admin-ajax
                                            and admin-post requests. This option whitelists those requests and does not
                                            cache them.
                                        </p>
                                    </div>
                                </div>

                                <div class="uk-form-row">
                                    <label class="uk-form-label" for="firewall">
                                        <input type="hidden" name="wpc[firewall]" class="form-control" value="0"/>
                                        <input id="firewall" type="checkbox" name="wpc[firewall]"
                                               value="1" <?php checked( $firewall, 1 ) ?>>
                                        Disable Firewall
                                    </label>

                                    <div class="uk-form-controls">
                                        <p class="uk-form-help-block">
                                            <span class="uk-badge">NOTE</span>
                                            By enabling this option you will disable the Firewall. This is not recommended, but could be useful in some cases.
                                        </p>
                                    </div>
                                </div>

                                <div class="uk-form-row">
                                    <label class="uk-form-label" for="firewall_sync">
                                        <input type="hidden" name="wpc[firewall_sync]" class="form-control" value="0"/>
                                        <input id="firewall_sync" type="checkbox" name="wpc[firewall_sync]"
                                               value="1" <?php checked( $firewall_sync, 1 ) ?>>
                                        Firewall Synchronization
                                    </label>

                                    <div class="uk-form-controls">
                                        <p class="uk-form-help-block">
                                            <span class="uk-badge">NOTE</span>
                                            This will enable firewall synchronization of all your websites running Crusader. If you turn this option on, your banned ip/country/crawler database will be
                                            stored at our server, which can be later on shared with new Crusader installations.
                                        </p>
                                    </div>
                                </div>

                                <br>

                                <div class="uk-width-1-1">
                                    <button type="submit" name="submit" id="submit-wpc-changes"
                                            class="uk-button uk-button-primary"><i
                                                class="fa fa-save"></i> Save All Changes
                                    </button>
                                </div>
                            </div>

                        </form>
                    </li>
                </ul>

            </div>

        </div>

    </div>


</div> <!-- .wrap -->

