<?php // PHP STARTS HERE
global $xag_update;

$prs = get_option('prs');

// Check whether this is
// the first time someone
// opens Xagio
$display_intro_video = FALSE;
//  if (!isset($prs['first_start_happened'])) {
//      if (!is_array($prs)) $prs = array();
//      $prs['first_start_happened'] = true;
//      update_option('prs', $prs);
//      $display_intro_video = true;
//  }

// Check if feature is enabled
$ps_features = get_option('ps_features');

$hasAccess   = false;
if ($ps_features != FALSE && is_array($ps_features)) {
	if (in_array('seo', $ps_features)) {
		$hasAccess = true;
	}
}

// License checks
$disabled      = '';
$license_email = '';
$license_key   = '';
if ($license_set = XAG_Licencator::isLicenseSet($license_email, $license_key)) {
	$disabled = 'disabled';
}
if (!empty($license_key)) {
	$license_lists = explode('-', $license_key);
	$license_key   = 'XXXXX-XXXXX-' . $license_lists[2] . '-' . $license_lists[3];
}

$XAG_MIGRATION = get_option('XAG_MIGRATION');
if (!is_array($XAG_MIGRATION)) {
	$XAG_MIGRATION = [];
}

$ht_access_file = get_home_path() . '.htaccess';
?>

<style>
    div#wpwrap {
        background: #f5f7fb;
    }
</style>

<!-- HTML STARTS HERE -->
<div class="wrap prs" style="max-width: 1200px;margin-left: auto;margin-right: auto;">
    <h2 class="logo-title logo-title-big">
        <span class="logo-title-center">
            <img class="logo-image" src="<?= XAG_URL; ?>assets/img/logo-xagio.png"/>
            Xagio
            -
            <small class="hand">Welcome!</small>

            <button type="button" class="uk-button uk-button-show-changelog"><i class="fa fa-info-circle"></i> v<?php echo XAG_CURRENT_VERSION; ?> Changelog</button>
            <button type="button" class="uk-button uk-button-show-tutorial" data-page="<?php echo (isset($_GET['page']) && !empty($_GET['page'])) ? $_GET['page'] : ''; ?>"><i class="fa fa-film"></i> Tutorials</button>
            <button type="button" class="uk-button uk-button-check-updates"><i class="fa fa-download"></i> Check for Updates</button>
        </span>
    </h2>

    <p class="logo-paragraph uk-block-xagio settings-info">
        <i class="fa fa-info-circle"></i> <b>Xagio</b> is now installed and ready to use! Get ready to rank with your website.
        Please register your purchase to get support and automatic plugin updates. Read below for additional information. We hope you enjoy it!
    </p>

    <ul class="uk-tab uk-tab-big" data-uk-tab="{connect:'#tab-content'}">
        <li class="uk-active"><a href=""><i class="fa fa-lock"></i> Product Registration</a></li>
		<?php if ($license_set && $hasAccess) { ?>
            <li><a href=""><i class="fa fa-magic"></i> Easy WP Setup</a></li>
            <li><a href=""><i class="fa fa-balance-scale"></i> Migration</a></li>
            <li><a href=""><i class="fa fa-gears"></i> Settings</a></li>
		<?php } ?>
        <li><a href=""><i class="fa fa-warning"></i> Troubleshooting</a></li>
        <li><a href=""><i class="fa fa-bar-chart"></i> System Status</a></li>
    </ul>

    <div id="tab-content" class="uk-switcher">

        <!-- Plugin Activation -->
        <div>
            <?php if (!$license_set) { ?>
            <!-- Steps -->
            <div class="uk-block uk-block-muted uk-block-xagio">

                <div class="uk-container">

                    <div class="uk-grid uk-grid-match" data-uk-grid-margin="">
                        <div class="uk-width-medium-1-3 uk-row-first">
                            <div class="uk-panel">
                                <h3><b>Step 1</b> - Sign up for Support</h3>
                                <p>
                                    <a href="https://supremacy.freshdesk.com/support/signup" target="_blank">Click
                                        here</a> to sign up at our support center. View a tutorial there. This gives you
                                    access to our documentation, knowledge base, video tutorials and ticket system.
                                </p>
                            </div>
                        </div>
                        <div class="uk-width-medium-1-3">
                            <div class="uk-panel">
                                <h3><b>Step 2</b> - Get your License Key</h3>
                                <p>
                                    Log in into your members area <a href="https://app.xagio.net/"
                                                                     target="_blank">here</a> and grab your E-Mail
                                    Address and License Key provided under Plugin Download & License page.
                                </p>
                            </div>
                        </div>
                        <div class="uk-width-medium-1-3">
                            <div class="uk-panel">
                                <h3><b>Step 3</b> - Activate plugin</h3>
                                <p>
                                    Enter below your E-Mail Address and License Key provided in members area to activate
                                    Xagio on this website.
                                </p>
                            </div>
                        </div>
                    </div>

                </div>

            </div>
            <?php } ?>

            <!-- License -->
            <div class="uk-block uk-block-muted uk-block-xagio m-t-30">

                <div class="uk-container">

                    <form class="validate-license" method="POST">

						<?php if (!$license_set) { ?>
                            <input type="hidden" name="action" value="xag_activate_license"/>
						<?php } else { ?>
                            <input type="hidden" name="action" value="xag_deactivate_license"/>
						<?php } ?>

                        <h2><i class="fa fa-lock"></i> Enter your <b>License</b> below:</h2>
                        <p class="p-padding">Use e-mail address and license key that you have obtained from your
                            membership area to activate Xagio on this website.</p>

                        <div class="uk-grid uk-grid-match" data-uk-grid-margin="">
                            <div class="uk-width-medium-1-2 uk-row-first">
                                <div class="uk-panel">
                                    <h3><i class="fa fa-envelope"></i> E-Mail Address:</h3>

                                    <!-- License E-Mail -->
                                    <input value="<?= $license_email; ?>" type="email"
                                           class="uk-input-big uk-input-custom" name="license_email"
                                           placeholder="eg. youremail@provider.com" required <?= $disabled; ?>/>

                                </div>
                            </div>
                            <div class="uk-width-medium-1-2">
                                <div class="uk-panel">
                                    <h3><i class="fa fa-key"></i> License Key:</h3>

                                    <!-- License Key -->
                                    <input value="<?= $license_key; ?>" type="text" class="uk-input-big uk-input-custom"
                                           name="license_key" placeholder="eg. XXXX-XXXX-XXXX-XXXX"
                                           required <?= $disabled; ?>/>

                                </div>
                            </div>
                        </div>

						<?php if (!$license_set) { ?>
                            <button type="submit" class="uk-button uk-button-success uk-button-big">
                                <i class="fa fa-arrow-circle-o-right"></i> Activate Xagio License
                            </button>
						<?php } else { ?>
                            <button type="submit" class="uk-button uk-button-danger uk-button-big">
                                <i class="fa fa-power-off"></i> Deactivate Xagio License
                            </button>
						<?php } ?>

                    </form>

                </div>

            </div>
        </div>

		<?php if ($license_set && $hasAccess) { ?>

            <!-- Easy WP Setup -->
            <div>
                <form class="fs">
                    <input type="hidden" name="action" value="xag_fs_perform"/>
                    <div class="uk-grid">
                        <div class="uk-width-1-2">
                            <!-- General Settings -->
                            <div class="uk-panel uk-block-xagio">
                                <h3 class="uk-panel-title"><i class="fa fa-gear"></i> General Settings</h3>

                                <div class="slider-container">
                                    <input type="hidden" name="fs_remove_pages" id="fs_remove_pages" value="0"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button" data-element="fs_remove_pages">No</span>
                                    </div>
                                    <p class="slider-label">Remove all <b>Pages</b> <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="This will remove all the sample pages you start with in WordPress."></i>
                                    </p>
                                </div>

                                <div class="slider-container">
                                    <input type="hidden" name="fs_remove_posts" id="fs_remove_posts" value="0"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button" data-element="fs_remove_posts">No</span>
                                    </div>
                                    <p class="slider-label">Remove all <b>Posts</b> <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="This will remove all the sample pages you start with in WordPress."></i>
                                    </p>
                                </div>

                                <div class="slider-container">
                                    <input type="hidden" name="fs_permalinks" id="fs_permalinks" value="0"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button" data-element="fs_permalinks">No</span>
                                    </div>
                                    <p class="slider-label">Set <b>permalink structure</b> to Post Name <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="This will set up permalink structure to Post Name. Example: /page-name/"></i>
                                    </p>
                                </div>

                            </div>
                            <!-- Comments Settings -->
                            <div class="uk-panel uk-block-xagio">
                                <h3 class="uk-panel-title"><i class="fa fa-comment"></i> Comments Settings</h3>

                                <div class="slider-container">
                                    <input type="hidden" name="fs_remove_comments" id="fs_remove_comments" value="0"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button" data-element="fs_remove_comments">No</span>
                                    </div>
                                    <p class="slider-label">Remove all <b>Comments</b> <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="This will remove all existing comments from your WordPress."></i>
                                    </p>
                                </div>

                                <div class="slider-container">
                                    <input type="hidden" name="fs_disable_comment_notifications"
                                           id="fs_disable_comment_notifications" value="0"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button"
                                              data-element="fs_disable_comment_notifications">No</span>
                                    </div>
                                    <p class="slider-label">Disable <b>new comments</b> notifications <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="Disables notifications when new comments are made."></i></p>
                                </div>

                                <div class="slider-container">
                                    <input type="hidden" name="fs_disable_comment_moderation"
                                           id="fs_disable_comment_moderation" value="0"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button"
                                              data-element="fs_disable_comment_moderation">No</span>
                                    </div>
                                    <p class="slider-label">Disable <b>comments moderation</b> notifications <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="Disables notifications for comment moderation."></i></p>
                                </div>

                            </div>
                            <!-- Content Settings -->
                            <div class="uk-panel uk-block-xagio">
                                <h3 class="uk-panel-title"><i class="fa fa-file-text"></i> Content Settings</h3>

                                <div class="slider-container">
                                    <input type="hidden" name="fs_create_aboutus" id="fs_create_aboutus" value="0"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button" data-element="fs_create_aboutus">No</span>
                                    </div>
                                    <p class="slider-label">Create <b>About Us</b> page <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="Creates an About Us page."></i></p>
                                </div>

                                <div class="slider-container">
                                    <input type="hidden" name="fs_create_privacypolicy" id="fs_create_privacypolicy"
                                           value="0"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button" data-element="fs_create_privacypolicy">No</span>
                                    </div>
                                    <p class="slider-label">Create <b>Privacy Policy</b> page <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="Creates a Privacy Policy page."></i></p>
                                </div>

                                <div class="slider-container">
                                    <input type="hidden" name="fs_create_termsofuse" id="fs_create_termsofuse"
                                           value="0"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button" data-element="fs_create_termsofuse">No</span>
                                    </div>
                                    <p class="slider-label">Create <b>Terms of Use</b> page <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="Creates Terms of Use page."></i></p>
                                </div>

                                <div class="slider-container">
                                    <input type="hidden" name="fs_create_earningsdisclaimer"
                                           id="fs_create_earningsdisclaimer" value="0"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button"
                                              data-element="fs_create_earningsdisclaimer">No</span>
                                    </div>
                                    <p class="slider-label">Create <b>Earnings Disclaimer</b> page <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="Creates Earning Disclaimer page."></i></p>
                                </div>

                                <div class="slider-container">
                                    <input type="hidden" name="fs_create_contactus" id="fs_create_contactus" value="0"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button" data-element="fs_create_contactus">No</span>
                                    </div>
                                    <p class="slider-label">Create <b>Contact Us</b> page <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="Creates Contact Us page."></i></p>
                                </div>

                                <hr>

                                <div class="slider-container">
                                    <input type="hidden" name="fs_create_amazonassociatedisclosure"
                                           id="fs_create_amazonassociatedisclosure" value="0"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button" data-element="fs_create_amazonassociatedisclosure">No</span>
                                    </div>
                                    <p class="slider-label">Create <b>Amazon Associate Disclose</b> page <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="Creates Amazon Associates Disclosure page."></i></p>
                                </div>

                                <div class="slider-container">
                                    <input type="hidden" name="fs_create_affiliatedisclosure"
                                           id="fs_create_affiliatedisclosure" value="0"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button"
                                              data-element="fs_create_affiliatedisclosure">No</span>
                                    </div>
                                    <p class="slider-label">Create <b>Affiliate Disclose</b> page <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="Creates Affiliate Disclosure page."></i></p>
                                </div>

                                <div class="slider-container">
                                    <input type="hidden" name="fs_create_copyright" id="fs_create_copyright" value="0"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button" data-element="fs_create_copyright">No</span>
                                    </div>
                                    <p class="slider-label">Create <b>Copyright Notice</b> page <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="Creates Copyright Notice page."></i></p>
                                </div>

                                <div class="slider-container">
                                    <input type="hidden" name="fs_create_antispam" id="fs_create_antispam" value="0"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button" data-element="fs_create_antispam">No</span>
                                    </div>
                                    <p class="slider-label">Create <b>Anti Spam Policy</b> page <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="Creates Anti Spam Policy page."></i></p>
                                </div>

                                <div class="slider-container">
                                    <input type="hidden" name="fs_create_medicaldisclaimer"
                                           id="fs_create_medicaldisclaimer" value="0"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button" data-element="fs_create_medicaldisclaimer">No</span>
                                    </div>
                                    <p class="slider-label">Create <b>Medical Disclaimer</b> page <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="Creates Medical Disclaimer page."></i></p>
                                </div>

                                <hr>

                                <div class="slider-container">
                                    <input type="hidden" name="fs_create_categories" id="fs_create_categories"
                                           value="0"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button" data-element="fs_create_categories">No</span>
                                    </div>
                                    <p class="slider-label">Create <b>Multiple Categories</b> <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="Creates 5 Categories for you to customize."></i></p>
                                </div>

                                <div class="fs_create_categories_list uk-hidden">

                                    <input name="fs_create_categories_list[]" type="text"
                                           placeholder="eg. Category Name" class="uk-width-1-1"/>
                                    <input name="fs_create_categories_list[]" type="text"
                                           placeholder="eg. Category Name" class="uk-width-1-1"/>
                                    <input name="fs_create_categories_list[]" type="text"
                                           placeholder="eg. Category Name" class="uk-width-1-1"/>
                                    <input name="fs_create_categories_list[]" type="text"
                                           placeholder="eg. Category Name" class="uk-width-1-1"/>

                                    <button type="button"
                                            class="uk-button uk-button-mini uk-button-primary uk-button-add-category"><i
                                                class="fa fa-plus"></i> Add
                                    </button>
                                    <button type="button"
                                            class="uk-button uk-button-mini uk-button-danger uk-button-remove-category">
                                        <i class="fa fa-close"></i> Remove
                                    </button>
                                </div>

                                <div class="slider-container">
                                    <input type="hidden" name="fs_create_blank_pages" id="fs_create_blank_pages"
                                           value="0"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button" data-element="fs_create_blank_pages">No</span>
                                    </div>
                                    <p class="slider-label">Create <b>Multiple Pages</b> <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="Creates 5 blank pages for you to customize."></i></p>
                                </div>

                                <div class="fs_create_blank_pages_list uk-hidden">

                                    <input name="fs_create_blank_pages_list[]" type="text" placeholder="eg. Page Name"
                                           class="uk-width-1-1"/>
                                    <input name="fs_create_blank_pages_list[]" type="text" placeholder="eg. Page Name"
                                           class="uk-width-1-1"/>
                                    <input name="fs_create_blank_pages_list[]" type="text" placeholder="eg. Page Name"
                                           class="uk-width-1-1"/>
                                    <input name="fs_create_blank_pages_list[]" type="text" placeholder="eg. Page Name"
                                           class="uk-width-1-1"/>

                                    <button type="button"
                                            class="uk-button uk-button-mini uk-button-primary uk-button-add-pages"><i
                                                class="fa fa-plus"></i> Add
                                    </button>
                                    <button type="button"
                                            class="uk-button uk-button-mini uk-button-danger uk-button-remove-pages"><i
                                                class="fa fa-close"></i> Remove
                                    </button>
                                </div>

                                <div class="slider-container">
                                    <input type="hidden" name="fs_create_blank_posts" id="fs_create_blank_posts"
                                           value="0"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button" data-element="fs_create_blank_posts">No</span>
                                    </div>
                                    <p class="slider-label">Create <b>Multiple Posts</b> <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="Creates 5 blank posts for you to customize."></i></p>
                                </div>

                                <div class="fs_create_blank_posts_list uk-hidden">

                                    <input name="fs_create_blank_posts_list[]" type="text" placeholder="eg. Post Name"
                                           class="uk-width-1-1"/>
                                    <input name="fs_create_blank_posts_list[]" type="text" placeholder="eg. Post Name"
                                           class="uk-width-1-1"/>
                                    <input name="fs_create_blank_posts_list[]" type="text" placeholder="eg. Post Name"
                                           class="uk-width-1-1"/>
                                    <input name="fs_create_blank_posts_list[]" type="text" placeholder="eg. Post Name"
                                           class="uk-width-1-1"/>

                                    <button type="button"
                                            class="uk-button uk-button-mini uk-button-primary uk-button-add-post"><i
                                                class="fa fa-plus"></i> Add
                                    </button>
                                    <button type="button"
                                            class="uk-button uk-button-mini uk-button-danger uk-button-remove-post"><i
                                                class="fa fa-close"></i> Remove
                                    </button>
                                </div>

                            </div>
                        </div>
                        <div class="uk-width-1-2">
                            <!-- Plugin Settings -->
                            <div class="uk-panel uk-block-xagio">
                                <h3 class="uk-panel-title"><i class="fa fa-plug"></i> Plugin Settings</h3>

                                <div class="slider-container">
                                    <input type="hidden" name="fs_remove_plugins" id="fs_remove_plugins" value="0"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button" data-element="fs_remove_plugins">No</span>
                                    </div>
                                    <p class="slider-label">Remove default <b>Plugins</b> <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="Removes Akismet & Hello Dolly from your WordPress."></i></p>
                                </div>

                                <h3 class="uk-panel-title"><i class="fa fa-search"></i> Plugin Picker <i
                                            class="fa fa-info-circle help-icon" data-uk-tooltip
                                            title="This will allow you to select which plugins you wish to install."></i>
                                </h3>

                                <!-- Plugin Search -->
                                <div class="uk-search uk-active">
                                    <input data-type="plugins" class="uk-search-field" id="search_plugins"
                                           placeholder="type here to search for Plugins...">
                                    <div class="uk-dropdown uk-dropdown-search" aria-expanded="false"></div>
                                </div>

                                <!-- Plugins results -->
                                <div class="result-container" id="result_plugins">

                                </div>

                                <!-- Plugin tags -->
                                <input name="fs_plugins" id="plugins" value=""/>


                            </div>

                            <!-- Theme Settings -->
                            <div class="uk-panel uk-block-xagio">
                                <h3 class="uk-panel-title"><i class="fa fa-paint-brush"></i> Theme Settings</h3>

                                <div class="slider-container">
                                    <input type="hidden" name="fs_remove_themes" id="fs_remove_themes" value="0"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button" data-element="fs_remove_themes">No</span>
                                    </div>
                                    <p class="slider-label">Remove default <b>Themes</b> <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="Removes TwentySixteen and TwentyFifteen themes from your WordPress."></i>
                                    </p>
                                </div>

                                <h3 class="uk-panel-title"><i class="fa fa-search"></i> Theme Picker <i
                                            class="fa fa-info-circle help-icon" data-uk-tooltip
                                            title="This will allow you to select which themes you wish to install."></i>
                                </h3>

                                <!-- Theme Search -->
                                <div class="uk-search uk-active">
                                    <input data-type="themes" class="uk-search-field" id="search_themes"
                                           placeholder="type here to search for Themes...">
                                    <div class="uk-dropdown uk-dropdown-search" aria-expanded="false"></div>
                                </div>

                                <!-- Theme results -->
                                <div class="result-container" id="result_themes">

                                </div>

                                <!-- Theme tags -->
                                <input name="fs_themes" id="themes" value=""/>

                            </div>
                        </div>
                    </div>

                    <button type="submit" class="uk-button uk-button-primary uk-button-big btn-save-changes">
                        <i class="fa fa-magic"></i> Start Easy WP Setup
                    </button>

                </form>
            </div>

            <!-- Migration -->
            <div>
                <form class="ts">
                    <input type="hidden" name="action" value="xag_migrate"/>

                    <div class="uk-grid">
                        <div class="uk-width-4-10">
                            <div class="uk-panel uk-block-xagio">
                                <h3 class="uk-panel-title">Xagio V2 – Migration</h3>

                                <?php if (is_plugin_active('project-supremacy/google_keyword_tool.php')) { ?>

                                    <div class="slider-container">
                                        <input type="hidden" name="ts_migrate_reviews" id="ts_migrate_reviews" value="0"/>
                                        <div class="prs-slider-frame">
                                        <span class="slider-button" <?php echo (isset($XAG_MIGRATION['ts_migrate_reviews'])) ? 'data-migrated="true" data-uk-tooltip title="You have migrated this already on this website."' : ''; ?>
                                              data-element="ts_migrate_reviews">No</span>
                                        </div>
                                        <p class="slider-label">Migrate <b>Reviews</b> <i
                                                    class="fa fa-info-circle help-icon" data-uk-tooltip
                                                    title="Will migrate all page/post PS SEO settings from v2 to v3."></i>
                                        </p>
                                    </div>

                                    <div class="slider-container">
                                        <input type="hidden" name="ts_migrate_projects" id="ts_migrate_projects" value="0"/>
                                        <div class="prs-slider-frame">
                                        <span class="slider-button" <?php echo (isset($XAG_MIGRATION['ts_migrate_projects'])) ? 'data-migrated="true" data-uk-tooltip title="You have migrated this already on this website."' : ''; ?>
                                              data-element="ts_migrate_projects">No</span>
                                        </div>
                                        <p class="slider-label">Migrate <b>Projects</b> <i
                                                    class="fa fa-info-circle help-icon" data-uk-tooltip
                                                    title="Will migrate all your projects from v2 to v3."></i></p>
                                    </div>

                                    <div class="slider-container">
                                        <input type="hidden" name="ts_migrate_affiliate_shortcodes"
                                               id="ts_migrate_affiliate_shortcodes" value="0"/>
                                        <div class="prs-slider-frame">
                                        <span class="slider-button" <?php echo (isset($XAG_MIGRATION['ts_migrate_affiliate_shortcodes'])) ? 'data-migrated="true" data-uk-tooltip title="You have migrated this already on this website."' : ''; ?>
                                              data-element="ts_migrate_affiliate_shortcodes">No</span>
                                        </div>
                                        <p class="slider-label">Migrate <b>Affiliate Shortcodes</b> <i
                                                    class="fa fa-info-circle help-icon" data-uk-tooltip
                                                    title="Will migrate all your affiliate shortcodes from v2 to v3."></i>
                                        </p>
                                    </div>

                                    <div class="slider-container">
                                        <input type="hidden" name="ts_migrate_schemas" id="ts_migrate_schemas" value="0"/>
                                        <div class="prs-slider-frame">
                                        <span class="slider-button" <?php echo (isset($XAG_MIGRATION['ts_migrate_schemas'])) ? 'data-migrated="true" data-uk-tooltip title="You have migrated this already on this website."' : ''; ?>
                                              data-element="ts_migrate_schemas">No</span>
                                        </div>
                                        <p class="slider-label">Migrate <b>Schemas</b> <i
                                                    class="fa fa-info-circle help-icon" data-uk-tooltip
                                                    title="Will migrate all your schemas from v2 to v3."></i></p>
                                    </div>

                                    <div class="slider-container">
                                        <input type="hidden" name="ts_migrate_settings" id="ts_migrate_settings" value="0"/>
                                        <div class="prs-slider-frame">
                                        <span class="slider-button" <?php echo (isset($XAG_MIGRATION['ts_migrate_settings'])) ? 'data-migrated="true" data-uk-tooltip title="You have migrated this already on this website."' : ''; ?>
                                              data-element="ts_migrate_settings">No</span>
                                        </div>
                                        <p class="slider-label">Migrate <b>Settings</b> <i
                                                    class="fa fa-info-circle help-icon" data-uk-tooltip
                                                    title="Will migrate all v2 settings to v3."></i></p>
                                    </div>

                                    <div class="slider-container">
                                        <input type="hidden" name="ts_migrate_on_page_seo" id="ts_migrate_on_page_seo" value="0"/>
                                        <div class="prs-slider-frame">
                                        <span class="slider-button" <?php echo (isset($XAG_MIGRATION['ts_migrate_on_page_seo'])) ? 'data-migrated="true" data-uk-tooltip title="You have migrated this already on this website."' : ''; ?>
                                              data-element="ts_migrate_on_page_seo">No</span>
                                        </div>
                                        <p class="slider-label">Migrate <b>On Page SEO</b> <i
                                                    class="fa fa-info-circle help-icon" data-uk-tooltip
                                                    title="Will migrate all v2 on page SEO settings to v3."></i></p>
                                    </div>

                                    <button type="submit"
                                            class="uk-button uk-button-primary uk-button-big btn-save-changes">
                                        <i class="fa fa-caret-right"></i> Start V2 Migration
                                    </button>

                                <?php } else { ?>
                                    <h4 class="migration-notice uk-block-xagio"><i class="fa fa-warning"></i> To use V2 migration, please install and activate Xagio v2.</h4>
                                <?php } ?>
                            </div>
                        </div>
                        <div class="uk-width-6-10">
                            <div class="uk-panel uk-block-xagio">
                                <h3 class="uk-panel-title">Yoast SEO – Migration</h3>
							<?php if (is_plugin_active('wordpress-seo/wp-seo.php') || is_plugin_active('wordpress-seo-premium/wp-seo-premium.php')) { ?>

                                <p class="migration-info">Following page/post data will be migrated from <b>Yoast
                                        SEO</b> to <b>Xagio V3:</b></p>
                                <ul class="migration-list">
                                    <li>Titles</li>
                                    <li>Descriptions</li>
                                    <li>Focus Keywords</li>
                                    <li>Canonical URLs</li>
                                    <li>OpenGraph Titles</li>
                                    <li>OpenGraph Descriptions</li>
                                    <li>OpenGraph Images</li>
                                </ul>

                                <button type="button" class="uk-button uk-button-primary uk-button-big migration-yoast">
                                    <i class="fa fa-caret-right"></i> Start Yoast Migration
                                </button>


							<?php } else { ?>
                                <h4 class="migration-notice uk-block-xagio"><i class="fa fa-warning"></i> To use Yoast migration,
                                    please install and activate Yoast SEO.</h4>
							<?php } ?>
                            </div>

                            <div class="uk-panel uk-block-xagio">
                                <h3 class="uk-panel-title">All in One SEO – Migration</h3>
							<?php if (is_plugin_active('all-in-one-seo-pack/all_in_one_seo_pack.php') ||
								is_plugin_active('all-in-one-seo-pack-pro/all_in_one_seo_pack.php')) { ?>

                                <p class="migration-info">Following page/post data will be migrated from <b>All in One
                                        SEO</b> to <b>Xagio V3:</b></p>
                                <ul class="migration-list">
                                    <li>Titles</li>
                                    <li>Descriptions</li>
                                    <li>Canonical URLs</li>
                                </ul>

                                <button type="button" class="uk-button uk-button-primary uk-button-big migration-aio">
                                    <i class="fa fa-caret-right"></i> Start AIO Migration
                                </button>


							<?php } else { ?>
                                <h4 class="migration-notice uk-block-xagio"><i class="fa fa-warning"></i> To use AIO migration, please
                                    install and activate All in One SEO.</h4>
							<?php } ?>
                            </div>
                        </div>
                    </div>

                </form>
            </div>

            <!-- Settings -->
            <div>
                <div class="uk-grid">
                    <div class="uk-width-4-10">

                        <div class="uk-panel uk-block-xagio">

                            <h3 class="uk-panel-title"><i class="fa fa-gears"></i> Settings</h3>

                            <form class="ts">
                                <input type="hidden" name="action" value="xag_settings"/>

                                <!-- Force Schemas -->
                                <div class="slider-container">
                                    <input type="hidden" name="xag_force_schema" id="xag_force_schema"
                                           value="<?= (XAG_FORCE_SCHEMA == TRUE) ? 1 : 0; ?>"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button <?= (XAG_FORCE_SCHEMA == TRUE) ? 'on' : ''; ?>"
                                              data-element="xag_force_schema"><?= (XAG_FORCE_SCHEMA == TRUE) ? 'Yes' : 'No'; ?></span>
                                    </div>
                                    <p class="slider-label">Force <b>Homepage</b> Schemas <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="In case where you want to want your Homepage schema(s) to appear on all of your pages and posts, set this to Yes. However be warned that this may result in getting spammy structured data warnings from Google."></i>
                                    </p>
                                </div>

                                <!-- Render Pretty Schemas -->
                                <div class="slider-container">
                                    <input type="hidden" name="xag_pretty_schema" id="xag_pretty_schema"
                                           value="<?= (XAG_PRETTY_SCHEMA == TRUE) ? 1 : 0; ?>"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button <?= (XAG_PRETTY_SCHEMA == TRUE) ? 'on' : ''; ?>"
                                              data-element="xag_pretty_schema"><?= (XAG_PRETTY_SCHEMA == TRUE) ? 'Yes' : 'No'; ?></span>
                                    </div>
                                    <p class="slider-label">Render <b>Pretty</b> Schemas <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="This can be useful during the schemas setup. It will show you schemas in source code in human readable format instead of minified version you normal see. Should be turned off after setup to save server resources."></i>
                                    </p>
                                </div>

                                <!-- reCAPTCHA -->
                                <div class="slider-container">
                                    <input type="hidden" name="xag_recaptcha_enabled" id="xag_recaptcha_enabled"
                                           value="<?= (XAG_RECAPTCHA == TRUE) ? 1 : 0; ?>"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button <?= (XAG_RECAPTCHA == TRUE) ? 'on' : ''; ?>"
                                              data-element="xag_recaptcha_enabled"><?= (XAG_RECAPTCHA == TRUE) ? 'Yes' : 'No'; ?></span>
                                    </div>
                                    <p class="slider-label">Use <b>reCAPTCHA</b> Protection <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="If you have set your reCAPTCHA site key and secret key on Panel, plugin will use those to display reCAPTCHA validation on your login, registration and comments forms. This greatly reduces risk from hacking and spamming."></i>
                                    </p>
                                </div>

                                <!-- Disable 301 Redirects -->
                                <div class="slider-container">
                                    <input type="hidden" name="xag_disable_redirects" id="xag_disable_redirects"
                                           value="<?= (XAG_DISABLE_REDIRECTS == TRUE) ? 1 : 0; ?>"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button <?= (XAG_DISABLE_REDIRECTS == TRUE) ? 'on' : ''; ?>"
                                              data-element="xag_disable_redirects"><?= (XAG_DISABLE_REDIRECTS == TRUE) ? 'Yes' : 'No'; ?></span>
                                    </div>
                                    <p class="slider-label">Disable <b>Automatic</b> Redirects <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="This will disable automatic generation of 301 redirects that are made when you change the URL of an existing page/post."></i>
                                    </p>
                                </div>

                                <!-- Remove footprint -->
                                <div class="slider-container">
                                    <input type="hidden" name="xag_remove_footprint" id="xag_remove_footprint"
                                           value="<?= (XAG_REMOVE_FOOTPRINT == TRUE) ? 1 : 0; ?>"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button <?= (XAG_REMOVE_FOOTPRINT == TRUE) ? 'on' : ''; ?>"
                                              data-element="xag_remove_footprint"><?= (XAG_REMOVE_FOOTPRINT == TRUE) ? 'Yes' : 'No'; ?></span>
                                    </div>
                                    <p class="slider-label">Disable <b>HTML Comments</b> Footprint <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="PSv3 displays HTML comments inside of your website's source code when rendering schemas, seo settings, meta robots and etc. Google is not actually seeing or parsing those, but if you want to remove them, you can by setting this to Yes."></i>
                                    </p>
                                </div>

                                <!-- Disable FailSafe Recovery -->
                                <div class="slider-container">
                                    <input type="hidden" name="xag_disable_failsafe" id="xag_disable_failsafe"
                                           value="<?= (XAG_DISABLE_FAILSAFE == TRUE) ? 1 : 0; ?>"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button <?= (XAG_DISABLE_FAILSAFE == TRUE) ? 'on' : ''; ?>"
                                              data-element="xag_disable_failsafe"><?= (XAG_DISABLE_FAILSAFE == TRUE) ? 'Yes' : 'No'; ?></span>
                                    </div>
                                    <p class="slider-label">Disable <b>FailSafe</b> Recovery <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="This will disable failsafe recovery menu from being created on this website."></i>
                                    </p>
                                </div>

                                <!-- Enable/Disable review widget css,js -->
                                <div class="slider-container">
                                    <input type="hidden" name="xag_review_widget_status" id="xag_review_widget_status"
                                           value="<?= (XAG_ENABLED_DISABLE_REVIEW_WIDGET_STATUS == TRUE) ? 1 : 0; ?>"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button <?= (XAG_ENABLED_DISABLE_REVIEW_WIDGET_STATUS == TRUE) ? 'on' : ''; ?>"
                                              data-element="xag_review_widget_status"><?= (XAG_ENABLED_DISABLE_REVIEW_WIDGET_STATUS == TRUE) ? 'Yes' : 'No'; ?></span>
                                    </div>
                                    <p class="slider-label">Disable <b>CSS, JS</b> for Review Widget <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="This will enabled/disable review widget css, js file on this website."></i>
                                    </p>
                                </div>

                                <!-- Disable Canonicals -->
                                <div class="slider-container">
                                    <input type="hidden" name="xag_disable_canonicals" id="xag_disable_canonicals"
                                           value="<?= (XAG_DISABLE_CANONICALS == TRUE) ? 1 : 0; ?>"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button <?= (XAG_DISABLE_CANONICALS == TRUE) ? 'on' : ''; ?>"
                                              data-element="xag_disable_canonicals"><?= (XAG_DISABLE_CANONICALS == TRUE) ? 'Yes' : 'No'; ?></span>
                                    </div>
                                    <p class="slider-label">Disable WordPress <b>Canonical URLs</b> <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="Use this option if you want to prevent default Canonical URLs that WordPress generates. Instead, PSv3 will generate Canonical URLs for your pages automatically."></i>
                                    </p>
                                </div>

                                <!-- Enable/Disable default OG setting -->
                                <div class="slider-container">
                                    <input type="hidden" name="xag_default_og_status" id="xag_default_og_status"
                                           value="<?= (XAG_DEFAULT_OG_STATUS == TRUE) ? 1 : 0; ?>"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button <?= (XAG_DEFAULT_OG_STATUS == TRUE) ? 'on' : ''; ?>"
                                              data-element="xag_default_og_status"><?= (XAG_DEFAULT_OG_STATUS == TRUE) ? 'Yes' : 'No'; ?></span>
                                    </div>
                                    <p class="slider-label">Disable <b>Default OG Settings</b> <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="This will enabled/disable default OG settings for all page/post."></i>
                                    </p>
                                </div>

                                <!-- Enable/Disable DEV mode -->
                                <div class="slider-container">
                                    <input type="hidden" name="xag_dev_mode" id="xag_dev_mode"
                                           value="<?= (XAG_DEV_MODE == TRUE) ? 1 : 0; ?>"/>
                                    <div class="prs-slider-frame">
                                        <span class="slider-button <?= (XAG_DEV_MODE == TRUE) ? 'on' : ''; ?>"
                                              data-element="xag_dev_mode"><?= (XAG_DEV_MODE == TRUE) ? 'Yes' : 'No'; ?></span>
                                    </div>
                                    <p class="slider-label">Activate <b>DEV Mode</b> <i
                                                class="fa fa-info-circle help-icon" data-uk-tooltip
                                                title="Turns on DEV mode and unlocks features useful only to developers."></i>
                                    </p>
                                </div>

                                <button type="submit"
                                        class="uk-button uk-button-primary uk-button-big btn-save-changes">
                                    <i class="fa fa-save"></i> Save Changes
                                </button>

                            </form>

                        </div>
                    </div>
                    <div class="uk-width-6-10">
                        <div class="uk-panel uk-block-xagio">
                            <h3 class="uk-panel-title"><i class="fa fa-bolt"></i> Actions</h3>

                            <!-- Refresh API keys -->
                            <button type="button" class="uk-button uk-button-primary action-button"
                                    data-target="xag_settings_update_api_keys"><i class="fa fa-key"></i> Update <b>API</b> Keys
                            </button>
                            <p class="action-button-info">
                                <i class="fa fa-info-circle"></i> API keys are being synchronized once a day. If you
                                changed your API key and want to use it inside of plugin instantly, you need to perform
                                this operation.
                            </p>

                            <!-- Refresh Backup settings -->
                            <button type="button" class="uk-button uk-button-primary action-button"
                                    data-target="xag_settings_update_backup_settings"><i class="fa fa-gears"></i> Update <b>Backup</b> settings
                            </button>
                            <p class="action-button-info">
                                <i class="fa fa-info-circle"></i> Backup settings are being synchronized once a day.
                                This is forcing them to update instantly.
                            </p>

                            <!-- Refresh Shared Scripts -->
                            <button type="button" class="uk-button uk-button-primary action-button"
                                    data-target="xag_settings_update_shared_scripts"><i class="fa fa-key"></i> Update <b>Shared</b> Scripts
                            </button>
                            <p class="action-button-info">
                                <i class="fa fa-info-circle"></i> Shared Scripts are being synchronized once a day. If you
                                changed your Shared Scripts and want to use it inside of plugin instantly, you need to perform
                                this operation.
                            </p>


                            <!-- Redownload Clickbank -->
                            <button type="button" class="uk-button uk-button-primary action-button"
                                    data-target="xag_settings_download_clickbank_data"><i class="fa fa-download"></i> Download <b>Clickbank</b> Data
                            </button>
                            <p class="action-button-info">
                                <i class="fa fa-info-circle"></i> If you can't see Clickbank data in Affiliate Products,
                                use this operation to download the latest data from Clickbank.
                            </p>

                            <!-- Create a Backup -->
                            <button type="button" class="uk-button uk-button-primary action-button" data-target="xag_settings_create_backup"><i class="fa fa-database"></i> Create a new <b>Backup</b></button>
                            <p class="action-button-info">
                                <i class="fa fa-info-circle"></i> Create instantly a fresh backup and store it on the preferred storage method for this website.
                            </p>

                            <!-- Export / Import SEO settings -->
                            <button type="button" class="uk-button uk-button-primary export_to_file"
                                    data-target="xag_export_options"><i class="fa fa-file-text"></i> Export <b>Options</b></button>

                            <form action="admin-post.php" id="import_options" method="post" enctype="multipart/form-data" style="display: inline;">
                                <input type="hidden" name="action" value="xag_import_options"/>
                                <label for="import_options_file" type="button" class="uk-button uk-button-primary import_to_file"
                                       data-target="xag_import_options"><i class="fa fa-cubes"></i> Import <b>Options</b></label>
                                <input id="import_options_file" name="import_options_file" type="file" accept=".psexp" style="display: none;"/>
                            </form>
                            <p class="action-button-info">
                                <i class="fa fa-info-circle"></i> Export and Import all configuration of SEO Settings and On Page SEO for each post/page
                            </p>

                        </div>
                    </div>
                </div>

            </div>

		<?php } ?>

        <!-- Troubleshooting -->
        <div>
            <form class="ts">
                <input type="hidden" name="action" value="xag_troubleshooting"/>

                <div class="uk-grid">
                    <div class="uk-width-1-2">

                        <div class="uk-panel uk-block-xagio">
                            <h3 class="uk-panel-title"><i class="fa fa-database"></i> Database Fixes</h3>

                            <!-- Database Tweaks -->
                            <div class="slider-container">
                                <input type="hidden" name="ts_update_tables" id="ts_update_tables" value="0"/>
                                <div class="prs-slider-frame">
                                    <span class="slider-button" data-element="ts_update_tables">No</span>
                                </div>
                                <p class="slider-label">Update <b>Table</b> Structure <i
                                            class="fa fa-info-circle help-icon" data-uk-tooltip
                                            title="This will regenerate your table structure while keeping the data intact."></i>
                                </p>
                            </div>

                            <div class="slider-container">
                                <input type="hidden" name="ts_fix_queued_keywords" id="ts_fix_queued_keywords" value="0"/>
                                <div class="prs-slider-frame">
                                    <span class="slider-button" data-element="ts_fix_queued_keywords">No</span>
                                </div>
                                <p class="slider-label">Fix Keywords <b>Stuck in Queue</b> <i
                                            class="fa fa-info-circle help-icon" data-uk-tooltip
                                            title="This reset the status of the queued keywords, allowing you to again submit them to analysis."></i>
                                </p>
                            </div>

                        </div>
                    </div>
                    <div class="uk-width-1-2">
                        <div class="uk-panel uk-block-xagio">
                            <h3 class="uk-panel-title"><i class="fa fa-code"></i> Server Fixes</h3>


                        <!-- Set Unlimited Memory -->
                        <div class="slider-container">
                            <input type="hidden" name="ts_memory_limit" id="ts_memory_limit"
                                   value="<?= (get_option('prs_ts_memory_limit') == TRUE) ? 1 : 0; ?>"/>
                            <div class="prs-slider-frame">
                                <span class="slider-button <?= (get_option('prs_ts_memory_limit') == TRUE) ? 'on' : ''; ?>"
                                      data-element="ts_memory_limit"><?= (get_option('prs_ts_memory_limit') == TRUE) ? 'Yes' : 'No'; ?></span>
                            </div>
                            <p class="slider-label">Set <b>Unlimited</b> Memory Limit <i
                                        class="fa fa-info-circle help-icon" data-uk-tooltip
                                        title="Sometimes the servers are configured to use the minimal amount of memory needed for WordPress to run. However, PSv3 would need a bit more if you have a huge website with a lot of pages and posts."></i>
                            </p>
                        </div>

                        <!-- Use Alternative API -->
                        <div class="slider-container">
                            <input type="hidden" name="ts_alternative_api" id="ts_alternative_api"
                                   value="<?= (get_option('prs_ts_alternative_api') == TRUE) ? 1 : 0; ?>"/>
                            <div class="prs-slider-frame">
                                <span class="slider-button <?= (get_option('prs_ts_alternative_api') == TRUE) ? 'on' : ''; ?>"
                                      data-element="ts_alternative_api"><?= (get_option('prs_ts_alternative_api') == TRUE) ? 'Yes' : 'No'; ?></span>
                            </div>
                            <p class="slider-label">Use <b>Alternative</b> API Endpoint <i
                                        class="fa fa-info-circle help-icon" data-uk-tooltip
                                        title="In case when you get 'Panel Communication' problems, set this setting to Yes. It will drop a new PHP file onto the root of your WordPress installation and use it as an alternative API endpoint for V3 when the normal /wp-admin/admin-post.php isn't working properly."></i>
                            </p>
                        </div>

                            <button type="button" class="uk-button uk-button-primary action-button"
                                    data-target="xag_settings_update_server_api"><i class="fa fa-key"></i> Update <b>Server API</b> Key
                            </button>
                            <p class="action-button-info">
                                <i class="fa fa-info-circle"></i> Server API key is required to secure connection between your plugin and main application. If our
                                main application showing that your plugin is deactivated and it's not, please use this option.
                            </p>

                        </div>
                    </div>
                </div>

                <button type="submit" class="uk-button uk-button-primary uk-button-big btn-save-changes">
                    <i class="fa fa-save"></i> Save Changes
                </button>

            </form>

        </div>

        <!-- System Status -->
        <div>
            <table class="uk-table system-status-table uk-block-xagio">
                <thead>
                <tr>
                    <th colspan="2">Xagio V3 – Variables</th>
                </tr>
                </thead>
                <tbody>
                <tr>
                    <td>Current Version</td>
                    <td><?= XAG_CURRENT_VERSION; ?></td>
                </tr>
                <tr>
                    <td>Panel URL</td>
                    <td><?= XAG_PANEL_URL; ?></td>
                </tr>
                <tr>
                    <td>Plugin Path</td>
                    <td><?= XAG_PATH; ?></td>
                </tr>
                <tr>
                    <td>Plugin URL Path</td>
                    <td><?= XAG_URL; ?></td>
                </tr>
                <tr>
                    <td>Features</td>
					<?php
                    if (!empty($ps_features)) {
                        $ps_features = '<kbd>' . join('</kbd>, <kbd>', $ps_features) . '</kbd>';
                    } else {
                        $ps_features = '<kbd>NULL</kbd>';
                    }
					?>
                    <td><?= $ps_features; ?></td>
                </tr>
                </tbody>
            </table>

            <table class="uk-table system-status-table uk-block-xagio">
                <thead>
                <tr>
                    <th colspan="2">WordPress Environment</th>
                </tr>
                </thead>
                <tbody>
                <tr>
                    <td>Home URL:</td>
                    <td><?= get_home_url(); ?></td>
                </tr>
                <tr>
                    <td>Site URL:</td>
                    <td><?= get_site_url(); ?></td>
                </tr>
                <tr>
                    <td>WP Version:</td>
                    <td><?= get_bloginfo('version'); ?></td>
                </tr>
                <tr>
                    <td>WP Multisite:</td>
                    <td><?= (is_multisite()) ? '<i class="fa fa-check uk-text-danger"></i>' : '-' ?></td>
                </tr>
                <tr>
                    <td>WP Memory Limit:</td>
                    <td><?= WP_MEMORY_LIMIT; ?></td>
                </tr>
                <tr>
                    <td>WP Debug Mode:</td>
                    <td><?= (defined('WP_DEBUG') && TRUE === WP_DEBUG) ? '<i class="fa fa-check"><i>' : '<i class="fa fa-close"><i>' ?></td>
                </tr>
                <tr>
                    <td>Language:</td>
                    <td><?= get_bloginfo('language'); ?></td>
                </tr>
                </tbody>
            </table>

            <form class="ts">
				<?php
				if (file_exists($ht_access_file)) {
					if (!is_writable($ht_access_file)) {
						echo '<p><em>';
						printf(
						/* translators: %s expands to ".htaccess". */
							esc_html__('If your %s were writable, you could change server environment from here.', 'xagio-settings'),
							'.htaccess'
						);
						echo '</em></p>';
					}
				}
				?>
                <table class="uk-table system-status-table uk-block-xagio">
                    <thead>
                    <tr>
                        <th colspan="2">Server Environment</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td>Server Info:</td>
                        <td><?= $_SERVER['SERVER_SOFTWARE']; ?></td>
                    </tr>
                    <tr>
                        <td>PHP Version:</td>
                        <td><?= phpversion(); ?></td>
                    </tr>
                    <tr>
                        <td>PHP Post Max Size:</td>
                        <td>
                            <select id="postSize" data-target="xag_settings_update_post_max_size" name="postSize">
                                <option <?php if (ini_get('post_max_size') == '200M') {
									echo 'selected';
								} ?> value="200M">200M
                                </option>
                                <option <?php if (ini_get('post_max_size') == '400M') {
									echo 'selected';
								} ?> value="400M">400M
                                </option>
                                <option <?php if (ini_get('post_max_size') == '600M') {
									echo 'selected';
								} ?> value="600M">600M
                                </option>
                                <option <?php if (ini_get('post_max_size') == '800M') {
									echo 'selected';
								} ?> value="800M">800M
                                </option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>PHP Max Upload Size:</td>
                        <td>
                            <select id="uploadSize" data-target="xag_settings_update_max_upload_size" name="uploadSize">
                                <option <?php if (ini_get('upload_max_filesize') == '200M') {
									echo 'selected';
								} ?> value="200M">200M
                                </option>
                                <option <?php if (ini_get('upload_max_filesize') == '400M') {
									echo 'selected';
								} ?> value="400M">400M
                                </option>
                                <option <?php if (ini_get('upload_max_filesize') == '600M') {
									echo 'selected';
								} ?> value="600M">600M
                                </option>
                                <option <?php if (ini_get('upload_max_filesize') == '800M') {
									echo 'selected';
								} ?> value="800M">800M
                                </option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>PHP Time Limit:</td>
                        <td>
                            <select id="executionTime" data-target="xag_settings_update_max_execution_time" name="executionTime">
                                <option <?php if (ini_get('max_execution_time') == '600') {
									echo 'selected';
								} ?> value="600">600
                                </option>
                                <option <?php if (ini_get('max_execution_time') == '800') {
									echo 'selected';
								} ?> value="800">800
                                </option>
                                <option <?php if (ini_get('max_execution_time') == '1000') {
									echo 'selected';
								} ?> value="1000">1000
                                </option>
                                <option <?php if (ini_get('max_execution_time') == '1200') {
									echo 'selected';
								} ?> value="1200">1200
                                </option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>PHP Max Input Vars:</td>
                        <td>
                            <select id="inputVars" data-target="xag_settings_update_max_input_vars" name="inputVars">
                                <option <?php if (ini_get('max_input_vars') == '1000') {
									echo 'selected';
								} ?> value="1000">1000
                                </option>
                                <option <?php if (ini_get('max_input_vars') == '1500') {
									echo 'selected';
								} ?> value="1500">1500
                                </option>
                                <option <?php if (ini_get('max_input_vars') == '2000') {
									echo 'selected';
								} ?> value="2000">2000
                                </option>
                                <option <?php if (ini_get('max_input_vars') == '2500') {
									echo 'selected';
								} ?> value="2500">2500
                                </option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>PHP Memory Limit:</td>
                        <td>
                            <select id="memoryLimit" data-target="xag_settings_update_max_memory_limit" name="memoryLimit">
                                <option <?php if (ini_get('memory_limit') == '256M') {
									echo 'selected';
								} ?> value="256M">256M
                                </option>
                                <option <?php if (ini_get('memory_limit') == '480M') {
									echo 'selected';
								} ?> value="480M">480M
                                </option>
                                <option <?php if (ini_get('memory_limit') == '1024M') {
									echo 'selected';
								} ?> value="1024M">1024M
                                </option>
                                <option <?php if (ini_get('memory_limit') == '2048M') {
									echo 'selected';
								} ?> value="2048M">2048M
                                </option>
                                <option <?php if (ini_get('memory_limit') == '-1') {
									echo 'selected';
								} ?> value="-1">Unlimited
                                </option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>OpenSSL:</td>
                        <td><?php
							if (defined('OPENSSL_VERSION_NUMBER')) {

								if (OPENSSL_VERSION_NUMBER >= 268439647) {
									?><i class="fa fa-check uk-text-success"></i><?php
								} else {
									?><i title="OpenSSL version must be at least 1.0.1e."
                                         class="fa fa-close uk-text-danger"></i><?php
								}

							} else {
								?><i title="OpenSSL is not installed." class="fa fa-close uk-text-danger"></i><?php
							}
							?></td>
                    </tr>
                    <tr>
                        <td>cURL:</td>
                        <td><?= (function_exists('curl_init')) ? '<i class="fa fa-check uk-text-success"></i>' : '<i class="fa fa-close uk-text-danger"></i>'; ?></td>
                    </tr>
                    <tr>
                        <td>ZipArchive:</td>
                        <td><?= (class_exists('ZipArchive')) ? '<i class="fa fa-check uk-text-success"></i>' : '<i class="fa fa-close uk-text-danger"></i>'; ?></td>
                    </tr>
                    <tr>
                        <td>DOMDocument:</td>
                        <td><?= (class_exists('DOMDocument')) ? '<i class="fa fa-check uk-text-success"></i>' : '<i class="fa fa-close uk-text-danger"></i>'; ?></td>
                    </tr>
                    <tr>
                        <td>WP Remote Get:</td>
                        <td><?= (function_exists('wp_remote_get')) ? '<i class="fa fa-check uk-text-success"></i>' : '<i class="fa fa-close uk-text-danger"></i>'; ?></td>
                    </tr>
                    <tr>
                        <td>WP Remote Post:</td>
                        <td><?= (function_exists('wp_remote_post')) ? '<i class="fa fa-check uk-text-success"></i>' : '<i class="fa fa-close uk-text-danger"></i>'; ?></td>
                    </tr>
                    </tbody>
                </table>
            </form>
        </div>
    </div>

    <!-- Changelog -->
    <div id="changelog" class="uk-modal">
        <div class="uk-modal-dialog">
            <button type="button" class="uk-modal-close uk-close"></button>
            <div class="uk-modal-header">
                <h2><i class="fa fa-info-circle"></i> Lastest Updates</h2>
            </div>

            <p>Version: <b><?php echo XAG_CURRENT_VERSION; ?></b>, what is new?</p>

            <pre class="changelog"><?php echo file_get_contents(XAG_PATH . '/changelog.txt'); ?></pre>

            <p>Due to nature of updates and constant changes of different files in our plugins, we <b
                        style="color:red">strongly advise</b> you to clear your browser cache (and WordPress cache
                if you are using any caching plugins) when you're done with installing new plugin updates.
                If you aren't tech savvy, please follow one of the links according to your browser type in order
                to get instructions on how to clear your browser cache:
                <br>[ <a href="https://support.google.com/chrome/answer/95582?hl=en" target="_blank">Google
                    Chrome</a> |
                <a href="https://support.mozilla.org/en-US/kb/how-clear-firefox-cache" target="_blank">Mozilla
                    Firefox</a> |
                <a href="https://kb.wisc.edu/page.php?id=45060" target="_blank">Safari</a> |
                <a href="https://kb.wisc.edu/helpdesk/page.php?id=12381" target="_blank">Opera</a> |
                <a href="https://kb.wisc.edu/page.php?id=15141" target="_blank">Internet Explorer</a> ]

            </p>

            <div class="uk-modal-footer uk-text-right">
                <button type="button" class="uk-button uk-modal-close">Close</button>
            </div>
        </div>
    </div>

    <!-- Tutorials -->
    <div id="tutorials" class="uk-modal">
        <div class="uk-modal-dialog uk-modal-dialog-large">
            <button type="button" class="uk-modal-close uk-close"></button>
            <div class="uk-modal-header">
                <h2><i class="fa fa-info-circle"></i> Tutorials</h2>
            </div>
            <div class="uk-modal-body">

            </div>
            <div class="uk-modal-footer uk-text-right">
                <button type="button" class="uk-button uk-modal-close">Close</button>
            </div>
        </div>
    </div>

    <div class="tut_holder hide">
        <h2 style="margin-top: 20px"></h2>
        <iframe width="100%" height="480" frameborder="0" allowfullscreen="allowfullscreen" mozallowfullscreen="mozallowfullscreen" msallowfullscreen="msallowfullscreen" oallowfullscreen="oallowfullscreen" webkitallowfullscreen="webkitallowfullscreen"
                src="">
        </iframe>
    </div>
    <!-- Tutorials -->

</div> <!-- .wrap -->

<?php if ($display_intro_video) { ?>
    <script type="application/javascript">
        var lightbox = UIkit.lightbox.create([
            {'source': 'https://www.youtube.com/watch?v=LrGSqfF-fMo?autoplay=1', 'type': 'video'}
        ]);
        lightbox.show();
    </script>
<?php } ?>
