<!-- HTML STARTS HERE -->
<div class="wrap prs">

    <h2 class="logo-title">
        <span class="logo-title-center">
             <img class="logo-image" src="<?= XAG_URL; ?>assets/img/logo-xagio.png"/>
        Xagio - SILO Builder
        -
        <small class="hand">Create a visual structure of your website...</small>

        <button type="button" class="uk-button uk-button-success uk-button-show-tutorial"
                data-page="<?php
                echo (isset($_GET['page']) && !empty($_GET['page'])) ? $_GET['page'] : ''; ?>"><i
                    class="fa fa-film"></i> Tutorials
        </button>
        </span>
    </h2>

    <!-- Projects Silo -->
    <div class="project-silo">

        <button data-uk-tooltip="{pos:'bottom'}"
                title="You can press Control (CTRL) + S keys to save changes instead of clicking here." type="button"
                class="uk-button uk-button-success uk-float-right silo-save uk-margin-small-left"><i
                    class="fa fa-save"></i> Save Pages
        </button>

        <button data-uk-tooltip="{pos:'bottom'}"
                title="You can press DELETE on your keyboard to remove operators/links instead of clicking here."
                type="button" class="uk-button uk-button-danger uk-float-right silo-remove"><i
                    class="fa fa-trash-o"></i> Delete
        </button>

        <div class="button-separator">–</div>

        <div class="uk-button-group uk-float-right uk-margin-small-left">
            <a data-uk-tooltip="{pos:'bottom', delay:'800'}" title="Create a new Page/Post"
               class="uk-button uk-button-default silo-add-page-post"
               href="#silo-add-page-post" uk-toggle><i class="fa fa-file"></i> New</a>
            <button class="uk-button uk-button-warning uk-button-reset-all uk-margin-small-left"
                    data-uk-tooltip="{pos:'bottom', delay:'800'}"
                    title="Perform a HARD reset and clear out all the operators from your Pages and Posts SILOs. This operation is irreversible, proceed with caution.">
                <i class="fa fa-exclamation-triangle"></i> HARD Reset</a></button>
        </div>

        <!-- This is the tabbed navigation containing the toggling elements -->
        <ul class="uk-tab uk-tab-big main-nav" data-uk-tab="{connect:'#silo-tabs'}">
            <li><a href="#" class="silo-pages-tab"><i class="fa fa-file-powerpoint-o"></i> Pages</a></li>
            <li><a href="#" class="silo-posts-tab"><i class="fa fa-file-text-o"></i> Posts</a></li>
            <li><a href="#" class="silo-links-tab"><i class="fa fa-link"></i> Links</a></li>
        </ul>

        <!-- This is the container of the content items -->
        <div id="silo-tabs" class="uk-switcher uk-margin">
            <div class="tab">
                <div class="uk-grid uk-grid-collapse">
                    <div class="uk-width-1-5">
                        <div class="settings uk-accordion" data-uk-accordion="{showfirst:false}">
                            <h3 class="uk-accordion-title"><i class="fa fa-gears"></i> Canvas Settings <i
                                        class="fa fa-angle-down uk-float-right"></i></h3>
                            <div class="uk-accordion-content">
                                <form class="uk-form silo-settings-save">

                                    <div class="uk-margin-bottom">
                                        <label class="uk-form-label" for="pages_line_width">Line Thickness:</label>
                                        <div class="uk-form-controls">
                                            <input type="range" name="line_thickness" id="pages_line_width"
                                                   class="uk-width-1-1" min="1" max="20" value="2"/>
                                        </div>
                                    </div>

                                    <div class="uk-margin-bottom">
                                        <label class="uk-form-label" for="pages_line_type">Line Type:</label>
                                        <div class="uk-form-controls">
                                            <select name="line_type" id="pages_line_type" class="uk-width-1-1">
                                                <option value="">–– Select ––</option>
                                                <option value="0">Solid</option>
                                                <option value="15" selected="selected">Dashed</option>
                                                <option value="3">Dotted</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="uk-margin-bottom">
                                        <label class="uk-form-label" for="pages_line_color">Line Color:</label>
                                        <div class="uk-form-controls">
                                            <input type="color" name="line_color" id="pages_line_color"
                                                   value="#559acc"/>
                                        </div>
                                    </div>

                                    <div class="uk-margin-bottom">
                                        <label class="uk-form-label" for="pages_canvas_size">Canvas Size:</label>
                                        <div class="uk-form-controls">
                                            <input type="range" name="canvas_size" id="pages_canvas_size"
                                                   class="uk-width-1-1" step="1000" min="5000" max="20000"/>
                                        </div>
                                    </div>

                                </form>
                            </div>
                        </div>
                        <div class="generate-silo-container">
                            <button type="button" class="uk-button uk-button-primary uk-button-large uk-button-generate-silo"><i
                                        class="fa fa-magic"></i> Generate SILO from Website
                            </button>
                        </div>
                        <div class="silo-pages">
                            <div class="silo-page">

                                <table class="wp-list-table widefat fixed striped siloPagesTable" cellspacing="0"
                                       width="100%">
                                    <thead>
                                    <tr>
                                        <th><i class="fa fa-gear"></i></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td class="uk-text-center"><i class="fa fa-spin fa-refresh"></i>
                                            Loading
                                        </td>
                                    </tr>
                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <th><i class="fa fa-gear"></i></th>
                                    </tr>
                                    </tfoot>
                                </table>

                            </div>
                        </div>
                    </div>
                    <div class="uk-width-4-5">
                        <div class="silo-area">
                            <div class="silo-tabs" data-type="pages">
                                <ul class="uk-tab uk-tab-big">
                                    <li data-uk-tooltip title="Add a new SILO."><a href="#" class="new-silo"><i
                                                    class="fa fa-plus"></i></a></li>
                                </ul>
                            </div>
                            <div class="silo-container">
                                <div class="navigation-controls">
                                    <div class="navigation-arrow" data-type="up" uk-tooltip="{pos:'right', delay: 1000}"
                                         title="You can use arrow key UP to move canvas in this direction"><i
                                                class="fa fa-arrow-up"></i></div>
                                    <div class="navigation-arrow" data-type="down"
                                         uk-tooltip="{pos:'right', delay: 1000}"
                                         title="You can use arrow key DOWN to move canvas in this direction"><i
                                                class="fa fa-arrow-down"></i></div>
                                    <div class="navigation-arrow" data-type="left"
                                         uk-tooltip="{pos:'right', delay: 1000}"
                                         title="You can use arrow key LEFT to move canvas in this direction"><i
                                                class="fa fa-arrow-left"></i></div>
                                    <div class="navigation-arrow" data-type="right"
                                         uk-tooltip="{pos:'right', delay: 1000}"
                                         title="You can use arrow key RIGHT to move canvas in this direction"><i
                                                class="fa fa-arrow-right"></i></div>
                                </div>
                                <div class="silo pages"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab">
                <div class="uk-grid uk-grid-collapse">
                    <div class="uk-width-1-5 border-right-silo">
                        <div class="settings uk-accordion" data-uk-accordion="{showfirst:false}">
                            <h3 class="uk-accordion-title"><i class="fa fa-gears"></i> Canvas Settings <i
                                        class="fa fa-angle-down uk-float-right"></i></h3>
                            <div class="uk-accordion-content">
                                <form class="uk-form silo-settings-save">

                                    <h2 class="uk-h3 uk-text-bold">Categories</h2>

                                    <div class="uk-margin-bottom">
                                        <label class="uk-form-label" for="posts_line_width1">Line Thickness:</label>
                                        <div class="uk-form-controls">
                                            <input type="range" name="line_category_thickness" id="posts_line_width1"
                                                   class="uk-width-1-1" min="1" max="20" value="2"/>
                                        </div>
                                    </div>

                                    <div class="uk-margin-bottom">
                                        <label class="uk-form-label" for="posts_line_type1">Line Type:</label>
                                        <div class="uk-form-controls">
                                            <select name="line_category_type" id="posts_line_type1"
                                                    class="uk-width-1-1">
                                                <option value="">–– Select ––</option>
                                                <option value="0">Solid</option>
                                                <option value="15" selected="selected">Dashed</option>
                                                <option value="3">Dotted</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="uk-grid">
                                        <div class="uk-margin-bottom uk-width-large-1-2">
                                            <label class="uk-form-label" for="posts_line_color1">Line Color:</label>
                                            <div class="uk-form-controls">
                                                <input type="color" name="line_category_color" id="posts_line_color1"
                                                       value="#729d9a"/>
                                            </div>
                                        </div>

                                        <div class="uk-margin-bottom uk-width-large-1-2">
                                            <label class="uk-form-label" for="posts_box_color1">Box Color:</label>
                                            <div class="uk-form-controls">
                                                <input type="color" value="#d1fffc" name="box_category_color"
                                                       id="posts_box_color1"/>
                                            </div>
                                        </div>
                                    </div>

                                    <hr>

                                    <h2 class="uk-h3 uk-text-bold">Tags</h2>

                                    <div class="uk-margin-bottom">
                                        <label class="uk-form-label" for="posts_line_width2">Line Thickness:</label>
                                        <div class="uk-form-controls">
                                            <input type="range" name="line_tag_thickness" id="posts_line_width2"
                                                   class="uk-width-1-1" min="1" max="20" value="2"/>
                                        </div>
                                    </div>

                                    <div class="uk-margin-bottom">
                                        <label class="uk-form-label" for="posts_line_type2">Line Type:</label>
                                        <div class="uk-form-controls">
                                            <select name="line_tag_type" id="posts_line_type2" class="uk-width-1-1">
                                                <option value="">–– Select ––</option>
                                                <option value="0">Solid</option>
                                                <option value="15" selected="selected">Dashed</option>
                                                <option value="3">Dotted</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="uk-grid">

                                        <div class="uk-margin-bottom uk-width-large-1-2">
                                            <label class="uk-form-label" for="posts_line_color2">Line Color:</label>
                                            <div class="uk-form-controls">
                                                <input type="color" name="line_tag_color" id="posts_line_color2"
                                                       value="#989898"/>
                                            </div>
                                        </div>

                                        <div class="uk-margin-bottom uk-width-large-1-2">
                                            <label class="uk-form-label" for="posts_box_color2">Box Color:</label>
                                            <div class="uk-form-controls">
                                                <input type="color" value="#dbdbdb" name="box_tag_color"
                                                       id="posts_box_color2"/>
                                            </div>
                                        </div>

                                    </div>

                                    <hr>

                                    <div class="uk-margin-bottom">
                                        <label class="uk-form-label" for="posts_canvas_size">Canvas Size:</label>
                                        <div class="uk-form-controls">
                                            <input type="range" name="canvas_size" id="posts_canvas_size"
                                                   class="uk-width-1-1" step="1000" min="5000" max="20000"/>
                                        </div>
                                    </div>

                                </form>
                            </div>
                        </div>

                        <div class="generate-silo-container">
                            <button type="button" class="uk-button uk-button-primary uk-button-large uk-button-generate-silo"><i
                                        class="fa fa-magic"></i> Generate SILO from Website
                            </button>
                        </div>

                        <div class="settings uk-accordion" data-uk-accordion="{showfirst:false}">
                            <h3 class="uk-accordion-title"><i class="fa fa-link"></i> Permalink Settings <i
                                        class="fa fa-angle-down uk-float-right"></i></h3>
                            <div class="uk-accordion-content">
                                <form class="uk-form silo-permalinks-save" method="post">

                                    <?php
                                    wp_nonce_field('update-permalink'); ?>

                                    <ul class="uk-tab" data-uk-tab="{connect:'#permalink-tabs'}">
                                        <li class="uk-active"><a href="#"><p>Common Settings</p></a></li>
                                        <li><a href="#"><p>Optional</p></a></li>
                                    </ul>

                                    <div id="permalink-tabs" class="uk-switcher uk-margin">
                                        <div>
                                            <div>
                                                <label><input name="selection" class="permalink-radio" type="radio"
                                                              value=""> Plain</label>
                                                <code class="permalink-code uk-text-primary"><?= site_url() ?>
                                                    /?p=123</code>
                                            </div>
                                            <div>
                                                <label><input name="selection" class="permalink-radio" type="radio"
                                                              value="/%year%/%monthnum%/%day%/%postname%/"> Day and name</label>
                                                <code class="permalink-code uk-text-primary"><?= site_url() ?>
                                                    /2020/10/15/sample-post/</code>
                                            </div>
                                            <div>
                                                <label><input name="selection" class="permalink-radio" type="radio"
                                                              value="/%year%/%monthnum%/%postname%/"> Month and
                                                    name</label>
                                                <code class="permalink-code uk-text-primary"><?= site_url() ?>
                                                    /2020/10/sample-post/</code>
                                            </div>
                                            <div>
                                                <label><input name="selection" class="permalink-radio" type="radio"
                                                              value="/archives/%post_id%"> Numeric</label>
                                                <code class="permalink-code uk-text-primary"><?= site_url() ?>
                                                    /archives/123</code>
                                            </div>
                                            <div>
                                                <label><input name="selection" class="permalink-radio" type="radio"
                                                              value="/%postname%/" checked> Post name</label>
                                                <code class="permalink-code uk-text-primary"><?= site_url() ?>
                                                    /sample-post/</code>
                                            </div>
                                            <div>
                                                <label><input name="selection" id="custom_selection" type="radio"
                                                              value="custom">
                                                    Custom Structure </label>

                                                <code class="permalink-code uk-text-primary"><?= site_url() ?></code>
                                            </div>
                                            <div>
                                                <div>
                                                    <input name="permalink_structure" id="permalink_structure"
                                                           type="text" value="/%postname%/"
                                                           class="regular-text code silo-permalink-input uk-margin-small-top uk-margin-bottom">
                                                    <!-- Permalink Tags -->
                                                    <div class="available-structure-tags hide-if-no-js">
                                                        <div id="custom_selection_updated" aria-live="assertive"
                                                             class="screen-reader-text"></div>
                                                        <a href="#" class="uk-button permalink-tags" type="button"
                                                           data-uk-toggle="{target:'#permalink-tags'}"><i
                                                                    class="fa fa-tags"></i> Available tags</a>

                                                        <div id="permalink-tags" class="uk-hidden uk-margin-top">
                                                            <div>
                                                                <div>
                                                                    <button type="button"
                                                                            class="button button-secondary permalink-button"
                                                                            aria-label="year (The year of the post, four digits, for example 2004.)"
                                                                            data-added="year added to permalink structure"
                                                                            data-used="year (already used in permalink structure)">
                                                                        %year%
                                                                    </button>

                                                                    <button type="button"
                                                                            class="button button-secondary permalink-button"
                                                                            aria-label="monthnum (Month of the year, for example 05.)"
                                                                            data-added="monthnum added to permalink structure"
                                                                            data-used="monthnum (already used in permalink structure)">
                                                                        %monthnum%
                                                                    </button>
                                                                </div>
                                                                <div>

                                                                    <button type="button"
                                                                            class="button button-secondary permalink-button"
                                                                            aria-label="day (Day of the month, for example 28.)"
                                                                            data-added="day added to permalink structure"
                                                                            data-used="day (already used in permalink structure)">
                                                                        %day%
                                                                    </button>

                                                                    <button type="button"
                                                                            class="button button-secondary permalink-button"
                                                                            aria-label="hour (Hour of the day, for example 15.)"
                                                                            data-added="hour added to permalink structure"
                                                                            data-used="hour (already used in permalink structure)">
                                                                        %hour%
                                                                    </button>

                                                                </div>
                                                                <div>

                                                                    <button type="button"
                                                                            class="button button-secondary permalink-button"
                                                                            aria-label="minute (Minute of the hour, for example 43.)"
                                                                            data-added="minute added to permalink structure"
                                                                            data-used="minute (already used in permalink structure)">
                                                                        %minute%
                                                                    </button>

                                                                    <button type="button"
                                                                            class="button button-secondary permalink-button"
                                                                            aria-label="second (Second of the minute, for example 33.)"
                                                                            data-added="second added to permalink structure"
                                                                            data-used="second (already used in permalink structure)">
                                                                        %second%
                                                                    </button>

                                                                </div>
                                                                <div>
                                                                    <button type="button"
                                                                            class="button button-secondary permalink-button"
                                                                            aria-label="post_id (The unique ID of the post, for example 423.)"
                                                                            data-added="post_id added to permalink structure"
                                                                            data-used="post_id (already used in permalink structure)">
                                                                        %post_id%
                                                                    </button>
                                                                    <button type="button"
                                                                            class="button button-secondary permalink-button"
                                                                            aria-label="postname (already used in permalink structure)"
                                                                            data-added="postname added to permalink structure"
                                                                            data-used="postname (already used in permalink structure)">
                                                                        %postname%
                                                                    </button>
                                                                </div>
                                                                <div>
                                                                    <button type="button"
                                                                            class="button button-secondary permalink-button"
                                                                            aria-label="category (Category slug. Nested sub-categories appear as nested directories in the URL.)"
                                                                            data-added="category added to permalink structure"
                                                                            data-used="category (already used in permalink structure)">
                                                                        %category%
                                                                    </button>
                                                                    <button type="button"
                                                                            class="button button-secondary permalink-button"
                                                                            aria-label="author (A sanitized version of the author name.)"
                                                                            data-added="author added to permalink structure"
                                                                            data-used="author (already used in permalink structure)">
                                                                        %author%
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div>
                                            <div><label for="category_base">Category base:</label></div>
                                            <div><input name="category_base" id="category_base" type="text" value="and"
                                                        class="regular-text code silo-permalink-optional-input"></div>
                                            <div><label for="tag_base">Tag base:</label></div>
                                            <div><input name="tag_base" id="tag_base" type="text" value="also"
                                                        class="regular-text code silo-permalink-optional-input"></div>
                                        </div>
                                    </div>

                                    <p class="submit"><input type="submit" name="submit" id="submit"
                                                             class="button button-primary permalink-save-button"
                                                             value="Save Changes"></p>

                                </form>
                            </div>
                        </div>

                        <div class="silo-pages">

                            <div class="silo-post">

                                <table class="wp-list-table widefat fixed striped siloPostsTable" cellspacing="0"
                                       width="100%">
                                    <thead>
                                    <tr>
                                        <th><i class="fa fa-gear"></i></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td class="uk-text-center"><i class="fa fa-spin fa-refresh"></i>
                                            Loading
                                        </td>
                                    </tr>
                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <th><i class="fa fa-gear"></i></th>
                                    </tr>
                                    </tfoot>
                                </table>

                            </div>

                        </div>
                    </div>
                    <div class="uk-width-4-5">
                        <div class="silo-area">
                            <div class="silo-tabs" data-type="posts">
                                <ul class="uk-tab uk-tab-big">
                                    <li data-uk-tooltip title="Add a new SILO."><a href="#" class="new-silo"><i
                                                    class="fa fa-plus"></i></a></li>
                                </ul>
                            </div>

                            <div class="silo-categories-tags">
                                <div class="silo-categories-tags-add">
                                    <button type="button" class="silo-categories-tags-button add-category"
                                            data-uk-tooltip title="Add a new category."><i class="fa fa-plus"></i>
                                    </button>
                                    <button type="button" class="silo-categories-tags-button add-tags" data-uk-tooltip
                                            title="Add a new tag."><i class="fa fa-plus"></i></button>
                                </div>
                                <div class="silo-categories-tags-actions">
                                    <button type="button" class="silo-categories-tags-button hide-all-categories"
                                            data-uk-tooltip title="Hide all categories."><i
                                                class="fa fa-eye-slash"></i></button>
                                    <button type="button" class="silo-categories-tags-button hide-all-tags"
                                            data-uk-tooltip="{pos:'bottom'}" title="Hide all tags."><i
                                                class="fa fa-eye-slash"></i></button>
                                </div>
                                <div class="silo-categories"></div>
                                <div class="silo-tags"></div>
                            </div>

                            <div class="silo-container">
                                <div class="navigation-controls">
                                    <div class="navigation-arrow" data-type="up"><i class="fa fa-arrow-up"></i></div>
                                    <div class="navigation-arrow" data-type="down"><i class="fa fa-arrow-down"></i>
                                    </div>
                                    <div class="navigation-arrow" data-type="left"><i class="fa fa-arrow-left"></i>
                                    </div>
                                    <div class="navigation-arrow" data-type="right"><i class="fa fa-arrow-right"></i>
                                    </div>
                                </div>
                                <div class="silo posts"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab">
                <div class="uk-grid uk-grid-collapse">
                    <div class="uk-width-1-5 border-right-silo">

                        <div class="settings uk-accordion" data-uk-accordion="{showfirst:false}">
                            <h3 class="uk-accordion-title"><i class="fa fa-gears"></i> Canvas Settings <i
                                        class="fa fa-angle-down uk-float-right"></i></h3>
                            <div class="uk-accordion-content">
                                <form class="uk-form silo-settings-save">

                                    <h2 class="uk-h3 uk-text-bold">Internal</h2>

                                    <div class="uk-margin-bottom">
                                        <label class="uk-form-label" for="internal_links_line_width">Line Thickness:</label>
                                        <div class="uk-form-controls">
                                            <input type="range" name="internal_line_thickness" id="internal_links_line_width" class="uk-width-1-1" min="1" max="20" value="2"/>
                                        </div>
                                    </div>

                                    <div class="uk-margin-bottom">
                                        <label class="uk-form-label" for="internal_links_line_type">Line Type:</label>
                                        <div class="uk-form-controls">
                                            <select name="internal_line_type" id="internal_links_line_type"
                                                    class="uk-width-1-1">
                                                <option value="">–– Select ––</option>
                                                <option value="0">Solid</option>
                                                <option value="15">Dashed</option>
                                                <option value="3">Dotted</option>
                                            </select>
                                        </div>
                                    </div>

                                    <label class="uk-form-label" for="internal_line_color">Line Color:</label>
                                    <div class="uk-form-controls">
                                        <input type="color" name="internal_line_color" id="internal_links_line_color"
                                               value="#559acc"/>
                                    </div>


                                    <h2 class="uk-h3 uk-text-bold">External</h2>

                                    <div class="uk-margin-bottom">
                                        <label class="uk-form-label" for="external_line_thickness">Line
                                            Thickness:</label>
                                        <div class="uk-form-controls">
                                            <input type="range" name="external_line_thickness"
                                                   id="external_links_line_width" class="uk-width-1-1" min="1" max="20"
                                                   value="2"/>
                                        </div>
                                    </div>

                                    <div class="uk-margin-bottom">
                                        <label class="uk-form-label" for="external_links_line_type">Line Type:</label>
                                        <div class="uk-form-controls">
                                            <select name="external_line_type" id="external_links_line_type"
                                                    class="uk-width-1-1">
                                                <option value="">–– Select ––</option>
                                                <option value="0">Solid</option>
                                                <option value="15">Dashed</option>
                                                <option value="3">Dotted</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="uk-grid">
                                        <div class="uk-margin-bottom uk-width-1-2">
                                            <label class="uk-form-label" for="external_links_line_color">Line
                                                Color:</label>
                                            <div class="uk-form-controls">
                                                <input type="color" name="external_line_color"
                                                       id="external_links_line_color" value="#559acc"/>
                                            </div>
                                        </div>
                                        <div class="uk-margin-bottom uk-width-1-2">
                                            <label class="uk-form-label" for="links_external_color">Box
                                                Color:</label>
                                            <div class="uk-form-controls">
                                                <input type="color" name="external_color" id="links_external_color"
                                                       value="#2b2b2b"/>
                                            </div>
                                        </div>
                                    </div>


                                    <div class="uk-margin-bottom">
                                        <label class="uk-form-label" for="links_canvas_size">Canvas Size:</label>
                                        <div class="uk-form-controls">
                                            <input type="range" name="canvas_size" id="links_canvas_size"
                                                   class="uk-width-1-1" step="1000" min="5000" max="20000"/>
                                        </div>
                                    </div>

                                </form>
                            </div>
                        </div>

                        <div class="generate-silo-container">
                            <button type="button" class="uk-button uk-button-primary uk-button-large generate-silo-links"><i
                                        class="fa fa-magic"></i> Generate SILO from Website
                            </button>
                        </div>

                        <div class="silo-pages">
                            <div class="silo-page">

                                <table class="wp-list-table widefat fixed striped siloPagesTableLinks" cellspacing="0"
                                       width="100%">
                                    <thead>
                                    <tr>
                                        <th>Title</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td colspan="1" class="uk-text-center"><i class="fa fa-spin fa-refresh"></i>
                                            Loading
                                        </td>
                                    </tr>
                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <th>Title</th>
                                    </tr>
                                    </tfoot>
                                </table>

                            </div>
                        </div>

                    </div>
                    <div class="uk-width-4-5">
                        <div class="silo-area">
                            <div class="silo-tabs" data-type="links">
                                <ul class="uk-tab uk-tab-big">
                                    <li data-uk-tooltip title="Add a new SILO."><a href="#" class="new-silo"><i
                                                    class="fa fa-plus"></i></a></li>
                                </ul>
                            </div>
                            <div class="silo-container">
                                <div class="silo links"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div> <!-- .wrap -->

    </div>

    <!-- Tutorials -->
    <div id="tutorials" class="uk-modal">
        <div class="uk-modal-dialog uk-modal-dialog-large">
            <button type="button" class="uk-modal-close uk-close"></button>
            <div class="uk-modal-header">
                <h2><i class="fa fa-info-circle"></i> Tutorials</h2>
            </div>
            <div class="uk-modal-body">

            </div>
            <div class="uk-modal-footer uk-text-right">
                <button type="button" class="uk-button uk-modal-close">Close</button>
            </div>
        </div>
    </div>

    <div class="tut_holder hide">
        <h2 style="margin-top: 20px"></h2>
        <iframe width="100%" height="480" frameborder="0" allowfullscreen="allowfullscreen"
                mozallowfullscreen="mozallowfullscreen" msallowfullscreen="msallowfullscreen"
                oallowfullscreen="oallowfullscreen" webkitallowfullscreen="webkitallowfullscreen"
                src="">
        </iframe>
    </div>
    <!-- Tutorials -->

    <div class="silo-context-menu template">

        <div>

            <input type="text" class="operator_h1" placeholder="eg. My Page H1" value="">
            <input type="text" class="operator_title" placeholder="eg. My Page Title" value="">
            <div class="uk-grid uk-grid-collapse">
                <div class="uk-grid-width-auto">
                    <span class="operator_slug_before">...</span>
                </div>
                <div class="uk-grid-width-expand">
                    <input type="text" class="operator_slug" placeholder="eg. mypagetitle" value="">
                </div>
            </div>
            <textarea class="operator_description" placeholder="eg. This page is about..."></textarea>

            <label class="ps-label ps-label-block">Title Length <i class="fa fa-info-circle" data-uk-tooltip="" title="Displays the current number of characters in SEO Title."></i></label>
            <small class="ps-metric">

                <div class="count-seo-container-left">

                    <i class="fa fa-desktop" data-uk-tooltip="" title="Desktop devices limits."></i>
                    <span class="count-seo-bold">
                                    <span class="count-seo-title">0</span> / 70
                                </span>
                    chars.

                </div>

                <div class="count-seo-container-right">

                    <i class="fa fa-mobile" data-uk-tooltip="" title="Mobile devices limits."></i>
                    <span class="count-seo-bold">
                                    <span class="count-seo-title-mobile">0</span> / 78
                                </span>
                    chars.

                </div>

                <div class="clear"></div>

            </small>

            <label class="ps-label ps-label-block">Description Length <i class="fa fa-info-circle" data-uk-tooltip="" title="Displays the current number of characters in SEO Description."></i></label>
            <small class="ps-metric">

                <div class="count-seo-container-left">

                    <i class="fa fa-desktop" data-uk-tooltip="" title="Desktop devices limits."></i>
                    <span class="count-seo-bold">
                                    <span class="count-seo-description">0</span> / 300
                                </span>
                    chars.

                </div>

                <div class="count-seo-container-right">

                    <i class="fa fa-mobile" data-uk-tooltip="" title="Mobile devices limits."></i>
                    <span class="count-seo-bold">
                                    <span class="count-seo-description-mobile">0</span> / 120
                                </span>
                    chars.

                </div>

                <div class="clear"></div>

            </small>

        </div>

        <div class="silo-context-menu-actions uk-margin-small-top">
            <button class="flat-button flat-button-success context-menu-save" type="button"><i class="fa fa-check"></i> Apply</button>
            <button class="flat-button flat-button-danger context-menu-discard uk-float-right" type="button"><i class="fa fa-times"></i> Discard</button>
        </div>
    </div>

    <div id="silo-generate-modal" class="uk-modal">
        <div class="uk-modal-dialog uk-modal-dialog-small">
            <div class="uk-modal-header uk-h4"><i class="fa fa-gears"></i> Generate SILO Settings</div>

            <input type="radio" id="imp_connections" name="radio" class="imp_connections" checked>
            <label for="imp_connections">Import Pages with connections <i data-uk-tooltip title="This will Generate a SILO based only on pages that have parents." class="fa fa-info-circle"></i></label>

            <hr>

            <input type="radio" id="imp_all" name="radio" class="imp_all">
            <label for="imp_all">Import all Pages <i class="fa fa-info-circle" data-uk-tooltip title="This will Generate a SILO based on all pages your have in WordPress."></i></label>

            <div class="uk-modal-footer uk-text-right">
                <button type="button" class="uk-button uk-modal-close">Cancel</button>
                <button type="button" class="uk-button uk-button-primary silo-continue-generate">Continue and Generate SILO</button>
            </div>
        </div>
    </div>

    <div id="silo-add-page-post" class="uk-modal">
        <div class="uk-modal-dialog">
            <div class="uk-modal-header uk-h4">New Page/Post</div>
            <form class="uk-form new-post-page">
                <b>Title:</b>
                <fieldset data-uk-margin>
                    <input type="text" class="post-page-title uk-margin-bottom" placeholder="eg. My First Post">
                </fieldset>
                <fieldset data-uk-margin>
                    <b>Permalink: </b><a href="<?php echo 'https://' . $_SERVER['HTTP_HOST'] . '/'; ?>"><?php echo 'https://' . $_SERVER['HTTP_HOST'] . '/'; ?> </a><input type="text" class="post-page-url" placeholder="">

                    <select class="uk-float-right uk-margin-small-left post-page-type">
                        <option value="page">Page</option>
                        <option value="post">Post</option>
                    </select>
                    <select class="uk-float-right post-page-status">
                        <option value="publish">Publish</option>
                        <option value="draft">Draft</option>
                        <option value="private">Private</option>
                        <option value="schedule">Schedule</option>
                    </select>

                </fieldset>
                <hr class="uk-divider-icon">
                <div class="uk-form-row">
                    <b>Content:</b>
                    <textarea class="post-page-content" cols="" rows="10" placeholder=""></textarea>
                </div>
            </form>

            <div class="uk-modal-footer uk-text-right">
                <button type="button" class="uk-button uk-modal-close">Cancel</button>
                <button type="button" class="uk-button uk-button-primary silo-post-page-create">Create</button>
            </div>
        </div>
    </div>

</div>